/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions.args;

import jadx.api.metadata.annotations.VarNode;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CodeVar {
    private String name;
    private ArgType type;
    private List<SSAVar> ssaVars = Collections.emptyList();
    private boolean isFinal;
    private boolean isThis;
    private boolean isDeclared;
    private VarNode cachedVarNode;

    public static CodeVar fromMthArg(RegisterArg mthArg, boolean linkRegister) {
        CodeVar var = new CodeVar();
        var.setType(mthArg.getInitType());
        var.setName(mthArg.getName());
        var.setThis(mthArg.isThis());
        var.setDeclared(true);
        var.setThis(mthArg.isThis());
        if (linkRegister) {
            var.setSsaVars(Collections.singletonList(new SSAVar(mthArg.getRegNum(), 0, mthArg)));
        }
        return var;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArgType getType() {
        return this.type;
    }

    public void setType(ArgType type) {
        this.type = type;
    }

    public List<SSAVar> getSsaVars() {
        return this.ssaVars;
    }

    public void addSsaVar(SSAVar ssaVar) {
        if (this.ssaVars.isEmpty()) {
            this.ssaVars = new ArrayList<SSAVar>(3);
        }
        if (!this.ssaVars.contains(ssaVar)) {
            this.ssaVars.add(ssaVar);
        }
    }

    public void setSsaVars(List<SSAVar> ssaVars) {
        this.ssaVars = ssaVars;
    }

    public SSAVar getAnySsaVar() {
        if (this.ssaVars.isEmpty()) {
            throw new IllegalStateException("CodeVar without SSA variables attached: " + this);
        }
        return this.ssaVars.get(0);
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setThis(boolean aThis) {
        this.isThis = aThis;
    }

    public boolean isDeclared() {
        return this.isDeclared;
    }

    public void setDeclared(boolean declared) {
        this.isDeclared = declared;
    }

    public VarNode getCachedVarNode() {
        return this.cachedVarNode;
    }

    public void setCachedVarNode(VarNode varNode) {
        this.cachedVarNode = varNode;
    }

    public void mergeFlagsFrom(CodeVar other) {
        if (other.isDeclared()) {
            this.setDeclared(true);
        }
        if (other.isThis()) {
            this.setThis(true);
        }
        if (other.isFinal()) {
            this.setFinal(true);
        }
    }

    public String toString() {
        return (this.isFinal ? "final " : "") + this.type + ' ' + this.name;
    }
}

