/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.SimplePacket;
import org.pcap4j.util.ByteArrays;

public final class FragmentedPacket
extends SimplePacket {
    private static final long serialVersionUID = 8065880017691703511L;

    public static FragmentedPacket newPacket(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new FragmentedPacket(rawData, offset, length);
    }

    private FragmentedPacket(byte[] rawData, int offset, int length) {
        super(rawData, offset, length);
    }

    private FragmentedPacket(Builder builder2) {
        super(builder2);
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    protected String modifier() {
        return "Fragmented ";
    }

    public static final class Builder
    extends SimplePacket.Builder {
        public Builder() {
        }

        private Builder(FragmentedPacket packet) {
            super(packet);
        }

        public Builder rawData(byte[] rawData) {
            this.setRawData(rawData);
            return this;
        }

        @Override
        public FragmentedPacket build() {
            return new FragmentedPacket(this);
        }
    }
}

