/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.Internal;
import org.hibernate.property.access.internal.AbstractSetterMethodSerialForm;
import org.hibernate.property.access.internal.AccessStrategyHelper;
import org.hibernate.property.access.spi.SetterMethodImpl;

@Internal
public class EnhancedSetterMethodImpl
extends SetterMethodImpl {
    private final @UnknownKeyFor @NonNull @Initialized String propertyName;
    private final @UnknownKeyFor @NonNull @Initialized int enhancementState;

    public EnhancedSetterMethodImpl(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method setterMethod) {
        super(containerClass, propertyName, setterMethod);
        this.propertyName = propertyName;
        this.enhancementState = AccessStrategyHelper.determineEnhancementState(containerClass, setterMethod.getReturnType());
    }

    @Override
    public void set(@UnknownKeyFor @NonNull @Initialized Object target, @Nullable @UnknownKeyFor @Initialized Object value) {
        super.set(target, value);
        AccessStrategyHelper.handleEnhancedInjection(target, value, this.enhancementState, this.propertyName);
    }

    private @UnknownKeyFor @NonNull @Initialized Object writeReplace() {
        return new SerialForm(this.getContainerClass(), this.propertyName, this.getMethod());
    }

    private static class SerialForm
    extends AbstractSetterMethodSerialForm
    implements Serializable {
        private SerialForm(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method) {
            super(containerClass, propertyName, method);
        }

        private @UnknownKeyFor @NonNull @Initialized Object readResolve() {
            return new EnhancedSetterMethodImpl(this.getContainerClass(), this.getPropertyName(), this.resolveMethod());
        }
    }
}

