/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public final class SqlAstTreeHelper {
    private SqlAstTreeHelper() {
    }

    public static Predicate combinePredicates(Predicate baseRestriction, Predicate incomingRestriction) {
        Junction secondJunction;
        Junction combinedPredicate;
        if (baseRestriction == null) {
            return incomingRestriction;
        }
        if (incomingRestriction == null) {
            return baseRestriction;
        }
        if (baseRestriction instanceof Junction) {
            Junction junction = (Junction)baseRestriction;
            if (junction.isEmpty()) {
                return incomingRestriction;
            }
            if (junction.getNature() == Junction.Nature.CONJUNCTION) {
                combinedPredicate = junction;
            } else {
                combinedPredicate = new Junction(Junction.Nature.CONJUNCTION);
                combinedPredicate.add(baseRestriction);
            }
        } else {
            combinedPredicate = new Junction(Junction.Nature.CONJUNCTION);
            combinedPredicate.add(baseRestriction);
        }
        if (incomingRestriction instanceof Junction && (secondJunction = (Junction)incomingRestriction).getNature() == Junction.Nature.CONJUNCTION) {
            for (Predicate predicate : secondJunction.getPredicates()) {
                combinedPredicate.add(predicate);
            }
        } else {
            combinedPredicate.add(incomingRestriction);
        }
        return combinedPredicate;
    }
}

