/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.rar.parsers;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.protocol.oidc.rar.AuthorizationRequestParserProvider;
import org.keycloak.protocol.oidc.rar.model.IntermediaryScopeRepresentation;
import org.keycloak.rar.AuthorizationDetails;
import org.keycloak.rar.AuthorizationRequestContext;
import org.keycloak.rar.AuthorizationRequestSource;
import org.keycloak.representations.AuthorizationDetailsJSONRepresentation;

public class ClientScopeAuthorizationRequestParser
implements AuthorizationRequestParserProvider {
    protected static final Logger logger = Logger.getLogger(ClientScopeAuthorizationRequestParser.class);
    private final ClientModel client;

    public ClientScopeAuthorizationRequestParser(ClientModel client) {
        this.client = client;
    }

    @Override
    public AuthorizationRequestContext parseScopes(String scopeParam) {
        Set clientScopeModelSet = this.client.getClientScopes(true).values().stream().filter(clientScopeModel -> !clientScopeModel.isDynamicScope()).map(IntermediaryScopeRepresentation::new).collect(Collectors.toSet());
        Set intermediaryScopeRepresentations = new HashSet();
        if (scopeParam != null) {
            intermediaryScopeRepresentations = TokenManager.parseScopeParameter(scopeParam).collect(Collectors.toSet()).stream().map(requestScope -> this.getMatchingClientScope((String)requestScope, this.client.getClientScopes(false).values())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        }
        intermediaryScopeRepresentations.addAll(clientScopeModelSet);
        List authorizationDetails = intermediaryScopeRepresentations.stream().map(this::buildAuthorizationDetailsJSONRepresentation).collect(Collectors.toList());
        return new AuthorizationRequestContext(authorizationDetails);
    }

    private AuthorizationDetails buildAuthorizationDetailsJSONRepresentation(IntermediaryScopeRepresentation intermediaryScopeRepresentation) {
        AuthorizationDetailsJSONRepresentation representation = new AuthorizationDetailsJSONRepresentation();
        representation.setCustomData("access", Collections.singletonList(intermediaryScopeRepresentation.getRequestedScopeString()));
        representation.setType("https://keycloak.org/auth-type/static-oauth2-scope");
        if (intermediaryScopeRepresentation.isDynamic() && intermediaryScopeRepresentation.getParameter() != null) {
            representation.setType("https://keycloak.org/auth-type/dynamic-oauth2-scope");
            representation.setCustomData("scope_parameter", (Object)intermediaryScopeRepresentation.getParameter());
        }
        return new AuthorizationDetails(intermediaryScopeRepresentation.getScope(), AuthorizationRequestSource.SCOPE, representation);
    }

    private Optional<IntermediaryScopeRepresentation> getMatchingClientScope(String requestScope, Collection<ClientScopeModel> optionalScopes) {
        for (ClientScopeModel clientScopeModel : optionalScopes) {
            if (clientScopeModel.isDynamicScope()) {
                Pattern p = Pattern.compile(clientScopeModel.getDynamicScopeRegexp().replace("*", "(.*)"));
                Matcher m = p.matcher(requestScope);
                if (!m.matches()) continue;
                return Optional.of(new IntermediaryScopeRepresentation(clientScopeModel, m.group(1), requestScope));
            }
            if (!requestScope.equalsIgnoreCase(clientScopeModel.getName())) continue;
            return Optional.of(new IntermediaryScopeRepresentation(clientScopeModel));
        }
        return Optional.empty();
    }

    public void close() {
    }
}

