"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatInteractionFromBackend = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Agent framework changes interaction_id to message_id
 * In FE we need to change this back.
 */
const formatInteractionFromBackend = interaction => {
  const {
    message_id: messageId,
    memory_id: memoryId,
    ...others
  } = interaction || {};
  return {
    ...others,
    interaction_id: messageId || '',
    conversation_id: memoryId || ''
  };
};
exports.formatInteractionFromBackend = formatInteractionFromBackend;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJmb3JtYXRJbnRlcmFjdGlvbkZyb21CYWNrZW5kIiwiaW50ZXJhY3Rpb24iLCJtZXNzYWdlX2lkIiwibWVzc2FnZUlkIiwibWVtb3J5X2lkIiwibWVtb3J5SWQiLCJvdGhlcnMiLCJpbnRlcmFjdGlvbl9pZCIsImNvbnZlcnNhdGlvbl9pZCIsImV4cG9ydHMiXSwic291cmNlcyI6WyJmb3JtYXQudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQge1xuICBJbnRlcmFjdGlvbixcbiAgSW50ZXJhY3Rpb25Gcm9tQWdlbnRGcmFtZXdvcmssXG59IGZyb20gJy4uLy4uL2NvbW1vbi90eXBlcy9jaGF0X3NhdmVkX29iamVjdF9hdHRyaWJ1dGVzJztcblxuLyoqXG4gKiBBZ2VudCBmcmFtZXdvcmsgY2hhbmdlcyBpbnRlcmFjdGlvbl9pZCB0byBtZXNzYWdlX2lkXG4gKiBJbiBGRSB3ZSBuZWVkIHRvIGNoYW5nZSB0aGlzIGJhY2suXG4gKi9cbmV4cG9ydCBjb25zdCBmb3JtYXRJbnRlcmFjdGlvbkZyb21CYWNrZW5kID0gKFxuICBpbnRlcmFjdGlvbjogSW50ZXJhY3Rpb25Gcm9tQWdlbnRGcmFtZXdvcmtcbik6IEludGVyYWN0aW9uID0+IHtcbiAgY29uc3QgeyBtZXNzYWdlX2lkOiBtZXNzYWdlSWQsIG1lbW9yeV9pZDogbWVtb3J5SWQsIC4uLm90aGVycyB9ID0gaW50ZXJhY3Rpb24gfHwge307XG4gIHJldHVybiB7XG4gICAgLi4ub3RoZXJzLFxuICAgIGludGVyYWN0aW9uX2lkOiBtZXNzYWdlSWQgfHwgJycsXG4gICAgY29udmVyc2F0aW9uX2lkOiBtZW1vcnlJZCB8fCAnJyxcbiAgfTtcbn07XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQU9BO0FBQ0E7QUFDQTtBQUNBO0FBQ08sTUFBTUEsNEJBQTRCLEdBQ3ZDQyxXQUEwQyxJQUMxQjtFQUNoQixNQUFNO0lBQUVDLFVBQVUsRUFBRUMsU0FBUztJQUFFQyxTQUFTLEVBQUVDLFFBQVE7SUFBRSxHQUFHQztFQUFPLENBQUMsR0FBR0wsV0FBVyxJQUFJLENBQUMsQ0FBQztFQUNuRixPQUFPO0lBQ0wsR0FBR0ssTUFBTTtJQUNUQyxjQUFjLEVBQUVKLFNBQVMsSUFBSSxFQUFFO0lBQy9CSyxlQUFlLEVBQUVILFFBQVEsSUFBSTtFQUMvQixDQUFDO0FBQ0gsQ0FBQztBQUFDSSxPQUFBLENBQUFULDRCQUFBLEdBQUFBLDRCQUFBIn0=