"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.catalogRequestIntercept = catalogRequestIntercept;
var _constants = require("../constants");
var _cache_manager = require("./cache_manager");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function catalogRequestIntercept() {
  return fetchOptions => {
    if (fetchOptions.path.includes(_constants.SECURITY_DASHBOARDS_LOGOUT_URL)) {
      // Clears all user catalog cache details
      _cache_manager.CatalogCacheManager.clearDataSourceCache();
      _cache_manager.CatalogCacheManager.clearAccelerationsCache();
    }
  };
}