// Copyright (C) The Qt Company Ltd. and other contributors.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

// This file was generated by qlalr - DO NOT EDIT!
#ifndef QQMLJSGRAMMAR_P_H
#define QQMLJSGRAMMAR_P_H

#include <QtCore/qglobal.h>

QT_BEGIN_NAMESPACE

class QQmlJSGrammar
{
public:
    enum VariousConstants {
        EOF_SYMBOL = 0,
        REDUCE_HERE = 138,
        T_AND = 1,
        T_AND_AND = 2,
        T_AND_EQ = 3,
        T_ARROW = 95,
        T_AS = 116,
        T_AT = 89,
        T_AUTOMATIC_SEMICOLON = 63,
        T_BREAK = 4,
        T_CASE = 5,
        T_CATCH = 6,
        T_CLASS = 102,
        T_COLON = 7,
        T_COMMA = 8,
        T_COMMENT = 93,
        T_COMPATIBILITY_SEMICOLON = 94,
        T_COMPONENT = 108,
        T_CONST = 87,
        T_CONTINUE = 9,
        T_DEBUGGER = 90,
        T_DEFAULT = 10,
        T_DELETE = 11,
        T_DIVIDE_ = 12,
        T_DIVIDE_EQ = 13,
        T_DO = 14,
        T_DOT = 15,
        T_ELLIPSIS = 99,
        T_ELSE = 16,
        T_ENUM = 98,
        T_EOL = 122,
        T_EQ = 17,
        T_EQ_EQ = 18,
        T_EQ_EQ_EQ = 19,
        T_ERROR = 121,
        T_EXPORT = 105,
        T_EXTENDS = 103,
        T_FALSE = 86,
        T_FEED_JS_EXPRESSION = 131,
        T_FEED_JS_MODULE = 133,
        T_FEED_JS_SCRIPT = 132,
        T_FEED_JS_STATEMENT = 130,
        T_FEED_UI_OBJECT_MEMBER = 129,
        T_FEED_UI_PROGRAM = 128,
        T_FINALLY = 20,
        T_FOR = 21,
        T_FORCE_BLOCK = 135,
        T_FORCE_DECLARATION = 134,
        T_FOR_LOOKAHEAD_OK = 136,
        T_FROM = 106,
        T_FUNCTION = 22,
        T_GE = 23,
        T_GET = 118,
        T_GT = 24,
        T_GT_GT = 25,
        T_GT_GT_EQ = 26,
        T_GT_GT_GT = 27,
        T_GT_GT_GT_EQ = 28,
        T_IDENTIFIER = 29,
        T_IF = 30,
        T_IMPORT = 114,
        T_IN = 31,
        T_INSTANCEOF = 32,
        T_LBRACE = 33,
        T_LBRACKET = 34,
        T_LE = 35,
        T_LET = 88,
        T_LPAREN = 36,
        T_LT = 37,
        T_LT_LT = 38,
        T_LT_LT_EQ = 39,
        T_MINUS = 40,
        T_MINUS_EQ = 41,
        T_MINUS_MINUS = 42,
        T_MULTILINE_STRING_LITERAL = 92,
        T_NEW = 43,
        T_NONE = 120,
        T_NOT = 44,
        T_NOT_EQ = 45,
        T_NOT_EQ_EQ = 46,
        T_NO_SUBSTITUTION_TEMPLATE = 109,
        T_NULL = 84,
        T_NUMERIC_LITERAL = 47,
        T_OF = 117,
        T_ON = 137,
        T_OR = 48,
        T_OR_EQ = 50,
        T_OR_OR = 51,
        T_PARTIAL_COMMENT = 123,
        T_PARTIAL_DOUBLE_QUOTE_STRING_LITERAL = 125,
        T_PARTIAL_SINGLE_QUOTE_STRING_LITERAL = 124,
        T_PARTIAL_TEMPLATE_HEAD = 126,
        T_PARTIAL_TEMPLATE_MIDDLE = 127,
        T_PLUS = 52,
        T_PLUS_EQ = 53,
        T_PLUS_PLUS = 54,
        T_PRAGMA = 115,
        T_PROPERTY = 69,
        T_PUBLIC = 113,
        T_QUESTION = 55,
        T_QUESTION_DOT = 97,
        T_QUESTION_QUESTION = 96,
        T_RBRACE = 56,
        T_RBRACKET = 57,
        T_READONLY = 71,
        T_REMAINDER = 58,
        T_REMAINDER_EQ = 59,
        T_REQUIRED = 107,
        T_RESERVED_WORD = 91,
        T_RETURN = 60,
        T_RPAREN = 61,
        T_SEMICOLON = 62,
        T_SET = 119,
        T_SIGNAL = 70,
        T_STAR = 64,
        T_STAR_EQ = 67,
        T_STAR_STAR = 65,
        T_STAR_STAR_EQ = 66,
        T_STATIC = 104,
        T_STRING_LITERAL = 68,
        T_SUPER = 101,
        T_SWITCH = 72,
        T_TEMPLATE_HEAD = 110,
        T_TEMPLATE_MIDDLE = 111,
        T_TEMPLATE_TAIL = 112,
        T_THEN = 139,
        T_THIS = 73,
        T_THROW = 74,
        T_TILDE = 75,
        T_TRUE = 85,
        T_TRY = 76,
        T_TYPEOF = 77,
        T_VAR = 78,
        T_VERSION_NUMBER = 49,
        T_VOID = 79,
        T_WHILE = 80,
        T_WITH = 81,
        T_WITHOUTAS = 140,
        T_XOR = 82,
        T_XOR_EQ = 83,
        T_YIELD = 100,

        ACCEPT_STATE = 1111,
        RULE_COUNT = 625,
        STATE_COUNT = 1112,
        TERMINAL_COUNT = 141,
        NON_TERMINAL_COUNT = 241,

        GOTO_INDEX_OFFSET = 1112,
        GOTO_INFO_OFFSET = 8120,
        GOTO_CHECK_OFFSET = 8120
    };

    static const char *const     spell[];
    static const short             lhs[];
    static const short             rhs[];
    static const short    goto_default[];
    static const short  action_default[];
    static const short    action_index[];
    static const short     action_info[];
    static const short    action_check[];

    static inline int nt_action (int state, int nt)
    {
        const int yyn = action_index [GOTO_INDEX_OFFSET + state] + nt;
        if (yyn < 0 || action_check [GOTO_CHECK_OFFSET + yyn] != nt)
            return goto_default [nt];

        return action_info [GOTO_INFO_OFFSET + yyn];
    }

    static inline int t_action (int state, int token)
    {
        const int yyn = action_index [state] + token;

        if (yyn < 0 || action_check [yyn] != token)
            return - action_default [state];

        return action_info [yyn];
    }
};


QT_END_NAMESPACE
#endif // QQMLJSGRAMMAR_P_H

