/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.user;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.guacamole.form.BooleanField;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.auth.DelegatingUser;
import org.apache.guacamole.net.auth.User;

public class TOTPUser
extends DelegatingUser {
    public static final String TOTP_KEY_DISABLED_ATTRIBUTE_NAME = "guac-totp-disabled";
    public static final String TOTP_KEY_SECRET_ATTRIBUTE_NAME = "guac-totp-key-secret";
    public static final String TOTP_KEY_CONFIRMED_ATTRIBUTE_NAME = "guac-totp-key-confirmed";
    public static final String TOTP_KEY_SECRET_GENERATED_ATTRIBUTE_NAME = "guac-totp-key-generated";
    public static final String TRUTH_VALUE = "true";
    public static final Form TOTP_ENROLLMENT_STATUS = new Form("totp-enrollment-status", Arrays.asList(new BooleanField("guac-totp-disabled", "true"), new BooleanField("guac-totp-key-generated", "true"), new BooleanField("guac-totp-key-confirmed", "true")));

    public TOTPUser(User user) {
        super(user);
    }

    public User getUndecorated() {
        return this.getDelegateUser();
    }

    public Map<String, String> getAttributes() {
        String secret;
        HashMap<String, String> attributes = new HashMap<String, String>(super.getAttributes());
        if (!attributes.containsKey(TOTP_KEY_DISABLED_ATTRIBUTE_NAME)) {
            attributes.put(TOTP_KEY_DISABLED_ATTRIBUTE_NAME, null);
        }
        if ((secret = (String)attributes.remove(TOTP_KEY_SECRET_ATTRIBUTE_NAME)) != null && !secret.isEmpty()) {
            attributes.put(TOTP_KEY_SECRET_GENERATED_ATTRIBUTE_NAME, TRUTH_VALUE);
        }
        return attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        attributes = new HashMap<String, String>(attributes);
        attributes.remove(TOTP_KEY_SECRET_ATTRIBUTE_NAME);
        String generated = attributes.remove(TOTP_KEY_SECRET_GENERATED_ATTRIBUTE_NAME);
        if (generated != null && !generated.equals(TRUTH_VALUE)) {
            attributes.put(TOTP_KEY_SECRET_ATTRIBUTE_NAME, null);
            attributes.put(TOTP_KEY_CONFIRMED_ATTRIBUTE_NAME, null);
        }
        super.setAttributes(attributes);
    }
}

