set(NETGEN_VERSION "6.2.2404-80-g7656211b")
set(NETGEN_VERSION_MAJOR "6")
set(NETGEN_VERSION_MINOR "2")
set(NETGEN_VERSION_PATCH "2404")
set(NETGEN_VERSION_TWEAK "80")

get_filename_component(NETGEN_CMAKE_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

get_filename_component(NETGEN_DIR "${NETGEN_CMAKE_DIR}/../../../" ABSOLUTE)

set(NETGEN_COMPILE_DEFINITIONS "HAVE_DLFCN_H;$<$<CONFIG:Release>:OCC_CONVERT_SIGNALS>;$<$<CONFIG:Release>:HAVE_TK>;$<$<CONFIG:Release>:HAVE_XLIB>;$<$<CONFIG:Release>:HAVE_FREETYPE>;$<$<CONFIG:Release>:HAVE_OPENGL_EXT>;OCCGEOMETRY;JPEGLIB;FFMPEG;__STDC_CONSTANT_MACROS")

get_filename_component(NETGEN_INCLUDE_DIR "${NETGEN_CMAKE_DIR}/../../../include/netgen" ABSOLUTE)
get_filename_component(NETGEN_BINARY_DIR "${NETGEN_CMAKE_DIR}/../../../bin" ABSOLUTE)
get_filename_component(NETGEN_LIBRARY_DIR "${NETGEN_CMAKE_DIR}/../../" ABSOLUTE)
get_filename_component(NETGEN_PYTHON_DIR "${NETGEN_CMAKE_DIR}/../../python3.12/site-packages" ABSOLUTE)
get_filename_component(NETGEN_RESOURCE_DIR "${NETGEN_CMAKE_DIR}/../../../share" ABSOLUTE)

set(NETGEN_SOURCE_DIR "/local/pobj/netgen-mesher-6.2.2404/netgen-6.2.2404")

set(NETGEN_BUILD_FOR_CONDA "OFF")
set(NETGEN_CHECK_RANGE "OFF")
set(NETGEN_INCLUDE_DIRS "${NETGEN_INCLUDE_DIR}/include;${NETGEN_INCLUDE_DIR}")
set(NETGEN_CMAKE_THREAD_LIBS_INIT "-lpthread")
set(NETGEN_FFMPEG_LIBRARIES "/usr/local/lib/libavcodec.so.26.0;/usr/local/lib/libavformat.so.23.0;/usr/local/lib/libavutil.so.16.0;/usr/local/lib/libswscale.so.8.0")
set(NETGEN_JPEG_INCLUDE_DIR "/usr/local/include")
set(NETGEN_JPEG_LIBRARIES "/usr/local/lib/libjpeg.so.71.0")
set(NETGEN_LIBTOGL "")
set(NETGEN_METIS_INCLUDE_DIR "")
set(NETGEN_METIS_LIBRARY "")
set(NETGEN_MKL_LIBRARIES "")
set(NETGEN_MPI_CXX_INCLUDE_PATH "")
set(NETGEN_MPI_CXX_LIBRARIES "")
set(NETGEN_NUMA_LIBRARY "")
set(NETGEN_OCC_DIR "")
set(NETGEN_OCC_INCLUDE_DIR "/usr/local/include/opencascade")
set(NETGEN_OCC_LIBRARIES_BIN "/usr/local/bin")
set(NETGEN_OCC_LIBRARIES "-Wl,--start-group;TKBO;TKBRep;TKBool;TKCAF;TKCDF;TKFillet;TKG2d;TKG3d;TKGeomAlgo;TKGeomBase;TKHLR;TKLCAF;TKMath;TKMesh;TKOffset;TKPrim;TKService;TKShHealing;TKTopAlgo;TKV3d;TKVCAF;TKXCAF;TKXSBase;TKernel;TKDEIGES;TKDESTEP;TKDESTL;-Wl,--end-group")
set(NETGEN_OCC_LIBRARY_DIR "/usr/local/lib")
set(NETGEN_OPENGL_LIBRARIES "/usr/X11R6/lib/libGL.so.19.2;/usr/X11R6/lib/libGLU.so.9.0")
set(NETGEN_PYTHON_EXECUTABLE "/usr/local/bin/python3.12")
set(NETGEN_PYTHON_INCLUDE_DIRS "/usr/local/include/python3.12")
set(NETGEN_PYTHON_LIBRARIES "/usr/local/lib/libpython3.12.so.0.0")
set(NETGEN_TCL_INCLUDE_PATH "/usr/local/include/tcl8.6")
set(NETGEN_TCL_LIBRARY "/usr/local/lib/libtclstub86.a")
set(NETGEN_TK_DND_LIBRARY "")
set(NETGEN_TK_INCLUDE_PATH "/usr/local/include/tk8.6")
set(NETGEN_TK_LIBRARY "/usr/local/lib/libtkstub86.a")
set(NETGEN_X11_X11_LIB "/usr/X11R6/lib/libX11.so.19.0")
set(NETGEN_X11_Xmu_LIB "/usr/X11R6/lib/libXmu.so.11.0")
set(NETGEN_ZLIB_INCLUDE_DIRS "/usr/include")
set(NETGEN_ZLIB_LIBRARIES "/usr/lib/libz.so.7.1")

set(NETGEN_USE_GUI ON)
set(NETGEN_USE_PYTHON ON)
set(NETGEN_USE_MPI OFF)
set(NETGEN_USE_OCC ON)
set(NETGEN_USE_JPEG ON)
set(NETGEN_USE_MPEG ON)
set(NETGEN_USE_CGNS OFF)
set(NETGEN_INTEL_MIC OFF)
set(NETGEN_INSTALL_PROFILES OFF)
set(NETGEN_USE_CCACHE OFF)
set(NETGEN_USE_NATIVE_ARCH OFF)
set(NETGEN_USE_NUMA OFF)

set(NETGEN_PYTHON_RPATH "../../")
set(NETGEN_RPATH_TOKEN "$ORIGIN")

set(NETGEN_INSTALL_DIR_PYTHON lib/python3.12/site-packages)
set(NETGEN_INSTALL_DIR_BIN bin)
set(NETGEN_INSTALL_DIR_LIB lib)
set(NETGEN_INSTALL_DIR_INCLUDE include/netgen)
set(NETGEN_INSTALL_DIR_CMAKE lib/cmake/netgen)
set(NETGEN_INSTALL_DIR_RES share)

include(${CMAKE_CURRENT_LIST_DIR}/netgen-targets.cmake)
message(STATUS "Found Netgen: ${CMAKE_CURRENT_LIST_DIR}")
