'\"
'\" Generated from file 'img-png\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2024 Jan Nijtmans <nijtmans@users\&.sourceforge\&.net>
'\" Copyright (c) 2002-2024 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\" Copyright (c) 2003-2024 Paul Obermeier <obermeier@users\&.sourceforge\&.net>
'\"
.TH "img-png" n 2\&.0 img-png "Img"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
img-png \- Portable Network Graphics format (png)
.SH SYNOPSIS
package require \fBimg::png ?2\&.0?\fR
.sp
.BE
.SH DESCRIPTION
\fBpackage require img::png\fR
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR, so
that it supports files containing raster images in the
Portable Network Graphics format (png)\&. More specifically
\fBimg::png\fR extends \fBTk\fR's
\fIphoto\fR [https://www\&.tcl\&.tk/man/tcl9\&.0/TkCmd/photo\&.html] image type\&.
.PP
The name of the new format handler is \fBpng\fR\&.
This handler provides new additional configuration options\&. See
section \fBOptions\fR for more detailed explanations\&.
.PP
All of the above means that in a call like
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?
.PP
.IP [1]
Image data in png format (options \fB-data\fR and \fB-file\fR) is
detected automatically\&.
.IP [2]
The format name \fBpng\fR is recognized by the option \fB-format\fR\&.
.PP
In addition the value of option \fB-format\fR is treated as a list and may
contain any of the special options listed in section \fBOptions\fR\&.
.PP
The package \fBimg::png\fR is a sub-package of
\fBImg\fR\&. It can be loaded as a part of the complete Img support,
via \fBpackage require Img\fR, or on its own, via
\fBpackage require img::png\fR\&.
.PP
.SH NOTES
.IP [1]
Chapter \fIImage Metadata\fR of the \fBImg\fR manual page
describes the parameters of the resolution related options\&.
.PP
.SH OPTIONS
The handler provides the following options:
.TP
\fB-verbose\fR \fIbool\fR
This option is supported for reading and writing\&. Available since version 1\&.4\&.6\&.
.sp
If set to \fBtrue\fR, additional information about the read or written image
is printed to stdout\&. Default is \fBfalse\fR\&.
.TP
\fB-alpha\fR \fIdouble\fR
This option is supported for reading only\&. Available since version 1\&.4\&.2\&.
.sp
An additional alpha filtering value for the overall image, which
allows the background on which the image is displayed to show through\&.
This usually also has the effect of desaturating the image\&.
The alpha value must be between 0\&.0 and 1\&.0\&.
Specifying an alpha value, overrides the setting of the \fB-withalpha\fR flag,
i\&.e\&. reading a file which has no alpha channel (Grayscale, RGB) will
add an alpha channel to the image independent of the \fB-withalpha\fR flag setting\&.
.TP
\fB-gamma\fR \fIdouble\fR
This option is supported for reading only\&. Available since version 1\&.4\&.6\&.
.sp
Use the specified gamma value when reading an image\&.
This option overwrites gamma values specified in the file\&.
If this option is not specified and no gamma value is in the file,
a default value of 1\&.0 is used\&.
.TP
\fB-withalpha\fR \fIbool\fR
This option is supported for reading and writing\&. Available since version 1\&.4\&.1\&.
.sp
If set to \fBfalse\fR, an alpha channel is ignored
during reading or writing\&. Default is \fBtrue\fR\&.
.sp
\fINote:\fR This option was named \fB-matte\fR in previous versions and is still recognized\&.
.TP
\fB-resolution\fR \fIxres\fR ?\fIyres\fR?
This option is supported for writing only\&. Available since version 2\&.0\&.
.sp
Set the resolution values of the written image file\&.
If \fIyres\fR is not specified, it is set to the value of \fIxres\fR\&.
.sp
If option is not specified, the \fIDPI\fR and \fIaspect\fR values of the metadata dictionary are written\&.
If no metadata values are available, no resolution values are written\&.
.TP
\fB-xresolution\fR \fIxres\fR
This option is supported for writing only\&. Available since version 2\&.0\&.
.sp
Set the horizontal resolution value of the written image file\&.
.TP
\fB-yresolution\fR \fIyres\fR
This option is supported for writing only\&. Available since version 2\&.0\&.
.sp
Set the vertical resolution value of the written image file\&.
.TP
\fB-tag\fR \fIkey\fR \fIvalue\fR
This option is supported for writing only\&. Available since version 2\&.0\&.
.sp
Each key-value pair will be written as a named text chunk where the key provides
the name of the chunk and the value its contents\&.
Currently the maximum number of \fB-tag\fR specifications are 10\&.
.PP
.SH "SEE ALSO"
img, img-bmp, img-dted, img-flir, img-gif, img-ico, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-raw, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH COPYRIGHT
.nf
Copyright (c) 1995-2024 Jan Nijtmans <nijtmans@users\&.sourceforge\&.net>
Copyright (c) 2002-2024 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
Copyright (c) 2003-2024 Paul Obermeier <obermeier@users\&.sourceforge\&.net>

.fi
