/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.dao;

import ca.sqlpower.dao.SPPersistenceException;
import ca.sqlpower.dao.SPPersister;
import ca.sqlpower.dao.SPUpgradePersister;
import ca.sqlpower.dao.upgrade.UpgradePersisterManager;
import ca.sqlpower.util.SQLPowerUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLPersisterReader {
    private static final Logger logger = Logger.getLogger(XMLPersisterReader.class);
    private final Reader in;
    private final SPPersister target;
    private SPPersister upgradeTarget;
    private UpgradePersisterManager upgradePersisterManager;
    public final String PROJECT_TAG;

    public XMLPersisterReader(Reader in, SPPersister target, UpgradePersisterManager upgradePersisterManager, String projectTag) {
        this.in = in;
        this.target = target;
        this.upgradePersisterManager = upgradePersisterManager;
        this.PROJECT_TAG = projectTag;
    }

    public void read() throws SPPersistenceException {
        String line;
        BufferedReader reader = new BufferedReader(this.in);
        try {
            reader.mark(200);
            line = reader.readLine();
            while (!line.contains("<" + this.PROJECT_TAG)) {
                line = reader.readLine();
            }
            reader.reset();
        }
        catch (IOException e) {
            throw new SPPersistenceException(null, e);
        }
        int version = Integer.valueOf(line.substring(line.indexOf("file-version=") + "file-version=\"".length(), line.length() - 2));
        SPUpgradePersister latest = null;
        SPPersister previousTarget = null;
        this.upgradeTarget = this.target;
        if (version != this.upgradePersisterManager.getStateVersion()) {
            SPUpgradePersister newUpgradeTarget = this.upgradePersisterManager.getUpgradePersister(version);
            if (newUpgradeTarget != null) {
                this.upgradeTarget = newUpgradeTarget;
            }
            if ((latest = this.upgradePersisterManager.getUpgradePersister(this.upgradePersisterManager.getStateVersion() - 1)) != null) {
                previousTarget = latest.getNextPersister();
                latest.setNextPersister(this.target, false);
            }
        }
        try {
            this.upgradeTarget.begin();
            SAXHandler handler = new SAXHandler();
            SAXParser parser = new SAXParser();
            parser.setContentHandler((ContentHandler)handler);
            parser.parse(new InputSource(reader));
            this.upgradeTarget.commit();
        }
        catch (Exception e) {
            if (latest != null) {
                latest.setNextPersister(previousTarget, false);
            }
            logger.error((Object)"error loading project", (Throwable)e);
            this.upgradeTarget.rollback();
            throw new SPPersistenceException(null, e);
        }
    }

    private Object castValue(SPPersister.DataType type, String value) {
        switch (type) {
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case LONG: {
                return Long.valueOf(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
            case NULL: {
                return null;
            }
            case PNG_IMG: {
                return new ByteArrayInputStream(Base64.decodeBase64((byte[])value.getBytes()));
            }
            case STRING: 
            case REFERENCE: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unknown DataType " + (Object)((Object)type));
    }

    private class SAXHandler
    extends DefaultHandler {
        private Stack<String> currentObject = new Stack();

        private SAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("property".equals(localName)) {
                    String name = attributes.getValue("name");
                    SPPersister.DataType type = SPPersister.DataType.valueOf(attributes.getValue("type"));
                    String value = attributes.getValue("value");
                    value = SQLPowerUtils.unEscapeNewLines(value);
                    XMLPersisterReader.this.upgradeTarget.persistProperty(this.currentObject.peek(), name, type, XMLPersisterReader.this.castValue(type, value));
                } else if (!XMLPersisterReader.this.PROJECT_TAG.equals(localName)) {
                    logger.debug((Object)("Reading element " + localName));
                    String type = localName.replace("..", "$");
                    String UUID = attributes.getValue("UUID");
                    int index = Integer.valueOf(attributes.getValue("index"));
                    String parent = this.currentObject.isEmpty() ? "" : this.currentObject.peek();
                    XMLPersisterReader.this.upgradeTarget.persistObject(parent, type, UUID, index);
                    this.currentObject.push(UUID);
                }
            }
            catch (SPPersistenceException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!"property".equals(localName) && !XMLPersisterReader.this.PROJECT_TAG.equals(localName)) {
                this.currentObject.pop();
            }
        }
    }
}

