/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.util.BrowserUtil;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CheckForUpdateAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(CheckForUpdateAction.class);
    private static final String VERSION_FILE_URL = "http://power-architect.sqlpower.ca/current_version";
    private static final String UPDATE_URL = "http://download.sqlpower.ca/architect/current.html";
    private String versionPropertyString;
    private HttpURLConnection urlc;
    private InputStream propertyInputStream;

    public CheckForUpdateAction(ArchitectFrame frame) {
        super(frame, Messages.getString("CheckForUpdateAction.name"), Messages.getString("CheckForUpdateAction.description"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkForUpdate(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdate(boolean verbose) {
        try {
            URL url = new URL(VERSION_FILE_URL);
            this.urlc = (HttpURLConnection)url.openConnection();
            this.urlc.setAllowUserInteraction(false);
            this.urlc.setRequestMethod("GET");
            this.urlc.setDoInput(true);
            this.urlc.setDoOutput(false);
            this.urlc.connect();
            this.propertyInputStream = this.urlc.getInputStream();
            Properties properties = new Properties();
            properties.load(this.propertyInputStream);
            this.versionPropertyString = properties.getProperty("app.version");
            ArchitectVersion latestVersion = new ArchitectVersion(this.versionPropertyString);
            ArchitectVersion userVersion = ArchitectVersion.APP_FULL_VERSION;
            if (userVersion.compareTo(latestVersion) < 0) {
                this.promptUpdate();
            } else if (verbose) {
                JOptionPane.showMessageDialog(this.getSession().getArchitectFrame(), Messages.getString("CheckForUpdateAction.upToDate"), Messages.getString("CheckForUpdateAction.name"), 1);
            }
        }
        catch (IOException ex) {
            logger.error((Object)"Fail to retrieve current version number!");
            if (verbose) {
                ASUtils.showExceptionDialogNoReport(this.getSession().getArchitectFrame(), Messages.getString("CheckForUpdateAction.failedToCheckForUpdate"), ex);
            }
        }
        finally {
            this.urlc.disconnect();
            try {
                if (this.propertyInputStream != null) {
                    this.propertyInputStream.close();
                }
            }
            catch (IOException ex2) {
                logger.error((Object)"Exception while trying to close input stream.");
                throw new RuntimeException(ex2);
            }
        }
    }

    private void promptUpdate() {
        int response = JOptionPane.showConfirmDialog(this.getSession().getArchitectFrame(), Messages.getString("CheckForUpdateAction.newerVersionAvailable"), Messages.getString("CheckForUpdateAction.name"), 0);
        if (response == 0) {
            try {
                BrowserUtil.launch((String)UPDATE_URL);
            }
            catch (IOException e) {
                ASUtils.showExceptionDialogNoReport(this.getSession().getArchitectFrame(), Messages.getString("CheckForUpdateAction.failedToUpdate"), e);
            }
        }
    }
}

