/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.www.Messages;
import org.pentaho.di.www.TransformationMap;
import org.pentaho.di.www.WebResult;

public class CleanupTransServlet
extends HttpServlet {
    private static final long serialVersionUID = -5879200987669847357L;
    public static final String CONTEXT_PATH = "/kettle/cleanupTrans";
    private static LogWriter log = LogWriter.getInstance();
    private TransformationMap transformationMap;

    public CleanupTransServlet(TransformationMap transformationMap) {
        this.transformationMap = transformationMap;
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!request.getContextPath().equals(CONTEXT_PATH)) {
            return;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("TransStatusServlet.Log.TransCleanupRequested"), new Object[0]);
        }
        String transName = request.getParameter("name");
        String sockets = request.getParameter("sockets");
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        if (useXML) {
            response.setContentType("text/xml");
            response.setCharacterEncoding("UTF-8");
            out.print(XMLHandler.getXMLHeader((String)"UTF-8"));
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD>");
            out.println("<TITLE>Transformation cleanup</TITLE>");
            out.println("<META http-equiv=\"Refresh\" content=\"2;url=/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">");
            out.println("</HEAD>");
            out.println("<BODY>");
        }
        try {
            String message;
            if ("Y".equalsIgnoreCase(sockets)) {
                this.transformationMap.deallocateServerSocketPorts(transName);
                message = Messages.getString("TransStatusServlet.Log.TransServerSocketPortsReleased", transName);
            } else {
                Trans trans = this.transformationMap.getTransformation(transName);
                if (trans != null) {
                    trans.cleanup();
                    trans.endProcessing("end");
                    message = Messages.getString("TransStatusServlet.Log.TransCleanednup", transName);
                } else {
                    message = "The specified transformation [" + transName + "] could not be found";
                    if (useXML) {
                        out.println(new WebResult("ERROR", message));
                    } else {
                        out.println("<H1>" + message + "</H1>");
                        out.println("<a href=\"/kettle/status\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
                    }
                }
            }
            if (useXML) {
                out.println(new WebResult("OK", message).getXML());
            } else {
                out.println("<H1>" + message + "</H1>");
                out.println("<a href=\"/kettle/transStatus?name=" + URLEncoder.encode(transName, "UTF-8") + "\">" + Messages.getString("TransStatusServlet.BackToStatusPage") + "</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", "Unexpected error during transformations cleanup:" + Const.CR + Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Transformation cleanup";
    }
}

