/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.NativeTrade;
import net.sf.freecol.common.model.NativeTradeItem;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;
import net.sf.freecol.common.util.RandomUtils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.MissionAIPlayer;
import net.sf.freecol.server.ai.Wish;
import net.sf.freecol.server.ai.mission.DefendSettlementMission;
import net.sf.freecol.server.ai.mission.IndianBringGiftMission;
import net.sf.freecol.server.ai.mission.IndianDemandMission;
import net.sf.freecol.server.ai.mission.Mission;
import net.sf.freecol.server.ai.mission.UnitSeekAndDestroyMission;
import net.sf.freecol.server.ai.mission.UnitWanderHostileMission;

public final class NativeAIPlayer
extends MissionAIPlayer {
    private static final Logger logger = Logger.getLogger(NativeAIPlayer.class.getName());
    public static final int MAX_DISTANCE_TO_BRING_GIFTS = 5;
    public static final int MAX_NUMBER_OF_GIFTS_BEING_DELIVERED = 1;
    public static final int MAX_DISTANCE_TO_MAKE_DEMANDS = 5;
    public static final int MAX_NUMBER_OF_DEMANDS = 1;
    private final Map<Unit, String> reasons = new HashMap<Unit, String>();

    public NativeAIPlayer(AIMain aiMain, Player player) {
        super(aiMain, player);
        this.initialized = this.getPlayer() != null;
    }

    public NativeAIPlayer(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.initialized = this.getPlayer() != null;
    }

    private void initializeMissions(LogBuilder lb) {
        Player player = this.getPlayer();
        lb.add("\n  Initialize");
        for (IndianSettlement is : player.getIndianSettlementList()) {
            List<Unit> units = is.getAllUnitsList();
            while (units.size() > is.getRequiredDefenders()) {
                Unit u = units.remove(0);
                AIUnit aiu = this.getAIUnit(u);
                Mission m = this.getWanderHostileMission(aiu);
                if (m == null) continue;
                lb.add(" ", m);
            }
            for (Unit u : units) {
                AIUnit aiu = this.getAIUnit(u);
                Mission m = this.getDefendSettlementMission(aiu, is);
                if (m == null) continue;
                lb.add(" ", m);
            }
        }
    }

    private void determineStances(LogBuilder lb) {
        Player player = this.getPlayer();
        lb.mark();
        for (Player p : this.getGame().getLivePlayerList(player)) {
            Stance newStance = this.determineStance(p);
            if (newStance == player.getStance(p)) continue;
            this.getAIMain().getFreeColServer().getInGameController().changeStance(player, newStance, p, true);
            lb.add(" ", p.getDebugName(), "->", newStance, ", ");
        }
        if (lb.grew("\n  Stance changes:")) {
            lb.shrink(", ");
        }
    }

    private void secureSettlements(int[] randoms, LogBuilder lb) {
        int randomIdx = 0;
        List<IndianSettlement> settlements = this.getPlayer().getIndianSettlementList();
        for (IndianSettlement is : settlements) {
            int n;
            IndianSettlement settlement;
            if ((settlement = settlements.get(n = randoms[randomIdx++])) == is) continue;
            is.tradeGoodsWithSettlement(settlement);
        }
        for (IndianSettlement is : settlements) {
            lb.mark();
            this.equipBraves(is, lb);
            this.secureIndianSettlement(is, lb);
            if (!lb.grew("\n  At ", is.getName())) continue;
            lb.shrink(", ");
        }
    }

    public void equipBraves(IndianSettlement is, LogBuilder lb) {
        Comparator<Unit> comp = this.getGame().getCombatModel().getMilitaryStrengthComparator();
        for (Unit u : CollectionUtils.sort(is.getAllUnitsList(), comp)) {
            Role r = is.canImproveUnitMilitaryRole(u);
            if (r == null) continue;
            Role old = u.getRole();
            if (!this.getAIUnit(u).equipForRole(r) || u.getRole() == old) continue;
            lb.add(u, " upgraded from ", old.getSuffix(), ", ");
        }
    }

    public void secureIndianSettlement(IndianSettlement is, LogBuilder lb) {
        DefendSettlementMission dm;
        AIMain aiMain = this.getAIMain();
        Player player = this.getPlayer();
        CombatModel cm = this.getGame().getCombatModel();
        int minimumDefence = is.getType().getMinimumSize() - 1;
        List<Unit> units = is.getAllUnitsList();
        ArrayList<Unit> defenders = new ArrayList<Unit>();
        for (Unit u2 : is.getOwnedUnitList()) {
            if (units.contains(u2)) continue;
            units.add(u2);
        }
        for (Unit u2 : new ArrayList<Unit>(units)) {
            AIUnit aiu = aiMain.getAIUnit(u2);
            if (aiu == null) {
                units.remove(u2);
                continue;
            }
            dm = aiu.getMission(DefendSettlementMission.class);
            if (dm != null && dm.getTarget() == is) {
                defenders.add(u2);
                units.remove(u2);
                continue;
            }
            if (Mission.invalidNewMissionReason(aiu) == null) continue;
            units.remove(u2);
        }
        HashMap<Tile, Double> threats = new HashMap<Tile, Double>();
        for (Tile t2 : is.getTile().getSurroundingTiles(is.getRadius() + 1)) {
            double bonus;
            double threshold;
            if (!t2.isLand() || t2.getUnitCount() == 0) continue;
            Player enemy = t2.getFirstUnit().getOwner();
            if (enemy == player) {
                for (Unit u3 : t2.getUnitList()) {
                    AIUnit aiu;
                    if (defenders.contains(u3) || units.contains(u3) || (aiu = aiMain.getAIUnit(u3)) == null) continue;
                    dm = aiu.getMission(DefendSettlementMission.class);
                    if (dm != null && dm.getTarget() == is) {
                        defenders.add(u3);
                        continue;
                    }
                    if (Mission.invalidNewMissionReason(aiu) != null) continue;
                    units.add(u3);
                }
                continue;
            }
            Tension tension = is.getAlarm(enemy);
            if (tension == null || tension.getLevel().compareTo(Tension.Level.CONTENT) <= 0) continue;
            double value = 0.0;
            if (tension.getLevel().compareTo(Tension.Level.DISPLEASED) <= 0) {
                threshold = 1.0;
                bonus = 0.0;
            } else {
                threshold = 0.0;
                bonus = (float)tension.getLevel().ordinal() - (float)Tension.Level.CONTENT.ordinal();
            }
            if (!((value += CollectionUtils.sumDouble(t2.getUnits(), u -> cm.getOffencePower((FreeColGameObject)u, is) > threshold, u -> cm.getOffencePower((FreeColGameObject)u, is) + bonus)) > 0.0)) continue;
            threats.put(t2, value);
        }
        int homeBonus = 3;
        Tile isTile = is.getTile();
        Comparator<Unit> isComparator = CollectionUtils.cachingIntComparator(u -> {
            Tile t = u.getTile();
            return t.getDistanceTo(isTile) - (u.getHomeIndianSettlement() == is ? 3 : 0);
        });
        int needed = minimumDefence + threats.size();
        if (defenders.size() < needed) {
            units.sort(isComparator);
            while (!units.isEmpty()) {
                Unit u4 = units.remove(0);
                AIUnit aiu = aiMain.getAIUnit(u4);
                Mission m = this.getDefendSettlementMission(aiu, is);
                if (m == null) continue;
                lb.add(m, ", ");
                defenders.add(u4);
                if (defenders.size() < needed) continue;
                break;
            }
        } else if (defenders.size() > needed) {
            defenders.sort(isComparator.reversed());
            while (defenders.size() > needed) {
                units.add((Unit)defenders.remove(0));
            }
        }
        Comparator<Tile> threatComp = Comparator.comparingDouble(t -> (Double)threats.get(t));
        List<Tile> threatTiles = CollectionUtils.sort(threats.keySet(), threatComp);
        if (!defenders.isEmpty()) {
            lb.add(" defend with:");
            for (Unit u5 : defenders) {
                lb.add(" ", u5);
            }
            lb.add(" minimum=", minimumDefence, " threats=", threats.size(), ", ");
        }
        while (!threatTiles.isEmpty() && !units.isEmpty()) {
            Unit target;
            Comparator<Unit> scoreComp;
            ToIntFunction<Unit> score;
            Tile tile = threatTiles.remove(0);
            Predicate<Unit> validPred = arg_0 -> NativeAIPlayer.lambda$secureIndianSettlement$5(aiMain, tile, score = CollectionUtils.cacheInt(u -> u.getTile().getDistanceTo(tile)), arg_0);
            Unit unit = CollectionUtils.minimize(units, validPred, scoreComp = Comparator.comparingInt(score));
            if (unit == null) continue;
            units.remove(unit);
            AIUnit aiUnit = aiMain.getAIUnit(unit);
            Mission m = this.getSeekAndDestroyMission(aiUnit, target = tile.getDefendingUnit(unit));
            if (m == null) continue;
            lb.add(m, ", ");
        }
    }

    private void giveNormalMissions(LogBuilder lb) {
        Unit unit;
        Player player = this.getPlayer();
        List<AIUnit> aiUnits = this.getAIUnits();
        lb.mark();
        ArrayList<AIUnit> done = new ArrayList<AIUnit>(aiUnits.size());
        this.reasons.clear();
        for (AIUnit aiUnit : aiUnits) {
            unit = aiUnit.getUnit();
            Mission m = aiUnit.getMission();
            if (!unit.isInitialized() || unit.isDisposed()) {
                this.reasons.put(unit, "Invalid");
            } else {
                if (m == null || !m.isValid() || m.isOneTime()) continue;
                this.reasons.put(unit, "Valid");
            }
            done.add(aiUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        for (AIUnit aiUnit : aiUnits) {
            unit = aiUnit.getUnit();
            Settlement settlement = unit.getSettlement();
            IndianSettlement is = unit.getHomeIndianSettlement();
            Mission m = aiUnit.getMission();
            if (settlement != null && settlement.getUnitCount() + settlement.getTile().getUnitCount() <= 1) {
                if (!(m instanceof DefendSettlementMission) || m.getTarget() != settlement) {
                    m = this.getDefendSettlementMission(aiUnit, settlement);
                    if (m == null) continue;
                    lb.add(m, ", ");
                }
                this.reasons.put(unit, "Defend-" + settlement.getName());
            } else if (is != null && is.canImproveUnitMilitaryRole(unit) != null) {
                if (!(m instanceof DefendSettlementMission) || m.getTarget() != is) {
                    m = this.getDefendSettlementMission(aiUnit, is);
                    if (m == null) continue;
                    lb.add(m, ", ");
                }
                this.reasons.put(unit, "Equip-" + is.getName());
            } else {
                if (!(m instanceof UnitWanderHostileMission)) {
                    m = this.getWanderHostileMission(aiUnit);
                    if (m == null) continue;
                    lb.add(m, ", ");
                }
                this.reasons.put(unit, "Patrol");
            }
            done.add(aiUnit);
        }
        aiUnits.removeAll(done);
        done.clear();
        if (lb.grew("\n  Mission changes: ")) {
            lb.shrink(", ");
        }
        if (!aiUnits.isEmpty()) {
            lb.add("\n  Free Land Units:");
            for (AIUnit aiu : aiUnits) {
                lb.add(" ", aiu.getUnit());
            }
        }
        lb.add("\n  Missions(settlements=", player.getSettlementCount(), ")");
        this.logMissions(this.reasons, lb);
    }

    private void bringGifts(int[] randoms, LogBuilder lb) {
        Player player = this.getPlayer();
        CostDecider cd = CostDeciders.numberOfLegalTiles();
        int giftPercent = this.getSpecification().getPercentage("model.option.giftProbability");
        int randomIdx = 0;
        lb.mark();
        for (IndianSettlement is : player.getIndianSettlementList()) {
            Goods gift;
            if (randoms[randomIdx++] >= giftPercent || (gift = is.getRandomGift(this.getAIRandom())) == null) continue;
            ArrayList<Unit> availableUnits = new ArrayList<Unit>();
            int alreadyAssignedUnits = 0;
            for (Unit ou : is.getOwnedUnitList()) {
                AIUnit aiu = this.getAIUnit(ou);
                if (aiu == null) continue;
                if (aiu.hasMission(IndianBringGiftMission.class)) {
                    ++alreadyAssignedUnits;
                    continue;
                }
                if (Mission.invalidNewMissionReason(aiu) != null) continue;
                availableUnits.add(ou);
            }
            if (alreadyAssignedUnits > 1) {
                lb.add(is.getName(), " has ", alreadyAssignedUnits, " already, ");
                continue;
            }
            if (availableUnits.isEmpty()) {
                lb.add(is.getName(), " has no gift units, ");
                continue;
            }
            Unit unit = null;
            AIUnit aiUnit = null;
            Tile home = is.getTile();
            while (unit == null && !availableUnits.isEmpty()) {
                Unit u = (Unit)availableUnits.get(RandomUtils.randomInt(logger, "Gift unit", this.getAIRandom(), availableUnits.size()));
                availableUnits.remove(u);
                aiUnit = this.getAIUnit(u);
                if (IndianBringGiftMission.invalidMissionReason(aiUnit) != null || u.findPath(u.getTile(), home, null, cd, null) == null) continue;
                unit = u;
            }
            if (unit == null) {
                lb.add(is.getName(), " found no gift unit, ");
                continue;
            }
            ArrayList nearbyColonies = new ArrayList();
            for (Tile t : home.getSurroundingTiles(5)) {
                PathNode path;
                Colony c = t.getColony();
                if (c == null || !is.hasContacted(c.getOwner()) || IndianBringGiftMission.invalidMissionReason(aiUnit, c) != null || (path = unit.findPath(home, c.getTile(), null, cd, null)) == null) continue;
                int alarm = Math.max(1, is.getAlarm(c.getOwner()).getValue());
                nearbyColonies.add(new RandomChoice<Colony>(c, 1000000 / alarm / (1 + path.getTotalTurns())));
            }
            if (nearbyColonies.isEmpty()) {
                lb.add(is.getName(), " found no gift colonies, ");
                continue;
            }
            Colony target = (Colony)RandomChoice.getWeightedRandom(logger, "Choose gift colony", nearbyColonies, this.getAIRandom());
            if (target == null) {
                throw new RuntimeException("No gift target: " + this);
            }
            IndianBringGiftMission m = new IndianBringGiftMission(this.getAIMain(), aiUnit, target);
            lb.add(m, " gift from ", is.getName(), " to ", target.getName(), ", ");
        }
        if (lb.grew("\n  Gifts: ")) {
            lb.shrink(", ");
        }
    }

    private void demandTribute(int[] randoms, LogBuilder lb) {
        Player player = this.getPlayer();
        CostDecider cd = CostDeciders.numberOfLegalTiles();
        int demandPercent = this.getSpecification().getPercentage("model.option.demandProbability");
        int randomIdx = 0;
        lb.mark();
        for (IndianSettlement is : player.getIndianSettlementList()) {
            if (randoms[randomIdx++] >= demandPercent) continue;
            ArrayList<Unit> availableUnits = new ArrayList<Unit>();
            int alreadyAssignedUnits = 0;
            for (Unit ou : is.getOwnedUnitList()) {
                AIUnit aiu = this.getAIUnit(ou);
                if (Mission.invalidNewMissionReason(aiu) != null) continue;
                if (aiu.hasMission(IndianDemandMission.class)) {
                    ++alreadyAssignedUnits;
                    continue;
                }
                availableUnits.add(ou);
            }
            if (alreadyAssignedUnits > 1) {
                lb.add(is.getName(), " has ", alreadyAssignedUnits, " already, ");
                continue;
            }
            if (availableUnits.isEmpty()) {
                lb.add(is.getName(), " has no demand units, ");
                continue;
            }
            Tile home = is.getTile();
            Unit unit = null;
            AIUnit aiUnit = null;
            while (unit == null && !availableUnits.isEmpty()) {
                Unit u = (Unit)availableUnits.get(RandomUtils.randomInt(logger, "Demand unit", this.getAIRandom(), availableUnits.size()));
                availableUnits.remove(u);
                aiUnit = this.getAIUnit(u);
                if (IndianDemandMission.invalidMissionReason(aiUnit) != null || u.findPath(u.getTile(), home, null, cd, null) == null) continue;
                unit = u;
            }
            if (unit == null) {
                lb.add(is.getName(), " found no demand unit, ");
                continue;
            }
            ArrayList nearbyColonies = new ArrayList();
            for (Tile t : home.getSurroundingTiles(5)) {
                PathNode path;
                Colony c = t.getColony();
                if (c == null || !is.hasContacted(c.getOwner()) || IndianDemandMission.invalidMissionReason(aiUnit, c) != null || (path = unit.findPath(home, c.getTile(), null, cd, null)) == null) continue;
                int alarm = is.getAlarm(c.getOwner()).getValue();
                int defence = c.getUnitCount() + (c.getStockade() == null ? 1 : c.getStockade().getLevel() * 10);
                int weight = 1 + alarm * (1000000 / defence / (1 + path.getTotalTurns()));
                nearbyColonies.add(new RandomChoice<Colony>(c, weight));
            }
            if (nearbyColonies.isEmpty()) {
                lb.add(is.getName(), " found no demand colonies, ");
                continue;
            }
            Colony target = (Colony)RandomChoice.getWeightedRandom(logger, "Choose demand colony", nearbyColonies, this.getAIRandom());
            if (target == null) {
                lb.add(is.getName(), " found no demand target, ");
                continue;
            }
            IndianDemandMission m = new IndianDemandMission(this.getAIMain(), aiUnit, target);
            lb.add("At ", is.getName(), " ", m, " will demand of ", target, ", ");
        }
        if (lb.grew("\n  Tribute: ")) {
            lb.shrink(", ");
        }
    }

    private List<Modifier> getShipTradePenalties(boolean sense) {
        Specification spec = this.getSpecification();
        int penalty = (sense ? 1 : -1) * spec.getInteger("model.option.shipTradePenalty");
        Function<Modifier, Modifier> mapper = m -> Modifier.makeModifier(m).setValue(penalty);
        return CollectionUtils.transform(spec.getModifiers("model.modifier.shipTradePenalty"), CollectionUtils.alwaysTrue(), mapper);
    }

    public void abortInvalidMissions() {
        for (AIUnit au : this.getAIUnits()) {
            Mission mission = au.getMission();
            String reason = mission == null ? null : mission.invalidReason();
            if (reason == null) continue;
            au.changeMission(null);
        }
    }

    @Override
    public Constants.IndianDemandAction indianDemand(Unit unit, Colony colony, GoodsType type, int amount, Constants.IndianDemandAction accept) {
        IndianDemandMission mission;
        AIUnit aiu;
        Player player = this.getPlayer();
        if (unit.getOwner() == player && (aiu = this.getAIUnit(unit)) != null && (mission = aiu.getMission(IndianDemandMission.class)) != null && accept != Constants.IndianDemandAction.INDIAN_DEMAND_DONE) {
            mission.setSucceeded(accept == Constants.IndianDemandAction.INDIAN_DEMAND_ACCEPT);
        }
        return Constants.IndianDemandAction.INDIAN_DEMAND_DONE;
    }

    @Override
    public void startWorking() {
        List<AIUnit> more;
        Player player = this.getPlayer();
        Turn turn = this.getGame().getTurn();
        int nSettlements = player.getSettlementCount();
        Random air = this.getAIRandom();
        LogBuilder lb = new LogBuilder(1024);
        lb.add(player.getDebugName(), " in ", turn, "/", turn.getNumber());
        this.clearAIUnits();
        this.determineStances(lb);
        if (turn.isFirstTurn()) {
            this.initializeMissions(lb);
            more = this.getAIUnits();
        } else {
            this.abortInvalidMissions();
            if (nSettlements > 0) {
                int[] randoms = RandomUtils.randomInts(logger, "Trades", air, nSettlements, nSettlements);
                this.secureSettlements(randoms, lb);
                randoms = RandomUtils.randomInts(logger, "Gifts", air, 100, nSettlements);
                this.bringGifts(randoms, lb);
                randoms = RandomUtils.randomInts(logger, "Tribute", air, 100, nSettlements);
                this.demandTribute(randoms, lb);
            }
            this.giveNormalMissions(lb);
            more = this.doMissions(this.getAIUnits(), lb);
        }
        if (!more.isEmpty()) {
            this.abortInvalidMissions();
            this.giveNormalMissions(lb);
            this.doMissions(more, lb);
        }
        this.clearAIUnits();
        lb.log(logger, Level.FINEST);
    }

    @Override
    public int adjustMission(AIUnit aiUnit, PathNode path, Class type, int value) {
        if (type == DefendSettlementMission.class) {
            Settlement settlement = (Settlement)DefendSettlementMission.extractTarget(aiUnit, path);
            value -= 75 * this.getSettlementDefenders(settlement);
        } else if (type == UnitSeekAndDestroyMission.class) {
            Location target = UnitSeekAndDestroyMission.extractTarget(aiUnit, path);
            Player targetPlayer = target instanceof Ownable ? ((Ownable)((Object)target)).getOwner() : null;
            IndianSettlement is = aiUnit.getUnit().getHomeIndianSettlement();
            if (targetPlayer != null && is != null && is.getAlarm(targetPlayer) != null) {
                value += is.getAlarm(targetPlayer).getValue() - Tension.Level.DISPLEASED.getLimit();
            }
        }
        return value;
    }

    private void updateTrade(NativeTrade nt, int anger) {
        int h;
        int price;
        Object u;
        Specification spec = this.getSpecification();
        Turn turn = this.getGame().getTurn();
        IndianSettlement is = nt.getIndianSettlement();
        Unit unit = nt.getUnit();
        HashSet<Modifier> modifiers = new HashSet<Modifier>();
        if (is.hasMissionary(unit.getOwner()) && spec.getBoolean("model.option.enhancedMissionaries")) {
            u = is.getMissionary();
            modifiers.addAll(((Unit)u).getMissionaryTradeModifiers(true));
        }
        if (unit.isNaval()) {
            modifiers.addAll(this.getShipTradePenalties(true));
        }
        for (NativeTradeItem nti : nt.getUnitToSettlement()) {
            price = (int)FeatureContainer.applyModifiers(1.0f / (float)anger * (float)is.getPriceToBuy(nti.getGoods()), turn, modifiers);
            for (h = nti.getHaggleCount(); h >= 0; --h) {
                price = NativeTrade.haggleUp(price);
            }
            if (price <= 0) {
                price = -1;
            }
            nti.setPrice(price);
        }
        modifiers.clear();
        if (is.hasMissionary(unit.getOwner()) && spec.getBoolean("model.option.enhancedMissionaries")) {
            u = is.getMissionary();
            modifiers.addAll(((Unit)u).getMissionaryTradeModifiers(false));
        }
        if (unit.isNaval()) {
            modifiers.addAll(this.getShipTradePenalties(false));
        }
        for (NativeTradeItem nti : nt.getSettlementToUnit()) {
            price = (int)FeatureContainer.applyModifiers((float)anger * (float)is.getPriceToSell(nti.getGoods()), turn, modifiers);
            for (h = nti.getHaggleCount(); h >= 0; --h) {
                price = NativeTrade.haggleDown(price);
            }
            if (price <= 0) {
                price = -1;
            }
            nti.setPrice(price);
        }
    }

    @Override
    public NativeTrade.NativeTradeAction handleTrade(NativeTrade.NativeTradeAction action, NativeTrade nt) {
        Unit unit;
        Player other;
        int HAGGLE_NUMBER = 3;
        if (nt == null || !this.getPlayer().owns(nt.getIndianSettlement())) {
            return NativeTrade.NativeTradeAction.NAK_INVALID;
        }
        IndianSettlement is = nt.getIndianSettlement();
        Tension tension = is.getAlarm(other = (unit = nt.getUnit()).getOwner());
        if (tension == null) {
            return NativeTrade.NativeTradeAction.NAK_INVALID;
        }
        switch (action) {
            case OPEN: {
                int anger;
                switch (tension.getLevel()) {
                    case HAPPY: 
                    case CONTENT: {
                        anger = 1;
                        break;
                    }
                    case DISPLEASED: {
                        anger = 2;
                        break;
                    }
                    default: {
                        anger = -1;
                    }
                }
                if (anger < 0) {
                    return NativeTrade.NativeTradeAction.NAK_HOSTILE;
                }
                this.updateTrade(nt, anger);
                return nt.getDone() ? NativeTrade.NativeTradeAction.NAK_NOSALE : NativeTrade.NativeTradeAction.ACK_OPEN;
            }
            case BUY: {
                int anger;
                switch (tension.getLevel()) {
                    case HAPPY: 
                    case CONTENT: {
                        anger = 1;
                        break;
                    }
                    case DISPLEASED: {
                        anger = 2;
                        break;
                    }
                    default: {
                        anger = -1;
                    }
                }
                if (anger < 0) {
                    return NativeTrade.NativeTradeAction.NAK_HOSTILE;
                }
                this.updateTrade(nt, anger);
                NativeTradeItem ours = CollectionUtils.find(nt.getSettlementToUnit(), nt.getItem().goodsMatcher());
                if (ours == null) {
                    return NativeTrade.NativeTradeAction.NAK_INVALID;
                }
                if (nt.getItem().priceIsSet() && nt.getItem().getPrice() >= ours.getPrice()) {
                    return NativeTrade.NativeTradeAction.ACK_BUY;
                }
                int haggle = ours.getHaggleCount() + 1;
                if (RandomUtils.randomInt(logger, "Haggle-buy", this.getAIRandom(), 3 + haggle) >= 3) {
                    return NativeTrade.NativeTradeAction.NAK_HAGGLE;
                }
                ours.setHaggleCount(haggle);
                this.updateTrade(nt, anger);
                nt.setItem(ours);
                return NativeTrade.NativeTradeAction.ACK_BUY_HAGGLE;
            }
            case SELL: {
                int anger;
                switch (tension.getLevel()) {
                    case HAPPY: 
                    case CONTENT: {
                        anger = 1;
                        break;
                    }
                    case DISPLEASED: {
                        anger = 2;
                        break;
                    }
                    case ANGRY: {
                        anger = CollectionUtils.any(nt.getUnitToSettlement(), nti -> nti.getGoods().getType().getMilitary()) ? 3 : -1;
                        break;
                    }
                    default: {
                        anger = -1;
                    }
                }
                if (anger < 0) {
                    return NativeTrade.NativeTradeAction.NAK_HOSTILE;
                }
                this.updateTrade(nt, anger);
                NativeTradeItem ours = CollectionUtils.find(nt.getUnitToSettlement(), nt.getItem().goodsMatcher());
                if (ours == null) {
                    return NativeTrade.NativeTradeAction.NAK_INVALID;
                }
                if (nt.getItem().priceIsSet() && nt.getItem().getPrice() <= ours.getPrice()) {
                    return NativeTrade.NativeTradeAction.ACK_SELL;
                }
                int haggle = ours.getHaggleCount() + 1;
                if (RandomUtils.randomInt(logger, "Haggle-sell", this.getAIRandom(), 3 + haggle) >= 3) {
                    return NativeTrade.NativeTradeAction.NAK_HAGGLE;
                }
                ours.setHaggleCount(haggle);
                this.updateTrade(nt, anger);
                nt.setItem(ours);
                return NativeTrade.NativeTradeAction.ACK_SELL_HAGGLE;
            }
            case GIFT: {
                NativeTradeItem ours = CollectionUtils.find(nt.getUnitToSettlement(), nt.getItem().goodsMatcher());
                if (ours == null) {
                    return NativeTrade.NativeTradeAction.NAK_INVALID;
                }
                return is.canAdd(nt.getItem().getGoods()) ? NativeTrade.NativeTradeAction.ACK_GIFT : NativeTrade.NativeTradeAction.NAK_GOODS;
            }
        }
        return NativeTrade.NativeTradeAction.NAK_INVALID;
    }

    @Override
    public int getNeededWagons(Tile tile) {
        throw new RuntimeException("Can not happen: " + this);
    }

    @Override
    public int pioneersNeeded() {
        throw new RuntimeException("Can not happen: " + this);
    }

    @Override
    public int scoutsNeeded() {
        throw new RuntimeException("Can not happen: " + this);
    }

    @Override
    public void completeWish(Wish w) {
        throw new RuntimeException("Can not happen: " + this);
    }

    private static /* synthetic */ boolean lambda$secureIndianSettlement$5(AIMain aiMain, Tile tile, ToIntFunction score, Unit u) {
        return UnitSeekAndDestroyMission.invalidMissionReason(aiMain.getAIUnit(u), tile.getDefendingUnit(u)) == null && score.applyAsInt(u) >= 0;
    }
}

