/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import java.awt.EventQueue;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.OptionsChangedListener;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.MainFooterPanel;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.db.TableAlertTag;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.extension.XmlReporterExtension;
import org.zaproxy.zap.extension.alert.AlertAPI;
import org.zaproxy.zap.extension.alert.AlertAddDialog;
import org.zaproxy.zap.extension.alert.AlertEventPublisher;
import org.zaproxy.zap.extension.alert.AlertNode;
import org.zaproxy.zap.extension.alert.AlertPanel;
import org.zaproxy.zap.extension.alert.AlertParam;
import org.zaproxy.zap.extension.alert.AlertTreeModel;
import org.zaproxy.zap.extension.alert.OptionsAlertPanel;
import org.zaproxy.zap.extension.alert.PopupMenuAlert;
import org.zaproxy.zap.extension.alert.PopupMenuAlertDelete;
import org.zaproxy.zap.extension.alert.PopupMenuAlertEdit;
import org.zaproxy.zap.extension.alert.PopupMenuAlertSetFalsePositive;
import org.zaproxy.zap.extension.alert.PopupMenuAlertsRefresh;
import org.zaproxy.zap.extension.alert.PopupMenuShowAlerts;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.model.Target;

public class ExtensionAlert
extends ExtensionAdaptor
implements SessionChangedListener,
XmlReporterExtension,
OptionsChangedListener {
    public static final String NAME = "ExtensionAlert";
    private static final Logger logger = LogManager.getLogger(ExtensionAlert.class);
    private Map<Integer, HistoryReference> hrefs = new HashMap<Integer, HistoryReference>();
    private AlertTreeModel treeModel = null;
    private AlertTreeModel filteredTreeModel = null;
    private AlertPanel alertPanel = null;
    private RecordScan recordScan = null;
    private PopupMenuAlert popupMenuAlertAdd;
    private PopupMenuAlertEdit popupMenuAlertEdit = null;
    private PopupMenuAlertSetFalsePositive popupMenuAlertSetFalsePositive = null;
    private PopupMenuAlertDelete popupMenuAlertDelete = null;
    private PopupMenuAlertsRefresh popupMenuAlertsRefresh = null;
    private PopupMenuShowAlerts popupMenuShowAlerts = null;
    private AlertParam alertParam = null;
    private OptionsAlertPanel optionsPanel = null;
    private Properties alertOverrides = new Properties();
    private AlertAddDialog dialogAlertAdd;

    public ExtensionAlert() {
        super(NAME);
        this.setOrder(27);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("alerts.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addOptionsParamSet(this.getAlertParam());
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsPanel());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertAdd());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertEdit());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertSetFalsePositive());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertDelete());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuAlertsRefresh());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuShowAlerts());
            extensionHook.getHookView().addStatusPanel(this.getAlertPanel());
            ExtensionHelp.enableHelpKey(this.getAlertPanel(), "ui.tabs.alerts");
        }
        extensionHook.addSessionListener(this);
        extensionHook.addOptionsChangedListener(this);
        extensionHook.addApiImplementor(new AlertAPI(this));
    }

    @Override
    public void optionsLoaded() {
        this.reloadOverridesFile();
    }

    @Override
    public void optionsChanged(OptionsParam optionsParam) {
        this.reloadOverridesFile();
    }

    public boolean reloadOverridesFile() {
        this.alertOverrides.clear();
        String filename = this.getAlertParam().getOverridesFilename();
        if (filename != null && filename.length() > 0) {
            boolean bl;
            block10: {
                File file = new File(filename);
                if (!file.isFile() || !file.canRead()) {
                    logger.error("Cannot read alert overrides file " + file.getAbsolutePath());
                    return false;
                }
                BufferedReader br = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);
                try {
                    this.alertOverrides.load(br);
                    logger.info("Read " + this.alertOverrides.size() + " overrides from " + file.getAbsolutePath());
                    bl = true;
                    if (br == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error("Failed to read alert overrides file " + file.getAbsolutePath(), (Throwable)e);
                        return false;
                    }
                }
                br.close();
            }
            return bl;
        }
        return true;
    }

    private OptionsAlertPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new OptionsAlertPanel();
        }
        return this.optionsPanel;
    }

    private AlertParam getAlertParam() {
        if (this.alertParam == null) {
            this.alertParam = new AlertParam();
        }
        return this.alertParam;
    }

    public void alertFound(Alert alert, HistoryReference ref) {
        if (ExtensionAlert.isInvalid(alert)) {
            return;
        }
        try {
            logger.debug("alertFound " + alert.getName() + " " + alert.getUri());
            if (ref == null) {
                ref = alert.getHistoryRef();
            }
            if (ref == null) {
                ref = new HistoryReference(this.getModel().getSession(), 3, alert.getMessage());
                alert.setHistoryRef(ref);
            }
            if (alert.getSource() == Alert.Source.UNKNOWN) {
                alert.setSource(Alert.Source.TOOL);
            }
            alert.setSourceHistoryId(ref.getHistoryId());
            this.hrefs.put(ref.getHistoryId(), ref);
            this.applyOverrides(alert);
            this.writeAlertToDB(alert, ref);
            try {
                if (this.getView() == null || EventQueue.isDispatchThread()) {
                    SessionStructure.addPath(Model.getSingleton(), ref, alert.getMessage());
                } else {
                    final HistoryReference fRef = ref;
                    final HttpMessage fMsg = alert.getMessage();
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            SessionStructure.addPath(Model.getSingleton(), fRef, fMsg);
                        }
                    });
                }
                ref.addAlert(alert);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            this.addAlertToTree(alert);
            alert.setMessage(null);
            this.publishAlertEvent(alert, "alert.added");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static boolean isInvalid(Alert alert) {
        if (alert.getUri().isEmpty() || alert.getMessage() == null) {
            logger.error("Attempting to raise an alert without URI and/or HTTP message, Plugin ID: " + alert.getPluginId() + " Alert Name:" + alert.getName() + "\n\t" + StringUtils.join((Object[])Thread.currentThread().getStackTrace(), "\n\t"));
            return true;
        }
        return false;
    }

    protected void applyOverrides(Alert alert) {
        String changedReference;
        String changedOther;
        String changedSolution;
        String changedDesc;
        if (this.alertOverrides.isEmpty()) {
            return;
        }
        String changedName = this.alertOverrides.getProperty(alert.getPluginId() + ".name");
        if (changedName != null) {
            alert.setName(this.applyOverride(alert.getName(), changedName));
        }
        if ((changedDesc = this.alertOverrides.getProperty(alert.getPluginId() + ".description")) != null) {
            alert.setDescription(this.applyOverride(alert.getDescription(), changedDesc));
        }
        if ((changedSolution = this.alertOverrides.getProperty(alert.getPluginId() + ".solution")) != null) {
            alert.setSolution(this.applyOverride(alert.getSolution(), changedSolution));
        }
        if ((changedOther = this.alertOverrides.getProperty(alert.getPluginId() + ".otherInfo")) != null) {
            alert.setOtherInfo(this.applyOverride(alert.getOtherInfo(), changedOther));
        }
        if ((changedReference = this.alertOverrides.getProperty(alert.getPluginId() + ".reference")) != null) {
            alert.setReference(this.applyOverride(alert.getReference(), changedReference));
        }
        HashMap<String, String> tags = new HashMap<String, String>(alert.getTags());
        for (Map.Entry<Object, Object> e : this.alertOverrides.entrySet()) {
            String propertyKey = e.getKey().toString();
            if (!propertyKey.startsWith(alert.getPluginId() + ".tag.")) continue;
            String tagKey = propertyKey.substring((alert.getPluginId() + ".tag.").length());
            tags.put(tagKey, this.applyOverride(alert.getTags().getOrDefault(tagKey, ""), e.getValue().toString()));
        }
        alert.setTags(tags);
    }

    protected void setAlertOverrideProperty(String key, String value) {
        this.alertOverrides.put(key, value);
    }

    private String applyOverride(String original, String override) {
        if (override.startsWith("+")) {
            return original + override.substring(1);
        }
        if (override.startsWith("-")) {
            return override.substring(1) + original;
        }
        return override;
    }

    private void publishAlertEvent(Alert alert, String event) {
        HistoryReference historyReference = this.hrefs.get(alert.getSourceHistoryId());
        if (historyReference == null) {
            historyReference = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class).getHistoryReference(alert.getSourceHistoryId());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("alertId", Integer.toString(alert.getAlertId()));
        map.put("historyId", Integer.toString(alert.getSourceHistoryId()));
        map.put("name", alert.getName());
        map.put("uri", alert.getUri().toString());
        map.put("param", alert.getParam());
        map.put("risk", Integer.toString(alert.getRisk()));
        map.put("riskString", Alert.MSG_RISK[alert.getRisk()]);
        map.put("confidence", Integer.toString(alert.getConfidence()));
        map.put("confidenceString", Alert.MSG_CONFIDENCE[alert.getConfidence()]);
        map.put("source", Integer.toString(alert.getSource().getId()));
        ZAP.getEventBus().publishSyncEvent(AlertEventPublisher.getPublisher(), new Event(AlertEventPublisher.getPublisher(), event, new Target(historyReference.getSiteNode()), map));
    }

    private void addAlertToTree(final Alert alert) {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        if (!this.hasView() || EventQueue.isDispatchThread()) {
            this.addAlertToTreeEventHandler(alert);
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAlert.this.addAlertToTreeEventHandler(alert);
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isInFilter(Alert alert) {
        return this.getModel().getSession().isInScope(alert.getHistoryRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAlertToTreeEventHandler(Alert alert) {
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            this.getTreeModel().addPath(alert);
            if (this.isInFilter(alert)) {
                this.getFilteredTreeModel().addPath(alert);
            }
            if (this.getView() != null) {
                this.getAlertPanel().expandRoot();
                this.recalcAlerts();
            }
        }
    }

    AlertPanel getAlertPanel() {
        if (this.alertPanel == null) {
            this.alertPanel = new AlertPanel(this);
            this.alertPanel.setSize(345, 122);
            this.setMainTreeModel();
        }
        return this.alertPanel;
    }

    AlertTreeModel getTreeModel() {
        if (this.treeModel == null) {
            this.treeModel = new AlertTreeModel();
        }
        return this.treeModel;
    }

    private AlertTreeModel getFilteredTreeModel() {
        if (this.filteredTreeModel == null) {
            this.filteredTreeModel = new AlertTreeModel();
        }
        return this.filteredTreeModel;
    }

    private void writeAlertToDB(Alert alert, HistoryReference ref) throws HttpMalformedHeaderException, DatabaseException {
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        int scanId = 0;
        if (this.recordScan != null) {
            scanId = this.recordScan.getScanId();
        }
        RecordAlert recordAlert = tableAlert.write(scanId, alert.getPluginId(), alert.getName(), alert.getRisk(), alert.getConfidence(), alert.getDescription(), alert.getUri(), alert.getParam(), alert.getAttack(), alert.getOtherInfo(), alert.getSolution(), alert.getReference(), alert.getEvidence(), alert.getCweId(), alert.getWascId(), ref.getHistoryId(), alert.getSourceHistoryId(), alert.getSource().getId(), alert.getAlertRef());
        int alertId = recordAlert.getAlertId();
        alert.setAlertId(alertId);
        TableAlertTag tableAlertTag = this.getModel().getDb().getTableAlertTag();
        for (Map.Entry<String, String> e : alert.getTags().entrySet()) {
            tableAlertTag.insertOrUpdate(alertId, e.getKey(), e.getValue());
        }
    }

    public void updateAlert(Alert alert) throws HttpMalformedHeaderException, DatabaseException {
        logger.debug("updateAlert " + alert.getName() + " " + alert.getUri());
        HistoryReference hRef = this.hrefs.get(alert.getSourceHistoryId());
        if (hRef != null) {
            this.updateAlertInDB(alert);
            hRef.updateAlert(alert);
            this.publishAlertEvent(alert, "alert.changed");
            this.updateAlertInTree(alert, alert);
        }
    }

    private void updateAlertInDB(Alert alert) throws HttpMalformedHeaderException, DatabaseException {
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        tableAlert.update(alert.getAlertId(), alert.getName(), alert.getRisk(), alert.getConfidence(), alert.getDescription(), alert.getUri(), alert.getParam(), alert.getAttack(), alert.getOtherInfo(), alert.getSolution(), alert.getReference(), alert.getEvidence(), alert.getCweId(), alert.getWascId(), alert.getSourceHistoryId());
        int alertId = alert.getAlertId();
        TableAlertTag tableAlertTag = this.getModel().getDb().getTableAlertTag();
        Map<String, String> existingTags = tableAlertTag.getTagsByAlertId(alertId);
        Map<String, String> newTags = alert.getTags();
        for (Map.Entry<String, String> e : existingTags.entrySet()) {
            if (newTags.containsKey(e.getKey())) continue;
            tableAlertTag.delete(alertId, e.getKey());
        }
        for (Map.Entry<String, String> e : newTags.entrySet()) {
            tableAlertTag.insertOrUpdate(alertId, e.getKey(), e.getValue());
        }
    }

    public void displayAlert(Alert alert) {
        logger.debug("displayAlert " + alert.getName() + " " + alert.getUri());
        this.alertPanel.getAlertViewPanel().displayAlert(alert);
    }

    public void updateAlertInTree(final Alert originalAlert, final Alert alert) {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        if (this.getView() == null || EventQueue.isDispatchThread()) {
            this.updateAlertInTreeEventHandler(originalAlert, alert);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAlert.this.updateAlertInTreeEventHandler(originalAlert, alert);
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void updateAlertInTreeEventHandler(Alert originalAlert, Alert alert) {
        this.getTreeModel().updatePath(originalAlert, alert);
        if (this.isInFilter(alert)) {
            this.getFilteredTreeModel().updatePath(originalAlert, alert);
        }
        this.recalcAlerts();
        if (this.hasView()) {
            JTree alertTree = this.getAlertPanel().getTreeAlert();
            TreePath alertPath = new TreePath(this.getTreeModel().getAlertNode(alert).getPath());
            alertTree.setSelectionPath(alertPath);
            alertTree.scrollPathToVisible(alertPath);
        }
    }

    @Override
    public void sessionChanged(final Session session) {
        if (EventQueue.isDispatchThread()) {
            this.sessionChangedEventHandler(session);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAlert.this.sessionChangedEventHandler(session);
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void sessionChangedEventHandler(Session session) {
        this.setTreeModel(new AlertTreeModel());
        this.treeModel = null;
        this.filteredTreeModel = null;
        this.hrefs = new HashMap<Integer, HistoryReference>();
        if (session == null) {
            return;
        }
        try {
            this.refreshAlert(session);
        }
        catch (DatabaseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.setTreeModel(this.getTreeModel());
    }

    private void refreshAlert(Session session) throws DatabaseException {
        if (Constant.isLowMemoryOptionSet()) {
            return;
        }
        SiteMap siteTree = this.getModel().getSession().getSiteTree();
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        TableAlertTag tableAlertTag = this.getModel().getDb().getTableAlertTag();
        Vector<Integer> v = tableAlert.getAlertList();
        ExtensionHistory extensionHistory = Control.getSingleton().getExtensionLoader().getExtension(ExtensionHistory.class);
        for (int i = 0; i < v.size(); ++i) {
            int alertId = v.get(i);
            RecordAlert recAlert = tableAlert.read(alertId);
            int historyId = recAlert.getHistoryId();
            HistoryReference historyReference = null;
            if (extensionHistory != null) {
                historyReference = extensionHistory.getHistoryReference(historyId);
            }
            if (historyReference == null) {
                historyReference = this.hrefs.get(historyId);
            }
            Alert alert = historyReference != null ? new Alert(recAlert, historyReference) : new Alert(recAlert);
            alert.setTags(tableAlertTag.getTagsByAlertId(alertId));
            historyReference = alert.getHistoryRef();
            if (historyReference == null) continue;
            this.addAlertToTree(alert);
            Integer key = historyId;
            if (this.hrefs.containsKey(key)) continue;
            this.hrefs.put(key, alert.getHistoryRef());
        }
        siteTree.nodeStructureChanged(siteTree.getRoot());
    }

    private PopupMenuAlert getPopupMenuAlertAdd() {
        if (this.popupMenuAlertAdd == null) {
            this.popupMenuAlertAdd = new PopupMenuAlert(Constant.messages.getString("alert.add.popup"), this);
        }
        return this.popupMenuAlertAdd;
    }

    private PopupMenuAlertEdit getPopupMenuAlertEdit() {
        if (this.popupMenuAlertEdit == null) {
            this.popupMenuAlertEdit = new PopupMenuAlertEdit(this);
        }
        return this.popupMenuAlertEdit;
    }

    private PopupMenuAlertSetFalsePositive getPopupMenuAlertSetFalsePositive() {
        if (this.popupMenuAlertSetFalsePositive == null) {
            this.popupMenuAlertSetFalsePositive = new PopupMenuAlertSetFalsePositive();
        }
        return this.popupMenuAlertSetFalsePositive;
    }

    private PopupMenuAlertDelete getPopupMenuAlertDelete() {
        if (this.popupMenuAlertDelete == null) {
            this.popupMenuAlertDelete = new PopupMenuAlertDelete();
        }
        return this.popupMenuAlertDelete;
    }

    private PopupMenuAlertsRefresh getPopupMenuAlertsRefresh() {
        if (this.popupMenuAlertsRefresh == null) {
            this.popupMenuAlertsRefresh = new PopupMenuAlertsRefresh();
        }
        return this.popupMenuAlertsRefresh;
    }

    private PopupMenuShowAlerts getPopupMenuShowAlerts() {
        if (this.popupMenuShowAlerts == null) {
            this.popupMenuShowAlerts = new PopupMenuShowAlerts(Constant.messages.getString("alerts.view.popup"), this);
        }
        return this.popupMenuShowAlerts;
    }

    public void deleteAlert(Alert alert) {
        logger.debug("deleteAlert " + alert.getName() + " " + alert.getUri());
        try {
            this.getModel().getDb().getTableAlert().deleteAlert(alert.getAlertId());
            this.getModel().getDb().getTableAlertTag().deleteAllTagsForAlert(alert.getAlertId());
        }
        catch (DatabaseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.deleteAlertFromDisplay(alert);
        this.publishAlertEvent(alert, "alert.removed");
    }

    public void deleteAllAlerts() {
        try {
            this.getModel().getDb().getTableAlert().deleteAllAlerts();
            this.getModel().getDb().getTableAlertTag().deleteAllTags();
        }
        catch (DatabaseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (!Constant.isLowMemoryOptionSet()) {
            SiteMap siteTree = this.getModel().getSession().getSiteTree();
            siteTree.getRoot().deleteAllAlerts();
        }
        for (HistoryReference href : this.hrefs.values()) {
            href.deleteAllAlerts();
        }
        ZAP.getEventBus().publishSyncEvent(AlertEventPublisher.getPublisher(), new Event(AlertEventPublisher.getPublisher(), "alert.all.removed", null));
        this.hrefs = new HashMap<Integer, HistoryReference>();
        this.treeModel = null;
        this.filteredTreeModel = null;
        this.setTreeModel(this.getTreeModel());
    }

    private void deleteAlertFromDisplay(final Alert alert) {
        if (this.getView() == null || Constant.isLowMemoryOptionSet()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.deleteAlertFromDisplayEventHandler(alert);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExtensionAlert.this.deleteAlertFromDisplayEventHandler(alert);
                    }
                });
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAlertFromDisplayEventHandler(Alert alert) {
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            this.getTreeModel().deletePath(alert);
            this.getFilteredTreeModel().deletePath(alert);
            ArrayList<HistoryReference> toDelete = new ArrayList<HistoryReference>();
            for (HistoryReference href : this.hrefs.values()) {
                if (!href.hasAlert(alert)) continue;
                href.deleteAlert(alert);
                if (href.hasAlerts()) continue;
                toDelete.add(href);
            }
            for (HistoryReference href : toDelete) {
                this.hrefs.remove(href.getHistoryId());
            }
        }
        this.recalcAlerts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHistoryReferenceAlerts(HistoryReference hRef) {
        List<Alert> alerts = hRef.getAlerts();
        SiteMap siteTree = this.getModel().getSession().getSiteTree();
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            for (int i = 0; i < alerts.size(); ++i) {
                Alert alert = alerts.get(i);
                this.getTreeModel().deletePath(alert);
                this.getFilteredTreeModel().deletePath(alert);
                try {
                    this.getModel().getDb().getTableAlert().deleteAlert(alert.getAlertId());
                    this.getModel().getDb().getTableAlertTag().deleteAllTagsForAlert(alert.getAlertId());
                    continue;
                }
                catch (DatabaseException e) {
                    logger.error("Failed to delete alert with ID: " + alert.getAlertId(), (Throwable)e);
                }
            }
            SiteNode node = hRef.getSiteNode();
            if (node == null) {
                node = siteTree.findNode(hRef.getURI(), hRef.getMethod(), hRef.getRequestBody());
            }
            if (node != null) {
                node.deleteAlerts(alerts);
            }
            alerts.clear();
            this.recalcAlerts();
        }
        this.hrefs.remove(hRef.getHistoryId());
    }

    void recalcAlerts() {
        if (!this.hasView()) {
            return;
        }
        int totalInfo = 0;
        int totalLow = 0;
        int totalMedium = 0;
        int totalHigh = 0;
        AlertNode parent = (AlertNode)this.getAlertPanel().getTreeAlert().getModel().getRoot();
        if (parent != null) {
            block6: for (int i = 0; i < parent.getChildCount(); ++i) {
                AlertNode child = parent.getChildAt(i);
                switch (child.getRisk()) {
                    case 0: {
                        ++totalInfo;
                        continue block6;
                    }
                    case 1: {
                        ++totalLow;
                        continue block6;
                    }
                    case 2: {
                        ++totalMedium;
                        continue block6;
                    }
                    case 3: {
                        ++totalHigh;
                    }
                }
            }
        }
        MainFooterPanel footer = this.getView().getMainFrame().getMainFooterPanel();
        footer.setAlertInfo(totalInfo);
        footer.setAlertLow(totalLow);
        footer.setAlertMedium(totalMedium);
        footer.setAlertHigh(totalHigh);
    }

    public List<Alert> getAllAlerts() {
        ArrayList<Alert> allAlerts = new ArrayList<Alert>();
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        TableAlertTag tableAlertTag = this.getModel().getDb().getTableAlertTag();
        try {
            Vector<Integer> v = tableAlert.getAlertList();
            for (int i = 0; i < v.size(); ++i) {
                int alertId = v.get(i);
                RecordAlert recAlert = tableAlert.read(alertId);
                Alert alert = new Alert(recAlert);
                if (alert.getHistoryRef() == null || allAlerts.contains(alert)) continue;
                alert.setTags(tableAlertTag.getTagsByAlertId(alertId));
                allAlerts.add(alert);
            }
        }
        catch (DatabaseException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return allAlerts;
    }

    @Override
    public String getXml(SiteNode site) {
        StringBuilder xml = new StringBuilder();
        xml.append("<alerts>");
        List<Alert> alerts = site.getAlerts();
        TreeSet<String> handledAlerts = new TreeSet<String>();
        for (int i = 0; i < alerts.size(); ++i) {
            Alert alert = alerts.get(i);
            if (alert.getConfidence() == 0) continue;
            if (this.getAlertParam().isMergeRelatedIssues()) {
                String fingerprint = this.alertFingerprint(alert);
                if (!handledAlerts.add(fingerprint)) continue;
                StringBuilder sb = new StringBuilder();
                sb.append("  <instances>\n");
                int count = 0;
                for (int j = i; j < alerts.size(); ++j) {
                    Alert alert2 = alerts.get(j);
                    if (!fingerprint.equals(this.alertFingerprint(alert2))) continue;
                    if (this.getAlertParam().getMaximumInstances() == 0 || count < this.getAlertParam().getMaximumInstances()) {
                        sb.append("  <instance>\n");
                        sb.append(alert2.getUrlParamXML());
                        sb.append("  </instance>\n");
                    }
                    ++count;
                }
                sb.append("  </instances>\n");
                sb.append("  <count>");
                sb.append(count);
                sb.append("</count>\n");
                xml.append(alert.toPluginXML(sb.toString()));
                continue;
            }
            String urlParamXML = alert.getUrlParamXML();
            xml.append(alert.toPluginXML(urlParamXML));
        }
        xml.append("</alerts>");
        return xml.toString();
    }

    private String alertFingerprint(Alert alert) {
        return alert.getPluginId() + "/" + alert.getName() + "/" + alert.getRisk() + "/" + alert.getConfidence();
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("alerts.desc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionScopeChanged(Session session) {
        AlertTreeModel alertTreeModel = this.getTreeModel();
        synchronized (alertTreeModel) {
            ((AlertNode)this.getFilteredTreeModel().getRoot()).removeAllChildren();
            AlertNode root = (AlertNode)this.getTreeModel().getRoot();
            this.filterTree(root);
            this.getFilteredTreeModel().nodeStructureChanged(root);
        }
        this.recalcAlerts();
    }

    private void filterTree(AlertNode node) {
        Alert alert;
        if (node.getUserObject() != null && this.isInFilter(alert = node.getUserObject())) {
            this.getFilteredTreeModel().addPath(alert);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.filterTree(node.getChildAt(i));
        }
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    public void setAlertTabFocus() {
        this.getAlertPanel().setTabFocus();
    }

    public void setShowJustInScope(boolean inScope) {
        if (inScope) {
            this.setLinkWithSitesTreeSelection(false);
            this.setTreeModel(this.getFilteredTreeModel());
        } else {
            this.setMainTreeModel();
        }
    }

    void setMainTreeModel() {
        this.setTreeModel(this.getTreeModel());
    }

    private void setTreeModel(AlertTreeModel alertTreeModel) {
        if (this.getView() == null) {
            return;
        }
        this.getAlertPanel().getTreeAlert().setModel(alertTreeModel);
        this.recalcAlerts();
    }

    public void setLinkWithSitesTreeSelection(boolean enabled) {
        this.getAlertPanel().setLinkWithSitesTreeSelection(enabled);
    }

    public void showAlertAddDialog(HistoryReference ref) {
        if (this.dialogAlertAdd == null || !this.dialogAlertAdd.isVisible()) {
            this.dialogAlertAdd = new AlertAddDialog((Frame)this.getView().getMainFrame(), false);
            this.dialogAlertAdd.setVisible(true);
            this.dialogAlertAdd.setHistoryRef(ref);
        }
    }

    public void showAlertAddDialog(HttpMessage httpMessage, int historyType) {
        if (this.dialogAlertAdd == null || !this.dialogAlertAdd.isVisible()) {
            this.dialogAlertAdd = new AlertAddDialog((Frame)this.getView().getMainFrame(), false);
            this.dialogAlertAdd.setHttpMessage(httpMessage, historyType);
            this.dialogAlertAdd.setVisible(true);
        }
    }

    public void showAlertEditDialog(Alert alert) {
        if (this.dialogAlertAdd == null || !this.dialogAlertAdd.isVisible()) {
            this.dialogAlertAdd = new AlertAddDialog((Frame)this.getView().getMainFrame(), false);
            this.dialogAlertAdd.setVisible(true);
            this.dialogAlertAdd.setAlert(alert);
        }
    }

    AlertAddDialog getDialogAlertAdd() {
        return this.dialogAlertAdd;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    public boolean isNewAlert(Alert alertToCheck) {
        return this.getTreeModel().getAlertNode(alertToCheck) == null;
    }
}

