/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Locale;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StatsdClient
extends TimerTask {
    private ByteBuffer sendBuffer;
    private Timer flushTimer;
    private boolean multi_metrics = false;
    private static final Random RNG = new Random();
    private static final Logger log = LogManager.getLogger(StatsdClient.class.getName());
    private final InetSocketAddress _address;
    private final DatagramChannel _channel;

    public StatsdClient(String host, int port) throws UnknownHostException, IOException {
        this(InetAddress.getByName(host), port);
    }

    public StatsdClient(InetAddress host, int port) throws IOException {
        this._address = new InetSocketAddress(host, port);
        this._channel = DatagramChannel.open();
        this._channel.configureBlocking(false);
        this._channel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)4096);
        this.setBufferSize((short)1500);
    }

    protected void finalize() {
        this.flush();
    }

    public synchronized void setBufferSize(short packetBufferSize) {
        if (this.sendBuffer != null) {
            this.flush();
        }
        this.sendBuffer = ByteBuffer.allocate(packetBufferSize);
    }

    public synchronized void enableMultiMetrics(boolean enable) {
        this.multi_metrics = enable;
    }

    public synchronized boolean startFlushTimer(long period) {
        if (this.flushTimer == null) {
            if (period <= 0L) {
                period = 2000L;
            }
            this.flushTimer = new Timer();
            this.flushTimer.schedule((TimerTask)this, period, period);
            return true;
        }
        return false;
    }

    public synchronized void stopFlushTimer() {
        if (this.flushTimer != null) {
            this.flushTimer.cancel();
            this.flushTimer = null;
        }
    }

    @Override
    public void run() {
        this.flush();
    }

    public boolean timing(String key, int value) {
        return this.timing(key, value, 1.0);
    }

    public boolean timing(String key, int value, double sampleRate) {
        return this.send(sampleRate, String.format(Locale.ENGLISH, "%s:%d|ms", key, value));
    }

    public boolean decrement(String key) {
        return this.increment(key, -1, 1.0);
    }

    public boolean decrement(String key, int magnitude) {
        return this.decrement(key, magnitude, 1.0);
    }

    public boolean decrement(String key, int magnitude, double sampleRate) {
        magnitude = magnitude < 0 ? magnitude : -magnitude;
        return this.increment(key, magnitude, sampleRate);
    }

    public boolean decrement(String ... keys) {
        return this.increment(-1, 1.0, keys);
    }

    public boolean decrement(int magnitude, String ... keys) {
        magnitude = magnitude < 0 ? magnitude : -magnitude;
        return this.increment(magnitude, 1.0, keys);
    }

    public boolean decrement(int magnitude, double sampleRate, String ... keys) {
        magnitude = magnitude < 0 ? magnitude : -magnitude;
        return this.increment(magnitude, sampleRate, keys);
    }

    public boolean increment(String key) {
        return this.increment(key, 1, 1.0);
    }

    public boolean increment(String key, int magnitude) {
        return this.increment(key, magnitude, 1.0);
    }

    public boolean increment(String key, int magnitude, double sampleRate) {
        String stat = String.format(Locale.ENGLISH, "%s:%s|c", key, magnitude);
        return this.send(sampleRate, stat);
    }

    public boolean increment(int magnitude, double sampleRate, String ... keys) {
        String[] stats = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            stats[i] = String.format(Locale.ENGLISH, "%s:%s|c", keys[i], magnitude);
        }
        return this.send(sampleRate, stats);
    }

    public boolean gauge(String key, double magnitude) {
        return this.gauge(key, magnitude, 1.0);
    }

    public boolean gauge(String key, double magnitude, double sampleRate) {
        String stat = String.format(Locale.ENGLISH, "%s:%s|g", key, magnitude);
        return this.send(sampleRate, stat);
    }

    private boolean send(double sampleRate, String ... stats) {
        boolean retval = false;
        if (sampleRate < 1.0) {
            for (String stat : stats) {
                if (!(RNG.nextDouble() <= sampleRate) || !this.doSend(stat = String.format(Locale.ENGLISH, "%s|@%f", stat, sampleRate))) continue;
                retval = true;
            }
        } else {
            for (String stat : stats) {
                if (!this.doSend(stat)) continue;
                retval = true;
            }
        }
        return retval;
    }

    private synchronized boolean doSend(String stat) {
        try {
            byte[] data = stat.getBytes("utf-8");
            if (this.sendBuffer.remaining() < data.length + 1) {
                this.flush();
            }
            if (this.sendBuffer.position() > 0) {
                this.sendBuffer.put((byte)10);
            }
            this.sendBuffer.put(data);
            if (!this.multi_metrics) {
                this.flush();
            }
            return true;
        }
        catch (IOException e) {
            log.error(String.format("Could not send stat %s to host %s:%d", this.sendBuffer.toString(), this._address.getHostName(), this._address.getPort()), (Throwable)e);
            return false;
        }
    }

    public synchronized boolean flush() {
        try {
            int sizeOfBuffer = this.sendBuffer.position();
            if (sizeOfBuffer <= 0) {
                return false;
            }
            this.sendBuffer.flip();
            int nbSentBytes = this._channel.send(this.sendBuffer, this._address);
            this.sendBuffer.limit(this.sendBuffer.capacity());
            this.sendBuffer.rewind();
            if (sizeOfBuffer == nbSentBytes) {
                return true;
            }
            log.error(String.format("Could not send entirely stat %s to host %s:%d. Only sent %d bytes out of %d bytes", this.sendBuffer.toString(), this._address.getHostName(), this._address.getPort(), nbSentBytes, sizeOfBuffer));
            return false;
        }
        catch (IOException e) {
            log.error(String.format("Could not send stat %s to host %s:%d", this.sendBuffer.toString(), this._address.getHostName(), this._address.getPort()), (Throwable)e);
            return false;
        }
    }
}

