/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.Iterator;

public class FilteredIterator<E>
implements Iterator<E> {
    private final Iterator<E> it;
    private final Filter<E> filter;
    private E nextValue;

    public FilteredIterator(Iterator<E> iterator, Filter<E> filter) {
        this.it = iterator;
        this.filter = filter;
        this.moveNext();
    }

    @Override
    public boolean hasNext() {
        return this.nextValue != null;
    }

    @Override
    public E next() throws NoSuchElementException {
        E e = this.nextValue;
        this.moveNext();
        return e;
    }

    private void moveNext() {
        while (this.it.hasNext()) {
            E e = this.it.next();
            if (!this.filter.test(e)) continue;
            this.nextValue = e;
            return;
        }
        this.nextValue = null;
    }

    @Override
    public int nextInt() throws NoSuchElementException {
        throw new NoSuchElementException("Iterator");
    }

    @Override
    public long nextLong() throws NoSuchElementException {
        throw new NoSuchElementException("Iterator");
    }

    @Override
    public void remove() throws NoSuchElementException {
        throw new NoSuchElementException("Iterator");
    }

    public static interface Filter<E> {
        public boolean test(E var1);
    }
}

