/*===------- llvm/Config/llvm-config.h - llvm configuration -------*- C -*-===*/
/*                                                                            */
/* Part of the LLVM Project, under the Apache License v2.0 with LLVM          */
/* Exceptions.                                                                */
/* See https://llvm.org/LICENSE.txt for license information.                  */
/* SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception                    */
/*                                                                            */
/*===----------------------------------------------------------------------===*/

/* This file enumerates variables from the LLVM configuration so that they
   can be in exported headers and won't override package specific directives.
   This is a C header that can be included in the llvm-c headers. */

#ifndef LLVM_CONFIG_H
#define LLVM_CONFIG_H

/*
 * When bsd.lib.mk builds shared libraries it builds with -DPIC which 
 * causes problems in the following files which use PIC as a variable name.
 * undefine PIC here to minimise the diff to upstream LLVM
 *
 * include/llvm/MC/MCObjectFileInfo.h
 * lib/MC/MCObjectFileInfo.cpp
 * lib/Transforms/Scalar/LICM.cpp
 * lib/Transforms/Utils/PredicateInfo.cpp
 */
#undef PIC

/* Define if LLVM_ENABLE_DUMP is enabled */
/* #undef LLVM_ENABLE_DUMP */

/* Define if threads enabled */
#define LLVM_ENABLE_THREADS 1

/* Has gcc/MSVC atomic intrinsics */
#define LLVM_HAS_ATOMICS 1

/* LLVM name for the native target MCA init function, if available */
/* #undef LLVM_NATIVE_TARGETMCA */

/* Define if this is Unixish platform */
#define LLVM_ON_UNIX 1

/* Define if we have the Intel JIT API runtime support library */
#define LLVM_USE_INTEL_JITEVENTS 0

/* Define if we have the oprofile JIT-support library */
#define LLVM_USE_OPROFILE 0

/* Define if we have the perf JIT-support library */
#define LLVM_USE_PERF 0

/* Major version of the LLVM API */
#define LLVM_VERSION_MAJOR 19

/* Minor version of the LLVM API */
#define LLVM_VERSION_MINOR 1

/* Patch version of the LLVM API */
#define LLVM_VERSION_PATCH 7

/* LLVM version string */
#define LLVM_VERSION_STRING "19.1.7"

/* Whether LLVM records statistics for use with GetStatistics(),
 * PrintStatistics() or PrintStatisticsJSON()
 */
#define LLVM_FORCE_ENABLE_STATS 0

/* Define if we have z3 and want to build it */
/* #undef LLVM_WITH_Z3 */

/* Define if we have curl and want to use it */
/* #undef LLVM_ENABLE_CURL */

/* Define if we have cpp-httplib and want to use it */
/* #undef LLVM_ENABLE_HTTPLIB */

/* Define if zlib compression is available */
#define LLVM_ENABLE_ZLIB 0

/* Define if zstd compression is available */
#define LLVM_ENABLE_ZSTD 0

/* Define if LLVM is using tflite */
/* #undef LLVM_HAVE_TFLITE */

/* Define to 1 if you have the <sysexits.h> header file. */
#define HAVE_SYSEXITS_H 1

/* Define if building libLLVM shared library */
#define LLVM_BUILD_LLVM_DYLIB

/* Define if building LLVM with BUILD_SHARED_LIBS */
/* #undef LLVM_BUILD_SHARED_LIBS */

/* Define if building LLVM with LLVM_FORCE_USE_OLD_TOOLCHAIN_LIBS */
/* #undef LLVM_FORCE_USE_OLD_TOOLCHAIN */

/* Define if llvm_unreachable should be optimized with undefined behavior
 * in non assert builds */
#define LLVM_UNREACHABLE_OPTIMIZE 1

/* Define to 1 if you have the DIA SDK installed, and to 0 if you don't. */
#define LLVM_ENABLE_DIA_SDK 0

/* Define if plugins enabled */
/* #undef LLVM_ENABLE_PLUGINS */

/* Define if logf128 is available */
/* #undef LLVM_HAS_LOGF128 */

#define LLVM_DEFAULT_TARGET_TRIPLE "riscv64-unknown-openbsd7.8"
#define LLVM_HOST_TRIPLE "riscv64-unknown-openbsd7.8"
#define LLVM_NATIVE_ARCH RISCV
#define LLVM_NATIVE_ASMPARSER LLVMInitializeRISCVAsmParser
#define LLVM_NATIVE_ASMPRINTER LLVMInitializeRISCVAsmPrinter
#define LLVM_NATIVE_DISASSEMBLER LLVMInitializeRISCVDisassembler
#define LLVM_NATIVE_TARGET LLVMInitializeRISCVTarget
#define LLVM_NATIVE_TARGETINFO LLVMInitializeRISCVTargetInfo
#define LLVM_NATIVE_TARGETMC LLVMInitializeRISCVTargetMC

#endif
