/* This file is autogenerated by egd_tables.py from evergreend.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 * SPDX-License-Identifier: MIT
 */

#ifndef EG_TABLES_H
#define EG_TABLES_H

struct eg_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into eg_strings_offsets */
};

struct eg_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct eg_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct eg_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_DEALLOC_STATE},
	{18, PKT3_DISPATCH_DIRECT},
	{34, PKT3_DISPATCH_INDIRECT},
	{52, PKT3_INDIRECT_BUFFER_END},
	{72, PKT3_SET_PREDICATION},
	{88, PKT3_REG_RMW},
	{96, PKT3_COND_EXEC},
	{106, PKT3_PRED_EXEC},
	{116, PKT3_DRAW_INDEX_2},
	{129, PKT3_CONTEXT_CONTROL},
	{145, PKT3_DRAW_INDEX_IMMD_BE},
	{164, PKT3_INDEX_TYPE},
	{175, PKT3_DRAW_INDEX},
	{186, PKT3_DRAW_INDEX_AUTO},
	{202, PKT3_DRAW_INDEX_IMMD},
	{218, PKT3_NUM_INSTANCES},
	{232, PKT3_STRMOUT_BUFFER_UPDATE},
	{254, PKT3_INDIRECT_BUFFER_MP},
	{273, PKT3_MEM_SEMAPHORE},
	{287, PKT3_MPEG_INDEX},
	{298, PKT3_WAIT_REG_MEM},
	{311, PKT3_MEM_WRITE},
	{321, PKT3_INDIRECT_BUFFER},
	{337, PKT3_PFP_SYNC_ME},
	{349, PKT3_SURFACE_SYNC},
	{362, PKT3_ME_INITIALIZE},
	{376, PKT3_COND_WRITE},
	{387, PKT3_EVENT_WRITE},
	{399, PKT3_EVENT_WRITE_EOP},
	{415, PKT3_EVENT_WRITE_EOS},
	{431, PKT3_ONE_REG_WRITE},
	{445, PKT3_SET_CONFIG_REG},
	{460, PKT3_SET_CONTEXT_REG},
	{476, PKT3_SET_ALU_CONST},
	{490, PKT3_SET_BOOL_CONST},
	{505, PKT3_SET_LOOP_CONST},
	{520, PKT3_SET_RESOURCE},
	{533, PKT3_SET_SAMPLER},
	{545, PKT3_SET_CTL_CONST},
	{559, PKT3_SURFACE_BASE_UPDATE},
	{579, PKT3_IT_OPCODE_C},
	{591, PKT3_CP_DMA},
	{598, PKT3_SET_APPEND_CNT},
	{613, PKT3_SAC_SRC_SEL_DATA},
	{630, PKT3_SAC_SRC_SEL_REG},
	{646, PKT3_SAC_SRC_SEL_GDS},
	{662, PKT3_SAC_SRC_SEL_MEM},
};

static const struct eg_field egd_fields_table[] = {
	/* 0 */
	{678, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 1 */
	{697, S_028B94_STREAMOUT_0_EN(~0u)},
	{712, S_028B94_STREAMOUT_1_EN(~0u)},
	{727, S_028B94_STREAMOUT_2_EN(~0u)},
	{742, S_028B94_STREAMOUT_3_EN(~0u)},
	{757, S_028B94_RAST_STREAM(~0u)},
	{769, S_028B94_RAST_STREAM_MASK(~0u)},
	{786, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 8 */
	{807, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{826, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{845, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{864, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	{883, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{902, S_028804_PS_ITER_SAMPLES(~0u)},
	{918, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{942, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{968, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{995, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{1017, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{1036, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{1054, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{1081, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{1108, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{1133, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	{1164, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{1182, S_028BDC_LAST_PIXEL(~0u)},
	{1193, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{1218, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	{1240, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{1257, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{1279, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{1295, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{1316, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 33 */
	{1339, S_008C00_VC_ENABLE(~0u)},
	{1349, S_008C00_EXPORT_SRC_C(~0u)},
	{1362, S_008C00_CS_PRIO(~0u)},
	{1370, S_008C00_LS_PRIO(~0u)},
	{1378, S_008C00_HS_PRIO(~0u)},
	{1386, S_008C00_PS_PRIO(~0u)},
	{1394, S_008C00_VS_PRIO(~0u)},
	{1402, S_008C00_GS_PRIO(~0u)},
	{1410, S_008C00_ES_PRIO(~0u)},
	/* 42 */
	{1418, S_008C04_NUM_PS_GPRS(~0u)},
	{1430, S_008C04_NUM_VS_GPRS(~0u)},
	{1442, S_008C04_NUM_CLAUSE_TEMP_GPRS(~0u)},
	/* 45 */
	{1463, S_008C08_NUM_GS_GPRS(~0u)},
	{1475, S_008C08_NUM_ES_GPRS(~0u)},
	/* 47 */
	{1487, S_008C0C_NUM_HS_GPRS(~0u)},
	{1499, S_008C0C_NUM_LS_GPRS(~0u)},
	/* 49 */
	{1511, S_008C18_NUM_PS_THREADS(~0u)},
	{1526, S_008C18_NUM_VS_THREADS(~0u)},
	{1541, S_008C18_NUM_GS_THREADS(~0u)},
	{1556, S_008C18_NUM_ES_THREADS(~0u)},
	/* 53 */
	{1571, S_008C1C_NUM_HS_THREADS(~0u)},
	{1586, S_008C1C_NUM_LS_THREADS(~0u)},
	/* 55 */
	{1601, S_008C20_NUM_PS_STACK_ENTRIES(~0u)},
	{1622, S_008C20_NUM_VS_STACK_ENTRIES(~0u)},
	/* 57 */
	{1643, S_008C24_NUM_GS_STACK_ENTRIES(~0u)},
	{1664, S_008C24_NUM_ES_STACK_ENTRIES(~0u)},
	/* 59 */
	{1685, S_008C28_NUM_HS_STACK_ENTRIES(~0u)},
	{1706, S_008C28_NUM_LS_STACK_ENTRIES(~0u)},
	/* 61 */
	{1727, S_008E2C_NUM_PS_LDS(~0u)},
	{1738, S_008E2C_NUM_LS_LDS(~0u)},
	/* 63 */
	{1749, S_008CF0_CACHE_FIFO_SIZE(~0u)},
	{1765, S_008CF0_FETCH_FIFO_HIWATER(~0u)},
	{1784, S_008CF0_DONE_FIFO_HIWATER(~0u)},
	{1802, S_008CF0_ALU_UPDATE_FIFO_HIWATER(~0u)},
	/* 67 */
	{1826, S_00913C_VTX_DONE_DELAY(~0u)},
	/* 68 */
	{1841, S_028C64_PITCH_TILE_MAX(~0u)},
	/* 69 */
	{1856, S_028C68_SLICE_TILE_MAX(~0u)},
	/* 70 */
	{1871, S_028C70_ENDIAN(~0u)},
	{2408, S_028C70_FORMAT(~0u), 49, 0},
	{2499, S_028C70_ARRAY_MODE(~0u), 5, 49},
	{2615, S_028C70_NUMBER_TYPE(~0u), 8, 54},
	{2671, S_028C70_COMP_SWAP(~0u), 4, 62},
	{2681, S_028C70_FAST_CLEAR(~0u)},
	{2692, S_028C70_COMPRESSION(~0u)},
	{2704, S_028C70_BLEND_CLAMP(~0u)},
	{2716, S_028C70_BLEND_BYPASS(~0u)},
	{2729, S_028C70_SIMPLE_FLOAT(~0u)},
	{2742, S_028C70_ROUND_MODE(~0u)},
	{2753, S_028C70_TILE_COMPACT(~0u)},
	{2814, S_028C70_SOURCE_FORMAT(~0u), 3, 66},
	{2828, S_028C70_RAT(~0u)},
	{2892, S_028C70_RESOURCE_TYPE(~0u), 6, 69},
	/* 85 */
	{2906, S_028C74_NON_DISP_TILING_ORDER(~0u)},
	{2928, S_028C74_TILE_SPLIT(~0u)},
	{2939, S_028C74_NUM_BANKS(~0u)},
	{2949, S_028C74_BANK_WIDTH(~0u)},
	{2960, S_028C74_BANK_HEIGHT(~0u)},
	{2972, S_028C74_MACRO_TILE_ASPECT(~0u)},
	{2990, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{930, S_028C74_NUM_SAMPLES(~0u)},
	{3008, S_028C74_NUM_FRAGMENTS(~0u)},
	{3022, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 95 */
	{3040, S_028C78_WIDTH_MAX(~0u)},
	{3050, S_028C78_HEIGHT_MAX(~0u)},
	/* 97 */
	{3061, S_028410_ALPHA_FUNC(~0u)},
	{3072, S_028410_ALPHA_TEST_ENABLE(~0u)},
	{3090, S_028410_ALPHA_TEST_BYPASS(~0u)},
	/* 100 */
	{170, S_028B6C_TYPE(~0u), 3, 75},
	{3197, S_028B6C_PARTITIONING(~0u), 4, 78},
	{3274, S_028B6C_TOPOLOGY(~0u), 4, 82},
	{3283, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{3324, S_028B6C_BUFFER_ACCESS_MODE(~0u), 2, 86},
	{3343, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	/* 106 */
	{3365, S_028800_STENCIL_ENABLE(~0u)},
	{3380, S_028800_Z_ENABLE(~0u)},
	{3389, S_028800_Z_WRITE_ENABLE(~0u)},
	{3404, S_028800_ZFUNC(~0u)},
	{3410, S_028800_BACKFACE_ENABLE(~0u)},
	{3577, S_028800_STENCILFUNC(~0u), 8, 88},
	{3708, S_028800_STENCILFAIL(~0u), 8, 96},
	{3720, S_028800_STENCILZPASS(~0u)},
	{3733, S_028800_STENCILZFAIL(~0u)},
	{3746, S_028800_STENCILFUNC_BF(~0u)},
	{3761, S_028800_STENCILFAIL_BF(~0u)},
	{3776, S_028800_STENCILZPASS_BF(~0u)},
	{3792, S_028800_STENCILZFAIL_BF(~0u)},
	/* 119 */
	{3808, S_028808_DEGAMMA_ENABLE(~0u)},
	{1334, S_028808_MODE(~0u), 6, 104},
	{3913, S_028808_ROP3(~0u)},
	/* 122 */
	{3918, S_028810_UCP_ENA_0(~0u)},
	{3928, S_028810_UCP_ENA_1(~0u)},
	{3938, S_028810_UCP_ENA_2(~0u)},
	{3948, S_028810_UCP_ENA_3(~0u)},
	{3958, S_028810_UCP_ENA_4(~0u)},
	{3968, S_028810_UCP_ENA_5(~0u)},
	{3978, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{3997, S_028810_PS_UCP_MODE(~0u)},
	{4009, S_028810_CLIP_DISABLE(~0u)},
	{4022, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{4040, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{4063, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{4081, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{4101, S_028810_VTX_KILL_OR(~0u)},
	{4113, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{4135, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{4159, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{4185, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{4204, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 141 */
	{2408, S_028040_FORMAT(~0u), 4, 110},
	{930, S_028040_NUM_SAMPLES(~0u)},
	{2499, S_028040_ARRAY_MODE(~0u)},
	{4253, S_028040_READ_SIZE(~0u)},
	{4263, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{4283, S_028040_ZRANGE_PRECISION(~0u)},
	{2928, S_028040_TILE_SPLIT(~0u)},
	{2939, S_028040_NUM_BANKS(~0u)},
	{2949, S_028040_BANK_WIDTH(~0u)},
	{2960, S_028040_BANK_HEIGHT(~0u)},
	{2972, S_028040_MACRO_TILE_ASPECT(~0u)},
	/* 152 */
	{2408, S_028044_FORMAT(~0u), 2, 114},
	{2928, S_028044_TILE_SPLIT(~0u)},
	/* 154 */
	{1841, S_028058_PITCH_TILE_MAX(~0u)},
	{4326, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 156 */
	{1856, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 157 */
	{4342, S_028430_STENCILREF(~0u)},
	{4353, S_028430_STENCILMASK(~0u)},
	{4365, S_028430_STENCILWRITEMASK(~0u)},
	/* 160 */
	{4382, S_028434_STENCILREF_BF(~0u)},
	{4396, S_028434_STENCILMASK_BF(~0u)},
	{4411, S_028434_STENCILWRITEMASK_BF(~0u)},
	/* 163 */
	{4859, S_028780_COLOR_SRCBLEND(~0u), 21, 116},
	{4964, S_028780_COLOR_COMB_FCN(~0u), 5, 137},
	{4979, S_028780_COLOR_DESTBLEND(~0u)},
	{4995, S_028780_OPACITY_WEIGHT(~0u)},
	{5010, S_028780_ALPHA_SRCBLEND(~0u)},
	{5025, S_028780_ALPHA_COMB_FCN(~0u)},
	{5040, S_028780_ALPHA_DESTBLEND(~0u)},
	{5056, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{5077, S_028780_BLEND_CONTROL_ENABLE(~0u)},
	/* 172 */
	{5098, S_028814_CULL_FRONT(~0u)},
	{5109, S_028814_CULL_BACK(~0u)},
	{5119, S_028814_FACE(~0u)},
	{5124, S_028814_POLY_MODE(~0u)},
	{5134, S_028814_POLYMODE_FRONT_PTYPE(~0u)},
	{5155, S_028814_POLYMODE_BACK_PTYPE(~0u)},
	{5175, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{5200, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{5224, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{5248, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{5273, S_028814_PROVOKING_VTX_LAST(~0u)},
	{5292, S_028814_PERSP_CORR_DIS(~0u)},
	{5307, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 185 */
	{5325, S_028ABC_HTILE_WIDTH(~0u)},
	{5337, S_028ABC_HTILE_HEIGHT(~0u)},
	{5350, S_028ABC_LINEAR(~0u)},
	{5357, S_028ABC_FULL_CACHE(~0u)},
	{5368, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{5391, S_028ABC_PRELOAD(~0u)},
	{5399, S_028ABC_PREFETCH_WIDTH(~0u)},
	{5414, S_028ABC_PREFETCH_HEIGHT(~0u)},
	/* 193 */
	{5430, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{5446, S_02880C_STENCIL_EXPORT_ENABLE(~0u)},
	{5518, S_02880C_Z_ORDER(~0u), 4, 142},
	{5526, S_02880C_KILL_ENABLE(~0u)},
	{5538, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{5557, S_02880C_DUAL_EXPORT_ENABLE(~0u)},
	{5576, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{5594, S_02880C_EXEC_ON_NOOP(~0u)},
	{5653, S_02880C_DB_SOURCE_FORMAT(~0u), 3, 146},
	{5670, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{5692, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{5782, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 149},
	/* 205 */
	{2965, S_028A00_HEIGHT(~0u)},
	{1176, S_028A00_WIDTH(~0u)},
	/* 207 */
	{5804, S_028A0C_LINE_PATTERN(~0u)},
	{5817, S_028A0C_REPEAT_COUNT(~0u)},
	{5830, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{5848, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 211 */
	{1334, S_028A40_MODE(~0u), 6, 153},
	{5937, S_028A40_ES_PASSTHRU(~0u)},
	{5994, S_028A40_CUT_MODE(~0u), 4, 159},
	{6003, S_028A40_COMPUTE_MODE(~0u)},
	{6016, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	/* 216 */
	{6103, S_028A6C_OUTPRIM_TYPE(~0u), 3, 163},
	/* 217 */
	{6116, S_008040_WAIT_CP_DMA_IDLE(~0u)},
	{6133, S_008040_WAIT_CMDFIFO(~0u)},
	{6146, S_008040_WAIT_2D_IDLE(~0u)},
	{6159, S_008040_WAIT_3D_IDLE(~0u)},
	{6172, S_008040_WAIT_2D_IDLECLEAN(~0u)},
	{6190, S_008040_WAIT_3D_IDLECLEAN(~0u)},
	{6208, S_008040_WAIT_EXTERN_SIG(~0u)},
	{6224, S_008040_CMDFIFO_ENTRIES(~0u)},
	/* 225 */
	{6240, S_0286CC_NUM_INTERP(~0u)},
	{6251, S_0286CC_POSITION_ENA(~0u)},
	{6264, S_0286CC_POSITION_CENTROID(~0u)},
	{6282, S_0286CC_POSITION_ADDR(~0u)},
	{6296, S_0286CC_PARAM_GEN(~0u)},
	{6306, S_0286CC_PERSP_GRADIENT_ENA(~0u)},
	{6325, S_0286CC_LINEAR_GRADIENT_ENA(~0u)},
	{6345, S_0286CC_POSITION_SAMPLE(~0u)},
	/* 233 */
	{6361, S_0286D0_FRONT_FACE_ENA(~0u)},
	{6376, S_0286D0_FRONT_FACE_CHAN(~0u)},
	{6392, S_0286D0_FRONT_FACE_ALL_BITS(~0u)},
	{6412, S_0286D0_FRONT_FACE_ADDR(~0u)},
	{6428, S_0286D0_FOG_ADDR(~0u)},
	{6437, S_0286D0_FIXED_PT_POSITION_ENA(~0u)},
	{6459, S_0286D0_FIXED_PT_POSITION_ADDR(~0u)},
	/* 240 */
	{6482, S_0286C4_VS_PER_COMPONENT(~0u)},
	{6499, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{6515, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{6530, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 244 */
	{6550, S_0286E0_PERSP_CENTER_ENA(~0u)},
	{6567, S_0286E0_PERSP_CENTROID_ENA(~0u)},
	{6586, S_0286E0_PERSP_SAMPLE_ENA(~0u)},
	{6603, S_0286E0_PERSP_PULL_MODEL_ENA(~0u)},
	{6624, S_0286E0_LINEAR_CENTER_ENA(~0u)},
	{6642, S_0286E0_LINEAR_CENTROID_ENA(~0u)},
	{6662, S_0286E0_LINEAR_SAMPLE_ENA(~0u)},
	/* 251 */
	{6680, S_028250_TL_X(~0u)},
	{6685, S_028250_TL_Y(~0u)},
	{6690, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 254 */
	{6712, S_028254_BR_X(~0u)},
	{6717, S_028254_BR_Y(~0u)},
	/* 256 */
	{6680, S_028240_TL_X(~0u)},
	{6685, S_028240_TL_Y(~0u)},
	{6690, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 259 */
	{6712, S_028244_BR_X(~0u)},
	{6717, S_028244_BR_Y(~0u)},
	/* 261 */
	{6680, S_028030_TL_X(~0u)},
	{6685, S_028030_TL_Y(~0u)},
	/* 263 */
	{6712, S_028034_BR_X(~0u)},
	{6717, S_028034_BR_Y(~0u)},
	/* 265 */
	{6680, S_028204_TL_X(~0u)},
	{6685, S_028204_TL_Y(~0u)},
	{6690, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 268 */
	{6712, S_028208_BR_X(~0u)},
	{6717, S_028208_BR_Y(~0u)},
	/* 270 */
	{6722, S_0287F0_SOURCE_SELECT(~0u)},
	{6736, S_0287F0_MAJOR_MODE(~0u)},
	{5927, S_0287F0_SPRITE_EN(~0u)},
	{6747, S_0287F0_NOT_EOP(~0u)},
	{6755, S_0287F0_USE_OPAQUE(~0u)},
	/* 275 */
	{6911, S_030000_DIM(~0u), 8, 166},
	{2906, S_030000_NON_DISP_TILING_ORDER(~0u)},
	{6915, S_030000_PITCH(~0u)},
	{6921, S_030000_TEX_WIDTH(~0u)},
	/* 279 */
	{6931, S_030004_TEX_HEIGHT(~0u)},
	{6942, S_030004_TEX_DEPTH(~0u)},
	{2499, S_030004_ARRAY_MODE(~0u)},
	/* 282 */
	{6952, S_030008_BASE_ADDRESS(~0u)},
	/* 283 */
	{6965, S_03000C_MIP_ADDRESS(~0u)},
	/* 284 */
	{7054, S_030010_FORMAT_COMP_X(~0u), 3, 174},
	{7068, S_030010_FORMAT_COMP_Y(~0u)},
	{7082, S_030010_FORMAT_COMP_Z(~0u)},
	{7096, S_030010_FORMAT_COMP_W(~0u)},
	{7168, S_030010_NUM_FORMAT_ALL(~0u), 3, 177},
	{7230, S_030010_SRF_MODE_ALL(~0u), 2, 180},
	{7243, S_030010_FORCE_DEGAMMA(~0u)},
	{7257, S_030010_ENDIAN_SWAP(~0u)},
	{7269, S_030010_LOG2_NUM_FRAGMENTS(~0u)},
	{7342, S_030010_DST_SEL_X(~0u), 6, 182},
	{7352, S_030010_DST_SEL_Y(~0u)},
	{7362, S_030010_DST_SEL_Z(~0u)},
	{7372, S_030010_DST_SEL_W(~0u)},
	{7382, S_030010_BASE_LEVEL(~0u)},
	/* 298 */
	{7393, S_030014_LAST_LEVEL(~0u)},
	{7404, S_030014_BASE_ARRAY(~0u)},
	{7415, S_030014_LAST_ARRAY(~0u)},
	/* 301 */
	{7426, S_030018_MAX_ANISO_RATIO(~0u)},
	{2990, S_030018_FMASK_BANK_HEIGHT(~0u)},
	{7442, S_030018_PERF_MODULATION(~0u)},
	{7458, S_030018_INTERLACED(~0u)},
	{2928, S_030018_TILE_SPLIT(~0u)},
	/* 306 */
	{7469, S_03001C_DATA_FORMAT(~0u)},
	{2972, S_03001C_MACRO_TILE_ASPECT(~0u)},
	{2949, S_03001C_BANK_WIDTH(~0u)},
	{2960, S_03001C_BANK_HEIGHT(~0u)},
	{7481, S_03001C_DEPTH_SAMPLE_ORDER(~0u)},
	{2939, S_03001C_NUM_BANKS(~0u)},
	{170, S_03001C_TYPE(~0u), 4, 188},
	/* 313 */
	{7602, S_030008_BASE_ADDRESS_HI(~0u)},
	{7618, S_030008_STRIDE(~0u)},
	{7625, S_030008_CLAMP_X(~0u)},
	{7469, S_030008_DATA_FORMAT(~0u)},
	{7168, S_030008_NUM_FORMAT_ALL(~0u), 3, 177},
	{7633, S_030008_FORMAT_COMP_ALL(~0u)},
	{7230, S_030008_SRF_MODE_ALL(~0u)},
	{7257, S_030008_ENDIAN_SWAP(~0u)},
	/* 321 */
	{7649, S_03000C_UNCACHED(~0u)},
	{7342, S_03000C_DST_SEL_X(~0u), 6, 182},
	{7352, S_03000C_DST_SEL_Y(~0u)},
	{7362, S_03000C_DST_SEL_Z(~0u)},
	{7372, S_03000C_DST_SEL_W(~0u)},
	/* 326 */
	{7625, S_03C000_CLAMP_X(~0u), 8, 192},
	{7840, S_03C000_CLAMP_Y(~0u)},
	{7848, S_03C000_CLAMP_Z(~0u)},
	{7905, S_03C000_XY_MAG_FILTER(~0u), 2, 200},
	{7919, S_03C000_XY_MIN_FILTER(~0u)},
	{7999, S_03C000_Z_FILTER(~0u), 3, 202},
	{8008, S_03C000_MIP_FILTER(~0u)},
	{7426, S_03C000_MAX_ANISO_RATIO(~0u)},
	{8146, S_03C000_BORDER_COLOR_TYPE(~0u), 4, 205},
	{8396, S_03C000_DEPTH_COMPARE_FUNCTION(~0u), 8, 209},
	{8492, S_03C000_CHROMA_KEY(~0u), 3, 217},
	/* 337 */
	{8503, S_03C004_MIN_LOD(~0u)},
	{8511, S_03C004_MAX_LOD(~0u)},
	{8519, S_03C004_PERF_MIP(~0u)},
	{8528, S_03C004_PERF_Z(~0u)},
	/* 341 */
	{8535, S_03C008_LOD_BIAS(~0u)},
	{8544, S_03C008_LOD_BIAS_SEC(~0u)},
	{8557, S_03C008_MC_COORD_TRUNCATE(~0u)},
	{7243, S_03C008_FORCE_DEGAMMA(~0u)},
	{8575, S_03C008_ANISO_BIAS(~0u)},
	{8586, S_03C008_TRUNCATE_COORD(~0u)},
	{8601, S_03C008_DISABLE_CUBE_WRAP(~0u)},
	{170, S_03C008_TYPE(~0u)},
	/* 349 */
	{6106, S_008958_PRIM_TYPE(~0u), 29, 220},
	/* 350 */
	{9135, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{9151, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{9167, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{9183, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{9199, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{9215, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{9231, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{9247, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{9263, S_02881C_CULL_DIST_ENA_0(~0u)},
	{9279, S_02881C_CULL_DIST_ENA_1(~0u)},
	{9295, S_02881C_CULL_DIST_ENA_2(~0u)},
	{9311, S_02881C_CULL_DIST_ENA_3(~0u)},
	{9327, S_02881C_CULL_DIST_ENA_4(~0u)},
	{9343, S_02881C_CULL_DIST_ENA_5(~0u)},
	{9359, S_02881C_CULL_DIST_ENA_6(~0u)},
	{9375, S_02881C_CULL_DIST_ENA_7(~0u)},
	{9391, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{9410, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{9428, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{9455, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{9477, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{9495, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{9515, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{9538, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	/* 374 */
	{9561, S_028860_NUM_GPRS(~0u)},
	{9570, S_028860_STACK_SIZE(~0u)},
	{9581, S_028860_DX10_CLAMP(~0u)},
	{9592, S_028860_UNCACHED_FIRST_INST(~0u)},
	/* 378 */
	{9561, S_028878_NUM_GPRS(~0u)},
	{9570, S_028878_STACK_SIZE(~0u)},
	{9581, S_028878_DX10_CLAMP(~0u)},
	{9592, S_028878_UNCACHED_FIRST_INST(~0u)},
	/* 382 */
	{9561, S_028890_NUM_GPRS(~0u)},
	{9570, S_028890_STACK_SIZE(~0u)},
	{9581, S_028890_DX10_CLAMP(~0u)},
	{9592, S_028890_UNCACHED_FIRST_INST(~0u)},
	/* 386 */
	{9686, S_028864_SINGLE_ROUND(~0u), 4, 249},
	{9699, S_028864_DOUBLE_ROUND(~0u)},
	{9712, S_028864_ALLOW_SINGLE_DENORM_IN(~0u)},
	{9735, S_028864_ALLOW_SINGLE_DENORM_OUT(~0u)},
	{9759, S_028864_ALLOW_DOUBLE_DENORM_IN(~0u)},
	{9782, S_028864_ALLOW_DOUBLE_DENORM_OUT(~0u)},
	/* 392 */
	{9561, S_028844_NUM_GPRS(~0u)},
	{9570, S_028844_STACK_SIZE(~0u)},
	{9581, S_028844_DX10_CLAMP(~0u)},
	{9806, S_028844_PRIME_CACHE_ON_DRAW(~0u)},
	{9592, S_028844_UNCACHED_FIRST_INST(~0u)},
	{9826, S_028844_CLAMP_CONSTS(~0u)},
	/* 398 */
	{9686, S_028848_SINGLE_ROUND(~0u)},
	{9699, S_028848_DOUBLE_ROUND(~0u)},
	{9712, S_028848_ALLOW_SINGLE_DENORM_IN(~0u)},
	{9735, S_028848_ALLOW_SINGLE_DENORM_OUT(~0u)},
	{9759, S_028848_ALLOW_DOUBLE_DENORM_IN(~0u)},
	{9782, S_028848_ALLOW_DOUBLE_DENORM_OUT(~0u)},
	/* 404 */
	{9561, S_0288BC_NUM_GPRS(~0u)},
	{9570, S_0288BC_STACK_SIZE(~0u)},
	{9581, S_0288BC_DX10_CLAMP(~0u)},
	{9806, S_0288BC_PRIME_CACHE_ON_DRAW(~0u)},
	{9592, S_0288BC_UNCACHED_FIRST_INST(~0u)},
	/* 409 */
	{9561, S_0288D4_NUM_GPRS(~0u)},
	{9570, S_0288D4_STACK_SIZE(~0u)},
	{9581, S_0288D4_DX10_CLAMP(~0u)},
	{9806, S_0288D4_PRIME_CACHE_ON_DRAW(~0u)},
	{9592, S_0288D4_UNCACHED_FIRST_INST(~0u)},
	/* 414 */
	{9839, S_028644_SEMANTIC(~0u)},
	{9848, S_028644_DEFAULT_VAL(~0u)},
	{9860, S_028644_FLAT_SHADE(~0u)},
	{9871, S_028644_SEL_CENTROID(~0u)},
	{9884, S_028644_SEL_LINEAR(~0u)},
	{9895, S_028644_CYL_WRAP(~0u)},
	{9904, S_028644_PT_SPRITE_TEX(~0u)},
	{9918, S_028644_SEL_SAMPLE(~0u)},
	/* 422 */
	{9929, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{9944, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{9959, S_0286D4_PNT_SPRITE_OVRD_X(~0u)},
	{9977, S_0286D4_PNT_SPRITE_OVRD_Y(~0u)},
	{9995, S_0286D4_PNT_SPRITE_OVRD_Z(~0u)},
	{10013, S_0286D4_PNT_SPRITE_OVRD_W(~0u)},
	{10031, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 429 */
	{10048, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{10067, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{10088, S_028000_DEPTH_COPY_ENABLE(~0u)},
	{10106, S_028000_STENCIL_COPY_ENABLE(~0u)},
	{10126, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{10145, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{10170, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{10193, S_028000_COPY_CENTROID(~0u)},
	{10207, S_028000_COPY_SAMPLE(~0u)},
	{10219, S_028000_COLOR_DISABLE(~0u)},
	/* 439 */
	{10233, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{10257, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{10278, S_028004_SAMPLE_RATE(~0u)},
	/* 442 */
	{10290, S_028008_SLICE_START(~0u)},
	{10339, S_028008_SLICE_MAX(~0u), 3, 253},
	/* 444 */
	{10349, S_02800C_FORCE_HIZ_ENABLE(~0u)},
	{10366, S_02800C_FORCE_HIS_ENABLE0(~0u)},
	{10384, S_02800C_FORCE_HIS_ENABLE1(~0u)},
	{10402, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{10423, S_02800C_FAST_Z_DISABLE(~0u)},
	{10438, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{10459, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{10477, S_02800C_FORCE_COLOR_KILL(~0u)},
	{10494, S_02800C_FORCE_Z_READ(~0u)},
	{10507, S_02800C_FORCE_STENCIL_READ(~0u)},
	{10526, S_02800C_FORCE_FULL_Z_RANGE(~0u)},
	{10545, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{10569, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{10592, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{10609, S_02800C_DISABLE_PIXEL_RATE_TILES(~0u)},
	/* 459 */
	{10634, S_028350_MULTIPASS(~0u)},
	/* 460 */
	{10644, S_028354_SURFACE_SYNC_MASK(~0u)},
	/* 461 */
	{10662, S_0286D8_PROVIDE_Z_TO_SPI(~0u)},
	/* 462 */
	{10679, S_0286E8_TID_IN_GROUP_ENA(~0u)},
	{10696, S_0286E8_TGID_ENA(~0u)},
	{10705, S_0286E8_DISABLE_INDEX_PACK(~0u)},
	/* 465 */
	{10724, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{10742, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{10761, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{10779, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{10798, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{10816, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{10835, S_028818_VTX_XY_FMT(~0u)},
	{10846, S_028818_VTX_Z_FMT(~0u)},
	{10856, S_028818_VTX_W0_FMT(~0u)},
	/* 474 */
	{1422, S_028838_PS_GPRS(~0u)},
	{1434, S_028838_VS_GPRS(~0u)},
	{1467, S_028838_GS_GPRS(~0u)},
	{1479, S_028838_ES_GPRS(~0u)},
	{1491, S_028838_HS_GPRS(~0u)},
	{1503, S_028838_LS_GPRS(~0u)},
	/* 480 */
	{10867, S_02884C_EXPORT_COLORS(~0u)},
	{10881, S_02884C_EXPORT_Z(~0u)},
	/* 482 */
	{10890, S_028A04_MIN_SIZE(~0u)},
	{10899, S_028A04_MAX_SIZE(~0u)},
	/* 484 */
	{1176, S_028A08_WIDTH(~0u)},
	/* 485 */
	{10908, S_028A48_MSAA_ENABLE(~0u)},
	{10920, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{10941, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	/* 488 */
	{10961, S_028A84_PRIMITIVEID_EN(~0u)},
	/* 489 */
	{10976, S_028A94_RESET_EN(~0u)},
	/* 490 */
	{10985, S_028AC8_MAX_X(~0u)},
	{10991, S_028AC8_MAX_Y(~0u)},
	/* 492 */
	{10997, S_028B38_MAX_VERT_OUT(~0u)},
	/* 493 */
	{11047, S_028B54_LS_EN(~0u), 3, 256},
	{11053, S_028B54_HS_EN(~0u)},
	{11098, S_028B54_ES_EN(~0u), 3, 259},
	{11104, S_028B54_GS_EN(~0u)},
	{11157, S_028B54_VS_EN(~0u), 3, 262},
	/* 498 */
	{11163, S_028B58_NUM_PATCHES(~0u)},
	{11175, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{11191, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 501 */
	{1760, S_028B5C_SIZE(~0u)},
	{11208, S_028B5C_PATCH_CP_SIZE(~0u)},
	/* 503 */
	{1760, S_028B60_SIZE(~0u)},
	{11208, S_028B60_PATCH_CP_SIZE(~0u)},
	/* 505 */
	{11222, S_028B64_HS_TOTAL_OUTPUT(~0u)},
	{11238, S_028B64_LS_HS_TOTAL_OUTPUT(~0u)},
	/* 507 */
	{1760, S_028B68_SIZE(~0u)},
	{7618, S_028B68_STRIDE(~0u)},
	/* 509 */
	{11257, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{11278, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{11300, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{11322, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{11344, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{11366, S_028B70_OFFSET_ROUND(~0u)},
	/* 515 */
	{11379, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{11407, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 517 */
	{11435, S_028B80_SCALE(~0u)},
	/* 518 */
	{11441, S_028B84_OFFSET(~0u)},
	/* 519 */
	{11435, S_028B88_SCALE(~0u)},
	/* 520 */
	{11441, S_028B8C_OFFSET(~0u)},
	/* 521 */
	{1342, S_028B90_ENABLE(~0u)},
	{609, S_028B90_CNT(~0u)},
	/* 523 */
	{1164, S_028C00_EXPAND_LINE_WIDTH(~0u)},
	{1182, S_028C00_LAST_PIXEL(~0u)},
	/* 525 */
	{1240, S_028C04_MSAA_NUM_SAMPLES(~0u)},
	{1257, S_028C04_AA_MASK_CENTROID_DTMN(~0u)},
	{1279, S_028C04_MAX_SAMPLE_DIST(~0u)},
	/* 528 */
	{11448, S_028C08_PIX_CENTER_HALF(~0u)},
	{2742, S_028C08_ROUND_MODE(~0u), 4, 265},
	{11581, S_028C08_QUANT_MODE(~0u), 8, 269},
	/* 531 */
	{10290, S_028C6C_SLICE_START(~0u)},
	{10339, S_028C6C_SLICE_MAX(~0u)},
	/* 533 */
	{1847, S_028C80_TILE_MAX(~0u)},
	/* 534 */
	{1847, S_028C88_TILE_MAX(~0u)},
	/* 535 */
	{11592, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{11608, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{11624, S_0085F0_SO0_DEST_BASE_ENA(~0u)},
	{11642, S_0085F0_SO1_DEST_BASE_ENA(~0u)},
	{11660, S_0085F0_SO2_DEST_BASE_ENA(~0u)},
	{11678, S_0085F0_SO3_DEST_BASE_ENA(~0u)},
	{11696, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{11714, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{11732, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{11750, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{11768, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{11786, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{11804, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{11822, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{11840, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{11857, S_0085F0_CB8_DEST_BASE_ENA(~0u)},
	{11875, S_0085F0_CB9_DEST_BASE_ENA(~0u)},
	{11893, S_0085F0_CB10_DEST_BASE_ENA(~0u)},
	{11912, S_0085F0_CB11_DEST_BASE_ENA(~0u)},
	{11931, S_0085F0_TC_ACTION_ENA(~0u)},
	{11945, S_0085F0_VC_ACTION_ENA(~0u)},
	{11959, S_0085F0_CB_ACTION_ENA(~0u)},
	{11973, S_0085F0_DB_ACTION_ENA(~0u)},
	{11987, S_0085F0_SH_ACTION_ENA(~0u)},
	{12001, S_0085F0_SMX_ACTION_ENA(~0u)},
	{12016, S_0085F0_CR0_ACTION_ENA(~0u)},
	{12031, S_0085F0_CR1_ACTION_ENA(~0u)},
	{12046, S_0085F0_CR2_ACTION_ENA(~0u)},
	/* 563 */
	{1727, S_0286FC_NUM_PS_LDS(~0u)},
	{1738, S_0286FC_NUM_LS_LDS(~0u)},
	{883, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{902, S_028804_PS_ITER_SAMPLES(~0u)},
	{918, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{942, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{968, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{995, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{1017, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{1036, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{1054, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{1081, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{1240, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{1257, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{1279, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{1295, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{1316, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{12061, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{12076, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{12095, S_028AA8_SWITCH_ON_EOP(~0u)},
};

static const struct eg_reg egd_reg_table[] = {
	{12109, R_0084FC_CP_STRMOUT_CNTL, 1, 0},
	{12125, R_028B94_VGT_STRMOUT_CONFIG, 7, 1},
	{12144, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 25, 8},
	{12170, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{12203, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{12236, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{12269, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{12302, R_008C00_SQ_CONFIG, 9, 33},
	{12312, R_008C04_SQ_GPR_RESOURCE_MGMT_1, 3, 42},
	{12335, R_008C08_SQ_GPR_RESOURCE_MGMT_2, 2, 45},
	{12358, R_008C0C_SQ_GPR_RESOURCE_MGMT_3, 2, 47},
	{12381, R_008C10_SQ_GLOBAL_GPR_RESOURCE_MGMT_1},
	{12411, R_008C14_SQ_GLOBAL_GPR_RESOURCE_MGMT_2},
	{12441, R_008C18_SQ_THREAD_RESOURCE_MGMT_1, 4, 49},
	{12467, R_008C1C_SQ_THREAD_RESOURCE_MGMT_2, 2, 53},
	{12493, R_008C20_SQ_STACK_RESOURCE_MGMT_1, 2, 55},
	{12518, R_008C24_SQ_STACK_RESOURCE_MGMT_2, 2, 57},
	{12543, R_008C28_SQ_STACK_RESOURCE_MGMT_3, 2, 59},
	{12568, R_008E2C_SQ_LDS_RESOURCE_MGMT, 2, 61},
	{12589, R_008C40_SQ_ESGS_RING_BASE},
	{12607, R_008C44_SQ_ESGS_RING_SIZE},
	{12625, R_008C48_SQ_GSVS_RING_BASE},
	{12643, R_008C4C_SQ_GSVS_RING_SIZE},
	{12661, R_008CF0_SQ_MS_FIFO_SIZES, 4, 63},
	{12678, R_008E20_SQ_STATIC_THREAD_MGMT1},
	{12701, R_008E24_SQ_STATIC_THREAD_MGMT2},
	{12724, R_008E28_SQ_STATIC_THREAD_MGMT3},
	{12747, R_00899C_VGT_COMPUTE_START_X},
	{12767, R_0089A0_VGT_COMPUTE_START_Y},
	{12787, R_0089A4_VGT_COMPUTE_START_Z},
	{12807, R_0089AC_VGT_COMPUTE_THREAD_GROUP_SIZE},
	{12837, R_009100_SPI_CONFIG_CNTL},
	{12853, R_00913C_SPI_CONFIG_CNTL_1, 1, 67},
	{12871, R_028C64_CB_COLOR0_PITCH, 1, 68},
	{12887, R_028C68_CB_COLOR0_SLICE, 1, 69},
	{12903, R_028C70_CB_COLOR0_INFO, 15, 70},
	{12918, R_028C74_CB_COLOR0_ATTRIB, 10, 85},
	{12935, R_028C78_CB_COLOR0_DIM, 2, 95},
	{12949, R_028410_SX_ALPHA_TEST_CONTROL, 3, 97},
	{12971, R_0286EC_SPI_COMPUTE_NUM_THREAD_X},
	{12996, R_0286F0_SPI_COMPUTE_NUM_THREAD_Y},
	{13021, R_0286F4_SPI_COMPUTE_NUM_THREAD_Z},
	{13046, R_028B6C_VGT_TF_PARAM, 6, 100},
	{13059, R_028B74_VGT_DISPATCH_INITIATOR},
	{13082, R_028800_DB_DEPTH_CONTROL, 13, 106},
	{13099, R_028808_CB_COLOR_CONTROL, 3, 119},
	{13116, R_028810_PA_CL_CLIP_CNTL, 19, 122},
	{13132, R_028040_DB_Z_INFO, 11, 141},
	{13142, R_028044_DB_STENCIL_INFO, 2, 152},
	{13158, R_028058_DB_DEPTH_SIZE, 2, 154},
	{13172, R_02805C_DB_DEPTH_SLICE, 1, 156},
	{13187, R_028430_DB_STENCILREFMASK, 3, 157},
	{13205, R_028434_DB_STENCILREFMASK_BF, 3, 160},
	{13226, R_028780_CB_BLEND0_CONTROL, 9, 163},
	{13244, R_028814_PA_SU_SC_MODE_CNTL, 13, 172},
	{13263, R_028ABC_DB_HTILE_SURFACE, 8, 185},
	{13280, R_02880C_DB_SHADER_CONTROL, 12, 193},
	{13298, R_028A00_PA_SU_POINT_SIZE, 2, 205},
	{13315, R_028A0C_PA_SC_LINE_STIPPLE, 4, 207},
	{13334, R_028A40_VGT_GS_MODE, 5, 211},
	{13346, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 1, 216},
	{13367, R_008040_WAIT_UNTIL, 8, 217},
	{13378, R_0286CC_SPI_PS_IN_CONTROL_0, 8, 225},
	{13398, R_0286D0_SPI_PS_IN_CONTROL_1, 7, 233},
	{13418, R_0286C4_SPI_VS_OUT_CONFIG, 4, 240},
	{13436, R_0286E0_SPI_BARYC_CNTL, 7, 244},
	{13451, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 251},
	{13476, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 254},
	{13501, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 256},
	{13526, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 259},
	{13551, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 261},
	{13575, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 263},
	{13599, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 265},
	{13623, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 268},
	{13647, R_028A78_VGT_DMA_MAX_SIZE},
	{13664, R_028A7C_VGT_DMA_INDEX_TYPE},
	{13683, R_028A88_VGT_NUM_INSTANCES},
	{13701, R_0287E4_VGT_DMA_BASE_HI},
	{13717, R_0287E8_VGT_DMA_BASE},
	{13730, R_0287F0_VGT_DRAW_INITIATOR, 5, 270},
	{13749, R_030000_SQ_TEX_RESOURCE_WORD0_0, 4, 275},
	{13773, R_030004_SQ_TEX_RESOURCE_WORD1_0, 3, 279},
	{13797, R_030008_SQ_TEX_RESOURCE_WORD2_0, 1, 282},
	{13821, R_03000C_SQ_TEX_RESOURCE_WORD3_0, 1, 283},
	{13845, R_030010_SQ_TEX_RESOURCE_WORD4_0, 14, 284},
	{13869, R_030014_SQ_TEX_RESOURCE_WORD5_0, 3, 298},
	{13893, R_030018_SQ_TEX_RESOURCE_WORD6_0, 5, 301},
	{13917, R_03001C_SQ_TEX_RESOURCE_WORD7_0, 7, 306},
	{13941, R_030008_SQ_VTX_CONSTANT_WORD2_0, 8, 313},
	{13965, R_03000C_SQ_VTX_CONSTANT_WORD3_0, 5, 321},
	{13989, R_00A400_TD_PS_SAMPLER0_BORDER_INDEX},
	{14017, R_00A404_TD_PS_SAMPLER0_BORDER_RED},
	{14043, R_00A408_TD_PS_SAMPLER0_BORDER_GREEN},
	{14071, R_00A40C_TD_PS_SAMPLER0_BORDER_BLUE},
	{14098, R_00A410_TD_PS_SAMPLER0_BORDER_ALPHA},
	{14126, R_00A414_TD_VS_SAMPLER0_BORDER_INDEX},
	{14154, R_00A418_TD_VS_SAMPLER0_BORDER_RED},
	{14180, R_00A41C_TD_VS_SAMPLER0_BORDER_GREEN},
	{14208, R_00A420_TD_VS_SAMPLER0_BORDER_BLUE},
	{14235, R_00A424_TD_VS_SAMPLER0_BORDER_ALPHA},
	{14263, R_00A428_TD_GS_SAMPLER0_BORDER_INDEX},
	{14291, R_00A42C_TD_GS_SAMPLER0_BORDER_RED},
	{14317, R_00A430_TD_GS_SAMPLER0_BORDER_GREEN},
	{14345, R_00A434_TD_GS_SAMPLER0_BORDER_BLUE},
	{14372, R_00A438_TD_GS_SAMPLER0_BORDER_ALPHA},
	{14400, R_00A43C_TD_HS_SAMPLER0_BORDER_COLOR_INDEX},
	{14434, R_00A440_TD_HS_SAMPLER0_BORDER_COLOR_RED},
	{14466, R_00A444_TD_HS_SAMPLER0_BORDER_COLOR_GREEN},
	{14500, R_00A448_TD_HS_SAMPLER0_BORDER_COLOR_BLUE},
	{14533, R_00A44C_TD_HS_SAMPLER0_BORDER_COLOR_ALPHA},
	{14567, R_00A450_TD_LS_SAMPLER0_BORDER_COLOR_INDEX},
	{14601, R_00A454_TD_LS_SAMPLER0_BORDER_COLOR_RED},
	{14633, R_00A458_TD_LS_SAMPLER0_BORDER_COLOR_GREEN},
	{14667, R_00A45C_TD_LS_SAMPLER0_BORDER_COLOR_BLUE},
	{14700, R_00A460_TD_LS_SAMPLER0_BORDER_COLOR_ALPHA},
	{14734, R_00A464_TD_CS_SAMPLER0_BORDER_INDEX},
	{14762, R_00A468_TD_CS_SAMPLER0_BORDER_RED},
	{14788, R_00A46C_TD_CS_SAMPLER0_BORDER_GREEN},
	{14816, R_00A470_TD_CS_SAMPLER0_BORDER_BLUE},
	{14843, R_00A474_TD_CS_SAMPLER0_BORDER_ALPHA},
	{14871, R_03C000_SQ_TEX_SAMPLER_WORD0_0, 11, 326},
	{14894, R_03C004_SQ_TEX_SAMPLER_WORD1_0, 4, 337},
	{14917, R_03C008_SQ_TEX_SAMPLER_WORD2_0, 8, 341},
	{14940, R_008958_VGT_PRIMITIVE_TYPE, 1, 349},
	{14959, R_02881C_PA_CL_VS_OUT_CNTL, 24, 350},
	{14977, R_028860_SQ_PGM_RESOURCES_VS, 4, 374},
	{14997, R_028878_SQ_PGM_RESOURCES_GS, 4, 378},
	{15017, R_02887C_SQ_PGM_RESOURCES_2_GS},
	{15039, R_028890_SQ_PGM_RESOURCES_ES, 4, 382},
	{15059, R_028894_SQ_PGM_RESOURCES_2_ES},
	{15081, R_028864_SQ_PGM_RESOURCES_2_VS, 6, 386},
	{15103, R_028844_SQ_PGM_RESOURCES_PS, 6, 392},
	{15123, R_028848_SQ_PGM_RESOURCES_2_PS, 6, 398},
	{15145, R_0288BC_SQ_PGM_RESOURCES_HS, 5, 404},
	{15165, R_0288C0_SQ_PGM_RESOURCES_2_HS},
	{15187, R_0288D4_SQ_PGM_RESOURCES_LS, 5, 409},
	{15207, R_0288D8_SQ_PGM_RESOURCES_2_LS},
	{15229, R_028644_SPI_PS_INPUT_CNTL_0, 8, 414},
	{15249, R_0286D4_SPI_INTERP_CONTROL_0, 7, 422},
	{15270, R_008A14_PA_CL_ENHANCE},
	{15284, R_008D8C_SQ_DYN_GPR_CNTL_PS_FLUSH_REQ},
	{15313, R_028000_DB_RENDER_CONTROL, 10, 429},
	{15331, R_028004_DB_COUNT_CONTROL, 3, 439},
	{15348, R_028008_DB_DEPTH_VIEW, 2, 442},
	{15362, R_02800C_DB_RENDER_OVERRIDE, 15, 444},
	{15381, R_028010_DB_RENDER_OVERRIDE2},
	{15401, R_028014_DB_HTILE_DATA_BASE},
	{15420, R_028028_DB_STENCIL_CLEAR},
	{15437, R_02802C_DB_DEPTH_CLEAR},
	{15452, R_028048_DB_Z_READ_BASE},
	{15467, R_02804C_DB_STENCIL_READ_BASE},
	{15488, R_028050_DB_Z_WRITE_BASE},
	{15504, R_028054_DB_STENCIL_WRITE_BASE},
	{15526, R_028140_ALU_CONST_BUFFER_SIZE_PS_0},
	{15553, R_028144_ALU_CONST_BUFFER_SIZE_PS_1},
	{15580, R_028180_ALU_CONST_BUFFER_SIZE_VS_0},
	{15607, R_028184_ALU_CONST_BUFFER_SIZE_VS_1},
	{15634, R_0281C0_ALU_CONST_BUFFER_SIZE_GS_0},
	{15661, R_028F80_ALU_CONST_BUFFER_SIZE_HS_0},
	{15688, R_028FC0_ALU_CONST_BUFFER_SIZE_LS_0},
	{15715, R_028200_PA_SC_WINDOW_OFFSET},
	{15735, R_02820C_PA_SC_CLIPRECT_RULE},
	{15755, R_028210_PA_SC_CLIPRECT_0_TL},
	{15775, R_028214_PA_SC_CLIPRECT_0_BR},
	{15795, R_028218_PA_SC_CLIPRECT_1_TL},
	{15815, R_02821C_PA_SC_CLIPRECT_1_BR},
	{15835, R_028220_PA_SC_CLIPRECT_2_TL},
	{15855, R_028224_PA_SC_CLIPRECT_2_BR},
	{15875, R_028228_PA_SC_CLIPRECT_3_TL},
	{15895, R_02822C_PA_SC_CLIPRECT_3_BR},
	{15915, R_028230_PA_SC_EDGERULE},
	{15930, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET},
	{15959, R_028238_CB_TARGET_MASK},
	{15974, R_02823C_CB_SHADER_MASK},
	{15989, R_028350_SX_MISC, 1, 459},
	{15997, R_028354_SX_SURFACE_SYNC, 1, 460},
	{16013, R_028380_SQ_VTX_SEMANTIC_0},
	{16031, R_028384_SQ_VTX_SEMANTIC_1},
	{16049, R_028388_SQ_VTX_SEMANTIC_2},
	{16067, R_02838C_SQ_VTX_SEMANTIC_3},
	{16085, R_028390_SQ_VTX_SEMANTIC_4},
	{16103, R_028394_SQ_VTX_SEMANTIC_5},
	{16121, R_028398_SQ_VTX_SEMANTIC_6},
	{16139, R_02839C_SQ_VTX_SEMANTIC_7},
	{16157, R_0283A0_SQ_VTX_SEMANTIC_8},
	{16175, R_0283A4_SQ_VTX_SEMANTIC_9},
	{16193, R_0283A8_SQ_VTX_SEMANTIC_10},
	{16212, R_0283AC_SQ_VTX_SEMANTIC_11},
	{16231, R_0283B0_SQ_VTX_SEMANTIC_12},
	{16250, R_0283B4_SQ_VTX_SEMANTIC_13},
	{16269, R_0283B8_SQ_VTX_SEMANTIC_14},
	{16288, R_0283BC_SQ_VTX_SEMANTIC_15},
	{16307, R_0283C0_SQ_VTX_SEMANTIC_16},
	{16326, R_0283C4_SQ_VTX_SEMANTIC_17},
	{16345, R_0283C8_SQ_VTX_SEMANTIC_18},
	{16364, R_0283CC_SQ_VTX_SEMANTIC_19},
	{16383, R_0283D0_SQ_VTX_SEMANTIC_20},
	{16402, R_0283D4_SQ_VTX_SEMANTIC_21},
	{16421, R_0283D8_SQ_VTX_SEMANTIC_22},
	{16440, R_0283DC_SQ_VTX_SEMANTIC_23},
	{16459, R_0283E0_SQ_VTX_SEMANTIC_24},
	{16478, R_0283E4_SQ_VTX_SEMANTIC_25},
	{16497, R_0283E8_SQ_VTX_SEMANTIC_26},
	{16516, R_0283EC_SQ_VTX_SEMANTIC_27},
	{16535, R_0283F0_SQ_VTX_SEMANTIC_28},
	{16554, R_0283F4_SQ_VTX_SEMANTIC_29},
	{16573, R_0283F8_SQ_VTX_SEMANTIC_30},
	{16592, R_0283FC_SQ_VTX_SEMANTIC_31},
	{16611, R_0288F0_SQ_VTX_SEMANTIC_CLEAR},
	{16633, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{16652, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{16671, R_028400_VGT_MAX_VTX_INDX},
	{16688, R_028404_VGT_MIN_VTX_INDX},
	{16705, R_028408_VGT_INDX_OFFSET},
	{16721, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{16750, R_028414_CB_BLEND_RED},
	{16763, R_028418_CB_BLEND_GREEN},
	{16778, R_02841C_CB_BLEND_BLUE},
	{16792, R_028420_CB_BLEND_ALPHA},
	{16807, R_028438_SX_ALPHA_REF},
	{16820, R_02843C_PA_CL_VPORT_XSCALE_0},
	{16841, R_028440_PA_CL_VPORT_XOFFSET_0},
	{16863, R_028444_PA_CL_VPORT_YSCALE_0},
	{16884, R_028448_PA_CL_VPORT_YOFFSET_0},
	{16906, R_02844C_PA_CL_VPORT_ZSCALE_0},
	{16927, R_028450_PA_CL_VPORT_ZOFFSET_0},
	{16949, R_0285BC_PA_CL_UCP0_X},
	{16962, R_0285C0_PA_CL_UCP0_Y},
	{16975, R_0285C4_PA_CL_UCP0_Z},
	{16988, R_0285C8_PA_CL_UCP0_W},
	{17001, R_0285CC_PA_CL_UCP1_X},
	{17014, R_0285D0_PA_CL_UCP1_Y},
	{17027, R_0285D4_PA_CL_UCP1_Z},
	{17040, R_0285D8_PA_CL_UCP1_W},
	{17053, R_0285DC_PA_CL_UCP2_X},
	{17066, R_0285E0_PA_CL_UCP2_Y},
	{17079, R_0285E4_PA_CL_UCP2_Z},
	{17092, R_0285E8_PA_CL_UCP2_W},
	{17105, R_0285EC_PA_CL_UCP3_X},
	{17118, R_0285F0_PA_CL_UCP3_Y},
	{17131, R_0285F4_PA_CL_UCP3_Z},
	{17144, R_0285F8_PA_CL_UCP3_W},
	{17157, R_0285FC_PA_CL_UCP4_X},
	{17170, R_028600_PA_CL_UCP4_Y},
	{17183, R_028604_PA_CL_UCP4_Z},
	{17196, R_028608_PA_CL_UCP4_W},
	{17209, R_02860C_PA_CL_UCP5_X},
	{17222, R_028610_PA_CL_UCP5_Y},
	{17235, R_028614_PA_CL_UCP5_Z},
	{17248, R_028618_PA_CL_UCP5_W},
	{17261, R_02861C_SPI_VS_OUT_ID_0},
	{17277, R_028620_SPI_VS_OUT_ID_1},
	{17293, R_028624_SPI_VS_OUT_ID_2},
	{17309, R_028628_SPI_VS_OUT_ID_3},
	{17325, R_02862C_SPI_VS_OUT_ID_4},
	{17341, R_028630_SPI_VS_OUT_ID_5},
	{17357, R_028634_SPI_VS_OUT_ID_6},
	{17373, R_028638_SPI_VS_OUT_ID_7},
	{17389, R_02863C_SPI_VS_OUT_ID_8},
	{17405, R_028640_SPI_VS_OUT_ID_9},
	{17421, R_028648_SPI_PS_INPUT_CNTL_1, 8, 414},
	{17441, R_02864C_SPI_PS_INPUT_CNTL_2, 8, 414},
	{17461, R_028650_SPI_PS_INPUT_CNTL_3, 8, 414},
	{17481, R_028654_SPI_PS_INPUT_CNTL_4, 8, 414},
	{17501, R_028658_SPI_PS_INPUT_CNTL_5, 8, 414},
	{17521, R_02865C_SPI_PS_INPUT_CNTL_6, 8, 414},
	{17541, R_028660_SPI_PS_INPUT_CNTL_7, 8, 414},
	{17561, R_028664_SPI_PS_INPUT_CNTL_8, 8, 414},
	{17581, R_028668_SPI_PS_INPUT_CNTL_9, 8, 414},
	{17601, R_02866C_SPI_PS_INPUT_CNTL_10, 8, 414},
	{17622, R_028670_SPI_PS_INPUT_CNTL_11, 8, 414},
	{17643, R_028674_SPI_PS_INPUT_CNTL_12, 8, 414},
	{17664, R_028678_SPI_PS_INPUT_CNTL_13, 8, 414},
	{17685, R_02867C_SPI_PS_INPUT_CNTL_14, 8, 414},
	{17706, R_028680_SPI_PS_INPUT_CNTL_15, 8, 414},
	{17727, R_028684_SPI_PS_INPUT_CNTL_16, 8, 414},
	{17748, R_028688_SPI_PS_INPUT_CNTL_17, 8, 414},
	{17769, R_02868C_SPI_PS_INPUT_CNTL_18, 8, 414},
	{17790, R_028690_SPI_PS_INPUT_CNTL_19, 8, 414},
	{17811, R_028694_SPI_PS_INPUT_CNTL_20, 8, 414},
	{17832, R_028698_SPI_PS_INPUT_CNTL_21, 8, 414},
	{17853, R_02869C_SPI_PS_INPUT_CNTL_22, 8, 414},
	{17874, R_0286A0_SPI_PS_INPUT_CNTL_23, 8, 414},
	{17895, R_0286A4_SPI_PS_INPUT_CNTL_24, 8, 414},
	{17916, R_0286A8_SPI_PS_INPUT_CNTL_25, 8, 414},
	{17937, R_0286AC_SPI_PS_INPUT_CNTL_26, 8, 414},
	{17958, R_0286B0_SPI_PS_INPUT_CNTL_27, 8, 414},
	{17979, R_0286B4_SPI_PS_INPUT_CNTL_28, 8, 414},
	{18000, R_0286B8_SPI_PS_INPUT_CNTL_29, 8, 414},
	{18021, R_0286BC_SPI_PS_INPUT_CNTL_30, 8, 414},
	{18042, R_0286C0_SPI_PS_INPUT_CNTL_31, 8, 414},
	{18063, R_0286C8_SPI_THREAD_GROUPING},
	{18083, R_0286D8_SPI_INPUT_Z, 1, 461},
	{18095, R_0286DC_SPI_FOG_CNTL},
	{18108, R_0286E4_SPI_PS_IN_CONTROL_2, 8, 225},
	{18128, R_0286E8_SPI_COMPUTE_INPUT_CNTL, 3, 462},
	{18151, R_028720_GDS_ADDR_BASE},
	{18165, R_028724_GDS_ADDR_SIZE},
	{18179, R_028728_GDS_ORDERED_WAVE_PER_SE},
	{18203, R_02872C_GDS_APPEND_COUNT_0},
	{18222, R_028730_GDS_APPEND_COUNT_1},
	{18241, R_028734_GDS_APPEND_COUNT_2},
	{18260, R_028738_GDS_APPEND_COUNT_3},
	{18279, R_02873C_GDS_APPEND_COUNT_4},
	{18298, R_028740_GDS_APPEND_COUNT_5},
	{18317, R_028748_GDS_APPEND_COUNT_6},
	{18336, R_028744_GDS_APPEND_COUNT_7},
	{18355, R_028744_GDS_APPEND_COUNT_8},
	{18374, R_028744_GDS_APPEND_COUNT_9},
	{18393, R_028744_GDS_APPEND_COUNT_10},
	{18413, R_028744_GDS_APPEND_COUNT_11},
	{18433, R_028784_CB_BLEND1_CONTROL, 9, 163},
	{18451, R_028788_CB_BLEND2_CONTROL, 9, 163},
	{18469, R_02878C_CB_BLEND3_CONTROL, 9, 163},
	{18487, R_028790_CB_BLEND4_CONTROL, 9, 163},
	{18505, R_028794_CB_BLEND5_CONTROL, 9, 163},
	{18523, R_028798_CB_BLEND6_CONTROL, 9, 163},
	{18541, R_02879C_CB_BLEND7_CONTROL, 9, 163},
	{18559, R_028818_PA_CL_VTE_CNTL, 9, 465},
	{18574, R_028820_PA_CL_NANINF_CNTL},
	{18592, R_028830_SQ_LSTMP_RING_ITEMSIZE},
	{18615, R_028838_SQ_DYN_GPR_RESOURCE_LIMIT_1, 6, 474},
	{18643, R_028840_SQ_PGM_START_PS},
	{18659, R_02884C_SQ_PGM_EXPORTS_PS, 2, 480},
	{18677, R_02885C_SQ_PGM_START_VS},
	{18693, R_028874_SQ_PGM_START_GS},
	{18709, R_02888C_SQ_PGM_START_ES},
	{18725, R_0288A4_SQ_PGM_START_FS},
	{18741, R_0288B8_SQ_PGM_START_HS},
	{18757, R_0288D0_SQ_PGM_START_LS},
	{18773, R_0288A8_SQ_PGM_RESOURCES_FS},
	{18793, R_0288E8_SQ_LDS_ALLOC},
	{18806, R_0288EC_SQ_LDS_ALLOC_PS},
	{18822, R_028900_SQ_ESGS_RING_ITEMSIZE},
	{18844, R_028904_SQ_GSVS_RING_ITEMSIZE},
	{18866, R_008C50_SQ_ESTMP_RING_BASE},
	{18885, R_028908_SQ_ESTMP_RING_ITEMSIZE},
	{18908, R_008C54_SQ_ESTMP_RING_SIZE},
	{18927, R_008C58_SQ_GSTMP_RING_BASE},
	{18946, R_02890C_SQ_GSTMP_RING_ITEMSIZE},
	{18969, R_008C5C_SQ_GSTMP_RING_SIZE},
	{18988, R_008C60_SQ_VSTMP_RING_BASE},
	{19007, R_028910_SQ_VSTMP_RING_ITEMSIZE},
	{19030, R_008C64_SQ_VSTMP_RING_SIZE},
	{19049, R_008C68_SQ_PSTMP_RING_BASE},
	{19068, R_028914_SQ_PSTMP_RING_ITEMSIZE},
	{19091, R_008C6C_SQ_PSTMP_RING_SIZE},
	{19110, R_008E10_SQ_LSTMP_RING_BASE},
	{19129, R_008E14_SQ_LSTMP_RING_SIZE},
	{19148, R_008E18_SQ_HSTMP_RING_BASE},
	{19167, R_028834_SQ_HSTMP_RING_ITEMSIZE},
	{19190, R_008E1C_SQ_HSTMP_RING_SIZE},
	{19209, R_02891C_SQ_GS_VERT_ITEMSIZE},
	{19229, R_028920_SQ_GS_VERT_ITEMSIZE_1},
	{19251, R_028924_SQ_GS_VERT_ITEMSIZE_2},
	{19273, R_028928_SQ_GS_VERT_ITEMSIZE_3},
	{19295, R_02892C_SQ_GSVS_RING_OFFSET_1},
	{19317, R_028930_SQ_GSVS_RING_OFFSET_2},
	{19339, R_028934_SQ_GSVS_RING_OFFSET_3},
	{19361, R_028940_ALU_CONST_CACHE_PS_0},
	{19382, R_028944_ALU_CONST_CACHE_PS_1},
	{19403, R_028980_ALU_CONST_CACHE_VS_0},
	{19424, R_028984_ALU_CONST_CACHE_VS_1},
	{19445, R_0289C0_ALU_CONST_CACHE_GS_0},
	{19466, R_028F00_ALU_CONST_CACHE_HS_0},
	{19487, R_028F40_ALU_CONST_CACHE_LS_0},
	{19508, R_028A04_PA_SU_POINT_MINMAX, 2, 482},
	{19527, R_028A08_PA_SU_LINE_CNTL, 1, 484},
	{19543, R_028A10_VGT_OUTPUT_PATH_CNTL},
	{19564, R_028A14_VGT_HOS_CNTL},
	{19577, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{19600, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{19623, R_028A20_VGT_HOS_REUSE_DEPTH},
	{19643, R_028A24_VGT_GROUP_PRIM_TYPE},
	{19663, R_028A28_VGT_GROUP_FIRST_DECR},
	{19684, R_028A2C_VGT_GROUP_DECR},
	{19699, R_028A30_VGT_GROUP_VECT_0_CNTL},
	{19721, R_028A34_VGT_GROUP_VECT_1_CNTL},
	{19743, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL},
	{19769, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL},
	{19795, R_028A48_PA_SC_MODE_CNTL_0, 3, 485},
	{19813, R_028A4C_PA_SC_MODE_CNTL_1, 3, 485},
	{19831, R_028A54_GS_PER_ES},
	{19841, R_028A58_ES_PER_GS},
	{19851, R_028A5C_GS_PER_VS},
	{19861, R_028A84_VGT_PRIMITIVEID_EN, 1, 488},
	{19880, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 489},
	{19907, R_028AB4_VGT_REUSE_OFF},
	{19921, R_028AB8_VGT_VTX_CNT_EN},
	{19936, R_028AC0_DB_SRESULTS_COMPARE_STATE0},
	{19963, R_028AC4_DB_SRESULTS_COMPARE_STATE1},
	{19990, R_028AC8_DB_PRELOAD_CONTROL, 2, 490},
	{20009, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{20035, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0},
	{20060, R_028AD8_VGT_STRMOUT_BUFFER_BASE_0},
	{20086, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{20114, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{20140, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1},
	{20165, R_028AE8_VGT_STRMOUT_BUFFER_BASE_1},
	{20191, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{20219, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{20245, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2},
	{20270, R_028AF8_VGT_STRMOUT_BUFFER_BASE_2},
	{20296, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{20324, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{20350, R_028B04_VGT_STRMOUT_VTX_STRIDE_3},
	{20375, R_028B08_VGT_STRMOUT_BUFFER_BASE_3},
	{20401, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{20429, R_028B10_VGT_STRMOUT_BASE_OFFSET_0},
	{20455, R_028B14_VGT_STRMOUT_BASE_OFFSET_1},
	{20481, R_028B18_VGT_STRMOUT_BASE_OFFSET_2},
	{20507, R_028B1C_VGT_STRMOUT_BASE_OFFSET_3},
	{20533, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{20564, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{20607, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE},
	{20645, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 492},
	{20665, R_028B44_VGT_STRMOUT_BASE_OFFSET_HI_0},
	{20694, R_028B48_VGT_STRMOUT_BASE_OFFSET_HI_1},
	{20723, R_028B4C_VGT_STRMOUT_BASE_OFFSET_HI_2},
	{20752, R_028B50_VGT_STRMOUT_BASE_OFFSET_HI_3},
	{20781, R_028B54_VGT_SHADER_STAGES_EN, 5, 493},
	{20802, R_028B58_VGT_LS_HS_CONFIG, 3, 498},
	{20819, R_028B5C_VGT_LS_SIZE, 2, 501},
	{20831, R_028B60_VGT_HS_SIZE, 2, 503},
	{20843, R_028B64_VGT_LS_HS_ALLOC, 2, 505},
	{20859, R_028B68_VGT_HS_PATCH_CONST, 2, 507},
	{20878, R_028B70_DB_ALPHA_TO_MASK, 6, 509},
	{20895, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 515},
	{20925, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{20949, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE, 1, 517},
	{20979, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET, 1, 518},
	{21010, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE, 1, 519},
	{21039, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET, 1, 520},
	{21069, R_028B90_VGT_GS_INSTANCE_CNT, 2, 521},
	{21089, R_028B9C_CB_IMMED0_BASE},
	{21104, R_028BA0_CB_IMMED1_BASE},
	{21119, R_028BA4_CB_IMMED2_BASE},
	{21134, R_028BA4_CB_IMMED3_BASE},
	{21149, R_028BA4_CB_IMMED4_BASE},
	{21164, R_028BA4_CB_IMMED5_BASE},
	{21179, R_028BA4_CB_IMMED6_BASE},
	{21194, R_028BA4_CB_IMMED7_BASE},
	{21209, R_028BA4_CB_IMMED8_BASE},
	{21224, R_028BA4_CB_IMMED9_BASE},
	{21239, R_028BA4_CB_IMMED10_BASE},
	{21255, R_028BA4_CB_IMMED11_BASE},
	{21271, R_028C00_PA_SC_LINE_CNTL, 2, 523},
	{21287, R_028C04_PA_SC_AA_CONFIG, 3, 525},
	{21303, R_028C08_PA_SU_VTX_CNTL, 3, 528},
	{21318, R_028C0C_PA_CL_GB_VERT_CLIP_ADJ},
	{21341, R_028C10_PA_CL_GB_VERT_DISC_ADJ},
	{21364, R_028C14_PA_CL_GB_HORZ_CLIP_ADJ},
	{21387, R_028C18_PA_CL_GB_HORZ_DISC_ADJ},
	{21410, R_028C1C_PA_SC_AA_SAMPLE_LOCS_0},
	{21433, R_028C20_PA_SC_AA_SAMPLE_LOCS_1},
	{21456, R_028C24_PA_SC_AA_SAMPLE_LOCS_2},
	{21479, R_028C28_PA_SC_AA_SAMPLE_LOCS_3},
	{21502, R_028C2C_PA_SC_AA_SAMPLE_LOCS_4},
	{21525, R_028C30_PA_SC_AA_SAMPLE_LOCS_5},
	{21548, R_028C34_PA_SC_AA_SAMPLE_LOCS_6},
	{21571, R_028C38_PA_SC_AA_SAMPLE_LOCS_7},
	{21594, R_028C3C_PA_SC_AA_MASK},
	{21608, R_028C60_CB_COLOR0_BASE},
	{21623, R_028C6C_CB_COLOR0_VIEW, 2, 531},
	{21638, R_028C7C_CB_COLOR0_CMASK},
	{21654, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 533},
	{21676, R_028C84_CB_COLOR0_FMASK},
	{21692, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 534},
	{21714, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{21736, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{21758, R_028C94_CB_COLOR0_CLEAR_WORD2},
	{21780, R_028C98_CB_COLOR0_CLEAR_WORD3},
	{21802, R_028C9C_CB_COLOR1_BASE},
	{21817, R_028CA0_CB_COLOR1_PITCH, 1, 68},
	{21833, R_028CA4_CB_COLOR1_SLICE, 1, 69},
	{21849, R_028CA8_CB_COLOR1_VIEW, 2, 531},
	{21864, R_028CAC_CB_COLOR1_INFO, 15, 70},
	{21879, R_028CB0_CB_COLOR1_ATTRIB, 10, 85},
	{21896, R_028CB4_CB_COLOR1_DIM, 2, 95},
	{21910, R_028CB8_CB_COLOR1_CMASK},
	{21926, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 533},
	{21948, R_028CC0_CB_COLOR1_FMASK},
	{21964, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 534},
	{21986, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{22008, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{22030, R_028CD0_CB_COLOR1_CLEAR_WORD2},
	{22052, R_028CD4_CB_COLOR1_CLEAR_WORD3},
	{22074, R_028CD8_CB_COLOR2_BASE},
	{22089, R_028CDC_CB_COLOR2_PITCH, 1, 68},
	{22105, R_028CE0_CB_COLOR2_SLICE, 1, 69},
	{22121, R_028CE4_CB_COLOR2_VIEW, 2, 531},
	{22136, R_028CE8_CB_COLOR2_INFO, 15, 70},
	{22151, R_028CEC_CB_COLOR2_ATTRIB, 10, 85},
	{22168, R_028CF0_CB_COLOR2_DIM, 2, 95},
	{22182, R_028CF4_CB_COLOR2_CMASK},
	{22198, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 533},
	{22220, R_028CFC_CB_COLOR2_FMASK},
	{22236, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 534},
	{22258, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{22280, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{22302, R_028D0C_CB_COLOR2_CLEAR_WORD2},
	{22324, R_028D10_CB_COLOR2_CLEAR_WORD3},
	{22346, R_028D14_CB_COLOR3_BASE},
	{22361, R_028D18_CB_COLOR3_PITCH, 1, 68},
	{22377, R_028D1C_CB_COLOR3_SLICE, 1, 69},
	{22393, R_028D20_CB_COLOR3_VIEW, 2, 531},
	{22408, R_028D24_CB_COLOR3_INFO, 15, 70},
	{22423, R_028D28_CB_COLOR3_ATTRIB, 10, 85},
	{22440, R_028D2C_CB_COLOR3_DIM, 2, 95},
	{22454, R_028D30_CB_COLOR3_CMASK},
	{22470, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 533},
	{22492, R_028D38_CB_COLOR3_FMASK},
	{22508, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 534},
	{22530, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{22552, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{22574, R_028D48_CB_COLOR3_CLEAR_WORD2},
	{22596, R_028D4C_CB_COLOR3_CLEAR_WORD3},
	{22618, R_028D50_CB_COLOR4_BASE},
	{22633, R_028D54_CB_COLOR4_PITCH, 1, 68},
	{22649, R_028D58_CB_COLOR4_SLICE, 1, 69},
	{22665, R_028D5C_CB_COLOR4_VIEW, 2, 531},
	{22680, R_028D60_CB_COLOR4_INFO, 15, 70},
	{22695, R_028D64_CB_COLOR4_ATTRIB, 10, 85},
	{22712, R_028D68_CB_COLOR4_DIM, 2, 95},
	{22726, R_028D6C_CB_COLOR4_CMASK},
	{22742, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 533},
	{22764, R_028D74_CB_COLOR4_FMASK},
	{22780, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 534},
	{22802, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{22824, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{22846, R_028D84_CB_COLOR4_CLEAR_WORD2},
	{22868, R_028D88_CB_COLOR4_CLEAR_WORD3},
	{22890, R_028D8C_CB_COLOR5_BASE},
	{22905, R_028D90_CB_COLOR5_PITCH, 1, 68},
	{22921, R_028D94_CB_COLOR5_SLICE, 1, 69},
	{22937, R_028D98_CB_COLOR5_VIEW, 2, 531},
	{22952, R_028D9C_CB_COLOR5_INFO, 15, 70},
	{22967, R_028DA0_CB_COLOR5_ATTRIB, 10, 85},
	{22984, R_028DA4_CB_COLOR5_DIM, 2, 95},
	{22998, R_028DA8_CB_COLOR5_CMASK},
	{23014, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 533},
	{23036, R_028DB0_CB_COLOR5_FMASK},
	{23052, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 534},
	{23074, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{23096, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{23118, R_028DC0_CB_COLOR5_CLEAR_WORD2},
	{23140, R_028DC4_CB_COLOR5_CLEAR_WORD3},
	{23162, R_028DC8_CB_COLOR6_BASE},
	{23177, R_028DCC_CB_COLOR6_PITCH, 1, 68},
	{23193, R_028DD0_CB_COLOR6_SLICE, 1, 69},
	{23209, R_028DD4_CB_COLOR6_VIEW, 2, 531},
	{23224, R_028DD8_CB_COLOR6_INFO, 15, 70},
	{23239, R_028DDC_CB_COLOR6_ATTRIB, 10, 85},
	{23256, R_028DE0_CB_COLOR6_DIM, 2, 95},
	{23270, R_028DE4_CB_COLOR6_CMASK},
	{23286, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 533},
	{23308, R_028DEC_CB_COLOR6_FMASK},
	{23324, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 534},
	{23346, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{23368, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{23390, R_028DFC_CB_COLOR6_CLEAR_WORD2},
	{23412, R_028E00_CB_COLOR6_CLEAR_WORD3},
	{23434, R_028E04_CB_COLOR7_BASE},
	{23449, R_028E08_CB_COLOR7_PITCH, 1, 68},
	{23465, R_028E0C_CB_COLOR7_SLICE, 1, 69},
	{23481, R_028E10_CB_COLOR7_VIEW, 2, 531},
	{23496, R_028E14_CB_COLOR7_INFO, 15, 70},
	{23511, R_028E18_CB_COLOR7_ATTRIB, 10, 85},
	{23528, R_028E1C_CB_COLOR7_DIM, 2, 95},
	{23542, R_028E20_CB_COLOR7_CMASK},
	{23558, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 533},
	{23580, R_028E28_CB_COLOR7_FMASK},
	{23596, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 534},
	{23618, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{23640, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{23662, R_028E38_CB_COLOR7_CLEAR_WORD2},
	{23684, R_028E3C_CB_COLOR7_CLEAR_WORD3},
	{23706, R_028E40_CB_COLOR8_BASE},
	{23721, R_028E44_CB_COLOR8_PITCH, 1, 68},
	{23737, R_028E48_CB_COLOR8_SLICE, 1, 69},
	{23753, R_028E4C_CB_COLOR8_VIEW, 2, 531},
	{23768, R_028E50_CB_COLOR8_INFO, 15, 70},
	{23783, R_028E54_CB_COLOR8_ATTRIB, 10, 85},
	{23800, R_028E58_CB_COLOR8_DIM, 2, 95},
	{23814, R_028E5C_CB_COLOR9_BASE},
	{23829, R_028E60_CB_COLOR9_PITCH, 1, 68},
	{23845, R_028E64_CB_COLOR9_SLICE, 1, 69},
	{23861, R_028E68_CB_COLOR9_VIEW, 2, 531},
	{23876, R_028E6C_CB_COLOR9_INFO, 15, 70},
	{23891, R_028E70_CB_COLOR9_ATTRIB, 10, 85},
	{23908, R_028E74_CB_COLOR9_DIM, 2, 95},
	{23922, R_028E78_CB_COLOR10_BASE},
	{23938, R_028E7C_CB_COLOR10_PITCH, 1, 68},
	{23955, R_028E80_CB_COLOR10_SLICE, 1, 69},
	{23972, R_028E84_CB_COLOR10_VIEW, 2, 531},
	{23988, R_028E88_CB_COLOR10_INFO, 15, 70},
	{24004, R_028E8C_CB_COLOR10_ATTRIB, 10, 85},
	{24022, R_028E90_CB_COLOR10_DIM, 2, 95},
	{24037, R_028E94_CB_COLOR11_BASE},
	{24053, R_028E98_CB_COLOR11_PITCH, 1, 68},
	{24070, R_028E9C_CB_COLOR11_SLICE, 1, 69},
	{24087, R_028EA0_CB_COLOR11_VIEW, 2, 531},
	{24103, R_028EA4_CB_COLOR11_INFO, 15, 70},
	{24119, R_028EA8_CB_COLOR11_ATTRIB, 10, 85},
	{24137, R_028EAC_CB_COLOR11_DIM, 2, 95},
	{24152, R_030000_RESOURCE0_WORD0},
	{24168, R_030004_RESOURCE0_WORD1},
	{24184, R_030008_RESOURCE0_WORD2},
	{24200, R_03000C_RESOURCE0_WORD3},
	{24216, R_030010_RESOURCE0_WORD4},
	{24232, R_030014_RESOURCE0_WORD5},
	{24248, R_030018_RESOURCE0_WORD6},
	{24264, R_03001C_RESOURCE0_WORD7},
	{24280, R_0085F0_CP_COHER_CNTL, 28, 535},
	{24294, R_0085F4_CP_COHER_SIZE},
	{24308, R_0085F8_CP_COHER_BASE},
	{24322, R_008970_VGT_NUM_INDICES},
	{24338, R_03CFF0_SQ_VTX_BASE_VTX_LOC},
	{24358, R_03CFF4_SQ_VTX_START_INST_LOC},
	{24380, R_03A200_SQ_LOOP_CONST_0, 20, 563},
};

static const char egd_strings[] =
	"NOP\0" /* 0 */
	"DEALLOC_STATE\0" /* 4 */
	"DISPATCH_DIRECT\0" /* 18 */
	"DISPATCH_INDIRECT\0" /* 34 */
	"INDIRECT_BUFFER_END\0" /* 52 */
	"SET_PREDICATION\0" /* 72 */
	"REG_RMW\0" /* 88 */
	"COND_EXEC\0" /* 96 */
	"PRED_EXEC\0" /* 106 */
	"DRAW_INDEX_2\0" /* 116 */
	"CONTEXT_CONTROL\0" /* 129 */
	"DRAW_INDEX_IMMD_BE\0" /* 145 */
	"INDEX_TYPE\0" /* 170, 164 */
	"DRAW_INDEX\0" /* 175 */
	"DRAW_INDEX_AUTO\0" /* 186 */
	"DRAW_INDEX_IMMD\0" /* 202 */
	"NUM_INSTANCES\0" /* 218 */
	"STRMOUT_BUFFER_UPDATE\0" /* 232 */
	"INDIRECT_BUFFER_MP\0" /* 254 */
	"MEM_SEMAPHORE\0" /* 273 */
	"MPEG_INDEX\0" /* 287 */
	"WAIT_REG_MEM\0" /* 298 */
	"MEM_WRITE\0" /* 311 */
	"INDIRECT_BUFFER\0" /* 321, 330 */
	"PFP_SYNC_ME\0" /* 337 */
	"SURFACE_SYNC\0" /* 349 */
	"ME_INITIALIZE\0" /* 362 */
	"COND_WRITE\0" /* 376 */
	"EVENT_WRITE\0" /* 387 */
	"EVENT_WRITE_EOP\0" /* 399 */
	"EVENT_WRITE_EOS\0" /* 415 */
	"ONE_REG_WRITE\0" /* 431 */
	"SET_CONFIG_REG\0" /* 445 */
	"SET_CONTEXT_REG\0" /* 460 */
	"SET_ALU_CONST\0" /* 476 */
	"SET_BOOL_CONST\0" /* 490 */
	"SET_LOOP_CONST\0" /* 505 */
	"SET_RESOURCE\0" /* 520 */
	"SET_SAMPLER\0" /* 533 */
	"SET_CTL_CONST\0" /* 545 */
	"SURFACE_BASE_UPDATE\0" /* 559 */
	"IT_OPCODE_C\0" /* 579 */
	"CP_DMA\0" /* 591 */
	"SET_APPEND_CNT\0" /* 609, 598 */
	"SAC_SRC_SEL_DATA\0" /* 613 */
	"SAC_SRC_SEL_REG\0" /* 630 */
	"SAC_SRC_SEL_GDS\0" /* 646 */
	"SAC_SRC_SEL_MEM\0" /* 662 */
	"OFFSET_UPDATE_DONE\0" /* 678 */
	"STREAMOUT_0_EN\0" /* 697 */
	"STREAMOUT_1_EN\0" /* 712 */
	"STREAMOUT_2_EN\0" /* 727 */
	"STREAMOUT_3_EN\0" /* 742 */
	"RAST_STREAM\0" /* 757 */
	"RAST_STREAM_MASK\0" /* 769 */
	"USE_RAST_STREAM_MASK\0" /* 786 */
	"STREAM_0_BUFFER_EN\0" /* 807 */
	"STREAM_1_BUFFER_EN\0" /* 826 */
	"STREAM_2_BUFFER_EN\0" /* 845 */
	"STREAM_3_BUFFER_EN\0" /* 864 */
	"MAX_ANCHOR_SAMPLES\0" /* 883 */
	"PS_ITER_SAMPLES\0" /* 902 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 930, 918 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 942 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 968 */
	"INCOHERENT_EQAA_READS\0" /* 995 */
	"INTERPOLATE_COMP_Z\0" /* 1017 */
	"INTERPOLATE_SRC_Z\0" /* 1036 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 1054 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 1081 */
	"OVERRASTERIZATION_AMOUNT\0" /* 1108 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 1133 */
	"EXPAND_LINE_WIDTH\0" /* 1176, 1164 */
	"LAST_PIXEL\0" /* 1182 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 1193 */
	"DX10_DIAMOND_TEST_ENA\0" /* 1218 */
	"MSAA_NUM_SAMPLES\0" /* 1240 */
	"AA_MASK_CENTROID_DTMN\0" /* 1257 */
	"MAX_SAMPLE_DIST\0" /* 1279 */
	"MSAA_EXPOSED_SAMPLES\0" /* 1295 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 1316, 1334 */
	"VC_ENABLE\0" /* 1339, 1342 */
	"EXPORT_SRC_C\0" /* 1349 */
	"CS_PRIO\0" /* 1362 */
	"LS_PRIO\0" /* 1370 */
	"HS_PRIO\0" /* 1378 */
	"PS_PRIO\0" /* 1386 */
	"VS_PRIO\0" /* 1394 */
	"GS_PRIO\0" /* 1402 */
	"ES_PRIO\0" /* 1410 */
	"NUM_PS_GPRS\0" /* 1418, 1422 */
	"NUM_VS_GPRS\0" /* 1434, 1430 */
	"NUM_CLAUSE_TEMP_GPRS\0" /* 1442 */
	"NUM_GS_GPRS\0" /* 1467, 1463 */
	"NUM_ES_GPRS\0" /* 1475, 1479 */
	"NUM_HS_GPRS\0" /* 1491, 1487 */
	"NUM_LS_GPRS\0" /* 1499, 1503 */
	"NUM_PS_THREADS\0" /* 1511 */
	"NUM_VS_THREADS\0" /* 1526 */
	"NUM_GS_THREADS\0" /* 1541 */
	"NUM_ES_THREADS\0" /* 1556 */
	"NUM_HS_THREADS\0" /* 1571 */
	"NUM_LS_THREADS\0" /* 1586 */
	"NUM_PS_STACK_ENTRIES\0" /* 1601 */
	"NUM_VS_STACK_ENTRIES\0" /* 1622 */
	"NUM_GS_STACK_ENTRIES\0" /* 1643 */
	"NUM_ES_STACK_ENTRIES\0" /* 1664 */
	"NUM_HS_STACK_ENTRIES\0" /* 1685 */
	"NUM_LS_STACK_ENTRIES\0" /* 1706 */
	"NUM_PS_LDS\0" /* 1727 */
	"NUM_LS_LDS\0" /* 1738 */
	"CACHE_FIFO_SIZE\0" /* 1760, 1749 */
	"FETCH_FIFO_HIWATER\0" /* 1765 */
	"DONE_FIFO_HIWATER\0" /* 1784 */
	"ALU_UPDATE_FIFO_HIWATER\0" /* 1802 */
	"VTX_DONE_DELAY\0" /* 1826 */
	"PITCH_TILE_MAX\0" /* 1841, 1847 */
	"SLICE_TILE_MAX\0" /* 1856 */
	"ENDIAN\0" /* 1871 */
	"COLOR_INVALID\0" /* 1878 */
	"COLOR_8\0" /* 1892 */
	"COLOR_4_4\0" /* 1900 */
	"COLOR_3_3_2\0" /* 1910 */
	"COLOR_16\0" /* 1922 */
	"COLOR_16_FLOAT\0" /* 1931 */
	"COLOR_8_8\0" /* 1946 */
	"COLOR_5_6_5\0" /* 1956 */
	"COLOR_6_5_5\0" /* 1968 */
	"COLOR_1_5_5_5\0" /* 1980 */
	"COLOR_4_4_4_4\0" /* 1994 */
	"COLOR_5_5_5_1\0" /* 2008 */
	"COLOR_32\0" /* 2022 */
	"COLOR_32_FLOAT\0" /* 2031 */
	"COLOR_16_16\0" /* 2046 */
	"COLOR_16_16_FLOAT\0" /* 2058 */
	"COLOR_8_24\0" /* 2076 */
	"COLOR_8_24_FLOAT\0" /* 2087 */
	"COLOR_24_8\0" /* 2104 */
	"COLOR_24_8_FLOAT\0" /* 2115 */
	"COLOR_10_11_11\0" /* 2132 */
	"COLOR_10_11_11_FLOAT\0" /* 2147 */
	"COLOR_11_11_10\0" /* 2168 */
	"COLOR_11_11_10_FLOAT\0" /* 2183 */
	"COLOR_2_10_10_10\0" /* 2204 */
	"COLOR_8_8_8_8\0" /* 2221 */
	"COLOR_10_10_10_2\0" /* 2235 */
	"COLOR_X24_8_32_FLOAT\0" /* 2252 */
	"COLOR_32_32\0" /* 2273 */
	"COLOR_32_32_FLOAT\0" /* 2285 */
	"COLOR_16_16_16_16\0" /* 2303 */
	"COLOR_16_16_16_16_FLOAT\0" /* 2321 */
	"COLOR_32_32_32_32\0" /* 2345 */
	"COLOR_32_32_32_32_FLOAT\0" /* 2363 */
	"COLOR_32_32_32_FLOAT\0" /* 2387 */
	"FORMAT\0" /* 2408 */
	"ARRAY_LINEAR_GENERAL\0" /* 2415 */
	"ARRAY_LINEAR_ALIGNED\0" /* 2436 */
	"ARRAY_1D_TILED_THIN1\0" /* 2457 */
	"ARRAY_2D_TILED_THIN1\0" /* 2478 */
	"ARRAY_MODE\0" /* 2499 */
	"NUMBER_UNORM\0" /* 2510 */
	"NUMBER_SNORM\0" /* 2523 */
	"NUMBER_USCALED\0" /* 2536 */
	"NUMBER_SSCALED\0" /* 2551 */
	"NUMBER_UINT\0" /* 2566 */
	"NUMBER_SINT\0" /* 2578 */
	"NUMBER_SRGB\0" /* 2590 */
	"NUMBER_FLOAT\0" /* 2602 */
	"NUMBER_TYPE\0" /* 2615 */
	"SWAP_STD\0" /* 2627 */
	"SWAP_ALT\0" /* 2636 */
	"SWAP_STD_REV\0" /* 2645 */
	"SWAP_ALT_REV\0" /* 2658 */
	"COMP_SWAP\0" /* 2671 */
	"FAST_CLEAR\0" /* 2681 */
	"COMPRESSION\0" /* 2692 */
	"BLEND_CLAMP\0" /* 2704 */
	"BLEND_BYPASS\0" /* 2716 */
	"SIMPLE_FLOAT\0" /* 2729 */
	"ROUND_MODE\0" /* 2742 */
	"TILE_COMPACT\0" /* 2753 */
	"EXPORT_4C_32BPC\0" /* 2766 */
	"EXPORT_4C_16BPC\0" /* 2782 */
	"EXPORT_2C_32BPC\0" /* 2798 */
	"SOURCE_FORMAT\0" /* 2814 */
	"RAT\0" /* 2828 */
	"TEXTURE1D\0" /* 2832 */
	"TEXTURE1DARRAY\0" /* 2842 */
	"TEXTURE2D\0" /* 2857 */
	"TEXTURE2DARRAY\0" /* 2867 */
	"TEXTURE3D\0" /* 2882 */
	"RESOURCE_TYPE\0" /* 2892 */
	"NON_DISP_TILING_ORDER\0" /* 2906 */
	"TILE_SPLIT\0" /* 2928 */
	"NUM_BANKS\0" /* 2939 */
	"BANK_WIDTH\0" /* 2949 */
	"BANK_HEIGHT\0" /* 2960, 2965 */
	"MACRO_TILE_ASPECT\0" /* 2972 */
	"FMASK_BANK_HEIGHT\0" /* 2990 */
	"NUM_FRAGMENTS\0" /* 3008 */
	"FORCE_DST_ALPHA_1\0" /* 3022 */
	"WIDTH_MAX\0" /* 3040 */
	"HEIGHT_MAX\0" /* 3050 */
	"ALPHA_FUNC\0" /* 3061 */
	"ALPHA_TEST_ENABLE\0" /* 3072 */
	"ALPHA_TEST_BYPASS\0" /* 3090 */
	"TESS_ISOLINE\0" /* 3108 */
	"TESS_TRIANGLE\0" /* 3121 */
	"TESS_QUAD\0" /* 3135 */
	"PART_INTEGER\0" /* 3145 */
	"PART_POW2\0" /* 3158 */
	"PART_FRAC_ODD\0" /* 3168 */
	"PART_FRAC_EVEN\0" /* 3182 */
	"PARTITIONING\0" /* 3197 */
	"OUTPUT_POINT\0" /* 3210 */
	"OUTPUT_LINE\0" /* 3223 */
	"OUTPUT_TRIANGLE_CW\0" /* 3235 */
	"OUTPUT_TRIANGLE_CCW\0" /* 3254 */
	"TOPOLOGY\0" /* 3274 */
	"RESERVED_REDUC_AXIS\0" /* 3283 */
	"PATCH_MAJOR\0" /* 3303 */
	"TF_MAJOR\0" /* 3315 */
	"BUFFER_ACCESS_MODE\0" /* 3324 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 3343 */
	"STENCIL_ENABLE\0" /* 3365 */
	"Z_ENABLE\0" /* 3380 */
	"Z_WRITE_ENABLE\0" /* 3389 */
	"ZFUNC\0" /* 3404 */
	"BACKFACE_ENABLE\0" /* 3410 */
	"STENCILFUNC_NEVER\0" /* 3426 */
	"STENCILFUNC_LESS\0" /* 3444 */
	"STENCILFUNC_EQUAL\0" /* 3461 */
	"STENCILFUNC_LEQUAL\0" /* 3479 */
	"STENCILFUNC_GREATER\0" /* 3498 */
	"STENCILFUNC_NOTEQUAL\0" /* 3518 */
	"STENCILFUNC_GEQUAL\0" /* 3539 */
	"STENCILFUNC_ALWAYS\0" /* 3558 */
	"STENCILFUNC\0" /* 3577 */
	"STENCIL_KEEP\0" /* 3589 */
	"STENCIL_ZERO\0" /* 3602 */
	"STENCIL_REPLACE\0" /* 3615 */
	"STENCIL_INCR\0" /* 3631 */
	"STENCIL_DECR\0" /* 3644 */
	"STENCIL_INVERT\0" /* 3657 */
	"STENCIL_INCR_WRAP\0" /* 3672 */
	"STENCIL_DECR_WRAP\0" /* 3690 */
	"STENCILFAIL\0" /* 3708 */
	"STENCILZPASS\0" /* 3720 */
	"STENCILZFAIL\0" /* 3733 */
	"STENCILFUNC_BF\0" /* 3746 */
	"STENCILFAIL_BF\0" /* 3761 */
	"STENCILZPASS_BF\0" /* 3776 */
	"STENCILZFAIL_BF\0" /* 3792 */
	"DEGAMMA_ENABLE\0" /* 3808 */
	"CB_DISABLE\0" /* 3823 */
	"CB_NORMAL\0" /* 3834 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 3844 */
	"CB_RESOLVE\0" /* 3868 */
	"CB_DECOMPRESS\0" /* 3879 */
	"CB_FMASK_DECOMPRESS\0" /* 3893 */
	"ROP3\0" /* 3913 */
	"UCP_ENA_0\0" /* 3918 */
	"UCP_ENA_1\0" /* 3928 */
	"UCP_ENA_2\0" /* 3938 */
	"UCP_ENA_3\0" /* 3948 */
	"UCP_ENA_4\0" /* 3958 */
	"UCP_ENA_5\0" /* 3968 */
	"PS_UCP_Y_SCALE_NEG\0" /* 3978 */
	"PS_UCP_MODE\0" /* 3997 */
	"CLIP_DISABLE\0" /* 4009 */
	"UCP_CULL_ONLY_ENA\0" /* 4022 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 4040 */
	"DX_CLIP_SPACE_DEF\0" /* 4063 */
	"DIS_CLIP_ERR_DETECT\0" /* 4081 */
	"VTX_KILL_OR\0" /* 4101 */
	"DX_RASTERIZATION_KILL\0" /* 4113 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 4135 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 4159 */
	"ZCLIP_NEAR_DISABLE\0" /* 4185 */
	"ZCLIP_FAR_DISABLE\0" /* 4204 */
	"Z_INVALID\0" /* 4222 */
	"Z_16\0" /* 4232 */
	"Z_24\0" /* 4237 */
	"Z_32_FLOAT\0" /* 4242 */
	"READ_SIZE\0" /* 4253 */
	"TILE_SURFACE_ENABLE\0" /* 4263 */
	"ZRANGE_PRECISION\0" /* 4283 */
	"STENCIL_INVALID\0" /* 4300 */
	"STENCIL_8\0" /* 4316 */
	"HEIGHT_TILE_MAX\0" /* 4326 */
	"STENCILREF\0" /* 4342 */
	"STENCILMASK\0" /* 4353 */
	"STENCILWRITEMASK\0" /* 4365 */
	"STENCILREF_BF\0" /* 4382 */
	"STENCILMASK_BF\0" /* 4396 */
	"STENCILWRITEMASK_BF\0" /* 4411 */
	"BLEND_ZERO\0" /* 4431 */
	"BLEND_ONE\0" /* 4442 */
	"BLEND_SRC_COLOR\0" /* 4452 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 4468 */
	"BLEND_SRC_ALPHA\0" /* 4494 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 4510 */
	"BLEND_DST_ALPHA\0" /* 4536 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 4552 */
	"BLEND_DST_COLOR\0" /* 4578 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 4594 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 4620 */
	"BLEND_BOTH_SRC_ALPHA\0" /* 4645 */
	"BLEND_BOTH_INV_SRC_ALPHA\0" /* 4666 */
	"BLEND_CONST_COLOR\0" /* 4691 */
	"BLEND_ONE_MINUS_CONST_COLOR\0" /* 4709 */
	"BLEND_SRC1_COLOR\0" /* 4737 */
	"BLEND_INV_SRC1_COLOR\0" /* 4754 */
	"BLEND_SRC1_ALPHA\0" /* 4775 */
	"BLEND_INV_SRC1_ALPHA\0" /* 4792 */
	"BLEND_CONST_ALPHA\0" /* 4813 */
	"BLEND_ONE_MINUS_CONST_ALPHA\0" /* 4831 */
	"COLOR_SRCBLEND\0" /* 4859 */
	"COMB_DST_PLUS_SRC\0" /* 4874 */
	"COMB_SRC_MINUS_DST\0" /* 4892 */
	"COMB_MIN_DST_SRC\0" /* 4911 */
	"COMB_MAX_DST_SRC\0" /* 4928 */
	"COMB_DST_MINUS_SRC\0" /* 4945 */
	"COLOR_COMB_FCN\0" /* 4964 */
	"COLOR_DESTBLEND\0" /* 4979 */
	"OPACITY_WEIGHT\0" /* 4995 */
	"ALPHA_SRCBLEND\0" /* 5010 */
	"ALPHA_COMB_FCN\0" /* 5025 */
	"ALPHA_DESTBLEND\0" /* 5040 */
	"SEPARATE_ALPHA_BLEND\0" /* 5056 */
	"BLEND_CONTROL_ENABLE\0" /* 5077 */
	"CULL_FRONT\0" /* 5098 */
	"CULL_BACK\0" /* 5109 */
	"FACE\0" /* 5119 */
	"POLY_MODE\0" /* 5124 */
	"POLYMODE_FRONT_PTYPE\0" /* 5134 */
	"POLYMODE_BACK_PTYPE\0" /* 5155 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 5175 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 5200 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 5224 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 5248 */
	"PROVOKING_VTX_LAST\0" /* 5273 */
	"PERSP_CORR_DIS\0" /* 5292 */
	"MULTI_PRIM_IB_ENA\0" /* 5307 */
	"HTILE_WIDTH\0" /* 5325 */
	"HTILE_HEIGHT\0" /* 5337 */
	"LINEAR\0" /* 5350 */
	"FULL_CACHE\0" /* 5357 */
	"HTILE_USES_PRELOAD_WIN\0" /* 5368 */
	"PRELOAD\0" /* 5391 */
	"PREFETCH_WIDTH\0" /* 5399 */
	"PREFETCH_HEIGHT\0" /* 5414 */
	"Z_EXPORT_ENABLE\0" /* 5430 */
	"STENCIL_EXPORT_ENABLE\0" /* 5446 */
	"LATE_Z\0" /* 5468 */
	"EARLY_Z_THEN_LATE_Z\0" /* 5475 */
	"RE_Z\0" /* 5495 */
	"EARLY_Z_THEN_RE_Z\0" /* 5500 */
	"Z_ORDER\0" /* 5518 */
	"KILL_ENABLE\0" /* 5526 */
	"MASK_EXPORT_ENABLE\0" /* 5538 */
	"DUAL_EXPORT_ENABLE\0" /* 5557 */
	"EXEC_ON_HIER_FAIL\0" /* 5576 */
	"EXEC_ON_NOOP\0" /* 5594 */
	"EXPORT_DB_FULL\0" /* 5607 */
	"EXPORT_DB_FOUR16\0" /* 5622 */
	"EXPORT_DB_TWO\0" /* 5639 */
	"DB_SOURCE_FORMAT\0" /* 5653 */
	"ALPHA_TO_MASK_DISABLE\0" /* 5670 */
	"DEPTH_BEFORE_SHADER\0" /* 5692 */
	"EXPORT_ANY_Z\0" /* 5712 */
	"EXPORT_LESS_THAN_Z\0" /* 5725 */
	"EXPORT_GREATER_THAN_Z\0" /* 5744 */
	"EXPORT_RESERVED\0" /* 5766 */
	"CONSERVATIVE_Z_EXPORT\0" /* 5782 */
	"LINE_PATTERN\0" /* 5804 */
	"REPEAT_COUNT\0" /* 5817 */
	"PATTERN_BIT_ORDER\0" /* 5830 */
	"AUTO_RESET_CNTL\0" /* 5848 */
	"GS_OFF\0" /* 5864 */
	"GS_SCENARIO_A\0" /* 5871 */
	"GS_SCENARIO_B\0" /* 5885 */
	"GS_SCENARIO_G\0" /* 5899 */
	"GS_SCENARIO_C\0" /* 5913 */
	"SPRITE_EN\0" /* 5927 */
	"ES_PASSTHRU\0" /* 5937 */
	"GS_CUT_1024\0" /* 5949 */
	"GS_CUT_512\0" /* 5961 */
	"GS_CUT_256\0" /* 5972 */
	"GS_CUT_128\0" /* 5983 */
	"CUT_MODE\0" /* 5994 */
	"COMPUTE_MODE\0" /* 6003 */
	"PARTIAL_THD_AT_EOI\0" /* 6016 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 6035 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 6058 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 6081 */
	"OUTPRIM_TYPE\0" /* 6106, 6103 */
	"WAIT_CP_DMA_IDLE\0" /* 6116 */
	"WAIT_CMDFIFO\0" /* 6133 */
	"WAIT_2D_IDLE\0" /* 6146 */
	"WAIT_3D_IDLE\0" /* 6159 */
	"WAIT_2D_IDLECLEAN\0" /* 6172 */
	"WAIT_3D_IDLECLEAN\0" /* 6190 */
	"WAIT_EXTERN_SIG\0" /* 6208 */
	"CMDFIFO_ENTRIES\0" /* 6224 */
	"NUM_INTERP\0" /* 6240 */
	"POSITION_ENA\0" /* 6251 */
	"POSITION_CENTROID\0" /* 6264 */
	"POSITION_ADDR\0" /* 6282 */
	"PARAM_GEN\0" /* 6296 */
	"PERSP_GRADIENT_ENA\0" /* 6306 */
	"LINEAR_GRADIENT_ENA\0" /* 6325 */
	"POSITION_SAMPLE\0" /* 6345 */
	"FRONT_FACE_ENA\0" /* 6361 */
	"FRONT_FACE_CHAN\0" /* 6376 */
	"FRONT_FACE_ALL_BITS\0" /* 6392 */
	"FRONT_FACE_ADDR\0" /* 6412 */
	"FOG_ADDR\0" /* 6428 */
	"FIXED_PT_POSITION_ENA\0" /* 6437 */
	"FIXED_PT_POSITION_ADDR\0" /* 6459 */
	"VS_PER_COMPONENT\0" /* 6482 */
	"VS_EXPORT_COUNT\0" /* 6499 */
	"VS_EXPORTS_FOG\0" /* 6515 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 6530 */
	"PERSP_CENTER_ENA\0" /* 6550 */
	"PERSP_CENTROID_ENA\0" /* 6567 */
	"PERSP_SAMPLE_ENA\0" /* 6586 */
	"PERSP_PULL_MODEL_ENA\0" /* 6603 */
	"LINEAR_CENTER_ENA\0" /* 6624 */
	"LINEAR_CENTROID_ENA\0" /* 6642 */
	"LINEAR_SAMPLE_ENA\0" /* 6662 */
	"TL_X\0" /* 6680 */
	"TL_Y\0" /* 6685 */
	"WINDOW_OFFSET_DISABLE\0" /* 6690 */
	"BR_X\0" /* 6712 */
	"BR_Y\0" /* 6717 */
	"SOURCE_SELECT\0" /* 6722 */
	"MAJOR_MODE\0" /* 6736 */
	"NOT_EOP\0" /* 6747 */
	"USE_OPAQUE\0" /* 6755 */
	"SQ_TEX_DIM_1D\0" /* 6766 */
	"SQ_TEX_DIM_2D\0" /* 6780 */
	"SQ_TEX_DIM_3D\0" /* 6794 */
	"SQ_TEX_DIM_CUBEMAP\0" /* 6808 */
	"SQ_TEX_DIM_1D_ARRAY\0" /* 6827 */
	"SQ_TEX_DIM_2D_ARRAY\0" /* 6847 */
	"SQ_TEX_DIM_2D_MSAA\0" /* 6867 */
	"SQ_TEX_DIM_2D_ARRAY_MSAA\0" /* 6886 */
	"DIM\0" /* 6911 */
	"PITCH\0" /* 6915 */
	"TEX_WIDTH\0" /* 6921 */
	"TEX_HEIGHT\0" /* 6931 */
	"TEX_DEPTH\0" /* 6942 */
	"BASE_ADDRESS\0" /* 6952 */
	"MIP_ADDRESS\0" /* 6965 */
	"SQ_FORMAT_COMP_UNSIGNED\0" /* 6977 */
	"SQ_FORMAT_COMP_SIGNED\0" /* 7001 */
	"SQ_FORMAT_COMP_UNSIGNED_BIASED\0" /* 7023 */
	"FORMAT_COMP_X\0" /* 7054 */
	"FORMAT_COMP_Y\0" /* 7068 */
	"FORMAT_COMP_Z\0" /* 7082 */
	"FORMAT_COMP_W\0" /* 7096 */
	"SQ_NUM_FORMAT_NORM\0" /* 7110 */
	"SQ_NUM_FORMAT_INT\0" /* 7129 */
	"SQ_NUM_FORMAT_SCALED\0" /* 7147 */
	"NUM_FORMAT_ALL\0" /* 7168 */
	"SRF_MODE_ZERO_CLAMP_MINUS_ONE\0" /* 7183 */
	"SRF_MODE_NO_ZERO\0" /* 7213 */
	"SRF_MODE_ALL\0" /* 7230 */
	"FORCE_DEGAMMA\0" /* 7243 */
	"ENDIAN_SWAP\0" /* 7257 */
	"LOG2_NUM_FRAGMENTS\0" /* 7269 */
	"SQ_SEL_X\0" /* 7288 */
	"SQ_SEL_Y\0" /* 7297 */
	"SQ_SEL_Z\0" /* 7306 */
	"SQ_SEL_W\0" /* 7315 */
	"SQ_SEL_0\0" /* 7324 */
	"SQ_SEL_1\0" /* 7333 */
	"DST_SEL_X\0" /* 7342 */
	"DST_SEL_Y\0" /* 7352 */
	"DST_SEL_Z\0" /* 7362 */
	"DST_SEL_W\0" /* 7372 */
	"BASE_LEVEL\0" /* 7382 */
	"LAST_LEVEL\0" /* 7393 */
	"BASE_ARRAY\0" /* 7404 */
	"LAST_ARRAY\0" /* 7415 */
	"MAX_ANISO_RATIO\0" /* 7426 */
	"PERF_MODULATION\0" /* 7442 */
	"INTERLACED\0" /* 7458 */
	"DATA_FORMAT\0" /* 7469 */
	"DEPTH_SAMPLE_ORDER\0" /* 7481 */
	"SQ_TEX_VTX_INVALID_TEXTURE\0" /* 7500 */
	"SQ_TEX_VTX_INVALID_BUFFER\0" /* 7527 */
	"SQ_TEX_VTX_VALID_TEXTURE\0" /* 7553 */
	"SQ_TEX_VTX_VALID_BUFFER\0" /* 7578 */
	"BASE_ADDRESS_HI\0" /* 7602 */
	"STRIDE\0" /* 7618 */
	"CLAMP_X\0" /* 7625 */
	"FORMAT_COMP_ALL\0" /* 7633 */
	"UNCACHED\0" /* 7649 */
	"SQ_TEX_WRAP\0" /* 7658 */
	"SQ_TEX_MIRROR\0" /* 7670 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 7684 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 7708 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 7738 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 7763 */
	"SQ_TEX_CLAMP_BORDER\0" /* 7794 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 7814 */
	"CLAMP_Y\0" /* 7840 */
	"CLAMP_Z\0" /* 7848 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 7856 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 7879 */
	"XY_MAG_FILTER\0" /* 7905 */
	"XY_MIN_FILTER\0" /* 7919 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 7933 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 7954 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 7976 */
	"Z_FILTER\0" /* 7999 */
	"MIP_FILTER\0" /* 8008 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 8019 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 8051 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 8084 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 8117 */
	"BORDER_COLOR_TYPE\0" /* 8146 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 8164 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 8191 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 8217 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 8244 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 8275 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 8304 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 8334 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 8368 */
	"DEPTH_COMPARE_FUNCTION\0" /* 8396 */
	"SQ_TEX_CHROMA_KEY_DISABLE\0" /* 8419 */
	"SQ_TEX_CHROMA_KEY_KILL\0" /* 8445 */
	"SQ_TEX_CHROMA_KEY_BLEND\0" /* 8468 */
	"CHROMA_KEY\0" /* 8492 */
	"MIN_LOD\0" /* 8503 */
	"MAX_LOD\0" /* 8511 */
	"PERF_MIP\0" /* 8519 */
	"PERF_Z\0" /* 8528 */
	"LOD_BIAS\0" /* 8535 */
	"LOD_BIAS_SEC\0" /* 8544 */
	"MC_COORD_TRUNCATE\0" /* 8557 */
	"ANISO_BIAS\0" /* 8575 */
	"TRUNCATE_COORD\0" /* 8586 */
	"DISABLE_CUBE_WRAP\0" /* 8601 */
	"DI_PT_NONE\0" /* 8619 */
	"DI_PT_POINTLIST\0" /* 8630 */
	"DI_PT_LINELIST\0" /* 8646 */
	"DI_PT_LINESTRIP\0" /* 8661 */
	"DI_PT_TRILIST\0" /* 8677 */
	"DI_PT_TRIFAN\0" /* 8691 */
	"DI_PT_TRISTRIP\0" /* 8704 */
	"DI_PT_UNUSED_0\0" /* 8719 */
	"DI_PT_UNUSED_1\0" /* 8734 */
	"DI_PT_PATCH\0" /* 8749 */
	"DI_PT_LINELIST_ADJ\0" /* 8761 */
	"DI_PT_LINESTRIP_ADJ\0" /* 8780 */
	"DI_PT_TRILIST_ADJ\0" /* 8800 */
	"DI_PT_TRISTRIP_ADJ\0" /* 8818 */
	"DI_PT_UNUSED_3\0" /* 8837 */
	"DI_PT_UNUSED_4\0" /* 8852 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 8867 */
	"DI_PT_RECTLIST\0" /* 8889 */
	"DI_PT_LINELOOP\0" /* 8904 */
	"DI_PT_QUADLIST\0" /* 8919 */
	"DI_PT_QUADSTRIP\0" /* 8934 */
	"DI_PT_POLYGON\0" /* 8950 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 8964 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 8991 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 9018 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 9045 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 9072 */
	"DI_PT_2D_LINE_STRIP\0" /* 9096 */
	"DI_PT_2D_TRI_STRIP\0" /* 9116 */
	"CLIP_DIST_ENA_0\0" /* 9135 */
	"CLIP_DIST_ENA_1\0" /* 9151 */
	"CLIP_DIST_ENA_2\0" /* 9167 */
	"CLIP_DIST_ENA_3\0" /* 9183 */
	"CLIP_DIST_ENA_4\0" /* 9199 */
	"CLIP_DIST_ENA_5\0" /* 9215 */
	"CLIP_DIST_ENA_6\0" /* 9231 */
	"CLIP_DIST_ENA_7\0" /* 9247 */
	"CULL_DIST_ENA_0\0" /* 9263 */
	"CULL_DIST_ENA_1\0" /* 9279 */
	"CULL_DIST_ENA_2\0" /* 9295 */
	"CULL_DIST_ENA_3\0" /* 9311 */
	"CULL_DIST_ENA_4\0" /* 9327 */
	"CULL_DIST_ENA_5\0" /* 9343 */
	"CULL_DIST_ENA_6\0" /* 9359 */
	"CULL_DIST_ENA_7\0" /* 9375 */
	"USE_VTX_POINT_SIZE\0" /* 9391 */
	"USE_VTX_EDGE_FLAG\0" /* 9410 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 9428 */
	"USE_VTX_VIEWPORT_INDX\0" /* 9455 */
	"USE_VTX_KILL_FLAG\0" /* 9477 */
	"VS_OUT_MISC_VEC_ENA\0" /* 9495 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 9515 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 9538 */
	"NUM_GPRS\0" /* 9561 */
	"STACK_SIZE\0" /* 9570 */
	"DX10_CLAMP\0" /* 9581 */
	"UNCACHED_FIRST_INST\0" /* 9592 */
	"ROUND_NEAREST_EVEN\0" /* 9612 */
	"ROUND_PLUS_INFINITY\0" /* 9631 */
	"ROUND_MINUS_INFINITY\0" /* 9651 */
	"ROUND_TO_ZERO\0" /* 9672 */
	"SINGLE_ROUND\0" /* 9686 */
	"DOUBLE_ROUND\0" /* 9699 */
	"ALLOW_SINGLE_DENORM_IN\0" /* 9712 */
	"ALLOW_SINGLE_DENORM_OUT\0" /* 9735 */
	"ALLOW_DOUBLE_DENORM_IN\0" /* 9759 */
	"ALLOW_DOUBLE_DENORM_OUT\0" /* 9782 */
	"PRIME_CACHE_ON_DRAW\0" /* 9806 */
	"CLAMP_CONSTS\0" /* 9826 */
	"SEMANTIC\0" /* 9839 */
	"DEFAULT_VAL\0" /* 9848 */
	"FLAT_SHADE\0" /* 9860 */
	"SEL_CENTROID\0" /* 9871 */
	"SEL_LINEAR\0" /* 9884 */
	"CYL_WRAP\0" /* 9895 */
	"PT_SPRITE_TEX\0" /* 9904 */
	"SEL_SAMPLE\0" /* 9918 */
	"FLAT_SHADE_ENA\0" /* 9929 */
	"PNT_SPRITE_ENA\0" /* 9944 */
	"PNT_SPRITE_OVRD_X\0" /* 9959 */
	"PNT_SPRITE_OVRD_Y\0" /* 9977 */
	"PNT_SPRITE_OVRD_Z\0" /* 9995 */
	"PNT_SPRITE_OVRD_W\0" /* 10013 */
	"PNT_SPRITE_TOP_1\0" /* 10031 */
	"DEPTH_CLEAR_ENABLE\0" /* 10048 */
	"STENCIL_CLEAR_ENABLE\0" /* 10067 */
	"DEPTH_COPY_ENABLE\0" /* 10088 */
	"STENCIL_COPY_ENABLE\0" /* 10106 */
	"RESUMMARIZE_ENABLE\0" /* 10126 */
	"STENCIL_COMPRESS_DISABLE\0" /* 10145 */
	"DEPTH_COMPRESS_DISABLE\0" /* 10170 */
	"COPY_CENTROID\0" /* 10193 */
	"COPY_SAMPLE\0" /* 10207 */
	"COLOR_DISABLE\0" /* 10219 */
	"ZPASS_INCREMENT_DISABLE\0" /* 10233 */
	"PERFECT_ZPASS_COUNTS\0" /* 10257 */
	"SAMPLE_RATE\0" /* 10278 */
	"SLICE_START\0" /* 10290 */
	"FORCE_OFF\0" /* 10302 */
	"FORCE_ENABLE\0" /* 10312 */
	"FORCE_DISABLE\0" /* 10325 */
	"SLICE_MAX\0" /* 10339 */
	"FORCE_HIZ_ENABLE\0" /* 10349 */
	"FORCE_HIS_ENABLE0\0" /* 10366 */
	"FORCE_HIS_ENABLE1\0" /* 10384 */
	"FORCE_SHADER_Z_ORDER\0" /* 10402 */
	"FAST_Z_DISABLE\0" /* 10423 */
	"FAST_STENCIL_DISABLE\0" /* 10438 */
	"NOOP_CULL_DISABLE\0" /* 10459 */
	"FORCE_COLOR_KILL\0" /* 10477 */
	"FORCE_Z_READ\0" /* 10494 */
	"FORCE_STENCIL_READ\0" /* 10507 */
	"FORCE_FULL_Z_RANGE\0" /* 10526 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 10545 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 10569 */
	"IGNORE_SC_ZRANGE\0" /* 10592 */
	"DISABLE_PIXEL_RATE_TILES\0" /* 10609 */
	"MULTIPASS\0" /* 10634 */
	"SURFACE_SYNC_MASK\0" /* 10644 */
	"PROVIDE_Z_TO_SPI\0" /* 10662 */
	"TID_IN_GROUP_ENA\0" /* 10679 */
	"TGID_ENA\0" /* 10696 */
	"DISABLE_INDEX_PACK\0" /* 10705 */
	"VPORT_X_SCALE_ENA\0" /* 10724 */
	"VPORT_X_OFFSET_ENA\0" /* 10742 */
	"VPORT_Y_SCALE_ENA\0" /* 10761 */
	"VPORT_Y_OFFSET_ENA\0" /* 10779 */
	"VPORT_Z_SCALE_ENA\0" /* 10798 */
	"VPORT_Z_OFFSET_ENA\0" /* 10816 */
	"VTX_XY_FMT\0" /* 10835 */
	"VTX_Z_FMT\0" /* 10846 */
	"VTX_W0_FMT\0" /* 10856 */
	"EXPORT_COLORS\0" /* 10867 */
	"EXPORT_Z\0" /* 10881 */
	"MIN_SIZE\0" /* 10890 */
	"MAX_SIZE\0" /* 10899 */
	"MSAA_ENABLE\0" /* 10908 */
	"VPORT_SCISSOR_ENABLE\0" /* 10920 */
	"LINE_STIPPLE_ENABLE\0" /* 10941 */
	"PRIMITIVEID_EN\0" /* 10961 */
	"RESET_EN\0" /* 10976 */
	"MAX_X\0" /* 10985 */
	"MAX_Y\0" /* 10991 */
	"MAX_VERT_OUT\0" /* 10997 */
	"LS_STAGE_OFF\0" /* 11010 */
	"LS_STAGE_ON\0" /* 11023 */
	"CS_STAGE_ON\0" /* 11035 */
	"LS_EN\0" /* 11047 */
	"HS_EN\0" /* 11053 */
	"ES_STAGE_OFF\0" /* 11059 */
	"ES_STAGE_DS\0" /* 11072 */
	"ES_STAGE_REAL\0" /* 11084 */
	"ES_EN\0" /* 11098 */
	"GS_EN\0" /* 11104 */
	"VS_STAGE_REAL\0" /* 11110 */
	"VS_STAGE_DS\0" /* 11124 */
	"VS_STAGE_COPY_SHADER\0" /* 11136 */
	"VS_EN\0" /* 11157 */
	"NUM_PATCHES\0" /* 11163 */
	"HS_NUM_INPUT_CP\0" /* 11175 */
	"HS_NUM_OUTPUT_CP\0" /* 11191 */
	"PATCH_CP_SIZE\0" /* 11208 */
	"HS_TOTAL_OUTPUT\0" /* 11222 */
	"LS_HS_TOTAL_OUTPUT\0" /* 11238 */
	"ALPHA_TO_MASK_ENABLE\0" /* 11257 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 11278 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 11300 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 11322 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 11344 */
	"OFFSET_ROUND\0" /* 11366 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 11379 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 11407 */
	"SCALE\0" /* 11435 */
	"OFFSET\0" /* 11441 */
	"PIX_CENTER_HALF\0" /* 11448 */
	"X_TRUNCATE\0" /* 11464 */
	"X_ROUND\0" /* 11475 */
	"X_ROUND_TO_EVEN\0" /* 11483 */
	"X_ROUND_TO_ODD\0" /* 11499 */
	"X_1_16TH\0" /* 11514 */
	"X_1_8TH\0" /* 11523 */
	"X_1_4TH\0" /* 11531 */
	"X_1_2\0" /* 11539 */
	"X_1\0" /* 11545 */
	"X_1_256TH\0" /* 11549 */
	"X_1_1024TH\0" /* 11559 */
	"X_1_4096TH\0" /* 11570 */
	"QUANT_MODE\0" /* 11581 */
	"DEST_BASE_0_ENA\0" /* 11592 */
	"DEST_BASE_1_ENA\0" /* 11608 */
	"SO0_DEST_BASE_ENA\0" /* 11624 */
	"SO1_DEST_BASE_ENA\0" /* 11642 */
	"SO2_DEST_BASE_ENA\0" /* 11660 */
	"SO3_DEST_BASE_ENA\0" /* 11678 */
	"CB0_DEST_BASE_ENA\0" /* 11696 */
	"CB1_DEST_BASE_ENA\0" /* 11714 */
	"CB2_DEST_BASE_ENA\0" /* 11732 */
	"CB3_DEST_BASE_ENA\0" /* 11750 */
	"CB4_DEST_BASE_ENA\0" /* 11768 */
	"CB5_DEST_BASE_ENA\0" /* 11786 */
	"CB6_DEST_BASE_ENA\0" /* 11804 */
	"CB7_DEST_BASE_ENA\0" /* 11822 */
	"DB_DEST_BASE_ENA\0" /* 11840 */
	"CB8_DEST_BASE_ENA\0" /* 11857 */
	"CB9_DEST_BASE_ENA\0" /* 11875 */
	"CB10_DEST_BASE_ENA\0" /* 11893 */
	"CB11_DEST_BASE_ENA\0" /* 11912 */
	"TC_ACTION_ENA\0" /* 11931 */
	"VC_ACTION_ENA\0" /* 11945 */
	"CB_ACTION_ENA\0" /* 11959 */
	"DB_ACTION_ENA\0" /* 11973 */
	"SH_ACTION_ENA\0" /* 11987 */
	"SMX_ACTION_ENA\0" /* 12001 */
	"CR0_ACTION_ENA\0" /* 12016 */
	"CR1_ACTION_ENA\0" /* 12031 */
	"CR2_ACTION_ENA\0" /* 12046 */
	"PRIMGROUP_SIZE\0" /* 12061 */
	"PARTIAL_VS_WAVE_ON\0" /* 12076 */
	"SWITCH_ON_EOP\0" /* 12095 */
	"CP_STRMOUT_CNTL\0" /* 12109 */
	"VGT_STRMOUT_CONFIG\0" /* 12125 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 12144 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 12170 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 12203 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 12236 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 12269 */
	"SQ_CONFIG\0" /* 12302 */
	"SQ_GPR_RESOURCE_MGMT_1\0" /* 12312 */
	"SQ_GPR_RESOURCE_MGMT_2\0" /* 12335 */
	"SQ_GPR_RESOURCE_MGMT_3\0" /* 12358 */
	"SQ_GLOBAL_GPR_RESOURCE_MGMT_1\0" /* 12381 */
	"SQ_GLOBAL_GPR_RESOURCE_MGMT_2\0" /* 12411 */
	"SQ_THREAD_RESOURCE_MGMT_1\0" /* 12441 */
	"SQ_THREAD_RESOURCE_MGMT_2\0" /* 12467 */
	"SQ_STACK_RESOURCE_MGMT_1\0" /* 12493 */
	"SQ_STACK_RESOURCE_MGMT_2\0" /* 12518 */
	"SQ_STACK_RESOURCE_MGMT_3\0" /* 12543 */
	"SQ_LDS_RESOURCE_MGMT\0" /* 12568 */
	"SQ_ESGS_RING_BASE\0" /* 12589 */
	"SQ_ESGS_RING_SIZE\0" /* 12607 */
	"SQ_GSVS_RING_BASE\0" /* 12625 */
	"SQ_GSVS_RING_SIZE\0" /* 12643 */
	"SQ_MS_FIFO_SIZES\0" /* 12661 */
	"SQ_STATIC_THREAD_MGMT1\0" /* 12678 */
	"SQ_STATIC_THREAD_MGMT2\0" /* 12701 */
	"SQ_STATIC_THREAD_MGMT3\0" /* 12724 */
	"VGT_COMPUTE_START_X\0" /* 12747 */
	"VGT_COMPUTE_START_Y\0" /* 12767 */
	"VGT_COMPUTE_START_Z\0" /* 12787 */
	"VGT_COMPUTE_THREAD_GROUP_SIZE\0" /* 12807 */
	"SPI_CONFIG_CNTL\0" /* 12837 */
	"SPI_CONFIG_CNTL_1\0" /* 12853 */
	"CB_COLOR0_PITCH\0" /* 12871 */
	"CB_COLOR0_SLICE\0" /* 12887 */
	"CB_COLOR0_INFO\0" /* 12903 */
	"CB_COLOR0_ATTRIB\0" /* 12918 */
	"CB_COLOR0_DIM\0" /* 12935 */
	"SX_ALPHA_TEST_CONTROL\0" /* 12949 */
	"SPI_COMPUTE_NUM_THREAD_X\0" /* 12971 */
	"SPI_COMPUTE_NUM_THREAD_Y\0" /* 12996 */
	"SPI_COMPUTE_NUM_THREAD_Z\0" /* 13021 */
	"VGT_TF_PARAM\0" /* 13046 */
	"VGT_DISPATCH_INITIATOR\0" /* 13059 */
	"DB_DEPTH_CONTROL\0" /* 13082 */
	"CB_COLOR_CONTROL\0" /* 13099 */
	"PA_CL_CLIP_CNTL\0" /* 13116 */
	"DB_Z_INFO\0" /* 13132 */
	"DB_STENCIL_INFO\0" /* 13142 */
	"DB_DEPTH_SIZE\0" /* 13158 */
	"DB_DEPTH_SLICE\0" /* 13172 */
	"DB_STENCILREFMASK\0" /* 13187 */
	"DB_STENCILREFMASK_BF\0" /* 13205 */
	"CB_BLEND0_CONTROL\0" /* 13226 */
	"PA_SU_SC_MODE_CNTL\0" /* 13244 */
	"DB_HTILE_SURFACE\0" /* 13263 */
	"DB_SHADER_CONTROL\0" /* 13280 */
	"PA_SU_POINT_SIZE\0" /* 13298 */
	"PA_SC_LINE_STIPPLE\0" /* 13315 */
	"VGT_GS_MODE\0" /* 13334 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 13346 */
	"WAIT_UNTIL\0" /* 13367 */
	"SPI_PS_IN_CONTROL_0\0" /* 13378 */
	"SPI_PS_IN_CONTROL_1\0" /* 13398 */
	"SPI_VS_OUT_CONFIG\0" /* 13418 */
	"SPI_BARYC_CNTL\0" /* 13436 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 13451 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 13476 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 13501 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 13526 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 13551 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 13575 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 13599 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 13623 */
	"VGT_DMA_MAX_SIZE\0" /* 13647 */
	"VGT_DMA_INDEX_TYPE\0" /* 13664 */
	"VGT_NUM_INSTANCES\0" /* 13683 */
	"VGT_DMA_BASE_HI\0" /* 13701 */
	"VGT_DMA_BASE\0" /* 13717 */
	"VGT_DRAW_INITIATOR\0" /* 13730 */
	"SQ_TEX_RESOURCE_WORD0_0\0" /* 13749 */
	"SQ_TEX_RESOURCE_WORD1_0\0" /* 13773 */
	"SQ_TEX_RESOURCE_WORD2_0\0" /* 13797 */
	"SQ_TEX_RESOURCE_WORD3_0\0" /* 13821 */
	"SQ_TEX_RESOURCE_WORD4_0\0" /* 13845 */
	"SQ_TEX_RESOURCE_WORD5_0\0" /* 13869 */
	"SQ_TEX_RESOURCE_WORD6_0\0" /* 13893 */
	"SQ_TEX_RESOURCE_WORD7_0\0" /* 13917 */
	"SQ_VTX_CONSTANT_WORD2_0\0" /* 13941 */
	"SQ_VTX_CONSTANT_WORD3_0\0" /* 13965 */
	"TD_PS_SAMPLER0_BORDER_INDEX\0" /* 13989 */
	"TD_PS_SAMPLER0_BORDER_RED\0" /* 14017 */
	"TD_PS_SAMPLER0_BORDER_GREEN\0" /* 14043 */
	"TD_PS_SAMPLER0_BORDER_BLUE\0" /* 14071 */
	"TD_PS_SAMPLER0_BORDER_ALPHA\0" /* 14098 */
	"TD_VS_SAMPLER0_BORDER_INDEX\0" /* 14126 */
	"TD_VS_SAMPLER0_BORDER_RED\0" /* 14154 */
	"TD_VS_SAMPLER0_BORDER_GREEN\0" /* 14180 */
	"TD_VS_SAMPLER0_BORDER_BLUE\0" /* 14208 */
	"TD_VS_SAMPLER0_BORDER_ALPHA\0" /* 14235 */
	"TD_GS_SAMPLER0_BORDER_INDEX\0" /* 14263 */
	"TD_GS_SAMPLER0_BORDER_RED\0" /* 14291 */
	"TD_GS_SAMPLER0_BORDER_GREEN\0" /* 14317 */
	"TD_GS_SAMPLER0_BORDER_BLUE\0" /* 14345 */
	"TD_GS_SAMPLER0_BORDER_ALPHA\0" /* 14372 */
	"TD_HS_SAMPLER0_BORDER_COLOR_INDEX\0" /* 14400 */
	"TD_HS_SAMPLER0_BORDER_COLOR_RED\0" /* 14434 */
	"TD_HS_SAMPLER0_BORDER_COLOR_GREEN\0" /* 14466 */
	"TD_HS_SAMPLER0_BORDER_COLOR_BLUE\0" /* 14500 */
	"TD_HS_SAMPLER0_BORDER_COLOR_ALPHA\0" /* 14533 */
	"TD_LS_SAMPLER0_BORDER_COLOR_INDEX\0" /* 14567 */
	"TD_LS_SAMPLER0_BORDER_COLOR_RED\0" /* 14601 */
	"TD_LS_SAMPLER0_BORDER_COLOR_GREEN\0" /* 14633 */
	"TD_LS_SAMPLER0_BORDER_COLOR_BLUE\0" /* 14667 */
	"TD_LS_SAMPLER0_BORDER_COLOR_ALPHA\0" /* 14700 */
	"TD_CS_SAMPLER0_BORDER_INDEX\0" /* 14734 */
	"TD_CS_SAMPLER0_BORDER_RED\0" /* 14762 */
	"TD_CS_SAMPLER0_BORDER_GREEN\0" /* 14788 */
	"TD_CS_SAMPLER0_BORDER_BLUE\0" /* 14816 */
	"TD_CS_SAMPLER0_BORDER_ALPHA\0" /* 14843 */
	"SQ_TEX_SAMPLER_WORD0_0\0" /* 14871 */
	"SQ_TEX_SAMPLER_WORD1_0\0" /* 14894 */
	"SQ_TEX_SAMPLER_WORD2_0\0" /* 14917 */
	"VGT_PRIMITIVE_TYPE\0" /* 14940 */
	"PA_CL_VS_OUT_CNTL\0" /* 14959 */
	"SQ_PGM_RESOURCES_VS\0" /* 14977 */
	"SQ_PGM_RESOURCES_GS\0" /* 14997 */
	"SQ_PGM_RESOURCES_2_GS\0" /* 15017 */
	"SQ_PGM_RESOURCES_ES\0" /* 15039 */
	"SQ_PGM_RESOURCES_2_ES\0" /* 15059 */
	"SQ_PGM_RESOURCES_2_VS\0" /* 15081 */
	"SQ_PGM_RESOURCES_PS\0" /* 15103 */
	"SQ_PGM_RESOURCES_2_PS\0" /* 15123 */
	"SQ_PGM_RESOURCES_HS\0" /* 15145 */
	"SQ_PGM_RESOURCES_2_HS\0" /* 15165 */
	"SQ_PGM_RESOURCES_LS\0" /* 15187 */
	"SQ_PGM_RESOURCES_2_LS\0" /* 15207 */
	"SPI_PS_INPUT_CNTL_0\0" /* 15229 */
	"SPI_INTERP_CONTROL_0\0" /* 15249 */
	"PA_CL_ENHANCE\0" /* 15270 */
	"SQ_DYN_GPR_CNTL_PS_FLUSH_REQ\0" /* 15284 */
	"DB_RENDER_CONTROL\0" /* 15313 */
	"DB_COUNT_CONTROL\0" /* 15331 */
	"DB_DEPTH_VIEW\0" /* 15348 */
	"DB_RENDER_OVERRIDE\0" /* 15362 */
	"DB_RENDER_OVERRIDE2\0" /* 15381 */
	"DB_HTILE_DATA_BASE\0" /* 15401 */
	"DB_STENCIL_CLEAR\0" /* 15420 */
	"DB_DEPTH_CLEAR\0" /* 15437 */
	"DB_Z_READ_BASE\0" /* 15452 */
	"DB_STENCIL_READ_BASE\0" /* 15467 */
	"DB_Z_WRITE_BASE\0" /* 15488 */
	"DB_STENCIL_WRITE_BASE\0" /* 15504 */
	"ALU_CONST_BUFFER_SIZE_PS_0\0" /* 15526 */
	"ALU_CONST_BUFFER_SIZE_PS_1\0" /* 15553 */
	"ALU_CONST_BUFFER_SIZE_VS_0\0" /* 15580 */
	"ALU_CONST_BUFFER_SIZE_VS_1\0" /* 15607 */
	"ALU_CONST_BUFFER_SIZE_GS_0\0" /* 15634 */
	"ALU_CONST_BUFFER_SIZE_HS_0\0" /* 15661 */
	"ALU_CONST_BUFFER_SIZE_LS_0\0" /* 15688 */
	"PA_SC_WINDOW_OFFSET\0" /* 15715 */
	"PA_SC_CLIPRECT_RULE\0" /* 15735 */
	"PA_SC_CLIPRECT_0_TL\0" /* 15755 */
	"PA_SC_CLIPRECT_0_BR\0" /* 15775 */
	"PA_SC_CLIPRECT_1_TL\0" /* 15795 */
	"PA_SC_CLIPRECT_1_BR\0" /* 15815 */
	"PA_SC_CLIPRECT_2_TL\0" /* 15835 */
	"PA_SC_CLIPRECT_2_BR\0" /* 15855 */
	"PA_SC_CLIPRECT_3_TL\0" /* 15875 */
	"PA_SC_CLIPRECT_3_BR\0" /* 15895 */
	"PA_SC_EDGERULE\0" /* 15915 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 15930 */
	"CB_TARGET_MASK\0" /* 15959 */
	"CB_SHADER_MASK\0" /* 15974 */
	"SX_MISC\0" /* 15989 */
	"SX_SURFACE_SYNC\0" /* 15997 */
	"SQ_VTX_SEMANTIC_0\0" /* 16013 */
	"SQ_VTX_SEMANTIC_1\0" /* 16031 */
	"SQ_VTX_SEMANTIC_2\0" /* 16049 */
	"SQ_VTX_SEMANTIC_3\0" /* 16067 */
	"SQ_VTX_SEMANTIC_4\0" /* 16085 */
	"SQ_VTX_SEMANTIC_5\0" /* 16103 */
	"SQ_VTX_SEMANTIC_6\0" /* 16121 */
	"SQ_VTX_SEMANTIC_7\0" /* 16139 */
	"SQ_VTX_SEMANTIC_8\0" /* 16157 */
	"SQ_VTX_SEMANTIC_9\0" /* 16175 */
	"SQ_VTX_SEMANTIC_10\0" /* 16193 */
	"SQ_VTX_SEMANTIC_11\0" /* 16212 */
	"SQ_VTX_SEMANTIC_12\0" /* 16231 */
	"SQ_VTX_SEMANTIC_13\0" /* 16250 */
	"SQ_VTX_SEMANTIC_14\0" /* 16269 */
	"SQ_VTX_SEMANTIC_15\0" /* 16288 */
	"SQ_VTX_SEMANTIC_16\0" /* 16307 */
	"SQ_VTX_SEMANTIC_17\0" /* 16326 */
	"SQ_VTX_SEMANTIC_18\0" /* 16345 */
	"SQ_VTX_SEMANTIC_19\0" /* 16364 */
	"SQ_VTX_SEMANTIC_20\0" /* 16383 */
	"SQ_VTX_SEMANTIC_21\0" /* 16402 */
	"SQ_VTX_SEMANTIC_22\0" /* 16421 */
	"SQ_VTX_SEMANTIC_23\0" /* 16440 */
	"SQ_VTX_SEMANTIC_24\0" /* 16459 */
	"SQ_VTX_SEMANTIC_25\0" /* 16478 */
	"SQ_VTX_SEMANTIC_26\0" /* 16497 */
	"SQ_VTX_SEMANTIC_27\0" /* 16516 */
	"SQ_VTX_SEMANTIC_28\0" /* 16535 */
	"SQ_VTX_SEMANTIC_29\0" /* 16554 */
	"SQ_VTX_SEMANTIC_30\0" /* 16573 */
	"SQ_VTX_SEMANTIC_31\0" /* 16592 */
	"SQ_VTX_SEMANTIC_CLEAR\0" /* 16611 */
	"PA_SC_VPORT_ZMIN_0\0" /* 16633 */
	"PA_SC_VPORT_ZMAX_0\0" /* 16652 */
	"VGT_MAX_VTX_INDX\0" /* 16671 */
	"VGT_MIN_VTX_INDX\0" /* 16688 */
	"VGT_INDX_OFFSET\0" /* 16705 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 16721 */
	"CB_BLEND_RED\0" /* 16750 */
	"CB_BLEND_GREEN\0" /* 16763 */
	"CB_BLEND_BLUE\0" /* 16778 */
	"CB_BLEND_ALPHA\0" /* 16792 */
	"SX_ALPHA_REF\0" /* 16807 */
	"PA_CL_VPORT_XSCALE_0\0" /* 16820 */
	"PA_CL_VPORT_XOFFSET_0\0" /* 16841 */
	"PA_CL_VPORT_YSCALE_0\0" /* 16863 */
	"PA_CL_VPORT_YOFFSET_0\0" /* 16884 */
	"PA_CL_VPORT_ZSCALE_0\0" /* 16906 */
	"PA_CL_VPORT_ZOFFSET_0\0" /* 16927 */
	"PA_CL_UCP0_X\0" /* 16949 */
	"PA_CL_UCP0_Y\0" /* 16962 */
	"PA_CL_UCP0_Z\0" /* 16975 */
	"PA_CL_UCP0_W\0" /* 16988 */
	"PA_CL_UCP1_X\0" /* 17001 */
	"PA_CL_UCP1_Y\0" /* 17014 */
	"PA_CL_UCP1_Z\0" /* 17027 */
	"PA_CL_UCP1_W\0" /* 17040 */
	"PA_CL_UCP2_X\0" /* 17053 */
	"PA_CL_UCP2_Y\0" /* 17066 */
	"PA_CL_UCP2_Z\0" /* 17079 */
	"PA_CL_UCP2_W\0" /* 17092 */
	"PA_CL_UCP3_X\0" /* 17105 */
	"PA_CL_UCP3_Y\0" /* 17118 */
	"PA_CL_UCP3_Z\0" /* 17131 */
	"PA_CL_UCP3_W\0" /* 17144 */
	"PA_CL_UCP4_X\0" /* 17157 */
	"PA_CL_UCP4_Y\0" /* 17170 */
	"PA_CL_UCP4_Z\0" /* 17183 */
	"PA_CL_UCP4_W\0" /* 17196 */
	"PA_CL_UCP5_X\0" /* 17209 */
	"PA_CL_UCP5_Y\0" /* 17222 */
	"PA_CL_UCP5_Z\0" /* 17235 */
	"PA_CL_UCP5_W\0" /* 17248 */
	"SPI_VS_OUT_ID_0\0" /* 17261 */
	"SPI_VS_OUT_ID_1\0" /* 17277 */
	"SPI_VS_OUT_ID_2\0" /* 17293 */
	"SPI_VS_OUT_ID_3\0" /* 17309 */
	"SPI_VS_OUT_ID_4\0" /* 17325 */
	"SPI_VS_OUT_ID_5\0" /* 17341 */
	"SPI_VS_OUT_ID_6\0" /* 17357 */
	"SPI_VS_OUT_ID_7\0" /* 17373 */
	"SPI_VS_OUT_ID_8\0" /* 17389 */
	"SPI_VS_OUT_ID_9\0" /* 17405 */
	"SPI_PS_INPUT_CNTL_1\0" /* 17421 */
	"SPI_PS_INPUT_CNTL_2\0" /* 17441 */
	"SPI_PS_INPUT_CNTL_3\0" /* 17461 */
	"SPI_PS_INPUT_CNTL_4\0" /* 17481 */
	"SPI_PS_INPUT_CNTL_5\0" /* 17501 */
	"SPI_PS_INPUT_CNTL_6\0" /* 17521 */
	"SPI_PS_INPUT_CNTL_7\0" /* 17541 */
	"SPI_PS_INPUT_CNTL_8\0" /* 17561 */
	"SPI_PS_INPUT_CNTL_9\0" /* 17581 */
	"SPI_PS_INPUT_CNTL_10\0" /* 17601 */
	"SPI_PS_INPUT_CNTL_11\0" /* 17622 */
	"SPI_PS_INPUT_CNTL_12\0" /* 17643 */
	"SPI_PS_INPUT_CNTL_13\0" /* 17664 */
	"SPI_PS_INPUT_CNTL_14\0" /* 17685 */
	"SPI_PS_INPUT_CNTL_15\0" /* 17706 */
	"SPI_PS_INPUT_CNTL_16\0" /* 17727 */
	"SPI_PS_INPUT_CNTL_17\0" /* 17748 */
	"SPI_PS_INPUT_CNTL_18\0" /* 17769 */
	"SPI_PS_INPUT_CNTL_19\0" /* 17790 */
	"SPI_PS_INPUT_CNTL_20\0" /* 17811 */
	"SPI_PS_INPUT_CNTL_21\0" /* 17832 */
	"SPI_PS_INPUT_CNTL_22\0" /* 17853 */
	"SPI_PS_INPUT_CNTL_23\0" /* 17874 */
	"SPI_PS_INPUT_CNTL_24\0" /* 17895 */
	"SPI_PS_INPUT_CNTL_25\0" /* 17916 */
	"SPI_PS_INPUT_CNTL_26\0" /* 17937 */
	"SPI_PS_INPUT_CNTL_27\0" /* 17958 */
	"SPI_PS_INPUT_CNTL_28\0" /* 17979 */
	"SPI_PS_INPUT_CNTL_29\0" /* 18000 */
	"SPI_PS_INPUT_CNTL_30\0" /* 18021 */
	"SPI_PS_INPUT_CNTL_31\0" /* 18042 */
	"SPI_THREAD_GROUPING\0" /* 18063 */
	"SPI_INPUT_Z\0" /* 18083 */
	"SPI_FOG_CNTL\0" /* 18095 */
	"SPI_PS_IN_CONTROL_2\0" /* 18108 */
	"SPI_COMPUTE_INPUT_CNTL\0" /* 18128 */
	"GDS_ADDR_BASE\0" /* 18151 */
	"GDS_ADDR_SIZE\0" /* 18165 */
	"GDS_ORDERED_WAVE_PER_SE\0" /* 18179 */
	"GDS_APPEND_COUNT_0\0" /* 18203 */
	"GDS_APPEND_COUNT_1\0" /* 18222 */
	"GDS_APPEND_COUNT_2\0" /* 18241 */
	"GDS_APPEND_COUNT_3\0" /* 18260 */
	"GDS_APPEND_COUNT_4\0" /* 18279 */
	"GDS_APPEND_COUNT_5\0" /* 18298 */
	"GDS_APPEND_COUNT_6\0" /* 18317 */
	"GDS_APPEND_COUNT_7\0" /* 18336 */
	"GDS_APPEND_COUNT_8\0" /* 18355 */
	"GDS_APPEND_COUNT_9\0" /* 18374 */
	"GDS_APPEND_COUNT_10\0" /* 18393 */
	"GDS_APPEND_COUNT_11\0" /* 18413 */
	"CB_BLEND1_CONTROL\0" /* 18433 */
	"CB_BLEND2_CONTROL\0" /* 18451 */
	"CB_BLEND3_CONTROL\0" /* 18469 */
	"CB_BLEND4_CONTROL\0" /* 18487 */
	"CB_BLEND5_CONTROL\0" /* 18505 */
	"CB_BLEND6_CONTROL\0" /* 18523 */
	"CB_BLEND7_CONTROL\0" /* 18541 */
	"PA_CL_VTE_CNTL\0" /* 18559 */
	"PA_CL_NANINF_CNTL\0" /* 18574 */
	"SQ_LSTMP_RING_ITEMSIZE\0" /* 18592 */
	"SQ_DYN_GPR_RESOURCE_LIMIT_1\0" /* 18615 */
	"SQ_PGM_START_PS\0" /* 18643 */
	"SQ_PGM_EXPORTS_PS\0" /* 18659 */
	"SQ_PGM_START_VS\0" /* 18677 */
	"SQ_PGM_START_GS\0" /* 18693 */
	"SQ_PGM_START_ES\0" /* 18709 */
	"SQ_PGM_START_FS\0" /* 18725 */
	"SQ_PGM_START_HS\0" /* 18741 */
	"SQ_PGM_START_LS\0" /* 18757 */
	"SQ_PGM_RESOURCES_FS\0" /* 18773 */
	"SQ_LDS_ALLOC\0" /* 18793 */
	"SQ_LDS_ALLOC_PS\0" /* 18806 */
	"SQ_ESGS_RING_ITEMSIZE\0" /* 18822 */
	"SQ_GSVS_RING_ITEMSIZE\0" /* 18844 */
	"SQ_ESTMP_RING_BASE\0" /* 18866 */
	"SQ_ESTMP_RING_ITEMSIZE\0" /* 18885 */
	"SQ_ESTMP_RING_SIZE\0" /* 18908 */
	"SQ_GSTMP_RING_BASE\0" /* 18927 */
	"SQ_GSTMP_RING_ITEMSIZE\0" /* 18946 */
	"SQ_GSTMP_RING_SIZE\0" /* 18969 */
	"SQ_VSTMP_RING_BASE\0" /* 18988 */
	"SQ_VSTMP_RING_ITEMSIZE\0" /* 19007 */
	"SQ_VSTMP_RING_SIZE\0" /* 19030 */
	"SQ_PSTMP_RING_BASE\0" /* 19049 */
	"SQ_PSTMP_RING_ITEMSIZE\0" /* 19068 */
	"SQ_PSTMP_RING_SIZE\0" /* 19091 */
	"SQ_LSTMP_RING_BASE\0" /* 19110 */
	"SQ_LSTMP_RING_SIZE\0" /* 19129 */
	"SQ_HSTMP_RING_BASE\0" /* 19148 */
	"SQ_HSTMP_RING_ITEMSIZE\0" /* 19167 */
	"SQ_HSTMP_RING_SIZE\0" /* 19190 */
	"SQ_GS_VERT_ITEMSIZE\0" /* 19209 */
	"SQ_GS_VERT_ITEMSIZE_1\0" /* 19229 */
	"SQ_GS_VERT_ITEMSIZE_2\0" /* 19251 */
	"SQ_GS_VERT_ITEMSIZE_3\0" /* 19273 */
	"SQ_GSVS_RING_OFFSET_1\0" /* 19295 */
	"SQ_GSVS_RING_OFFSET_2\0" /* 19317 */
	"SQ_GSVS_RING_OFFSET_3\0" /* 19339 */
	"ALU_CONST_CACHE_PS_0\0" /* 19361 */
	"ALU_CONST_CACHE_PS_1\0" /* 19382 */
	"ALU_CONST_CACHE_VS_0\0" /* 19403 */
	"ALU_CONST_CACHE_VS_1\0" /* 19424 */
	"ALU_CONST_CACHE_GS_0\0" /* 19445 */
	"ALU_CONST_CACHE_HS_0\0" /* 19466 */
	"ALU_CONST_CACHE_LS_0\0" /* 19487 */
	"PA_SU_POINT_MINMAX\0" /* 19508 */
	"PA_SU_LINE_CNTL\0" /* 19527 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 19543 */
	"VGT_HOS_CNTL\0" /* 19564 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 19577 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 19600 */
	"VGT_HOS_REUSE_DEPTH\0" /* 19623 */
	"VGT_GROUP_PRIM_TYPE\0" /* 19643 */
	"VGT_GROUP_FIRST_DECR\0" /* 19663 */
	"VGT_GROUP_DECR\0" /* 19684 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 19699 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 19721 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 19743 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 19769 */
	"PA_SC_MODE_CNTL_0\0" /* 19795 */
	"PA_SC_MODE_CNTL_1\0" /* 19813 */
	"GS_PER_ES\0" /* 19831 */
	"ES_PER_GS\0" /* 19841 */
	"GS_PER_VS\0" /* 19851 */
	"VGT_PRIMITIVEID_EN\0" /* 19861 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 19880 */
	"VGT_REUSE_OFF\0" /* 19907 */
	"VGT_VTX_CNT_EN\0" /* 19921 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 19936 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 19963 */
	"DB_PRELOAD_CONTROL\0" /* 19990 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 20009 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 20035 */
	"VGT_STRMOUT_BUFFER_BASE_0\0" /* 20060 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 20086 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 20114 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 20140 */
	"VGT_STRMOUT_BUFFER_BASE_1\0" /* 20165 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 20191 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 20219 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 20245 */
	"VGT_STRMOUT_BUFFER_BASE_2\0" /* 20270 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 20296 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 20324 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 20350 */
	"VGT_STRMOUT_BUFFER_BASE_3\0" /* 20375 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 20401 */
	"VGT_STRMOUT_BASE_OFFSET_0\0" /* 20429 */
	"VGT_STRMOUT_BASE_OFFSET_1\0" /* 20455 */
	"VGT_STRMOUT_BASE_OFFSET_2\0" /* 20481 */
	"VGT_STRMOUT_BASE_OFFSET_3\0" /* 20507 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 20533 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 20564 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 20607 */
	"VGT_GS_MAX_VERT_OUT\0" /* 20645 */
	"VGT_STRMOUT_BASE_OFFSET_HI_0\0" /* 20665 */
	"VGT_STRMOUT_BASE_OFFSET_HI_1\0" /* 20694 */
	"VGT_STRMOUT_BASE_OFFSET_HI_2\0" /* 20723 */
	"VGT_STRMOUT_BASE_OFFSET_HI_3\0" /* 20752 */
	"VGT_SHADER_STAGES_EN\0" /* 20781 */
	"VGT_LS_HS_CONFIG\0" /* 20802 */
	"VGT_LS_SIZE\0" /* 20819 */
	"VGT_HS_SIZE\0" /* 20831 */
	"VGT_LS_HS_ALLOC\0" /* 20843 */
	"VGT_HS_PATCH_CONST\0" /* 20859 */
	"DB_ALPHA_TO_MASK\0" /* 20878 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 20895 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 20925 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 20949 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 20979 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 21010 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 21039 */
	"VGT_GS_INSTANCE_CNT\0" /* 21069 */
	"CB_IMMED0_BASE\0" /* 21089 */
	"CB_IMMED1_BASE\0" /* 21104 */
	"CB_IMMED2_BASE\0" /* 21119 */
	"CB_IMMED3_BASE\0" /* 21134 */
	"CB_IMMED4_BASE\0" /* 21149 */
	"CB_IMMED5_BASE\0" /* 21164 */
	"CB_IMMED6_BASE\0" /* 21179 */
	"CB_IMMED7_BASE\0" /* 21194 */
	"CB_IMMED8_BASE\0" /* 21209 */
	"CB_IMMED9_BASE\0" /* 21224 */
	"CB_IMMED10_BASE\0" /* 21239 */
	"CB_IMMED11_BASE\0" /* 21255 */
	"PA_SC_LINE_CNTL\0" /* 21271 */
	"PA_SC_AA_CONFIG\0" /* 21287 */
	"PA_SU_VTX_CNTL\0" /* 21303 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 21318 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 21341 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 21364 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 21387 */
	"PA_SC_AA_SAMPLE_LOCS_0\0" /* 21410 */
	"PA_SC_AA_SAMPLE_LOCS_1\0" /* 21433 */
	"PA_SC_AA_SAMPLE_LOCS_2\0" /* 21456 */
	"PA_SC_AA_SAMPLE_LOCS_3\0" /* 21479 */
	"PA_SC_AA_SAMPLE_LOCS_4\0" /* 21502 */
	"PA_SC_AA_SAMPLE_LOCS_5\0" /* 21525 */
	"PA_SC_AA_SAMPLE_LOCS_6\0" /* 21548 */
	"PA_SC_AA_SAMPLE_LOCS_7\0" /* 21571 */
	"PA_SC_AA_MASK\0" /* 21594 */
	"CB_COLOR0_BASE\0" /* 21608 */
	"CB_COLOR0_VIEW\0" /* 21623 */
	"CB_COLOR0_CMASK\0" /* 21638 */
	"CB_COLOR0_CMASK_SLICE\0" /* 21654 */
	"CB_COLOR0_FMASK\0" /* 21676 */
	"CB_COLOR0_FMASK_SLICE\0" /* 21692 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 21714 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 21736 */
	"CB_COLOR0_CLEAR_WORD2\0" /* 21758 */
	"CB_COLOR0_CLEAR_WORD3\0" /* 21780 */
	"CB_COLOR1_BASE\0" /* 21802 */
	"CB_COLOR1_PITCH\0" /* 21817 */
	"CB_COLOR1_SLICE\0" /* 21833 */
	"CB_COLOR1_VIEW\0" /* 21849 */
	"CB_COLOR1_INFO\0" /* 21864 */
	"CB_COLOR1_ATTRIB\0" /* 21879 */
	"CB_COLOR1_DIM\0" /* 21896 */
	"CB_COLOR1_CMASK\0" /* 21910 */
	"CB_COLOR1_CMASK_SLICE\0" /* 21926 */
	"CB_COLOR1_FMASK\0" /* 21948 */
	"CB_COLOR1_FMASK_SLICE\0" /* 21964 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 21986 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 22008 */
	"CB_COLOR1_CLEAR_WORD2\0" /* 22030 */
	"CB_COLOR1_CLEAR_WORD3\0" /* 22052 */
	"CB_COLOR2_BASE\0" /* 22074 */
	"CB_COLOR2_PITCH\0" /* 22089 */
	"CB_COLOR2_SLICE\0" /* 22105 */
	"CB_COLOR2_VIEW\0" /* 22121 */
	"CB_COLOR2_INFO\0" /* 22136 */
	"CB_COLOR2_ATTRIB\0" /* 22151 */
	"CB_COLOR2_DIM\0" /* 22168 */
	"CB_COLOR2_CMASK\0" /* 22182 */
	"CB_COLOR2_CMASK_SLICE\0" /* 22198 */
	"CB_COLOR2_FMASK\0" /* 22220 */
	"CB_COLOR2_FMASK_SLICE\0" /* 22236 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 22258 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 22280 */
	"CB_COLOR2_CLEAR_WORD2\0" /* 22302 */
	"CB_COLOR2_CLEAR_WORD3\0" /* 22324 */
	"CB_COLOR3_BASE\0" /* 22346 */
	"CB_COLOR3_PITCH\0" /* 22361 */
	"CB_COLOR3_SLICE\0" /* 22377 */
	"CB_COLOR3_VIEW\0" /* 22393 */
	"CB_COLOR3_INFO\0" /* 22408 */
	"CB_COLOR3_ATTRIB\0" /* 22423 */
	"CB_COLOR3_DIM\0" /* 22440 */
	"CB_COLOR3_CMASK\0" /* 22454 */
	"CB_COLOR3_CMASK_SLICE\0" /* 22470 */
	"CB_COLOR3_FMASK\0" /* 22492 */
	"CB_COLOR3_FMASK_SLICE\0" /* 22508 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 22530 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 22552 */
	"CB_COLOR3_CLEAR_WORD2\0" /* 22574 */
	"CB_COLOR3_CLEAR_WORD3\0" /* 22596 */
	"CB_COLOR4_BASE\0" /* 22618 */
	"CB_COLOR4_PITCH\0" /* 22633 */
	"CB_COLOR4_SLICE\0" /* 22649 */
	"CB_COLOR4_VIEW\0" /* 22665 */
	"CB_COLOR4_INFO\0" /* 22680 */
	"CB_COLOR4_ATTRIB\0" /* 22695 */
	"CB_COLOR4_DIM\0" /* 22712 */
	"CB_COLOR4_CMASK\0" /* 22726 */
	"CB_COLOR4_CMASK_SLICE\0" /* 22742 */
	"CB_COLOR4_FMASK\0" /* 22764 */
	"CB_COLOR4_FMASK_SLICE\0" /* 22780 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 22802 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 22824 */
	"CB_COLOR4_CLEAR_WORD2\0" /* 22846 */
	"CB_COLOR4_CLEAR_WORD3\0" /* 22868 */
	"CB_COLOR5_BASE\0" /* 22890 */
	"CB_COLOR5_PITCH\0" /* 22905 */
	"CB_COLOR5_SLICE\0" /* 22921 */
	"CB_COLOR5_VIEW\0" /* 22937 */
	"CB_COLOR5_INFO\0" /* 22952 */
	"CB_COLOR5_ATTRIB\0" /* 22967 */
	"CB_COLOR5_DIM\0" /* 22984 */
	"CB_COLOR5_CMASK\0" /* 22998 */
	"CB_COLOR5_CMASK_SLICE\0" /* 23014 */
	"CB_COLOR5_FMASK\0" /* 23036 */
	"CB_COLOR5_FMASK_SLICE\0" /* 23052 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 23074 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 23096 */
	"CB_COLOR5_CLEAR_WORD2\0" /* 23118 */
	"CB_COLOR5_CLEAR_WORD3\0" /* 23140 */
	"CB_COLOR6_BASE\0" /* 23162 */
	"CB_COLOR6_PITCH\0" /* 23177 */
	"CB_COLOR6_SLICE\0" /* 23193 */
	"CB_COLOR6_VIEW\0" /* 23209 */
	"CB_COLOR6_INFO\0" /* 23224 */
	"CB_COLOR6_ATTRIB\0" /* 23239 */
	"CB_COLOR6_DIM\0" /* 23256 */
	"CB_COLOR6_CMASK\0" /* 23270 */
	"CB_COLOR6_CMASK_SLICE\0" /* 23286 */
	"CB_COLOR6_FMASK\0" /* 23308 */
	"CB_COLOR6_FMASK_SLICE\0" /* 23324 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 23346 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 23368 */
	"CB_COLOR6_CLEAR_WORD2\0" /* 23390 */
	"CB_COLOR6_CLEAR_WORD3\0" /* 23412 */
	"CB_COLOR7_BASE\0" /* 23434 */
	"CB_COLOR7_PITCH\0" /* 23449 */
	"CB_COLOR7_SLICE\0" /* 23465 */
	"CB_COLOR7_VIEW\0" /* 23481 */
	"CB_COLOR7_INFO\0" /* 23496 */
	"CB_COLOR7_ATTRIB\0" /* 23511 */
	"CB_COLOR7_DIM\0" /* 23528 */
	"CB_COLOR7_CMASK\0" /* 23542 */
	"CB_COLOR7_CMASK_SLICE\0" /* 23558 */
	"CB_COLOR7_FMASK\0" /* 23580 */
	"CB_COLOR7_FMASK_SLICE\0" /* 23596 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 23618 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 23640 */
	"CB_COLOR7_CLEAR_WORD2\0" /* 23662 */
	"CB_COLOR7_CLEAR_WORD3\0" /* 23684 */
	"CB_COLOR8_BASE\0" /* 23706 */
	"CB_COLOR8_PITCH\0" /* 23721 */
	"CB_COLOR8_SLICE\0" /* 23737 */
	"CB_COLOR8_VIEW\0" /* 23753 */
	"CB_COLOR8_INFO\0" /* 23768 */
	"CB_COLOR8_ATTRIB\0" /* 23783 */
	"CB_COLOR8_DIM\0" /* 23800 */
	"CB_COLOR9_BASE\0" /* 23814 */
	"CB_COLOR9_PITCH\0" /* 23829 */
	"CB_COLOR9_SLICE\0" /* 23845 */
	"CB_COLOR9_VIEW\0" /* 23861 */
	"CB_COLOR9_INFO\0" /* 23876 */
	"CB_COLOR9_ATTRIB\0" /* 23891 */
	"CB_COLOR9_DIM\0" /* 23908 */
	"CB_COLOR10_BASE\0" /* 23922 */
	"CB_COLOR10_PITCH\0" /* 23938 */
	"CB_COLOR10_SLICE\0" /* 23955 */
	"CB_COLOR10_VIEW\0" /* 23972 */
	"CB_COLOR10_INFO\0" /* 23988 */
	"CB_COLOR10_ATTRIB\0" /* 24004 */
	"CB_COLOR10_DIM\0" /* 24022 */
	"CB_COLOR11_BASE\0" /* 24037 */
	"CB_COLOR11_PITCH\0" /* 24053 */
	"CB_COLOR11_SLICE\0" /* 24070 */
	"CB_COLOR11_VIEW\0" /* 24087 */
	"CB_COLOR11_INFO\0" /* 24103 */
	"CB_COLOR11_ATTRIB\0" /* 24119 */
	"CB_COLOR11_DIM\0" /* 24137 */
	"RESOURCE0_WORD0\0" /* 24152 */
	"RESOURCE0_WORD1\0" /* 24168 */
	"RESOURCE0_WORD2\0" /* 24184 */
	"RESOURCE0_WORD3\0" /* 24200 */
	"RESOURCE0_WORD4\0" /* 24216 */
	"RESOURCE0_WORD5\0" /* 24232 */
	"RESOURCE0_WORD6\0" /* 24248 */
	"RESOURCE0_WORD7\0" /* 24264 */
	"CP_COHER_CNTL\0" /* 24280 */
	"CP_COHER_SIZE\0" /* 24294 */
	"CP_COHER_BASE\0" /* 24308 */
	"VGT_NUM_INDICES\0" /* 24322 */
	"SQ_VTX_BASE_VTX_LOC\0" /* 24338 */
	"SQ_VTX_START_INST_LOC\0" /* 24358 */
	"SQ_LOOP_CONST_0\0" /* 24380 */;

static const int egd_strings_offsets[] = {
	/* 0 */ 1878, 1892, 1900, 1910, -1, 1922, 1931, 1946, 1956, 1968, 1980, 1994, 2008, 2022, 2031, 2046, 2058, 2076, 2087, 2104, 2115, 2132, 2147, 2168, 2183, 2204, 2221, 2235, 2252, 2273, 2285, 2303, 2321, -1, 2345, 2363, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2387,
	/* 49 */ 2415, 2436, 2457, -1, 2478,
	/* 54 */ 2510, 2523, 2536, 2551, 2566, 2578, 2590, 2602,
	/* 62 */ 2627, 2636, 2645, 2658,
	/* 66 */ 2766, 2782, 2798,
	/* 69 */ 330, 2832, 2842, 2857, 2867, 2882,
	/* 75 */ 3108, 3121, 3135,
	/* 78 */ 3145, 3158, 3168, 3182,
	/* 82 */ 3210, 3223, 3235, 3254,
	/* 86 */ 3303, 3315,
	/* 88 */ 3426, 3444, 3461, 3479, 3498, 3518, 3539, 3558,
	/* 96 */ 3589, 3602, 3615, 3631, 3644, 3657, 3672, 3690,
	/* 104 */ 3823, 3834, 3844, 3868, 3879, 3893,
	/* 110 */ 4222, 4232, 4237, 4242,
	/* 114 */ 4300, 4316,
	/* 116 */ 4431, 4442, 4452, 4468, 4494, 4510, 4536, 4552, 4578, 4594, 4620, 4645, 4666, 4691, 4709, 4737, 4754, 4775, 4792, 4813, 4831,
	/* 137 */ 4874, 4892, 4911, 4928, 4945,
	/* 142 */ 5468, 5475, 5495, 5500,
	/* 146 */ 5607, 5622, 5639,
	/* 149 */ 5712, 5725, 5744, 5766,
	/* 153 */ 5864, 5871, 5885, 5899, 5913, 5927,
	/* 159 */ 5949, 5961, 5972, 5983,
	/* 163 */ 6035, 6058, 6081,
	/* 166 */ 6766, 6780, 6794, 6808, 6827, 6847, 6867, 6886,
	/* 174 */ 6977, 7001, 7023,
	/* 177 */ 7110, 7129, 7147,
	/* 180 */ 7183, 7213,
	/* 182 */ 7288, 7297, 7306, 7315, 7324, 7333,
	/* 188 */ 7500, 7527, 7553, 7578,
	/* 192 */ 7658, 7670, 7684, 7708, 7738, 7763, 7794, 7814,
	/* 200 */ 7856, 7879,
	/* 202 */ 7933, 7954, 7976,
	/* 205 */ 8019, 8051, 8084, 8117,
	/* 209 */ 8164, 8191, 8217, 8244, 8275, 8304, 8334, 8368,
	/* 217 */ 8419, 8445, 8468,
	/* 220 */ 8619, 8630, 8646, 8661, 8677, 8691, 8704, 8719, 8734, 8749, 8761, 8780, 8800, 8818, 8837, 8852, 8867, 8889, 8904, 8919, 8934, 8950, 8964, 8991, 9018, 9045, 9072, 9096, 9116,
	/* 249 */ 9612, 9631, 9651, 9672,
	/* 253 */ 10302, 10312, 10325,
	/* 256 */ 11010, 11023, 11035,
	/* 259 */ 11059, 11072, 11084,
	/* 262 */ 11110, 11124, 11136,
	/* 265 */ 11464, 11475, 11483, 11499,
	/* 269 */ 11514, 11523, 11531, 11539, 11545, 11549, 11559, 11570,
};

#endif
