/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.vocab;

import com.adobe.epubcheck.vocab.Property;
import com.adobe.epubcheck.vocab.Vocab;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;

public final class EnumVocab<P extends Enum<P>>
implements Vocab {
    private final Map<String, Property> index;
    private final String uri;
    private final Converter<P, String> converter;

    public EnumVocab(Class<P> clazz, String base) {
        this(clazz, CaseFormat.LOWER_HYPHEN, base, null);
    }

    public EnumVocab(Class<P> clazz, CaseFormat format, String base) {
        this(clazz, format, base, null);
    }

    public EnumVocab(Class<P> clazz, String base, String prefix) {
        this(clazz, CaseFormat.LOWER_HYPHEN, base, prefix);
    }

    public EnumVocab(Class<P> clazz, CaseFormat format, final String base, final String prefix) {
        this.uri = Strings.nullToEmpty((String)base);
        this.converter = Enums.stringConverter(clazz).reverse().andThen(CaseFormat.UPPER_UNDERSCORE.converterTo(format == null ? CaseFormat.LOWER_HYPHEN : format));
        this.index = ImmutableMap.copyOf((Map)Maps.transformEntries((Map)Maps.uniqueIndex(EnumSet.allOf(clazz), this.converter), (Maps.EntryTransformer)new Maps.EntryTransformer<String, P, Property>(){
            final /* synthetic */ EnumVocab this$0;
            {
                this.this$0 = this$0;
            }

            public Property transformEntry(String name, P enumee) {
                return Property.newFrom(name, base, prefix, enumee);
            }
        }));
    }

    @Override
    public Optional<Property> lookup(String name) {
        return Optional.fromNullable((Object)this.index.get(name));
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    public Property get(P property) {
        Preconditions.checkNotNull(property);
        return (Property)this.lookup((String)this.converter.convert(property)).get();
    }

    public String getName(P property) {
        Preconditions.checkNotNull(property);
        return (String)this.converter.convert(property);
    }

    public Collection<String> getNames(Collection<P> properties) {
        Preconditions.checkNotNull(properties);
        return Collections2.transform(properties, (Function)new Function<P, String>(){

            public String apply(P property) {
                return (String)EnumVocab.this.converter.convert(property);
            }
        });
    }
}

