/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.descriptor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.UrlRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.resolver.M2ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.MavenResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;

public class MavenRepositoryDescriptor
extends UrlRepositoryDescriptor {
    private final ImmutableList<ResourcePattern> metadataResources;
    private final ImmutableList<URI> artifactUrls;
    private final ImmutableList<ResourcePattern> artifactResources;

    private MavenRepositoryDescriptor(String id, String name, URI url, ImmutableList<ResourcePattern> metadataResources, ImmutableList<ResourcePattern> artifactResources, ImmutableList<String> metadataSources, boolean authenticated, ImmutableList<String> authenticationSchemes, ImmutableList<URI> artifactUrls) {
        super(id, name, url, metadataSources, authenticated, authenticationSchemes);
        this.artifactUrls = artifactUrls;
        this.metadataResources = metadataResources;
        this.artifactResources = artifactResources;
    }

    @Override
    public RepositoryDescriptor.Type getType() {
        return RepositoryDescriptor.Type.MAVEN;
    }

    @Override
    public ImmutableList<ResourcePattern> getMetadataResources() {
        return this.metadataResources;
    }

    @Override
    public ImmutableList<ResourcePattern> getArtifactResources() {
        return this.artifactResources;
    }

    @Override
    protected void addProperties(ImmutableSortedMap.Builder<String, Object> builder) {
        super.addProperties(builder);
        builder.put((Object)Property.ARTIFACT_URLS.name(), this.artifactUrls);
    }

    private static enum Property {
        ARTIFACT_URLS;

    }

    public static class Builder
    extends UrlRepositoryDescriptor.Builder<Builder> {
        private ImmutableList<URI> artifactUrls;

        public Builder(String name, URI url) {
            super(name, url);
        }

        public Builder setArtifactUrls(Collection<URI> artifactUrls) {
            this.artifactUrls = ImmutableList.copyOf(artifactUrls);
            return this;
        }

        public MavenRepositoryDescriptor create() {
            Preconditions.checkNotNull(this.artifactUrls);
            Preconditions.checkNotNull((Object)this.metadataSources);
            ImmutableList metadataResources = ImmutableList.of((Object)new M2ResourcePattern(this.url, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier])(.[ext])"));
            ImmutableList.Builder artifactResourcesBuilder = ImmutableList.builderWithExpectedSize((int)(1 + this.artifactUrls.size()));
            artifactResourcesBuilder.add((Object)new M2ResourcePattern(this.url, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier])(.[ext])"));
            for (URI rootUri : this.artifactUrls) {
                artifactResourcesBuilder.add((Object)new M2ResourcePattern(rootUri, "[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier])(.[ext])"));
            }
            ImmutableList artifactResources = artifactResourcesBuilder.build();
            String id = this.calculateId(MavenResolver.class, (List<ResourcePattern>)metadataResources, (List<ResourcePattern>)artifactResources, (List<String>)this.metadataSources, hasher -> {});
            return new MavenRepositoryDescriptor(id, (String)Preconditions.checkNotNull((Object)this.name), this.url, metadataResources, artifactResources, this.metadataSources, (Boolean)Preconditions.checkNotNull((Object)this.authenticated), (ImmutableList)Preconditions.checkNotNull((Object)this.authenticationSchemes), this.artifactUrls);
        }
    }
}

