/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SessionParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsSRTPUtils;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.UseSRTPData;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.nlj.dtls.DtlsUtils;
import org.jitsi.nlj.dtls.DtlsUtilsKt;
import org.jitsi.nlj.srtp.SrtpConfig;
import org.jitsi.nlj.srtp.SrtpProfileInformation;
import org.jitsi.nlj.srtp.SrtpUtil;
import org.jitsi.rtp.extensions.ByteBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u001d\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020\u00072\u0010\u0010 \u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u0016H\u0016J\b\u0010*\u001a\u00020\u0007H\u0016J\u0012\u0010+\u001a\u00020\u00072\b\u0010,\u001a\u0004\u0018\u00010\u0006H\u0016J,\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\b\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0018\u00105\u001a\u00020\u00072\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/H\u0016J\u0013\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0014\u00a2\u0006\u0002\u00109R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006:"}, d2={"Lorg/jitsi/nlj/dtls/TlsServerImpl;", "Lorg/bouncycastle/tls/DefaultTlsServer;", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "notifyClientCertificateReceived", "Lkotlin/Function1;", "Lorg/bouncycastle/tls/Certificate;", "", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/dtls/CertificateInfo;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "session", "Lorg/bouncycastle/tls/TlsSession;", "srtpKeyingMaterial", "", "getSrtpKeyingMaterial", "()[B", "setSrtpKeyingMaterial", "([B)V", "chosenSrtpProtectionProfile", "", "getChosenSrtpProtectionProfile", "()I", "setChosenSrtpProtectionProfile", "(I)V", "getSessionToResume", "sessionID", "getServerExtensions", "Ljava/util/Hashtable;", "processClientExtensions", "clientExtensions", "getCipherSuites", "", "getRSAEncryptionCredentials", "Lorg/bouncycastle/tls/TlsCredentialedDecryptor;", "getECDSASignerCredentials", "Lorg/bouncycastle/tls/TlsCredentialedSigner;", "getCertificateRequest", "Lorg/bouncycastle/tls/CertificateRequest;", "getHandshakeTimeoutMillis", "notifyHandshakeComplete", "notifyClientCertificate", "clientCertificate", "notifyAlertRaised", "alertLevel", "", "alertDescription", "message", "", "cause", "", "notifyAlertReceived", "getSupportedVersions", "", "Lorg/bouncycastle/tls/ProtocolVersion;", "()[Lorg/bouncycastle/tls/ProtocolVersion;", "jitsi-media-transform"})
@SuppressFBWarnings(value={"NP_ALWAYS_NULL"}, justification="False positives with 'lateinit'.")
@SourceDebugExtension(value={"SMAP\nTlsServerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsServerImpl.kt\norg/jitsi/nlj/dtls/TlsServerImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 DtlsUtils.kt\norg/jitsi/nlj/dtls/DtlsUtilsKt\n*L\n1#1,177:1\n57#2,4:178\n57#2,4:182\n57#2,4:186\n63#2,4:192\n57#2,2:204\n60#2:208\n57#2,4:212\n75#2:217\n76#2:220\n298#3,2:190\n301#3,8:196\n309#3,2:206\n314#3:209\n318#3,2:210\n320#3:216\n321#3,2:218\n325#3:221\n*S KotlinDebug\n*F\n+ 1 TlsServerImpl.kt\norg/jitsi/nlj/dtls/TlsServerImpl\n*L\n131#1:178,4\n137#1:182,4\n140#1:186,4\n170#1:192,4\n170#1:204,2\n170#1:208\n173#1:212,4\n173#1:217\n173#1:220\n170#1:190,2\n170#1:196,8\n170#1:206,2\n170#1:209\n173#1:210,2\n173#1:216\n173#1:218,2\n173#1:221\n*E\n"})
public final class TlsServerImpl
extends DefaultTlsServer {
    @NotNull
    private final CertificateInfo certificateInfo;
    @NotNull
    private final Function1<Certificate, Unit> notifyClientCertificateReceived;
    @NotNull
    private final Logger logger;
    @Nullable
    private TlsSession session;
    public byte[] srtpKeyingMaterial;
    private int chosenSrtpProtectionProfile;

    public TlsServerImpl(@NotNull CertificateInfo certificateInfo, @NotNull Function1<? super Certificate, Unit> notifyClientCertificateReceived, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(certificateInfo, "certificateInfo");
        Intrinsics.checkNotNullParameter(notifyClientCertificateReceived, "notifyClientCertificateReceived");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(DtlsUtilsKt.getBC_TLS_CRYPTO());
        this.certificateInfo = certificateInfo;
        this.notifyClientCertificateReceived = notifyClientCertificateReceived;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
    }

    @NotNull
    public final byte[] getSrtpKeyingMaterial() {
        if (this.srtpKeyingMaterial != null) {
            return this.srtpKeyingMaterial;
        }
        Intrinsics.throwUninitializedPropertyAccessException("srtpKeyingMaterial");
        return null;
    }

    public final void setSrtpKeyingMaterial(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter(byArray, "<set-?>");
        this.srtpKeyingMaterial = byArray;
    }

    public final int getChosenSrtpProtectionProfile() {
        return this.chosenSrtpProtectionProfile;
    }

    public final void setChosenSrtpProtectionProfile(int n) {
        this.chosenSrtpProtectionProfile = n;
    }

    @Override
    @Nullable
    public TlsSession getSessionToResume(@Nullable byte[] sessionID) {
        return this.session;
    }

    @Override
    @NotNull
    public Hashtable<?, ?> getServerExtensions() {
        Hashtable extensions;
        Hashtable hashtable;
        Hashtable hashtable2 = super.getServerExtensions();
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        Hashtable it = hashtable = (extensions = hashtable2);
        boolean bl = false;
        if (TlsSRTPUtils.getUseSRTPExtension(it) == null) {
            int[] nArray = new int[]{this.chosenSrtpProtectionProfile};
            TlsSRTPUtils.addUseSRTPExtension(it, new UseSRTPData(nArray, TlsUtils.EMPTY_BYTES));
        }
        return hashtable;
    }

    public void processClientExtensions(@Nullable Hashtable<?, ?> clientExtensions) {
        super.processClientExtensions(clientExtensions);
        UseSRTPData useSRTPData = TlsSRTPUtils.getUseSRTPExtension(clientExtensions);
        int[] protectionProfiles = useSRTPData.getProtectionProfiles();
        Iterable iterable = SrtpConfig.Companion.getProtectionProfiles();
        Intrinsics.checkNotNull(protectionProfiles);
        this.chosenSrtpProtectionProfile = DtlsUtils.Companion.chooseSrtpProtectionProfile(iterable, ArraysKt.asIterable(protectionProfiles));
    }

    @Override
    @NotNull
    public int[] getCipherSuites() {
        return CollectionsKt.toIntArray((Collection<Integer>)DtlsConfig.Companion.getConfig().getCipherSuites());
    }

    @Override
    @NotNull
    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() {
        TlsCrypto tlsCrypto = this.context.getCrypto();
        Intrinsics.checkNotNull(tlsCrypto, "null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
        return new BcDefaultTlsCredentialedDecryptor((BcTlsCrypto)tlsCrypto, this.certificateInfo.getCertificate(), PrivateKeyFactory.createKey(this.certificateInfo.getKeyPair().getPrivate().getEncoded()));
    }

    @Override
    @NotNull
    protected TlsCredentialedSigner getECDSASignerCredentials() {
        TlsCryptoParameters tlsCryptoParameters = new TlsCryptoParameters(this.context);
        TlsCrypto tlsCrypto = this.context.getCrypto();
        Intrinsics.checkNotNull(tlsCrypto, "null cannot be cast to non-null type org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto");
        return new BcDefaultTlsCredentialedSigner(tlsCryptoParameters, (BcTlsCrypto)tlsCrypto, PrivateKeyFactory.createKey(this.certificateInfo.getKeyPair().getPrivate().getEncoded()), this.certificateInfo.getCertificate(), new SignatureAndHashAlgorithm(4, 3));
    }

    @Override
    @NotNull
    public CertificateRequest getCertificateRequest() {
        Vector<SignatureAndHashAlgorithm> signatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(1);
        signatureAlgorithms.add(new SignatureAndHashAlgorithm(4, 3));
        short[] sArray = new short[]{64};
        return new CertificateRequest(sArray, signatureAlgorithms, null);
    }

    @Override
    public int getHandshakeTimeoutMillis() {
        return (int)DtlsUtils.Companion.getConfig().getHandshakeTimeout().toMillis();
    }

    @Override
    public void notifyHandshakeComplete() {
        super.notifyHandshakeComplete();
        Logger $this$cinfo$iv = this.logger;
        boolean $i$f$cinfo = false;
        if ($this$cinfo$iv.isInfoEnabled()) {
            Logger logger = $this$cinfo$iv;
            boolean bl = false;
            logger.info("Negotiated DTLS version " + this.context.getSecurityParameters().getNegotiatedVersion());
        }
        TlsSession tlsSession = this.context.getResumableSession();
        if (tlsSession != null) {
            TlsSession newSession = tlsSession;
            boolean bl = false;
            ByteBuffer byteBuffer = ByteBuffer.wrap(newSession.getSessionID());
            Intrinsics.checkNotNullExpressionValue(byteBuffer, "wrap(...)");
            String newSessionIdHex = ByteBufferKt.toHex(byteBuffer);
            TlsSession tlsSession2 = this.session;
            if (tlsSession2 != null) {
                TlsSession existingSession = tlsSession2;
                boolean bl2 = false;
                byte[] byArray = existingSession.getSessionID();
                boolean bl3 = byArray != null ? Arrays.equals(byArray, newSession.getSessionID()) : false;
                if (bl3) {
                    Logger $this$cinfo$iv2 = this.logger;
                    boolean $i$f$cinfo2 = false;
                    if ($this$cinfo$iv2.isInfoEnabled()) {
                        Logger logger = $this$cinfo$iv2;
                        boolean bl4 = false;
                        logger.info("Resumed DTLS session " + newSessionIdHex);
                    }
                }
            } else {
                TlsServerImpl $this$notifyHandshakeComplete_u24lambda_u246_u24lambda_u245 = this;
                boolean bl5 = false;
                Logger $this$cinfo$iv3 = $this$notifyHandshakeComplete_u24lambda_u246_u24lambda_u245.logger;
                boolean $i$f$cinfo3 = false;
                if ($this$cinfo$iv3.isInfoEnabled()) {
                    Logger logger = $this$cinfo$iv3;
                    boolean bl6 = false;
                    logger.info("Established DTLS session " + newSessionIdHex);
                }
                $this$notifyHandshakeComplete_u24lambda_u246_u24lambda_u245.session = newSession;
            }
        }
        SrtpProfileInformation srtpProfileInformation = SrtpUtil.Companion.getSrtpProfileInformationFromSrtpProtectionProfile(this.chosenSrtpProtectionProfile);
        if (!this.context.getSecurityParameters().isExtendedMasterSecret()) {
            Object object = this.context.getSession();
            if (object != null && (object = object.exportSessionParameters()) != null && (object = ((SessionParameters)object).getMasterSecret()) != null) {
                Object it = object;
                boolean bl = false;
                TlsServerContext tlsServerContext = this.context;
                Intrinsics.checkNotNullExpressionValue(tlsServerContext, "context");
                this.setSrtpKeyingMaterial(DtlsUtils.Companion.exportKeyingMaterial(tlsServerContext, "EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength()), (TlsSecret)it));
            }
        } else {
            this.setSrtpKeyingMaterial(this.context.exportKeyingMaterial("EXTRACTOR-dtls_srtp", null, 2 * (srtpProfileInformation.getCipherKeyLength() + srtpProfileInformation.getCipherSaltLength())));
        }
    }

    @Override
    public void notifyClientCertificate(@Nullable Certificate clientCertificate) {
        this.notifyClientCertificateReceived.invoke(clientCertificate);
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, @Nullable String message, @Nullable Throwable cause) {
        Logger $this$notifyAlertRaised$iv = this.logger;
        boolean $i$f$notifyAlertRaised = false;
        if (alertDescription == 0) {
            Logger $this$cdebug$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv$iv;
                boolean bl = false;
                logger.debug("close_notify raised, connection closing");
            }
        } else {
            StringBuffer $this$notifyAlertRaised_u24lambda_u241$iv = new StringBuffer();
            boolean bl = false;
            Exception e$iv = new Exception();
            Iterator<StackTraceElement> iterator2 = ArrayIteratorKt.iterator(e$iv.getStackTrace());
            while (iterator2.hasNext()) {
                StackTraceElement el$iv = iterator2.next();
                Appendable appendable = ((Appendable)$this$notifyAlertRaised_u24lambda_u241$iv).append(el$iv.toString());
                Intrinsics.checkNotNullExpressionValue(appendable, "append(...)");
                Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append(...)");
            }
            String string = $this$notifyAlertRaised_u24lambda_u241$iv.toString();
            Intrinsics.checkNotNullExpressionValue(string, "with(...)");
            String stack$iv = string;
            Logger $this$cinfo$iv$iv = $this$notifyAlertRaised$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl2 = false;
                logger.info("Alert raised: level=" + alertLevel + ", description=" + alertDescription + ", message=" + message + " cause=" + cause + " " + stack$iv);
            }
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        Logger $this$notifyAlertReceived$iv = this.logger;
        boolean $i$f$notifyAlertReceived = false;
        if (alertDescription == 0) {
            Logger $this$cinfo$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cinfo = false;
            if ($this$cinfo$iv$iv.isInfoEnabled()) {
                Logger logger = $this$cinfo$iv$iv;
                boolean bl = false;
                logger.info("close_notify received, connection closing");
            }
        } else {
            Logger $this$cerror$iv$iv = $this$notifyAlertReceived$iv;
            boolean $i$f$cerror = false;
            Logger logger = $this$cerror$iv$iv;
            boolean bl = false;
            logger.error("Alert received: level=" + alertLevel + ", description=" + alertDescription + " (" + AlertDescription.getName(alertDescription) + ")");
        }
    }

    @Override
    @NotNull
    protected ProtocolVersion[] getSupportedVersions() {
        ProtocolVersion[] protocolVersionArray = new ProtocolVersion[]{ProtocolVersion.DTLSv12};
        return protocolVersionArray;
    }
}

