/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.SimplePacket;
import org.pcap4j.util.ByteArrays;

public final class EncryptedPacket
extends SimplePacket {
    private static final long serialVersionUID = 1942694224438957128L;

    public static EncryptedPacket newPacket(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new EncryptedPacket(rawData, offset, length);
    }

    private EncryptedPacket(byte[] rawData, int offset, int length) {
        super(rawData, offset, length);
    }

    private EncryptedPacket(Builder builder2) {
        super(builder2);
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    protected String modifier() {
        return "Encrypted ";
    }

    public static final class Builder
    extends SimplePacket.Builder {
        public Builder() {
        }

        private Builder(EncryptedPacket packet) {
            super(packet);
        }

        public Builder rawData(byte[] rawData) {
            this.setRawData(rawData);
            return this;
        }

        @Override
        public EncryptedPacket build() {
            return new EncryptedPacket(this);
        }
    }
}

