/* SPDX-FileCopyrightText: 2009 - Jesse van den Kieboom <jessevdk@gnome.org>
 * SPDX-FileCopyrightText: 2016, 2025 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_COMPLETION_ITEM             (gtk_source_completion_item_get_type ())
#define GTK_SOURCE_COMPLETION_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_COMPLETION_ITEM, GtkSourceCompletionItem))
#define GTK_SOURCE_COMPLETION_ITEM_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_COMPLETION_ITEM, GtkSourceCompletionItemClass))
#define GTK_SOURCE_IS_COMPLETION_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_COMPLETION_ITEM))
#define GTK_SOURCE_IS_COMPLETION_ITEM_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_COMPLETION_ITEM))
#define GTK_SOURCE_COMPLETION_ITEM_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_COMPLETION_ITEM, GtkSourceCompletionItemClass))

typedef struct _GtkSourceCompletionItem		GtkSourceCompletionItem;
typedef struct _GtkSourceCompletionItemClass	GtkSourceCompletionItemClass;
typedef struct _GtkSourceCompletionItemPrivate	GtkSourceCompletionItemPrivate;

struct _GtkSourceCompletionItem
{
	GObject parent;
	GtkSourceCompletionItemPrivate *priv;
};

struct _GtkSourceCompletionItemClass
{
	GObjectClass parent_class;
	gpointer padding[1];
};

G_MODULE_EXPORT
GType 			 gtk_source_completion_item_get_type 		(void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceCompletionItem *gtk_source_completion_item_new			(void);

G_MODULE_EXPORT
void			 gtk_source_completion_item_set_label		(GtkSourceCompletionItem *item,
									 const gchar             *label);

G_MODULE_EXPORT
void			 gtk_source_completion_item_set_markup		(GtkSourceCompletionItem *item,
									 const gchar             *markup);

G_MODULE_EXPORT
void			 gtk_source_completion_item_set_text		(GtkSourceCompletionItem *item,
									 const gchar             *text);

G_MODULE_EXPORT
void			 gtk_source_completion_item_set_icon		(GtkSourceCompletionItem *item,
									 GdkPixbuf               *icon);

G_MODULE_EXPORT
void			 gtk_source_completion_item_set_icon_name	(GtkSourceCompletionItem *item,
									 const gchar             *icon_name);

G_MODULE_EXPORT
void			 gtk_source_completion_item_set_gicon		(GtkSourceCompletionItem *item,
									 GIcon                   *gicon);

G_MODULE_EXPORT
void			 gtk_source_completion_item_set_info		(GtkSourceCompletionItem *item,
									 const gchar             *info);

G_END_DECLS
