/* SPDX-FileCopyrightText: 2010 - Jesse van den Kieboom
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtksourceview/gtksourcetypes.h>
#include <gtksourceview/gtksourcegutterrenderer.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_GUTTER_RENDERER_TEXT		(gtk_source_gutter_renderer_text_get_type ())
#define GTK_SOURCE_GUTTER_RENDERER_TEXT(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER_TEXT, GtkSourceGutterRendererText))
#define GTK_SOURCE_GUTTER_RENDERER_TEXT_CONST(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER_TEXT, GtkSourceGutterRendererText const))
#define GTK_SOURCE_GUTTER_RENDERER_TEXT_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GTK_SOURCE_TYPE_GUTTER_RENDERER_TEXT, GtkSourceGutterRendererTextClass))
#define GTK_SOURCE_IS_GUTTER_RENDERER_TEXT(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER_TEXT))
#define GTK_SOURCE_IS_GUTTER_RENDERER_TEXT_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_GUTTER_RENDERER_TEXT))
#define GTK_SOURCE_GUTTER_RENDERER_TEXT_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GTK_SOURCE_TYPE_GUTTER_RENDERER_TEXT, GtkSourceGutterRendererTextClass))

typedef struct _GtkSourceGutterRendererText         GtkSourceGutterRendererText;
typedef struct _GtkSourceGutterRendererTextClass    GtkSourceGutterRendererTextClass;
typedef struct _GtkSourceGutterRendererTextPrivate  GtkSourceGutterRendererTextPrivate;

struct _GtkSourceGutterRendererText
{
	/*< private >*/
	GtkSourceGutterRenderer parent;

	GtkSourceGutterRendererTextPrivate *priv;

	/*< public >*/
};

struct _GtkSourceGutterRendererTextClass
{
	/*< private >*/
	GtkSourceGutterRendererClass parent_class;

	gpointer padding[1];
};

G_MODULE_EXPORT
GType gtk_source_gutter_renderer_text_get_type (void) G_GNUC_CONST;

G_MODULE_EXPORT
GtkSourceGutterRenderer *gtk_source_gutter_renderer_text_new (void);

G_MODULE_EXPORT
void gtk_source_gutter_renderer_text_set_markup (GtkSourceGutterRendererText *renderer,
                                                 const gchar                 *markup,
                                                 gint                         length);

G_MODULE_EXPORT
void gtk_source_gutter_renderer_text_set_text (GtkSourceGutterRendererText *renderer,
                                               const gchar                 *text,
                                               gint                         length);

G_MODULE_EXPORT
void gtk_source_gutter_renderer_text_measure (GtkSourceGutterRendererText *renderer,
                                              const gchar                 *text,
                                              gint                        *width,
                                              gint                        *height);

G_MODULE_EXPORT
void gtk_source_gutter_renderer_text_measure_markup (GtkSourceGutterRendererText *renderer,
                                                     const gchar                 *markup,
                                                     gint                        *width,
                                                     gint                        *height);

G_END_DECLS
