/* SPDX-FileCopyrightText: 2002 Gustavo Giráldez <gustavo.giraldez@gmx.net>
 * SPDX-FileCopyrightText: 2016 Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GTK_SOURCE_TYPE_REGION (gtk_source_region_get_type ())

G_MODULE_EXPORT
G_DECLARE_DERIVABLE_TYPE (GtkSourceRegion, gtk_source_region,
			  GTK_SOURCE, REGION,
			  GObject)

struct _GtkSourceRegionClass
{
	GObjectClass parent_class;

	/* Padding for future expansion */
	gpointer padding[1];
};

/**
 * GtkSourceRegionIter:
 *
 * #GtkSourceRegionIter is an opaque datatype; ignore all its fields.
 * Initialize the iter with gtk_source_region_get_start_region_iter().
 *
 * Since: 3.22
 */
typedef struct _GtkSourceRegionIter GtkSourceRegionIter;
struct _GtkSourceRegionIter
{
	/*< private >*/
	gpointer dummy1;
	guint32  dummy2;
	gpointer dummy3;
};

G_MODULE_EXPORT
GtkSourceRegion *	gtk_source_region_new			(GtkTextBuffer *buffer);

G_MODULE_EXPORT
GtkTextBuffer *		gtk_source_region_get_buffer		(GtkSourceRegion *region);

G_MODULE_EXPORT
void			gtk_source_region_add_subregion		(GtkSourceRegion   *region,
								 const GtkTextIter *_start,
								 const GtkTextIter *_end);

G_MODULE_EXPORT
void			gtk_source_region_add_region		(GtkSourceRegion *region,
								 GtkSourceRegion *region_to_add);

G_MODULE_EXPORT
void			gtk_source_region_subtract_subregion	(GtkSourceRegion   *region,
								 const GtkTextIter *_start,
								 const GtkTextIter *_end);

G_MODULE_EXPORT
void			gtk_source_region_subtract_region	(GtkSourceRegion *region,
								 GtkSourceRegion *region_to_subtract);

G_MODULE_EXPORT
GtkSourceRegion *	gtk_source_region_intersect_subregion	(GtkSourceRegion   *region,
								 const GtkTextIter *_start,
								 const GtkTextIter *_end);

G_MODULE_EXPORT
GtkSourceRegion *	gtk_source_region_intersect_region	(GtkSourceRegion *region1,
								 GtkSourceRegion *region2);

G_MODULE_EXPORT
gboolean		gtk_source_region_is_empty		(GtkSourceRegion *region);

G_MODULE_EXPORT
gboolean		gtk_source_region_get_bounds		(GtkSourceRegion *region,
								 GtkTextIter     *start,
								 GtkTextIter     *end);

G_MODULE_EXPORT
void			gtk_source_region_get_start_region_iter	(GtkSourceRegion     *region,
								 GtkSourceRegionIter *iter);

G_MODULE_EXPORT
gboolean		gtk_source_region_iter_is_end		(GtkSourceRegionIter *iter);

G_MODULE_EXPORT
gboolean		gtk_source_region_iter_next		(GtkSourceRegionIter *iter);

G_MODULE_EXPORT
gboolean		gtk_source_region_iter_get_subregion	(GtkSourceRegionIter *iter,
								 GtkTextIter         *start,
								 GtkTextIter         *end);

G_MODULE_EXPORT
gchar *			gtk_source_region_to_string		(GtkSourceRegion *region);

G_END_DECLS
