/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVertexInputAttributeDescription
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int BINDING;
    public static final int FORMAT;
    public static final int OFFSET;

    public VkVertexInputAttributeDescription(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVertexInputAttributeDescription.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int location() {
        return VkVertexInputAttributeDescription.nlocation(this.address());
    }

    @NativeType(value="uint32_t")
    public int binding() {
        return VkVertexInputAttributeDescription.nbinding(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkVertexInputAttributeDescription.nformat(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkVertexInputAttributeDescription.noffset(this.address());
    }

    public VkVertexInputAttributeDescription location(@NativeType(value="uint32_t") int value) {
        VkVertexInputAttributeDescription.nlocation(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription binding(@NativeType(value="uint32_t") int value) {
        VkVertexInputAttributeDescription.nbinding(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription format(@NativeType(value="VkFormat") int value) {
        VkVertexInputAttributeDescription.nformat(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription offset(@NativeType(value="uint32_t") int value) {
        VkVertexInputAttributeDescription.noffset(this.address(), value);
        return this;
    }

    public VkVertexInputAttributeDescription set(int location, int binding, int format, int offset) {
        this.location(location);
        this.binding(binding);
        this.format(format);
        this.offset(offset);
        return this;
    }

    public VkVertexInputAttributeDescription set(VkVertexInputAttributeDescription src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVertexInputAttributeDescription malloc() {
        return (VkVertexInputAttributeDescription)VkVertexInputAttributeDescription.wrap(VkVertexInputAttributeDescription.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkVertexInputAttributeDescription calloc() {
        return (VkVertexInputAttributeDescription)VkVertexInputAttributeDescription.wrap(VkVertexInputAttributeDescription.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkVertexInputAttributeDescription create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkVertexInputAttributeDescription)VkVertexInputAttributeDescription.wrap(VkVertexInputAttributeDescription.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkVertexInputAttributeDescription create(long address) {
        return (VkVertexInputAttributeDescription)VkVertexInputAttributeDescription.wrap(VkVertexInputAttributeDescription.class, (long)address);
    }

    @Nullable
    public static VkVertexInputAttributeDescription createSafe(long address) {
        return address == 0L ? null : (VkVertexInputAttributeDescription)VkVertexInputAttributeDescription.wrap(VkVertexInputAttributeDescription.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkVertexInputAttributeDescription.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkVertexInputAttributeDescription.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkVertexInputAttributeDescription.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVertexInputAttributeDescription.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkVertexInputAttributeDescription.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkVertexInputAttributeDescription.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkVertexInputAttributeDescription.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkVertexInputAttributeDescription mallocStack() {
        return VkVertexInputAttributeDescription.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkVertexInputAttributeDescription callocStack() {
        return VkVertexInputAttributeDescription.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkVertexInputAttributeDescription mallocStack(MemoryStack stack) {
        return VkVertexInputAttributeDescription.malloc(stack);
    }

    @Deprecated
    public static VkVertexInputAttributeDescription callocStack(MemoryStack stack) {
        return VkVertexInputAttributeDescription.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkVertexInputAttributeDescription.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkVertexInputAttributeDescription.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkVertexInputAttributeDescription.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkVertexInputAttributeDescription.calloc(capacity, stack);
    }

    public static VkVertexInputAttributeDescription malloc(MemoryStack stack) {
        return (VkVertexInputAttributeDescription)VkVertexInputAttributeDescription.wrap(VkVertexInputAttributeDescription.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVertexInputAttributeDescription calloc(MemoryStack stack) {
        return (VkVertexInputAttributeDescription)VkVertexInputAttributeDescription.wrap(VkVertexInputAttributeDescription.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVertexInputAttributeDescription.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVertexInputAttributeDescription.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    public static int nbinding(long struct) {
        return UNSAFE.getInt(null, struct + (long)BINDING);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int noffset(long struct) {
        return UNSAFE.getInt(null, struct + (long)OFFSET);
    }

    public static void nlocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATION, value);
    }

    public static void nbinding(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BINDING, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void noffset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OFFSET, value);
    }

    static {
        Struct.Layout layout = VkVertexInputAttributeDescription.__struct((Struct.Member[])new Struct.Member[]{VkVertexInputAttributeDescription.__member((int)4), VkVertexInputAttributeDescription.__member((int)4), VkVertexInputAttributeDescription.__member((int)4), VkVertexInputAttributeDescription.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        BINDING = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
        OFFSET = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkVertexInputAttributeDescription, Buffer>
    implements NativeResource {
        private static final VkVertexInputAttributeDescription ELEMENT_FACTORY = VkVertexInputAttributeDescription.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkVertexInputAttributeDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int location() {
            return VkVertexInputAttributeDescription.nlocation(this.address());
        }

        @NativeType(value="uint32_t")
        public int binding() {
            return VkVertexInputAttributeDescription.nbinding(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkVertexInputAttributeDescription.nformat(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkVertexInputAttributeDescription.noffset(this.address());
        }

        public Buffer location(@NativeType(value="uint32_t") int value) {
            VkVertexInputAttributeDescription.nlocation(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="uint32_t") int value) {
            VkVertexInputAttributeDescription.nbinding(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkVertexInputAttributeDescription.nformat(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkVertexInputAttributeDescription.noffset(this.address(), value);
            return this;
        }
    }
}

