/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.openhab.core.automation.module.script.ScriptExtensionAccessor;
import org.openhab.core.automation.module.script.ScriptExtensionProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ScriptExtensionManager.class, ScriptExtensionAccessor.class})
@NonNullByDefault
public class ScriptExtensionManager
implements ScriptExtensionAccessor {
    private final Set<ScriptExtensionProvider> scriptExtensionProviders = new CopyOnWriteArraySet<ScriptExtensionProvider>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addScriptExtensionProvider(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.add(provider);
    }

    public void removeScriptExtensionProvider(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.remove(provider);
    }

    public void addExtension(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.add(provider);
    }

    public void removeExtension(ScriptExtensionProvider provider) {
        this.scriptExtensionProviders.remove(provider);
    }

    public List<String> getTypes() {
        ArrayList<String> types = new ArrayList<String>();
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            types.addAll(provider.getTypes());
        }
        return types;
    }

    public List<String> getPresets() {
        ArrayList<String> presets = new ArrayList<String>();
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            presets.addAll(provider.getPresets());
        }
        return presets;
    }

    public @Nullable Object get(String type, String scriptIdentifier) {
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            if (!provider.getTypes().contains(type)) continue;
            return provider.get(scriptIdentifier, type);
        }
        return null;
    }

    public List<String> getDefaultPresets() {
        ArrayList<String> defaultPresets = new ArrayList<String>();
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            defaultPresets.addAll(provider.getDefaultPresets());
        }
        return defaultPresets;
    }

    public void importDefaultPresets(ScriptEngineFactory engineProvider, ScriptEngine scriptEngine, String scriptIdentifier) {
        engineProvider.scopeValues(scriptEngine, this.findDefaultPresets(scriptIdentifier));
    }

    public Map<String, Object> importPreset(String preset, ScriptEngineFactory engineProvider, ScriptEngine scriptEngine, String scriptIdentifier) {
        Map<String, Object> rv = this.findPreset(preset, scriptIdentifier);
        engineProvider.scopeValues(scriptEngine, rv);
        return rv;
    }

    @Override
    public Map<String, Object> findDefaultPresets(String scriptIdentifier) {
        HashMap<String, Object> allValues = new HashMap<String, Object>();
        for (String preset : this.getDefaultPresets()) {
            allValues.putAll(this.findPreset(preset, scriptIdentifier));
        }
        return allValues;
    }

    @Override
    public Map<String, Object> findPreset(String preset, String scriptIdentifier) {
        HashMap<String, Object> allValues = new HashMap<String, Object>();
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            if (!provider.getPresets().contains(preset)) continue;
            Map<String, Object> scopeValues = provider.importPreset(scriptIdentifier, preset);
            allValues.putAll(scopeValues);
        }
        return allValues;
    }

    public void dispose(String scriptIdentifier) {
        for (ScriptExtensionProvider provider : this.scriptExtensionProviders) {
            provider.unload(scriptIdentifier);
        }
    }
}

