/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.IllegalFormatConversionException;
import java.util.Locale;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.library.types.DateTimeType;
import org.openhab.core.library.types.HSBType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.library.types.PercentType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.library.types.UpDownType;
import org.openhab.core.types.Command;
import org.openhab.core.types.PrimitiveType;
import org.openhab.core.types.State;

@NonNullByDefault
public class DecimalType
extends Number
implements PrimitiveType,
State,
Command,
Comparable<DecimalType> {
    private static final long serialVersionUID = 4226845847123464690L;
    protected static final BigDecimal BIG_DECIMAL_HUNDRED = BigDecimal.valueOf(100L);
    public static final DecimalType ZERO = new DecimalType(0);
    protected BigDecimal value;

    public DecimalType() {
        this(BigDecimal.ZERO);
    }

    /*
     * WARNING - void declaration
     */
    public DecimalType(Number value) {
        Number number = value;
        if (number instanceof QuantityType) {
            void type;
            QuantityType quantityType = (QuantityType)number;
            QuantityType cfr_ignored_0 = (QuantityType)number;
            this.value = type.toBigDecimal();
        } else {
            Number number2 = value;
            if (number2 instanceof DecimalType) {
                void type;
                DecimalType decimalType = (DecimalType)number2;
                DecimalType cfr_ignored_1 = (DecimalType)number2;
                this.value = type.toBigDecimal();
            } else {
                Number number3 = value;
                if (number3 instanceof BigDecimal) {
                    void decimal;
                    BigDecimal bigDecimal = (BigDecimal)number3;
                    BigDecimal cfr_ignored_2 = (BigDecimal)number3;
                    this.value = decimal;
                } else {
                    Number number4 = value;
                    if (number4 instanceof BigInteger) {
                        void integer;
                        BigInteger bigInteger = (BigInteger)number4;
                        BigInteger cfr_ignored_3 = (BigInteger)number4;
                        this.value = new BigDecimal((BigInteger)integer);
                    } else {
                        this.value = new BigDecimal(value.toString());
                    }
                }
            }
        }
    }

    public DecimalType(String value) {
        this(value, Locale.ENGLISH);
    }

    public DecimalType(String value, Locale locale) {
        DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(locale);
        df.setParseBigDecimal(true);
        ParsePosition position = new ParsePosition(0);
        BigDecimal parsedValue = (BigDecimal)df.parseObject(value.toUpperCase(locale), position);
        if (parsedValue == null || position.getErrorIndex() != -1 || position.getIndex() < value.length()) {
            throw new NumberFormatException("Invalid BigDecimal value: " + value);
        }
        this.value = parsedValue;
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.value.toPlainString();
    }

    public static DecimalType valueOf(String value) {
        return new DecimalType(value);
    }

    @Override
    public String format(String pattern) {
        try {
            return String.format(pattern, this.value.toBigIntegerExact());
        }
        catch (ArithmeticException arithmeticException) {
        }
        catch (IllegalFormatConversionException illegalFormatConversionException) {
            // empty catch block
        }
        return String.format(pattern, this.value);
    }

    public BigDecimal toBigDecimal() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DecimalType)) {
            return false;
        }
        DecimalType other = (DecimalType)obj;
        return this.value.compareTo(other.value) == 0;
    }

    @Override
    public int compareTo(DecimalType o) {
        return this.value.compareTo(o.toBigDecimal());
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    protected <T extends State> @Nullable T defaultConversion(@Nullable Class<T> target) {
        return State.super.as(target);
    }

    @Override
    public <T extends State> @Nullable T as(@Nullable Class<T> target) {
        if (target == OnOffType.class) {
            return (T)((State)target.cast(OnOffType.from(!this.equals(ZERO))));
        }
        if (target == PercentType.class) {
            return (T)((State)target.cast(new PercentType(this.toBigDecimal().multiply(BIG_DECIMAL_HUNDRED))));
        }
        if (target == UpDownType.class) {
            if (this.equals(ZERO)) {
                return (T)((State)target.cast(UpDownType.UP));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (T)((State)target.cast(UpDownType.DOWN));
            }
            return null;
        }
        if (target == OpenClosedType.class) {
            if (this.equals(ZERO)) {
                return (T)((State)target.cast(OpenClosedType.CLOSED));
            }
            if (this.toBigDecimal().compareTo(BigDecimal.ONE) == 0) {
                return (T)((State)target.cast(OpenClosedType.OPEN));
            }
            return null;
        }
        if (target == HSBType.class) {
            return (T)((State)target.cast(new HSBType(ZERO, PercentType.ZERO, new PercentType(this.toBigDecimal().multiply(BIG_DECIMAL_HUNDRED)))));
        }
        if (target == DateTimeType.class) {
            return (T)((State)target.cast(new DateTimeType(this.value.toString())));
        }
        return this.defaultConversion(target);
    }
}

