/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.generator;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.trace.AbstractTraceRegion;
import org.eclipse.xtext.generator.trace.ITraceRegionProvider;
import org.eclipse.xtext.generator.trace.TraceFileNameProvider;
import org.eclipse.xtext.generator.trace.TraceNotFoundException;
import org.eclipse.xtext.generator.trace.TraceRegionSerializer;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.util.RuntimeIOException;

public class JavaIoFileSystemAccess
extends AbstractFileSystemAccess2 {
    private IFileCallback callBack;
    @Inject
    private IEncodingProvider encodingProvider;
    @Inject
    private IResourceServiceProvider.Registry registry;
    @Inject
    private TraceFileNameProvider traceFileNameProvider;
    @Inject
    private TraceRegionSerializer traceSerializer;
    private boolean writeTrace = true;

    public JavaIoFileSystemAccess() {
    }

    public JavaIoFileSystemAccess(IResourceServiceProvider.Registry registry, IEncodingProvider encodingProvider) {
        this.registry = registry;
        this.encodingProvider = encodingProvider;
    }

    public JavaIoFileSystemAccess(IResourceServiceProvider.Registry registry, IEncodingProvider encodingProvider, TraceFileNameProvider traceFileNameProvider, TraceRegionSerializer traceRegionSerializer) {
        this.registry = registry;
        this.encodingProvider = encodingProvider;
        this.traceFileNameProvider = traceFileNameProvider;
        this.traceSerializer = traceRegionSerializer;
    }

    public void setCallBack(IFileCallback callBack) {
        this.callBack = callBack;
    }

    public Runnable withCallBack(final IFileCallback callBack) {
        final IFileCallback prev = this.callBack;
        this.callBack = prev == null ? callBack : (callBack == null ? null : new IFileCallback(){

            @Override
            public void fileDeleted(File file) {
                prev.fileDeleted(file);
                callBack.fileDeleted(file);
            }

            @Override
            public void fileAdded(File file) {
                prev.fileAdded(file);
                callBack.fileAdded(file);
            }
        });
        return () -> {
            IFileCallback iFileCallback2 = this.callBack = prev;
        };
    }

    @Override
    public void generateFile(String fileName, String outputConfigName, CharSequence contents) throws RuntimeIOException {
        File file = this.getFile(fileName, outputConfigName);
        if (!this.getOutputConfig(outputConfigName).isOverrideExistingResources() && file.exists()) {
            return;
        }
        try {
            this.createFolder(file.getParentFile());
            String encoding = this.getEncoding(this.getURI(fileName, outputConfigName));
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);){
                writer.append(this.postProcess(fileName, outputConfigName, contents, encoding));
                if (this.callBack != null) {
                    this.callBack.fileAdded(file);
                }
                if (this.writeTrace) {
                    this.generateTrace(fileName, outputConfigName, contents);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    protected void generateTrace(String generatedFile, String outputConfigName, CharSequence contents) {
        block11: {
            try {
                if (!(contents instanceof ITraceRegionProvider)) break block11;
                try (OutputStream out = null;){
                    try {
                        AbstractTraceRegion traceRegion = ((ITraceRegionProvider)((Object)contents)).getTraceRegion();
                        String traceFileName = this.traceFileNameProvider.getTraceFromJava(generatedFile);
                        File traceFile = this.getFile(traceFileName, outputConfigName);
                        out = new BufferedOutputStream(new FileOutputStream(traceFile));
                        this.traceSerializer.writeTraceRegionTo(traceRegion, out);
                        if (this.callBack != null) {
                            this.callBack.fileAdded(traceFile);
                        }
                    }
                    catch (TraceNotFoundException traceNotFoundException) {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeIOException((Throwable)e);
            }
            catch (IOException e) {
                throw new RuntimeIOException((Throwable)e);
            }
        }
    }

    public boolean isWriteTrace() {
        return this.writeTrace;
    }

    public void setWriteTrace(boolean writeTrace) {
        this.writeTrace = writeTrace;
    }

    protected String getEncoding(URI fileURI) {
        IResourceServiceProvider resourceServiceProvider = this.registry.getResourceServiceProvider(fileURI);
        if (resourceServiceProvider != null) {
            return resourceServiceProvider.getEncodingProvider().getEncoding(fileURI);
        }
        return this.encodingProvider.getEncoding(fileURI);
    }

    protected File getFile(String fileName, String outputConfigName) {
        String outlet = this.getPathes().get(outputConfigName);
        if (outlet == null) {
            throw new IllegalArgumentException("A slot with name '" + outputConfigName + "' has not been configured.");
        }
        String pathName = this.toSystemFileName(outlet + "/" + fileName);
        File file = new File(pathName).getAbsoluteFile();
        return file;
    }

    protected void createFolder(File parent) {
        if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
            throw new RuntimeIOException("Could not create directory " + String.valueOf(parent));
        }
    }

    @Override
    public void deleteFile(String fileName, String outputConfiguration) {
        File file = this.getFile(fileName, outputConfiguration);
        if (file.exists()) {
            file.delete();
        }
    }

    protected String toSystemFileName(String fileName) {
        return fileName.replace("/", File.separator);
    }

    @Override
    public URI getURI(String fileName, String outputConfiguration) {
        return URI.createURI((String)this.getFile(fileName, outputConfiguration).toURI().toString());
    }

    @Override
    public void generateFile(String fileName, String outputCfgName, InputStream content) throws RuntimeIOException {
        File file = this.getFile(fileName, outputCfgName);
        if (!this.getOutputConfig(outputCfgName).isOverrideExistingResources() && file.exists()) {
            return;
        }
        try {
            this.createFolder(file.getParentFile());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            try {
                ByteStreams.copy((InputStream)content, (OutputStream)out);
            }
            finally {
                try {
                    ((OutputStream)out).close();
                    if (this.callBack != null) {
                        this.callBack.fileAdded(file);
                    }
                }
                finally {
                    content.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    @Override
    public InputStream readBinaryFile(String fileName, String outputCfgName) throws RuntimeIOException {
        File file = this.getFile(fileName, outputCfgName);
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    @Override
    public CharSequence readTextFile(String fileName, String outputCfgName) throws RuntimeIOException {
        try {
            File file = this.getFile(fileName, outputCfgName);
            String encoding = this.getEncoding(this.getURI(fileName, outputCfgName));
            return new String(Files.toByteArray((File)file), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeIOException((Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeIOException((Throwable)e);
        }
    }

    @Override
    public boolean isFile(String path, String outputConfigurationName) throws RuntimeIOException {
        File file = this.getFile(path, outputConfigurationName);
        return file != null && file.exists() && file.isFile();
    }

    public static interface IFileCallback {
        public void fileAdded(File var1);

        public void fileDeleted(File var1);
    }
}

