/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceEditCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;

public class TextEditAcceptor {
    private final boolean useDocumentChanges;
    private final WorkspaceEdit edit;

    public TextEditAcceptor(WorkspaceEdit edit, ILanguageServerAccess access) {
        WorkspaceEditCapabilities workspaceEditCapabilities;
        WorkspaceClientCapabilities workspaceClientCapabilities;
        ClientCapabilities clientCapabilities;
        InitializeParams initializeParams;
        this.edit = edit;
        Boolean documentChanges = null;
        if (access != null && (initializeParams = access.getInitializeParams()) != null && (clientCapabilities = initializeParams.getCapabilities()) != null && (workspaceClientCapabilities = clientCapabilities.getWorkspace()) != null && (workspaceEditCapabilities = workspaceClientCapabilities.getWorkspaceEdit()) != null) {
            documentChanges = workspaceEditCapabilities.getDocumentChanges();
        }
        boolean bl = this.useDocumentChanges = documentChanges == Boolean.TRUE;
        if (this.useDocumentChanges) {
            this.edit.setDocumentChanges(new ArrayList());
        } else {
            this.edit.setChanges(new LinkedHashMap());
        }
    }

    public void accept(String theUri, Document document, List<TextEdit> textEdits) {
        if (this.useDocumentChanges) {
            TextDocumentEdit textDocumentEdit = new TextDocumentEdit();
            VersionedTextDocumentIdentifier versionedTextDocumentIdentifier = new VersionedTextDocumentIdentifier();
            versionedTextDocumentIdentifier.setUri(theUri);
            versionedTextDocumentIdentifier.setVersion(document.getVersion());
            textDocumentEdit.setTextDocument(versionedTextDocumentIdentifier);
            textDocumentEdit.setEdits(textEdits);
            this.edit.getDocumentChanges().add(Either.forLeft((Object)textDocumentEdit));
        } else {
            this.edit.getChanges().put(theUri, textEdits);
        }
    }
}

