/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.resolver;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.felix.utils.collections.StringArrayMap;
import org.apache.felix.utils.resource.CapabilityImpl;
import org.apache.felix.utils.resource.RequirementImpl;
import org.apache.felix.utils.resource.ResourceImpl;
import org.apache.felix.utils.resource.SimpleFilter;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public final class ResourceUtils {
    public static final String TYPE_SUBSYSTEM = "karaf.subsystem";
    public static final String TYPE_FEATURE = "karaf.feature";

    private ResourceUtils() {
    }

    public static String getType(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            return cap.getAttributes().get("type").toString();
        }
        return null;
    }

    public static String getUri(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            if (!cap.getNamespace().equals("osgi.content")) continue;
            return cap.getAttributes().get("url").toString();
        }
        return null;
    }

    public static String getFeatureId(Resource resource) {
        List caps = resource.getCapabilities(null);
        for (Capability cap : caps) {
            Map attributes;
            if (!cap.getNamespace().equals("osgi.identity") || !TYPE_FEATURE.equals((attributes = cap.getAttributes()).get("type"))) continue;
            String name = (String)attributes.get("osgi.identity");
            Version version = (Version)attributes.get("version");
            return version != null ? name + "/" + version : name;
        }
        return null;
    }

    public static RequirementImpl addIdentityRequirement(ResourceImpl resource, String name, String type, String range) {
        return ResourceUtils.addIdentityRequirement(resource, name, type, range, true);
    }

    public static RequirementImpl addIdentityRequirement(ResourceImpl resource, String name, String type, String range, boolean mandatory) {
        return ResourceUtils.addIdentityRequirement(resource, name, type, range != null ? new VersionRange(range) : null, mandatory);
    }

    public static RequirementImpl addIdentityRequirement(ResourceImpl resource, String name, String type, VersionRange range) {
        return ResourceUtils.addIdentityRequirement(resource, name, type, range, true);
    }

    public static RequirementImpl addIdentityRequirement(ResourceImpl resource, String name, String type, VersionRange range, boolean mandatory) {
        return ResourceUtils.addIdentityRequirement(resource, name, type, range, mandatory, false);
    }

    public static RequirementImpl addIdentityRequirement(ResourceImpl resource, String name, String type, VersionRange range, boolean mandatory, boolean conditional) {
        StringArrayMap<String> dirs = new StringArrayMap<String>((mandatory ? 0 : 1) + (conditional ? 1 : 0));
        StringArrayMap<Object> attrs = new StringArrayMap<Object>((name != null ? 1 : 0) + (type != null ? 1 : 0) + (range != null ? 1 : 0));
        if (!mandatory) {
            dirs.put("resolution", "optional");
        }
        if (conditional) {
            dirs.put("condition", "true");
        }
        if (name != null) {
            attrs.put("osgi.identity", (Object)name);
        }
        if (type != null) {
            attrs.put("type", (Object)type);
        }
        if (range != null) {
            attrs.put("version", (Object)range);
        }
        RequirementImpl requirement = new RequirementImpl(resource, "osgi.identity", dirs, attrs);
        resource.addRequirement(requirement);
        return requirement;
    }

    public static void addIdentityRequirement(ResourceImpl resource, Resource required) {
        ResourceUtils.addIdentityRequirement(resource, required, true);
    }

    public static void addIdentityRequirement(ResourceImpl resource, Resource required, boolean mandatory) {
        for (Capability cap : required.getCapabilities(null)) {
            if (!cap.getNamespace().equals("osgi.identity")) continue;
            Map attributes = cap.getAttributes();
            StringArrayMap<String> dirs = new StringArrayMap<String>(1);
            dirs.put("resolution", mandatory ? "mandatory" : "optional");
            Version version = (Version)attributes.get("version");
            StringArrayMap<Object> attrs = new StringArrayMap<Object>(version != null ? 3 : 2);
            attrs.put("osgi.identity", attributes.get("osgi.identity"));
            attrs.put("type", attributes.get("type"));
            if (version != null) {
                attrs.put("version", (Object)new VersionRange(version, true));
            }
            resource.addRequirement(new RequirementImpl(resource, "osgi.identity", dirs, attrs));
        }
    }

    public static String toFeatureRequirement(String feature) {
        String[] parts = feature.split("/");
        StringArrayMap<Object> attrs = new StringArrayMap<Object>(parts.length > 1 ? 3 : 2);
        attrs.put("osgi.identity", (Object)parts[0]);
        attrs.put("type", (Object)TYPE_FEATURE);
        if (parts.length > 1) {
            attrs.put("version", (Object)new VersionRange(parts[1]));
        }
        Map<String, String> dirs = Collections.singletonMap("filter", SimpleFilter.convert(attrs).toString());
        return new RequirementImpl(null, "osgi.identity", dirs, attrs).toString();
    }

    public static String toFeatureCapability(String feature) {
        String[] parts = feature.split("/");
        Map<String, String> dirs = Collections.emptyMap();
        StringArrayMap<Object> attrs = new StringArrayMap<Object>(parts.length > 1 ? 3 : 2);
        attrs.put("osgi.identity", (Object)parts[0]);
        attrs.put("type", (Object)TYPE_FEATURE);
        if (parts.length > 1) {
            attrs.put("version", (Object)VersionTable.getVersion(parts[1]));
        }
        return new CapabilityImpl(null, "osgi.identity", dirs, attrs).toString();
    }
}

