/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.library.unit;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.library.dimension.Currency;
import org.openhab.core.library.unit.CurrencyProvider;
import org.openhab.core.library.unit.CurrencyUnit;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(service={CurrencyProvider.class}, configurationPid={"org.openhab.units"})
@NonNullByDefault
public class FixedCurrencyProvider
implements CurrencyProvider {
    public static final String CONFIG_OPTION_BASE_CURRENCY = "fixedBaseCurrency";
    private String currencyCode = "DEF";

    @Activate
    public FixedCurrencyProvider(Map<String, Object> config) {
        this.modified(config);
    }

    @Modified
    public void modified(Map<String, Object> config) {
        String code = (String)config.get(CONFIG_OPTION_BASE_CURRENCY);
        this.currencyCode = Objects.requireNonNullElse(code, "DEF");
    }

    @Override
    public Unit<Currency> getBaseCurrency() {
        String symbol = null;
        try {
            symbol = java.util.Currency.getInstance(this.currencyCode).getSymbol();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return new CurrencyUnit(this.currencyCode, symbol);
    }

    @Override
    public Collection<Unit<Currency>> getAdditionalCurrencies() {
        return Set.of();
    }

    @Override
    public Function<Unit<Currency>, @Nullable BigDecimal> getExchangeRateFunction() {
        return unit -> null;
    }
}

