/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class CellocatorProtocolDecoder
extends BaseProtocolDecoder {
    static final int MSG_CLIENT_STATUS = 0;
    static final int MSG_CLIENT_PROGRAMMING = 3;
    static final int MSG_CLIENT_SERIAL_LOG = 7;
    static final int MSG_CLIENT_SERIAL = 8;
    static final int MSG_CLIENT_MODULAR = 9;
    static final int MSG_CLIENT_MODULAR_EXT = 11;
    public static final int MSG_SERVER_ACKNOWLEDGE = 4;

    public CellocatorProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public static ByteBuf encodeContent(int type, int uniqueId, int packetNumber, ByteBuf content) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte(77);
        buf.writeByte(67);
        buf.writeByte(71);
        buf.writeByte(80);
        buf.writeByte(type);
        buf.writeIntLE(uniqueId);
        buf.writeByte(packetNumber);
        buf.writeIntLE(0);
        buf.writeBytes(content);
        int checksum = 0;
        for (int i = 4; i < buf.writerIndex(); ++i) {
            checksum = (byte)(checksum + buf.getByte(i));
        }
        buf.writeByte(checksum);
        return buf;
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, long deviceId, byte packetNumber) {
        if (channel != null) {
            ByteBuf content = Unpooled.buffer();
            content.writeByte(0);
            content.writeByte((int)packetNumber);
            content.writeZero(11);
            ByteBuf reply = CellocatorProtocolDecoder.encodeContent(4, (int)deviceId, 0, content);
            channel.writeAndFlush((Object)new NetworkMessage(reply, remoteAddress));
        }
    }

    private void sendModuleResponse(Channel channel, SocketAddress remoteAddress, long deviceId, byte packetNumber) {
        if (channel != null) {
            ByteBuf content = Unpooled.buffer();
            content.writeByte(128);
            content.writeShortLE(10);
            content.writeIntLE(0);
            content.writeByte(9);
            content.writeShortLE(3);
            content.writeByte(0);
            content.writeShortLE(0);
            ByteBuf reply = CellocatorProtocolDecoder.encodeContent(11, (int)deviceId, packetNumber, content);
            channel.writeAndFlush((Object)new NetworkMessage(reply, remoteAddress));
        }
    }

    private String decodeAlarm(short reason) {
        return switch (reason) {
            case 70 -> "sos";
            case 80 -> "powerCut";
            case 81 -> "lowPower";
            default -> null;
        };
    }

    private Position decodeStatus(ByteBuf buf, DeviceSession deviceSession, boolean alternative) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("versionHw", buf.readUnsignedByte());
        position.set("versionFw", buf.readUnsignedByte());
        buf.readUnsignedByte();
        position.set("status", buf.readUnsignedByte() & 0xF);
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        short event = buf.readUnsignedByte();
        position.addAlarm(this.decodeAlarm(event));
        position.set("event", event);
        position.set("mode", buf.readUnsignedByte());
        long input = buf.readUnsignedInt();
        position.set("ignition", BitUtil.check(input, 29));
        position.set("door", BitUtil.check(input, 24));
        position.set("charge", BitUtil.check(input, 7));
        position.set("input", input);
        if (alternative) {
            buf.readUnsignedByte();
            position.set("adc1", buf.readUnsignedShortLE());
            position.set("adc2", buf.readUnsignedShortLE());
        } else {
            buf.readUnsignedByte();
            position.set("adc1", buf.readUnsignedByte());
            position.set("adc2", buf.readUnsignedByte());
            position.set("adc3", buf.readUnsignedByte());
            position.set("adc4", buf.readUnsignedByte());
        }
        position.set("odometer", buf.readUnsignedMediumLE());
        position.set("driverUniqueId", ByteBufUtil.hexDump((ByteBuf)buf.readSlice(6)));
        buf.readUnsignedShortLE();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        buf.readUnsignedByte();
        position.set("sat", buf.readUnsignedByte());
        position.setValid(true);
        if (alternative) {
            position.setLongitude((double)buf.readIntLE() / 1.0E7);
            position.setLatitude((double)buf.readIntLE() / 1.0E7);
        } else {
            position.setLongitude((double)buf.readIntLE() / Math.PI * 180.0 / 1.0E8);
            position.setLatitude((double)buf.readIntLE() / Math.PI * 180.0 / 1.0E8);
        }
        position.setAltitude((double)buf.readIntLE() * 0.01);
        if (alternative) {
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedIntLE()));
            position.setCourse((double)buf.readUnsignedShortLE() / 1000.0);
        } else {
            position.setSpeed(UnitsConverter.knotsFromMps((double)buf.readUnsignedIntLE() * 0.01));
            position.setCourse((double)buf.readUnsignedShortLE() / Math.PI * 180.0 / 1000.0);
        }
        DateBuilder dateBuilder = new DateBuilder().setTimeReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedShortLE());
        position.setTime(dateBuilder.getDate());
        return position;
    }

    private Position decodeModular(ByteBuf buf, DeviceSession deviceSession) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        buf.readUnsignedByte();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        buf.readUnsignedShortLE();
        while (buf.readableBytes() > 3) {
            short moduleType = buf.readUnsignedByte();
            int endIndex = buf.readUnsignedShortLE() + buf.readerIndex();
            switch (moduleType) {
                case 2: {
                    buf.readUnsignedShortLE();
                    buf.readUnsignedIntLE();
                    int count = buf.readUnsignedByte();
                    for (int i = 0; i < count; ++i) {
                        int id = buf.readUnsignedShortLE();
                        buf.readUnsignedByte();
                        position.set("io" + id, buf.readUnsignedIntLE());
                    }
                    break;
                }
                case 6: {
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    buf.readUnsignedByte();
                    position.setLongitude((double)buf.readIntLE() / Math.PI * 180.0 / 1.0E8);
                    position.setLatitude((double)buf.readIntLE() / Math.PI * 180.0 / 1.0E8);
                    position.setAltitude((double)buf.readIntLE() * 0.01);
                    position.setSpeed(UnitsConverter.knotsFromMps((double)buf.readUnsignedByte() * 0.01));
                    position.setCourse((double)buf.readUnsignedShortLE() / Math.PI * 180.0 / 1000.0);
                    break;
                }
                case 7: {
                    buf.readUnsignedByte();
                    DateBuilder dateBuilder = new DateBuilder().setTimeReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte());
                    position.setTime(dateBuilder.getDate());
                    break;
                }
            }
            buf.readerIndex(endIndex);
        }
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        boolean alternative = buf.getByte(buf.readerIndex() + 3) != 80;
        buf.skipBytes(4);
        short type = buf.readUnsignedByte();
        long deviceUniqueId = buf.readUnsignedIntLE();
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(deviceUniqueId));
        if (deviceSession == null) {
            return null;
        }
        if (type != 8) {
            buf.readUnsignedShortLE();
        }
        byte packetNumber = buf.readByte();
        if (type == 11) {
            this.sendModuleResponse(channel, remoteAddress, deviceUniqueId, packetNumber);
        } else {
            this.sendResponse(channel, remoteAddress, deviceUniqueId, packetNumber);
        }
        if (type == 0) {
            return this.decodeStatus(buf, deviceSession, alternative);
        }
        if (type == 11) {
            return this.decodeModular(buf, deviceSession);
        }
        return null;
    }
}

