/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.mimelookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.netbeans.modules.editor.mimelookup.APIAccessor;
import org.netbeans.modules.editor.mimelookup.MimeLookupCacheSPI;
import org.netbeans.modules.editor.mimelookup.MimePathLookup;
import org.openide.util.Lookup;

public final class MimePath {
    public static final MimePath EMPTY = new MimePath();
    private static final Object LOCK = new Object();
    private static final ArrayList<MimePath> LRU = new ArrayList();
    static final int MAX_LRU_SIZE = 3;
    private static final Pattern REG_NAME_PATTERN = Pattern.compile("^[[\\p{Alnum}][!#$&.+\\-^_]]{1,127}$");
    private static final Set<String> WELL_KNOWN_TYPES = new HashSet<String>(Arrays.asList("application", "audio", "content", "image", "message", "model", "multipart", "text", "video"));
    private static final Map<String, Reference<MimePath>> string2mimePath = new ConcurrentHashMap<String, Reference<MimePath>>();
    private final MimePath[] mimePaths;
    private final String path;
    private final String mimeType;
    private Map<String, SoftReference<MimePath>> mimeType2mimePathRef;
    private Lookup lookup;
    private final String LOOKUP_LOCK = new String("MimePath.LOOKUP_LOCK");

    public static MimePath get(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        return MimePath.get(EMPTY, string);
    }

    public static MimePath get(MimePath mimePath, String string) {
        if (!MimePath.validate(string)) {
            throw new IllegalArgumentException("Invalid mimeType=\"" + string + "\"");
        }
        return mimePath.getEmbedded(string);
    }

    public static MimePath parse(String string) {
        MimePath mimePath;
        assert (string != null) : "path cannot be null";
        Reference<MimePath> reference = string2mimePath.get(string);
        MimePath mimePath2 = mimePath = reference != null ? reference.get() : null;
        if (mimePath != null) {
            return mimePath;
        }
        Object object = MimePath.parseImpl(string, false);
        if (!(object instanceof MimePath)) {
            throw new IllegalArgumentException((String)object);
        }
        mimePath = (MimePath)object;
        string2mimePath.put(string.intern(), new WeakReference<MimePath>(mimePath));
        return mimePath;
    }

    public static boolean validate(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence != null) {
            if (MimePath.startsWith(charSequence, "test")) {
                for (int i = 4; i < charSequence.length(); ++i) {
                    if (charSequence.charAt(i) != '_') continue;
                    charSequence = charSequence.subSequence(i + 1, charSequence.length());
                    break;
                }
            }
            if (!WELL_KNOWN_TYPES.contains(charSequence.toString())) {
                return false;
            }
        }
        return charSequence2 == null || REG_NAME_PATTERN.matcher(charSequence2).matches();
    }

    public static boolean validate(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (string2mimePath.containsKey(charSequence.toString())) {
            return true;
        }
        return !(MimePath.parseImpl(charSequence, true) instanceof String);
    }

    private MimePath(MimePath mimePath, String string) {
        int n = mimePath.size();
        this.mimePaths = new MimePath[n + 1];
        System.arraycopy(mimePath.mimePaths, 0, this.mimePaths, 0, n);
        this.mimePaths[n] = this;
        String string2 = mimePath.path;
        this.path = string2 != null && string2.length() > 0 ? (string2 + '/' + string).intern() : string.intern();
        this.mimeType = string;
    }

    private MimePath() {
        this.mimePaths = new MimePath[0];
        this.path = "";
        this.mimeType = "";
    }

    public String getPath() {
        return this.path;
    }

    public int size() {
        return this.mimePaths.length;
    }

    public String getMimeType(int n) {
        return this.mimePaths[n].mimeType;
    }

    public MimePath getPrefix(int n) {
        return n == 0 ? EMPTY : this.mimePaths[n - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimePath getEmbedded(String string) {
        Object object = LOCK;
        synchronized (object) {
            MimePath mimePath;
            Reference reference;
            if (this.mimeType2mimePathRef == null) {
                this.mimeType2mimePathRef = new HashMap<String, SoftReference<MimePath>>();
            }
            if ((reference = (Reference)this.mimeType2mimePathRef.get(string)) == null || (mimePath = (MimePath)reference.get()) == null) {
                mimePath = new MimePath(this, string);
                this.mimeType2mimePathRef.put(string, new SoftReference<MimePath>(mimePath));
                LRU.add(0, mimePath);
                if (LRU.size() > 3) {
                    LRU.remove(LRU.size() - 1);
                }
            }
            return mimePath;
        }
    }

    private static Object parseImpl(CharSequence charSequence, boolean bl) {
        MimePath mimePath = EMPTY;
        int n = charSequence.length();
        int n2 = 0;
        while (true) {
            int n3;
            int n4 = -1;
            for (n3 = n2; n3 < n; ++n3) {
                if (charSequence.charAt(n3) != '/') continue;
                n4 = n3;
                break;
            }
            if (n4 == -1) {
                if (n3 == n2) break;
                return "mimeType '" + charSequence.subSequence(n2, charSequence.length()) + "' does not contain '/'.";
            }
            ++n3;
            while (n3 < n) {
                if (charSequence.charAt(n3) == '/') {
                    if (n3 != n4 + 1) break;
                    return "Two successive slashes in '" + charSequence.subSequence(n2, charSequence.length()) + "'";
                }
                ++n3;
            }
            if (n3 == n4 + 1) {
                return "Empty string after '/' in '" + charSequence.subSequence(n2, charSequence.length()) + "'";
            }
            if (!MimePath.validate(charSequence.subSequence(n2, n4), charSequence.subSequence(n4 + 1, n3))) {
                return "Invalid mimeType=\"" + charSequence.subSequence(n2, n3) + "\"";
            }
            if (!bl) {
                String string = charSequence.subSequence(n2, n3).toString();
                mimePath = mimePath.getEmbedded(string);
            }
            n2 = n3 + 1;
        }
        return mimePath;
    }

    Lookup getLookup() {
        return ((MimeLookupCacheSPI)Lookup.getDefault().lookup(MimeLookupCacheSPI.class)).getLookup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup getLookupImpl() {
        String string = this.LOOKUP_LOCK;
        synchronized (string) {
            if (this.lookup == null) {
                this.lookup = new MimePathLookup(this);
            }
            return this.lookup;
        }
    }

    public String toString() {
        return "MimePath[" + this.path + "]";
    }

    private static boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.length() < charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String getInheritedType() {
        if ("".equals(this.mimeType)) {
            return null;
        }
        MimePath mimePath = this.size() == 1 ? this : MimePath.parse(this.mimeType);
        List<String> list = mimePath.getInheritedPaths(null, null);
        if (list.size() > 1) {
            return list.get(1);
        }
        return null;
    }

    public List<MimePath> getIncludedPaths() {
        List<String> list = this.getInheritedPaths(null, null);
        ArrayList<MimePath> arrayList = new ArrayList<MimePath>(list.size());
        for (String string : list) {
            arrayList.add(MimePath.parse(string));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    List<String> getInheritedPaths(String string, String string2) {
        Object object = LOCK;
        synchronized (object) {
            String[] stringArray;
            ArrayList<Object> arrayList = new ArrayList<Object>(this.size());
            String[] stringArray2 = MimePath.split(this);
            for (int i = 0; i <= stringArray2.length; ++i) {
                String stringArray4;
                void string3;
                String[] stringArray3 = new String[stringArray2.length - i];
                boolean j = false;
                while (string3 < stringArray3.length) {
                    stringArray3[string3] = stringArray2[i + string3];
                    ++string3;
                }
                arrayList.add(stringArray3);
                if (stringArray3.length <= 0 || (stringArray4 = MimePath.getGenericPartOfCompoundMimeType((String)stringArray3[0])) == null) continue;
                stringArray = new String[stringArray3.length];
                System.arraycopy(stringArray3, 0, stringArray, 0, stringArray3.length);
                stringArray[0] = stringArray4;
                arrayList.add(stringArray);
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
            for (String[] stringArray3 : arrayList) {
                stringArray = new StringBuilder(10 * stringArray3.length + 20);
                if (string != null && string.length() > 0) {
                    stringArray.append(string);
                }
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (stringArray3[i].length() <= 0) continue;
                    if (stringArray.length() > 0) {
                        stringArray.append('/');
                    }
                    stringArray.append(stringArray3[i]);
                }
                if (string2 != null && string2.length() > 0) {
                    if (stringArray.length() > 0) {
                        stringArray.append('/');
                    }
                    stringArray.append(string2);
                }
                arrayList2.add(stringArray.toString());
            }
            return arrayList2;
        }
    }

    static String getGenericPartOfCompoundMimeType(String string) {
        int n = string.lastIndexOf(43);
        if (n != -1 && n < string.length() - 1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2 + 1);
            String string3 = string.substring(n + 1);
            if (string3.equals("xml")) {
                string2 = "text/";
            }
            return string2 + string3;
        }
        return null;
    }

    private static String[] split(MimePath mimePath) {
        String[] stringArray = new String[mimePath.size()];
        for (int i = 0; i < mimePath.size(); ++i) {
            stringArray[i] = mimePath.getMimeType(i);
        }
        return stringArray;
    }

    static {
        new AccessorImpl();
    }

    private static class AccessorImpl
    extends APIAccessor {
        private AccessorImpl() {
        }

        @Override
        public Lookup cacheMimeLookup(MimePath mimePath) {
            return mimePath.getLookupImpl();
        }
    }
}

