/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ForkDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.JUnitLauncherTask;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.SingleTestClass;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestDefinition;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.Resources;

public class TestClasses
extends TestDefinition {
    private final Resources resources = new Resources();

    public void add(ResourceCollection resourceCollection) {
        this.resources.add(resourceCollection);
    }

    public List<String> getTestClassNames() {
        if (this.resources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tests = new ArrayList<String>();
        for (Resource resource : this.resources) {
            String name;
            if (!resource.isExists() || !(name = resource.getName()).endsWith(".class")) continue;
            String className = name.substring(0, name.lastIndexOf(46));
            tests.add(className.replace(File.separatorChar, '.').replace('/', '.').replace('\\', '.'));
        }
        return tests;
    }

    @Override
    protected List<TestDefinition.ForkedRepresentation> toForkedRepresentations() throws IllegalStateException {
        if (this.forkDefinition == null) {
            throw new IllegalStateException("tests haven't been configured to run in forked JVM");
        }
        ForkDefinition.ForkMode forkMode = this.forkDefinition.getForkMode();
        if (forkMode == null) {
            return Collections.singletonList(new ForkModeRep(this.getTestClassNames()));
        }
        switch (forkMode.getValue()) {
            case "perTestClass": {
                ArrayList<ForkModeRep> forkModeReps = new ArrayList<ForkModeRep>();
                for (String testClass : this.getTestClassNames()) {
                    forkModeReps.add(new ForkModeRep(Collections.singletonList(testClass)));
                }
                return Collections.unmodifiableList(forkModeReps);
            }
        }
        throw new BuildException("Unsupported fork mode: " + forkMode.getValue());
    }

    public static List<TestDefinition> fromForkedRepresentation(XMLStreamReader reader) throws XMLStreamException {
        reader.require(1, null, "test-classes");
        ArrayList<SingleTestClass> testDefinitions = new ArrayList<SingleTestClass>();
        while (reader.nextTag() != 2) {
            String excludeEngs;
            String includeEngs;
            String outDir;
            SingleTestClass testDefinition = new SingleTestClass();
            reader.require(1, null, "test");
            String testClassName = TestClasses.requireAttributeValue(reader, "classname");
            testDefinition.setName(testClassName);
            String halt = reader.getAttributeValue(null, "haltOnFailure");
            if (halt != null) {
                testDefinition.setHaltOnFailure(Boolean.parseBoolean(halt));
            }
            if ((outDir = reader.getAttributeValue(null, "outDir")) != null) {
                testDefinition.setOutputDir(new File(outDir));
            }
            if ((includeEngs = reader.getAttributeValue(null, "includeEngines")) != null) {
                testDefinition.setIncludeEngines(includeEngs);
            }
            if ((excludeEngs = reader.getAttributeValue(null, "excludeEngines")) != null) {
                testDefinition.setExcludeEngines(excludeEngs);
            }
            while (reader.nextTag() != 2) {
                reader.require(1, null, "listener");
                testDefinition.addConfiguredListener(ListenerDefinition.fromForkedRepresentation(reader));
            }
            reader.require(2, null, "test");
            testDefinitions.add(testDefinition);
        }
        reader.require(2, null, "test-classes");
        return Collections.unmodifiableList(testDefinitions);
    }

    private static String requireAttributeValue(XMLStreamReader reader, String attrName) throws XMLStreamException {
        String val = reader.getAttributeValue(null, attrName);
        if (val != null) {
            return val;
        }
        throw new XMLStreamException("Attribute " + attrName + " is missing at " + reader.getLocation());
    }

    private final class ForkModeRep
    extends TestDefinition.ForkedRepresentation {
        private final List<String> testClassesToFork;

        private ForkModeRep(List<String> testClassesToFork) {
            this.testClassesToFork = testClassesToFork;
        }

        @Override
        public void write(JUnitLauncherTask task, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("test-classes");
            for (String test : this.testClassesToFork) {
                writer.writeStartElement("test");
                writer.writeAttribute("classname", test);
                if (TestClasses.this.haltOnFailure != null) {
                    writer.writeAttribute("haltOnFailure", TestClasses.this.haltOnFailure.toString());
                }
                if (TestClasses.this.outputDir != null) {
                    writer.writeAttribute("outDir", TestClasses.this.outputDir.getPath());
                }
                if (TestClasses.this.includeEngines != null) {
                    writer.writeAttribute("includeEngines", TestClasses.this.includeEngines);
                }
                if (TestClasses.this.excludeEngines != null) {
                    writer.writeAttribute("excludeEngines", TestClasses.this.excludeEngines);
                }
                if (TestClasses.this.listeners != null) {
                    for (ListenerDefinition listenerDef : TestClasses.this.getListeners()) {
                        if (!listenerDef.shouldUse(task.getProject())) continue;
                        listenerDef.toForkedRepresentation(writer);
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }
}

