/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.ForClause;
import net.sf.saxon.expr.flwor.ForMemberClausePull;
import net.sf.saxon.expr.flwor.ForMemberClausePush;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class ForMemberClause
extends ForClause {
    @Override
    public Clause.ClauseName getClauseKey() {
        return Clause.ClauseName.FOR_MEMBER;
    }

    @Override
    public ForMemberClause copy(FLWORExpression flwor, RebindingMap rebindings) {
        ForMemberClause f2 = new ForMemberClause();
        f2.setLocation(this.getLocation());
        f2.setPackageData(this.getPackageData());
        f2.rangeVariable = this.rangeVariable.copy();
        if (this.positionVariable != null) {
            f2.positionVariable = this.positionVariable.copy();
        }
        f2.initSequence(flwor, this.getSequence().copy(rebindings));
        f2.allowsEmpty = this.allowsEmpty;
        return f2;
    }

    @Override
    public void typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        SequenceType decl = this.rangeVariable.getRequiredType();
        if (this.allowsEmpty && !Cardinality.allowsZero(decl.getCardinality())) {
            RoleDiagnostic emptyRole = new RoleDiagnostic(3, this.rangeVariable.getVariableQName().getDisplayName(), 0);
            Expression checker = CardinalityChecker.makeCardinalityChecker(this.getSequence(), 49152, emptyRole);
            this.setSequence(checker);
        }
        SequenceType sequenceType = SequenceType.makeSequenceType(new ArrayItemType(decl), 16384);
        RoleDiagnostic role = new RoleDiagnostic(17, this.rangeVariable.getVariableQName().getDisplayName(), 0);
        this.setSequence(TypeChecker.strictTypeCheck(this.getSequence(), sequenceType, role, visitor.getStaticContext()));
    }

    @Override
    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        return new ForMemberClausePull(base, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush destination, Outputter output, XPathContext context) {
        return new ForMemberClausePush(output, destination, this);
    }

    @Override
    public boolean addPredicate(FLWORExpression flwor, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType, Expression condition) throws XPathException {
        return false;
    }

    @Override
    public void refineVariableType(ExpressionVisitor visitor, List<VariableReference> references, Expression returnExpr) {
        ItemType actualItemType = this.getSequence().getItemType();
        if (actualItemType instanceof ArrayItemType) {
            SequenceType memberType = ((ArrayItemType)actualItemType).getMemberType();
            for (VariableReference ref : references) {
                ref.refineVariableType(memberType.getPrimaryType(), memberType.getCardinality(), null, this.getSequence().getSpecialProperties());
            }
        }
    }

    @Override
    public void addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet varPath = this.getSequence().addToPathMap(pathMap, pathMapNodeSet);
        pathMap.registerPathForVariable(this.rangeVariable, varPath);
    }
}

