/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.Map;
import java.util.Properties;
import net.i2p.data.Hash;
import net.i2p.router.TunnelPoolSettings;

public class ClientTunnelSettings {
    private final TunnelPoolSettings _inboundSettings;
    private final TunnelPoolSettings _outboundSettings;

    public ClientTunnelSettings(Hash dest) {
        this._inboundSettings = new TunnelPoolSettings(dest, true);
        this._outboundSettings = new TunnelPoolSettings(dest, false);
    }

    public TunnelPoolSettings getInboundSettings() {
        return this._inboundSettings;
    }

    public TunnelPoolSettings getOutboundSettings() {
        return this._outboundSettings;
    }

    public void readFromProperties(Properties props) {
        this._inboundSettings.readFromProperties("inbound.", props);
        this._outboundSettings.readFromProperties("outbound.", props);
    }

    private void writeToProperties(Properties props) {
        if (props == null) {
            return;
        }
        this._inboundSettings.writeToProperties("inbound.", props);
        this._outboundSettings.writeToProperties("outbound.", props);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Properties p = new Properties();
        this.writeToProperties(p);
        buf.append("Client tunnel settings:\n");
        buf.append("====================================\n");
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String name = (String)entry.getKey();
            String val = (String)entry.getValue();
            buf.append(name).append(" = [").append(val).append("]\n");
        }
        buf.append("====================================\n");
        return buf.toString();
    }
}

