/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import freenet.support.CPUInformation.CPUID;
import freenet.support.CPUInformation.UnknownCPUException;
import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.i2p.client.impl.I2PSessionImpl;
import net.i2p.crypto.SigUtil;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterClock;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.router.message.GarlicMessageHandler;
import net.i2p.router.networkdb.PublishLocalRouterInfoJob;
import net.i2p.router.startup.PortableWorkingDir;
import net.i2p.router.startup.StartupJob;
import net.i2p.router.startup.WorkingDir;
import net.i2p.router.sybil.Analysis;
import net.i2p.router.tasks.BasePerms;
import net.i2p.router.tasks.CoalesceStatsEvent;
import net.i2p.router.tasks.CryptoChecker;
import net.i2p.router.tasks.GracefulShutdown;
import net.i2p.router.tasks.InstallUpdate;
import net.i2p.router.tasks.MarkLiveliness;
import net.i2p.router.tasks.OOMListener;
import net.i2p.router.tasks.PersistRouterInfoJob;
import net.i2p.router.tasks.Republish;
import net.i2p.router.tasks.Restarter;
import net.i2p.router.tasks.RouterWatchdog;
import net.i2p.router.tasks.ShutdownHook;
import net.i2p.router.tasks.Spinner;
import net.i2p.router.tasks.UpdateRoutingKeyModifierJob;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.UPnPScannerCallback;
import net.i2p.router.util.EventLog;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatManager;
import net.i2p.util.ByteCache;
import net.i2p.util.FileUtil;
import net.i2p.util.FortunaRandomSource;
import net.i2p.util.I2PAppThread;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.OrderedProperties;
import net.i2p.util.ReusableGZIPInputStream;
import net.i2p.util.ReusableGZIPOutputStream;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleByteCache;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

public class Router
implements RouterClock.ClockShiftListener {
    private Log _log;
    private final RouterContext _context;
    private final Map<String, String> _config;
    private String _configFilename;
    private RouterInfo _routerInfo;
    private final ReentrantReadWriteLock _routerInfoLock = new ReentrantReadWriteLock(false);
    public final Object routerInfoFileLock = new Object();
    private final Object _configFileLock = new Object();
    private long _started;
    private boolean _killVMOnEnd = true;
    private int _gracefulExitCode = -1;
    private I2PThread.OOMEventListener _oomListener;
    private ShutdownHook _shutdownHook;
    private I2PThread _gracefulShutdownDetector;
    private RouterWatchdog _watchdog;
    private Thread _watchdogThread;
    private final EventLog _eventLog;
    private final Object _stateLock = new Object();
    private State _state = State.UNINITIALIZED;
    private FamilyKeyCrypto _familyKeyCrypto;
    private boolean _familyKeyCryptoFail;
    public final Object _familyKeyLock = new Object();
    private UPnPScannerCallback _upnpScannerCallback;
    private long _downtime = -1L;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    public static final String PROP_CONFIG_FILE = "router.configLocation";
    public static final long CLOCK_FUDGE_FACTOR = 60000L;
    private static final int DEFAULT_NETWORK_ID = 2;
    private static final String PROP_NETWORK_ID = "router.networkID";
    private final int _networkID;
    public static final int COALESCE_TIME = 50000;
    public static final String PROP_HIDDEN = "router.hiddenMode";
    public static final String PROP_HIDDEN_HIDDEN = "router.isHidden";
    public static final String PROP_DYNAMIC_KEYS = "router.dynamicKeys";
    public static final String PROP_REBUILD_KEYS = "router.rebuildKeys";
    private static final String PROP_SHUTDOWN_IN_PROGRESS = "__shutdownInProgress";
    public static final String PROP_IB_RANDOM_KEY = "router.inboundPool.randomKey";
    public static final String PROP_OB_RANDOM_KEY = "router.outboundPool.randomKey";
    private static final String EVENTLOG = "eventlog.txt";
    private static final String PROP_JBIGI = "jbigi.loadedResource";
    private static final String PROP_JBIGI_PROCESSOR = "jbigi.lastProcessor";
    public static final String UPDATE_FILE = "i2pupdate.zip";
    private static final boolean CONGESTION_CAPS = true;
    private static final int SHUTDOWN_WAIT_SECS = 60;
    private static final String originalTimeZoneID;
    private static final Set<State> STATES_ALIVE;
    private static final Set<State> STATES_GRACEFUL;
    private static final Set<State> STATES_FINAL;
    public static final char CAPABILITY_BW12 = 'K';
    public static final char CAPABILITY_BW32 = 'L';
    public static final char CAPABILITY_BW64 = 'M';
    public static final char CAPABILITY_BW128 = 'N';
    public static final char CAPABILITY_BW256 = 'O';
    public static final char CAPABILITY_BW512 = 'P';
    public static final char CAPABILITY_BW_UNLIMITED = 'X';
    public static final String PROP_FORCE_BWCLASS = "router.forceBandwidthClass";
    public static final char CAPABILITY_REACHABLE = 'R';
    public static final char CAPABILITY_UNREACHABLE = 'U';
    public static final char CAPABILITY_CONGESTION_MODERATE = 'D';
    public static final char CAPABILITY_CONGESTION_SEVERE = 'E';
    public static final char CAPABILITY_NO_TUNNELS = 'G';
    public static final String PROP_FORCE_UNREACHABLE = "router.forceUnreachable";
    @Deprecated
    public static final char CAPABILITY_NEW_TUNNEL = 'T';
    public static final int MIN_BW_K = 0;
    public static final int MIN_BW_L = 12;
    public static final int MIN_BW_M = 48;
    public static final int MIN_BW_N = 64;
    public static final int MIN_BW_O = 128;
    public static final int MIN_BW_P = 256;
    public static final int MIN_BW_X = 2000;
    private static final String[] _rebuildFiles;
    public static final int EXIT_GRACEFUL = 2;
    public static final int EXIT_HARD = 3;
    public static final int EXIT_OOM = 10;
    public static final int EXIT_HARD_RESTART = 4;
    public static final int EXIT_GRACEFUL_RESTART = 5;
    private static final boolean ALLOW_DYNAMIC_KEYS = false;
    private static final long LIVELINESS_DELAY = 60000L;
    public static final String PROP_BANDWIDTH_SHARE_PERCENTAGE = "router.sharePercentage";
    public static final int DEFAULT_SHARE_PERCENTAGE = 80;

    public Router() {
        this(null, null);
    }

    public Router(Properties envProps) {
        this(null, envProps);
    }

    public Router(String configFilename) {
        this(configFilename, null);
    }

    public Router(String configFilename, Properties envProps) {
        this._config = new ConcurrentHashMap<String, String>();
        if (configFilename == null) {
            if (envProps != null) {
                this._configFilename = envProps.getProperty(PROP_CONFIG_FILE);
            }
            if (this._configFilename == null) {
                this._configFilename = System.getProperty(PROP_CONFIG_FILE, "router.config");
            }
        } else {
            this._configFilename = configFilename;
        }
        String migrate = System.getProperty("i2p.dir.migrate");
        boolean migrateFiles = Boolean.parseBoolean(migrate);
        String isPortableStr = System.getProperty("i2p.dir.portableMode");
        boolean isPortable = Boolean.parseBoolean(isPortableStr);
        String userDir = !isPortable ? WorkingDir.getWorkingDir(envProps, migrateFiles) : PortableWorkingDir.getWorkingDir(envProps);
        File cf = new File(this._configFilename);
        if (!cf.isAbsolute()) {
            cf = new File(userDir, this._configFilename);
            this._configFilename = cf.getAbsolutePath();
        }
        this.readConfig();
        if (envProps == null) {
            envProps = new Properties();
        }
        envProps.putAll(this._config);
        if (envProps.getProperty("i2p.dir.config") == null) {
            envProps.setProperty("i2p.dir.config", userDir);
        }
        envProps.setProperty("i2p.systemTimeZone", originalTimeZoneID);
        List<RouterContext> contexts = RouterContext.getContexts();
        if (contexts.isEmpty()) {
            RouterContext.killGlobalContext();
        } else if (SystemVersion.isAndroid()) {
            System.err.println("Warning: Killing " + contexts.size() + " other routers in this JVM");
            contexts.clear();
            RouterContext.killGlobalContext();
        } else {
            System.err.println("Warning: " + contexts.size() + " other routers in this JVM");
        }
        this._context = new RouterContext(this, envProps, false);
        RouterContext.setGlobalContext(this._context);
        this._eventLog = new EventLog(this._context, new File(this._context.getRouterDir(), EVENTLOG));
        if (!SystemVersion.isAndroid()) {
            for (int i = 0; i < 14; ++i) {
                if (this.isOnlyRouterRunning()) {
                    if (i <= 0) break;
                    System.err.println("INFO: No, there wasn't another router already running. Proceeding with startup.");
                    break;
                }
                if (i < 13) {
                    if (i == 0) {
                        System.err.println("WARN: There may be another router already running. Waiting a while to be sure...");
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this._eventLog.addEvent("aborted", "Another router running");
                System.err.println("ERROR: There appears to be another router already running!");
                System.err.println("       Please make sure to shut down old instances before starting up");
                System.err.println("       a new one.  If you are positive that no other instance is running,");
                System.err.println("       please delete the file " + this.getPingFile().getAbsolutePath());
                throw new IllegalStateException("ERROR: There appears to be another router already running! Please make sure to shut down old instances before starting up a new one.  If you are positive that no other instance is running, please delete the file " + this.getPingFile().getAbsolutePath());
            }
        }
        if (this._config.get("router.firstVersion") == null) {
            this._config.put("router.firstVersion", "2.8.2");
            String now = Long.toString(System.currentTimeMillis());
            this._config.put("router.firstInstalled", now);
            this._config.put("router.updateLastInstalled", now);
            this._config.put("router.previousVersion", "2.8.2");
            this.saveConfig();
        }
        int id = 2;
        String sid = this._config.get(PROP_NETWORK_ID);
        if (sid != null) {
            try {
                id = Integer.parseInt(sid);
                if (id < 2 || id > 254) {
                    throw new IllegalArgumentException("Invalid router.networkID");
                }
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid router.networkID");
            }
        }
        this._networkID = id;
        this.setUPnPScannerCallback(new LoggerCallback());
        this.changeState(State.INITIALIZED);
    }

    private void startupStuff() {
        this._log = this._context.logManager().getLog(Router.class);
        if (!SystemVersion.isAndroid()) {
            this.beginMarkingLiveliness();
        }
        System.setProperty("router.version", "2.8.2-0");
        this.warmupCrypto();
        this._context.initAll();
        if (this._context.hasWrapper()) {
            File f = new File(System.getProperty("java.io.tmpdir"), "wrapper.log");
            if (!f.exists()) {
                f = new File(this._context.getBaseDir(), "wrapper.log");
            }
            if (f.exists()) {
                SecureFileOutputStream.setPerms(f);
            }
        }
        CryptoChecker.warnUnavailableCrypto(this._context);
        this._routerInfo = null;
        if (this._log.shouldLog(20)) {
            this._log.info("New router created with config file " + this._configFilename);
        }
        this._oomListener = new OOMListener(this._context);
        this._shutdownHook = new ShutdownHook(this._context);
        this._gracefulShutdownDetector = new I2PAppThread(new GracefulShutdown(this._context), "Graceful ShutdownHook", true);
        this._gracefulShutdownDetector.setPriority(6);
        this._gracefulShutdownDetector.start();
        this._watchdog = new RouterWatchdog(this._context);
        this._watchdogThread = new I2PAppThread(this._watchdog, "RouterWatchdog", true);
        this._watchdogThread.setPriority(6);
        this._watchdogThread.start();
        if (SystemVersion.isWindows()) {
            BasePerms.fix(this._context);
        }
    }

    public static final void clearCaches() {
        ByteCache.clearAll();
        SimpleByteCache.clearAll();
        Destination.clearCache();
        Translate.clearCache();
        Hash.clearCache();
        PublicKey.clearCache();
        SigningPublicKey.clearCache();
        SigUtil.clearCaches();
        I2PSessionImpl.clearCache();
        ReusableGZIPInputStream.clearCache();
        ReusableGZIPOutputStream.clearCache();
    }

    public void setKillVMOnEnd(boolean shouldDie) {
        this._killVMOnEnd = shouldDie;
    }

    public boolean getKillVMOnEnd() {
        return this._killVMOnEnd;
    }

    public String getConfigFilename() {
        return this._configFilename;
    }

    @Deprecated
    public void setConfigFilename(String filename) {
        this._configFilename = filename;
    }

    public String getConfigSetting(String name) {
        return this._config.get(name);
    }

    @Deprecated
    public void setConfigSetting(String name, String value) {
        this._config.put(name, value);
    }

    @Deprecated
    public void removeConfigSetting(String name) {
        this._config.remove(name);
        this._context.removeProperty(name);
    }

    public Set<String> getConfigSettings() {
        return Collections.unmodifiableSet(this._config.keySet());
    }

    public Map<String, String> getConfigMap() {
        return Collections.unmodifiableMap(this._config);
    }

    public RouterInfo getRouterInfo() {
        this._routerInfoLock.readLock().lock();
        try {
            RouterInfo routerInfo = this._routerInfo;
            return routerInfo;
        }
        finally {
            this._routerInfoLock.readLock().unlock();
        }
    }

    public void setRouterInfo(RouterInfo info) {
        this._routerInfoLock.writeLock().lock();
        try {
            this._routerInfo = info;
        }
        finally {
            this._routerInfoLock.writeLock().unlock();
        }
        if (this._log.shouldLog(20)) {
            this._log.info("setRouterInfo() : " + info, new Exception("I did it"));
        }
        if (info != null) {
            this._context.jobQueue().addJob(new PersistRouterInfoJob(this._context));
        }
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getUptime() {
        if (this._started <= 0L) {
            return 1000L;
        }
        return Math.max(1000L, System.currentTimeMillis() - this._started);
    }

    public int getNetworkID() {
        return this._networkID;
    }

    public RouterContext getContext() {
        return this._context;
    }

    public synchronized void setUPnPScannerCallback(UPnPScannerCallback callback) {
        this._upnpScannerCallback = callback;
    }

    public synchronized UPnPScannerCallback getUPnPScannerCallback() {
        return this._upnpScannerCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runRouter() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state != State.INITIALIZED) {
                throw new IllegalStateException();
            }
            this.changeState(State.STARTING_1);
        }
        String last = this._config.get("router.previousFullVersion");
        if (last != null && !this._context.getBooleanProperty("i2p.vmCommSystem")) {
            this._eventLog.addEvent("updated", "from " + last + " to " + "2.8.2-0");
            this.saveConfig("router.previousFullVersion", null);
        }
        if (!this._context.getBooleanProperty("i2p.vmCommSystem")) {
            this._eventLog.addEvent("started", "2.8.2-0");
        }
        this.startupStuff();
        this.changeState(State.STARTING_2);
        this._started = System.currentTimeMillis();
        try {
            Runtime.getRuntime().addShutdownHook(this._shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (!SystemVersion.isAndroid()) {
            I2PThread.addOOMEventListener(this._oomListener);
        }
        this._context.inNetMessagePool().registerHandlerJobBuilder(11, new GarlicMessageHandler(this._context));
        if (this._context.getBooleanProperty(PROP_REBUILD_KEYS)) {
            this.killKeys();
        }
        this._context.messageValidator().startup();
        this._context.tunnelDispatcher().startup();
        this._context.inNetMessagePool().startup();
        this._context.jobQueue().runQueue(1);
        this._context.simpleTimer2().addPeriodicEvent(new CoalesceStatsEvent(this._context), 50000L);
        this._context.jobQueue().addJob(new UpdateRoutingKeyModifierJob(this._context));
        this._context.blocklist().startup();
        Object object2 = this._configFileLock;
        synchronized (object2) {
            if (!this._config.containsKey(PROP_IB_RANDOM_KEY) || this.getEstimatedDowntime() > 43200000L) {
                byte[] rk = new byte[32];
                this._context.random().nextBytes(rk);
                this._config.put(PROP_IB_RANDOM_KEY, Base64.encode(rk));
                this._context.random().nextBytes(rk);
                this._config.put(PROP_OB_RANDOM_KEY, Base64.encode(rk));
                this.saveConfig();
            }
        }
        long before = System.currentTimeMillis();
        this._context.clock().getTimestamper().waitForInitialization();
        long waited = System.currentTimeMillis() - before;
        if (this._log.shouldLog(20)) {
            this._log.info("Waited " + waited + "ms to initialize");
        }
        this.changeState(State.STARTING_3);
        this._context.jobQueue().addJob(new StartupJob(this._context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfig() {
        Object object = this._configFileLock;
        synchronized (object) {
            String f = this.getConfigFilename();
            Properties config = Router.getConfig(this._context, f);
            Map<String, String> foo = this._config;
            foo.putAll(config);
        }
    }

    private static Properties getConfig(RouterContext ctx, String filename) {
        Log log = null;
        if (ctx != null && (log = ctx.logManager().getLog(Router.class)).shouldLog(10)) {
            log.debug("Config file: " + filename, new Exception("location"));
        }
        Properties props = new Properties();
        try {
            File f = new File(filename);
            if (f.canRead()) {
                DataHelper.loadProps(props, f);
                props.remove(PROP_SHUTDOWN_IN_PROGRESS);
            } else if (log != null) {
                log.warn("Configuration file " + filename + " does not exist");
            }
        }
        catch (IOException ioe) {
            if (log != null) {
                log.error("Error loading the router configuration from " + filename, ioe);
            }
            System.err.println("Error loading the router configuration from " + filename + ": " + ioe);
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State state) {
        State oldState;
        Object object = this._stateLock;
        synchronized (object) {
            oldState = this._state;
            this._state = state;
        }
        if (this._log != null && oldState != state && state != State.STOPPED && this._log.shouldLog(30)) {
            this._log.warn("Router state change from " + (Object)((Object)oldState) + " to " + (Object)((Object)state));
            this._context.logManager().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        Object object = this._stateLock;
        synchronized (object) {
            return STATES_ALIVE.contains((Object)this._state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.RUNNING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRestarting() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._state == State.RESTARTING;
        }
    }

    public void setIsAlive() {
        this.changeState(State.RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetDbReady() {
        boolean changed = false;
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.STARTING_3) {
                this.changeState(State.NETDB_READY);
                changed = true;
            } else if (this._state == State.EXPL_TUNNELS_READY) {
                this.changeState(State.RUNNING);
                changed = true;
            }
        }
        if (changed && this._context.netDb().isInitialized()) {
            if (this._log.shouldWarn()) {
                this._log.warn("NetDB ready, publishing RI");
            }
            Republish r = new Republish(this._context);
            this._context.simpleTimer2().addEvent(r, 0L);
            PublishLocalRouterInfoJob plrij = new PublishLocalRouterInfoJob(this._context);
            plrij.getTiming().setStartAfter(this._context.clock().now() + plrij.getDelay());
            this._context.jobQueue().addJob(plrij);
        }
        if (changed) {
            this._context.commSystem().initGeoIP();
            if (!SystemVersion.isSlow() && !this._context.getBooleanProperty("i2np.allowLocal") && this._context.getProperty("router.sybilFrequency", 86400000L) > 0L) {
                Analysis.getInstance(this._context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplTunnelsReady() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.STARTING_3) {
                this.changeState(State.EXPL_TUNNELS_READY);
            } else if (this._state == State.NETDB_READY) {
                this.changeState(State.RUNNING);
            } else {
                this._log.warn("Invalid state " + (Object)((Object)this._state) + " for setExplTunnelsReady()");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean gracefulShutdownInProgress() {
        Object object = this._stateLock;
        synchronized (object) {
            return STATES_GRACEFUL.contains((Object)this._state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinalShutdownInProgress() {
        Object object = this._stateLock;
        synchronized (object) {
            return STATES_FINAL.contains((Object)this._state);
        }
    }

    public void rebuildRouterInfo() {
        this.rebuildRouterInfo(false);
    }

    public void rebuildRouterInfo(boolean blockingRebuild) {
        if (this._log.shouldLog(20)) {
            this._log.info("Rebuilding new routerInfo, publish inline? " + blockingRebuild, new Exception("I did it"));
        }
        List<RouterAddress> addresses = this._context.commSystem().createAddresses();
        this._routerInfoLock.writeLock().lock();
        try {
            this.locked_rebuildRouterInfo(addresses);
        }
        finally {
            this._routerInfoLock.writeLock().unlock();
        }
    }

    private void locked_rebuildRouterInfo(List<RouterAddress> addresses) {
        RouterInfo ri = this._routerInfo != null ? new RouterInfo(this._routerInfo) : new RouterInfo();
        try {
            ri.setPublished(this._context.clock().now());
            Properties stats = this._context.statPublisher().publishStatistics();
            ri.setOptions(stats);
            ri.setAddresses(addresses);
            SigningPrivateKey key = this._context.keyManager().getSigningPrivateKey();
            if (key == null) {
                this._log.log(50, "Internal error - signing private key not known? Impossible?");
                return;
            }
            ri.sign(key);
            this.setRouterInfo(ri);
            if (!ri.isValid()) {
                throw new DataFormatException("Our RouterInfo has a bad signature");
            }
            Republish r = new Republish(this._context);
            this._context.simpleTimer2().addEvent(r, 0L);
        }
        catch (DataFormatException dfe) {
            this._log.log(50, "Internal error - unable to sign our own address?!", dfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FamilyKeyCrypto getFamilyKeyCrypto() {
        Object object = this._familyKeyLock;
        synchronized (object) {
            if (this._familyKeyCrypto == null && !this._familyKeyCryptoFail) {
                try {
                    this._familyKeyCrypto = new FamilyKeyCrypto(this._context);
                }
                catch (Exception e) {
                    this._log.error("Failed to initialize family key crypto", e);
                    this._familyKeyCryptoFail = true;
                }
            }
        }
        return this._familyKeyCrypto;
    }

    public char getBandwidthClass() {
        int bwLim = Math.min(this._context.bandwidthLimiter().getInboundKBytesPerSecond(), this._context.bandwidthLimiter().getOutboundKBytesPerSecond());
        bwLim = (int)((double)bwLim * this.getSharePercentage());
        String force = this._context.getProperty(PROP_FORCE_BWCLASS);
        if (force != null && force.length() > 0) {
            return force.charAt(0);
        }
        if (bwLim < 12) {
            return 'K';
        }
        if (bwLim <= 48) {
            return 'L';
        }
        if (bwLim <= 64) {
            return 'M';
        }
        if (bwLim <= 128) {
            return 'N';
        }
        if (bwLim <= 256) {
            return 'O';
        }
        if (bwLim <= 2000) {
            return 'P';
        }
        return 'X';
    }

    public String getCapabilities() {
        StringBuilder rv = new StringBuilder(4);
        boolean hidden = this.isHidden();
        char bw = hidden ? (char)'L' : (char)this.getBandwidthClass();
        rv.append(bw);
        if (this._context.netDb().floodfillEnabled() && !this._context.getBooleanProperty("router.hideFloodfillParticipant")) {
            rv.append('f');
        }
        if (this._context.getBooleanProperty(PROP_HIDDEN)) {
            rv.append('H');
        }
        if (hidden || this._context.getBooleanProperty(PROP_FORCE_UNREACHABLE)) {
            rv.append('U');
            return rv.toString();
        }
        boolean forceG = false;
        switch (this._context.commSystem().getStatus()) {
            case OK: 
            case IPV4_OK_IPV6_UNKNOWN: 
            case IPV4_OK_IPV6_FIREWALLED: 
            case IPV4_FIREWALLED_IPV6_OK: 
            case IPV4_DISABLED_IPV6_OK: 
            case IPV4_UNKNOWN_IPV6_OK: 
            case IPV4_SNAT_IPV6_OK: {
                rv.append('R');
                break;
            }
            case DIFFERENT: 
            case HOSED: 
            case IPV4_SNAT_IPV6_UNKNOWN: {
                forceG = true;
            }
            case REJECT_UNSOLICITED: 
            case IPV4_DISABLED_IPV6_FIREWALLED: {
                rv.append('U');
                break;
            }
        }
        int cong = 0;
        int maxTunnels = this._context.getProperty("router.maxParticipatingTunnels", 10000);
        if (forceG || maxTunnels <= 0) {
            cong = 69;
        } else if (maxTunnels <= 50 || SystemVersion.isSlow()) {
            cong = 68;
        } else {
            int numTunnels = this._context.tunnelManager().getParticipatingCount();
            if (numTunnels > 9 * maxTunnels / 10) {
                cong = 69;
            } else if (numTunnels > 8 * maxTunnels / 10) {
                cong = 68;
            } else {
                long lag = this._context.jobQueue().getMaxLag();
                if (lag > 300L && this.getUptime() > 600000L) {
                    cong = lag > 500L ? 69 : 68;
                } else {
                    double bwLim = this.getSharePercentage() * 1024.0 * (double)Math.min(this._context.bandwidthLimiter().getInboundKBytesPerSecond(), this._context.bandwidthLimiter().getOutboundKBytesPerSecond());
                    if (bwLim < 4096.0) {
                        cong = 69;
                    } else {
                        Rate r;
                        RateStat rs = this._context.statManager().getRate("tunnel.participatingMessageCountAvgPerTunnel");
                        double messagesPerTunnel = 0.0;
                        if (rs != null && (r = rs.getRate(1200000L)) != null) {
                            RateAverages ra = RateAverages.getTemp();
                            messagesPerTunnel = r.computeAverages(ra, true).getAverage();
                        }
                        if (messagesPerTunnel < 40.0) {
                            messagesPerTunnel = 40.0;
                        }
                        double bpsAllocated = messagesPerTunnel * (double)numTunnels * 1024.0 / 600.0;
                        if (this._log.shouldInfo()) {
                            this._log.info("bps allocated: " + bpsAllocated + " bw limit: " + bwLim);
                        }
                        if (bpsAllocated > 0.9 * bwLim) {
                            cong = 69;
                        } else if (bpsAllocated > 0.8 * bwLim) {
                            cong = 68;
                        }
                    }
                }
            }
        }
        if (cong != 0) {
            rv.append((char)cong);
        }
        return rv.toString();
    }

    public boolean isHidden() {
        if (this._context.getBooleanProperty(PROP_HIDDEN)) {
            return true;
        }
        String h = this._context.getProperty(PROP_HIDDEN_HIDDEN);
        if (h != null) {
            return Boolean.parseBoolean(h);
        }
        return this._context.commSystem().isInStrictCountry();
    }

    public EventLog eventLog() {
        return this._eventLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killKeys() {
        for (int i = 0; i < _rebuildFiles.length; ++i) {
            File f = new File(this._context.getRouterDir(), _rebuildFiles[i]);
            if (!f.exists()) continue;
            boolean removed = f.delete();
            if (removed) {
                System.out.println("INFO:  Removing old identity file: " + _rebuildFiles[i]);
                continue;
            }
            System.out.println("ERROR: Could not remove old identity file: " + _rebuildFiles[i]);
        }
        Object object = this._configFileLock;
        synchronized (object) {
            this.removeConfigSetting("i2np.udp.internalPort");
            this.removeConfigSetting("i2np.udp.port");
            this.removeConfigSetting("i2np.udp.introKey");
            this.removeConfigSetting("i2np.ssu2.sp");
            this.removeConfigSetting("i2np.ssu2.ikey");
            this.removeConfigSetting("i2np.ntcp.port");
            this.removeConfigSetting("i2np.ntcp2.sp");
            this.removeConfigSetting("i2np.ntcp2.iv");
            this.removeConfigSetting(PROP_IB_RANDOM_KEY);
            this.removeConfigSetting(PROP_OB_RANDOM_KEY);
            this.removeConfigSetting(PROP_REBUILD_KEYS);
            this.saveConfig();
        }
    }

    public synchronized void rebuildNewIdentity() {
        if (this._shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.killKeys();
        for (Runnable task : this._context.getShutdownTasks()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Running shutdown task " + task.getClass());
            }
            try {
                task.run();
            }
            catch (Throwable t) {
                this._log.log(50, "Error running shutdown task", t);
            }
        }
        this._context.removeShutdownTasks();
        if (this._context.hasWrapper()) {
            this._log.log(50, "Restarting with new router identity");
        } else {
            this._log.log(50, "Shutting down because old router identity was invalid - restart I2P");
        }
        this.finalShutdown(4);
    }

    private void warmupCrypto() {
        String oldLoaded = this._context.getProperty(PROP_JBIGI);
        String oldProcessor = this._context.getProperty(PROP_JBIGI_PROCESSOR);
        String processor = null;
        if (SystemVersion.isX86()) {
            try {
                processor = CPUID.getInfo().getCPUModelString();
                if (SystemVersion.is64Bit()) {
                    processor = processor + "/64";
                }
                if (oldProcessor != null && !oldProcessor.equals(processor)) {
                    boolean isWin = SystemVersion.isWindows();
                    boolean isMac = SystemVersion.isMac();
                    String osName = System.getProperty("os.name").toLowerCase(Locale.US);
                    boolean goodOS = isWin || isMac || osName.contains("linux") || osName.contains("freebsd");
                    File jbigiJar = new File(this._context.getLibDir(), "jbigi.jar");
                    if (goodOS && jbigiJar.exists() && this._context.getBaseDir().canWrite()) {
                        String path;
                        boolean success;
                        String libPrefix;
                        String string = libPrefix = isWin ? "" : "lib";
                        String libSuffix = isWin ? ".dll" : (isMac ? ".jnilib" : ".so");
                        File jbigiLib = new File(this._context.getBaseDir(), libPrefix + "jbigi" + libSuffix);
                        if (jbigiLib.canWrite() && (success = FileUtil.copy(path = jbigiLib.getAbsolutePath(), path + ".bak", true, true)) && (success = jbigiLib.delete())) {
                            System.out.println("Processor change detected, moved jbigi library to " + path + ".bak");
                            System.out.println("Check logs for successful installation of new library");
                        }
                    }
                }
            }
            catch (UnknownCPUException isWin) {
                // empty catch block
            }
        }
        this._context.random().nextBoolean();
        this._context.elGamalEngine();
        String loaded = NativeBigInteger.getLoadedResourceName();
        HashMap<String, String> changes = null;
        if (loaded != null && !loaded.equals(oldLoaded)) {
            changes = new HashMap<String, String>(2);
            changes.put(PROP_JBIGI, loaded);
        }
        if (processor != null && !processor.equals(oldProcessor)) {
            if (changes == null) {
                changes = new HashMap(1);
            }
            changes.put(PROP_JBIGI_PROCESSOR, processor);
        }
        if (changes != null) {
            this.saveConfig(changes, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(int exitCode) {
        if (exitCode < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this._state == State.FINAL_SHUTDOWN_1 || this._state == State.FINAL_SHUTDOWN_2 || this._state == State.FINAL_SHUTDOWN_3 || this._state == State.STOPPED) {
                return;
            }
            this.changeState(State.FINAL_SHUTDOWN_1);
        }
        this._context.throttle().setShutdownStatus();
        if (this._shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this._shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        this.shutdown2(exitCode);
    }

    public synchronized void shutdown2(int exitCode) {
        boolean waitForClients;
        Thread th;
        if (exitCode < 0) {
            throw new IllegalArgumentException();
        }
        this.changeState(State.FINAL_SHUTDOWN_2);
        int priority = exitCode == 10 ? 9 : 7;
        Thread.currentThread().setPriority(priority);
        if (exitCode == 4 || exitCode == 5) {
            this._log.log(50, this._t("Restart imminent"));
        } else {
            this._log.log(50, this._t("Shutdown imminent"));
        }
        if (this._killVMOnEnd) {
            try {
                new Spinner().start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ((RouterClock)this._context.clock()).removeShiftListener(this);
        this._context.random().saveSeed();
        I2PThread.removeOOMEventListener(this._oomListener);
        LinkedList<I2PAppThread> tasks = new LinkedList<I2PAppThread>();
        for (Runnable task : this._context.getShutdownTasks()) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Running shutdown task " + task.getClass());
            }
            try {
                I2PAppThread t = new I2PAppThread(task, "Shutdown task " + task.getClass().getName());
                t.setDaemon(true);
                ((Thread)t).start();
                tasks.add(t);
            }
            catch (Throwable t) {
                this._log.log(50, "Error running shutdown task", t);
            }
        }
        long waitSecs = 60L;
        if (SystemVersion.isARM()) {
            waitSecs *= 2L;
        }
        long maxWait = System.currentTimeMillis() + waitSecs * 1000L;
        while ((th = (Thread)tasks.poll()) != null) {
            long toWait = maxWait - System.currentTimeMillis();
            if (toWait <= 0L) {
                this._log.logAlways(30, "Shutdown tasks took more than " + waitSecs + " seconds to run");
                tasks.clear();
                break;
            }
            try {
                th.join(toWait);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (th.isAlive()) {
                this._log.logAlways(30, "Shutdown task took more than " + waitSecs + " seconds to run: " + th.getName());
                tasks.clear();
                break;
            }
            if (!this._log.shouldInfo()) continue;
            this._log.info("Shutdown task complete: " + th.getName());
        }
        if (!"2.8.2".equals(this._config.get("router.previousVersion"))) {
            this.saveConfig("router.previousVersion", "2.8.2");
        }
        this._context.removeShutdownTasks();
        boolean bl = waitForClients = this._killVMOnEnd && !this._context.clientManager().listClients().isEmpty();
        if (this._log.shouldWarn()) {
            this._log.warn("Stopping ClientManager");
        }
        try {
            this._context.clientManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the client manager", t);
        }
        if (waitForClients) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException t) {
                // empty catch block
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Done waiting for clients to disconnect");
            }
        }
        try {
            this._context.namingService().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the naming service", t);
        }
        try {
            this._context.jobQueue().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the job queue", t);
        }
        try {
            this._context.tunnelManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the tunnel manager", t);
        }
        try {
            this._context.tunnelDispatcher().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the tunnel dispatcher", t);
        }
        try {
            this._context.netDbSegmentor().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the networkDb", t);
        }
        try {
            this._context.commSystem().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the comm system", t);
        }
        try {
            this._context.bandwidthLimiter().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the comm system", t);
        }
        try {
            this._context.peerManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the peer manager", t);
        }
        try {
            this._context.messageRegistry().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the message registry", t);
        }
        try {
            this._context.messageValidator().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the message validator", t);
        }
        try {
            this._context.inNetMessagePool().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the inbound net pool", t);
        }
        try {
            this._context.clientMessagePool().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the client msg pool", t);
        }
        try {
            this._context.sessionKeyManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the session key manager", t);
        }
        try {
            this._context.eciesEngine().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the ECIES engine", t);
        }
        try {
            this._context.messageHistory().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the message history logger", t);
        }
        try {
            this._context.statManager().shutdown();
        }
        catch (Throwable t) {
            this._log.error("Error shutting down the stats manager", t);
        }
        this._context.deleteTempDir();
        List<RouterContext> contexts = RouterContext.getContexts();
        contexts.remove(this._context);
        try {
            this._context.elGamalEngine().shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting elGamal", t);
        }
        if (!contexts.isEmpty()) {
            this._log.logAlways(30, "Warning - " + contexts.size() + " routers remaining in this JVM, not releasing all resources");
        }
        try {
            ((FortunaRandomSource)this._context.random()).shutdown();
        }
        catch (Throwable t) {
            this._log.log(50, "Error shutting random()", t);
        }
        this._watchdog.shutdown();
        this._watchdogThread.interrupt();
        if (!this._context.commSystem().isDummy()) {
            this._eventLog.addEvent("stopped", Integer.toString(exitCode));
        }
        this.finalShutdown(exitCode);
    }

    private synchronized void finalShutdown(int exitCode) {
        this.changeState(State.FINAL_SHUTDOWN_3);
        Router.clearCaches();
        this._log.log(50, "Shutdown(" + exitCode + ") complete");
        try {
            this._context.logManager().shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!SystemVersion.isAndroid()) {
            File f = this.getPingFile();
            f.delete();
        }
        if (SystemVersion.isAndroid()) {
            RouterContext.killGlobalContext();
        }
        for (Runnable task : this._context.getFinalShutdownTasks()) {
            try {
                task.run();
            }
            catch (Throwable t) {
                System.err.println("Running final shutdown task " + t);
            }
        }
        this._context.getFinalShutdownTasks().clear();
        if (this._killVMOnEnd) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Runtime.getRuntime().exit(exitCode);
        } else if (SystemVersion.isAndroid()) {
            Runtime.getRuntime().gc();
        }
        this.changeState(State.STOPPED);
    }

    public void shutdownGracefully() {
        this.shutdownGracefully(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownGracefully(int exitCode) {
        if (exitCode < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this.isFinalShutdownInProgress()) {
                return;
            }
            this.changeState(State.GRACEFUL_SHUTDOWN);
            this._gracefulExitCode = exitCode;
        }
        this._context.throttle().setShutdownStatus();
        object = this._gracefulShutdownDetector;
        synchronized (object) {
            this._gracefulShutdownDetector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelGracefulShutdown() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.isFinalShutdownInProgress()) {
                return;
            }
            this.changeState(State.RUNNING);
            this._gracefulExitCode = -1;
        }
        this._context.throttle().cancelShutdownStatus();
        object = this._gracefulShutdownDetector;
        synchronized (object) {
            this._gracefulShutdownDetector.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scheduledGracefulExitCode() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._gracefulExitCode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getShutdownTimeRemaining() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this._gracefulExitCode <= 0) {
                return -1L;
            }
            if (this._gracefulExitCode == 3 || this._gracefulExitCode == 4) {
                return 0L;
            }
        }
        long exp = this._context.tunnelManager().getLastParticipatingExpiration();
        if (exp < 0L) {
            return 0L;
        }
        return Math.max(0L, exp + 120000L - this._context.clock().now());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig() {
        try {
            OrderedProperties ordered = new OrderedProperties();
            Object object = this._configFileLock;
            synchronized (object) {
                ordered.putAll(this._config);
                DataHelper.storeProps(ordered, new File(this._configFilename));
            }
        }
        catch (IOException ioe) {
            if (this._log != null) {
                this._log.error("Error saving the config to " + this._configFilename, ioe);
            } else {
                System.err.println("Error saving the config to " + this._configFilename + ": " + ioe);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig(String name, String value) {
        Object object = this._configFileLock;
        synchronized (object) {
            if (value != null) {
                this._config.put(name, value);
            } else {
                this.removeConfigSetting(name);
            }
            return this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfig(Map toAdd, Collection<String> toRemove) {
        Object object = this._configFileLock;
        synchronized (object) {
            if (toAdd != null) {
                this._config.putAll(toAdd);
            }
            if (toRemove != null) {
                for (String s : toRemove) {
                    this.removeConfigSetting(s);
                }
            }
            return this.saveConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockShift(long delta) {
        if (delta > -60000L && delta < 60000L) {
            return;
        }
        Object object = this._stateLock;
        synchronized (object) {
            if (this.gracefulShutdownInProgress() || !this.isAlive()) {
                return;
            }
        }
        this._eventLog.addEvent("clockShift", Long.toString(delta));
        this._context.routerKeyGenerator().generateDateBasedModData();
        if (delta > 0L) {
            this._log.error("Restarting after large clock shift forward by " + DataHelper.formatDuration(delta));
        } else {
            this._log.error("Restarting after large clock shift backward by " + DataHelper.formatDuration(0L - delta));
        }
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restart() {
        Object object = this._stateLock;
        synchronized (object) {
            if (this.gracefulShutdownInProgress() || !this.isAlive()) {
                return;
            }
            this.changeState(State.RESTARTING);
        }
        ((RouterClock)this._context.clock()).removeShiftListener(this);
        this._started = System.currentTimeMillis();
        object = this._configFileLock;
        synchronized (object) {
            this._downtime = 1L;
        }
        I2PThread t = new I2PThread(new Restarter(this._context), "Router Restart");
        t.setPriority(6);
        ((Thread)t).start();
    }

    public static void main(String[] args) {
        Router r;
        boolean rebuild = false;
        if (args != null) {
            int c;
            boolean error = false;
            Getopt g = new Getopt("router", args, "");
            while ((c = g.getopt()) != -1) {
                switch (c) {
                    default: 
                }
                error = true;
            }
            int remaining = args.length - g.getOptind();
            if (remaining > 1) {
                error = true;
            } else if (remaining == 1 && !(rebuild = args[g.getOptind()].equals("rebuild"))) {
                error = true;
            }
            if (error) {
                throw new IllegalArgumentException();
            }
        }
        System.out.println("Starting I2P 2.8.2-0");
        try {
            r = new Router();
        }
        catch (IllegalStateException ise) {
            System.exit(-1);
            return;
        }
        if (rebuild) {
            r.rebuildNewIdentity();
        } else {
            InstallUpdate.installUpdates(r);
            r.runRouter();
        }
    }

    private File getPingFile() {
        String s = this._context.getProperty("router.pingFile", "router.ping");
        File f = new File(s);
        if (!f.isAbsolute()) {
            f = new File(this._context.getPIDDir(), s);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isOnlyRouterRunning() {
        File f = this.getPingFile();
        if (f.exists()) {
            long lastWritten = f.lastModified();
            long downtime = System.currentTimeMillis() - lastWritten;
            Object object = this._configFileLock;
            synchronized (object) {
                if (downtime > 0L && this._downtime < 0L) {
                    this._downtime = downtime;
                }
            }
            if (downtime > 60000L) {
                System.err.println("WARN: Old router was not shut down gracefully, deleting " + f);
                f.delete();
                if (lastWritten > 0L) {
                    this._eventLog.addEvent("crashed", Translate.getString("{0} ago", DataHelper.formatDuration2(downtime), this._context, BUNDLE_NAME));
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private void beginMarkingLiveliness() {
        File f = this.getPingFile();
        this._context.simpleTimer2().addPeriodicEvent(new MarkLiveliness(this, f), 0L, 55000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEstimatedDowntime() {
        Object object = this._configFileLock;
        synchronized (object) {
            long downtime;
            if (this._downtime >= 0L) {
                return this._downtime;
            }
            long begin = System.currentTimeMillis();
            long stopped = this._eventLog.getLastEvent("stopped", this._context.clock().now() - 31536000000L);
            long l = downtime = stopped > 0L ? this._started - stopped : 0L;
            if (downtime < 0L) {
                downtime = 0L;
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Downtime was " + DataHelper.formatDuration(downtime) + "; calculation took " + DataHelper.formatDuration(System.currentTimeMillis() - begin));
            }
            this._downtime = downtime;
            return downtime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEstimatedDowntime(long downtime) {
        if (downtime <= 0L) {
            downtime = 1L;
        }
        Object object = this._configFileLock;
        synchronized (object) {
            this._downtime = downtime;
        }
    }

    public double getSharePercentage() {
        block4: {
            String pct = this._context.getProperty(PROP_BANDWIDTH_SHARE_PERCENTAGE);
            if (pct != null) {
                try {
                    double d = Double.parseDouble(pct);
                    if (d > 1.0) {
                        return d / 100.0;
                    }
                    return d;
                }
                catch (NumberFormatException nfe) {
                    if (!this._log.shouldLog(20)) break block4;
                    this._log.info("Unable to get the share percentage");
                }
            }
        }
        return 0.8;
    }

    public int get1sRate() {
        return this.get1sRate(false);
    }

    public int get1sRate(boolean outboundOnly) {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        int out = (int)bw.getSendBps();
        if (outboundOnly) {
            return out;
        }
        return (int)Math.max((float)out, bw.getReceiveBps());
    }

    public int get1sRateIn() {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        return (int)bw.getReceiveBps();
    }

    public int get15sRate() {
        return this.get15sRate(false);
    }

    public int get15sRate(boolean outboundOnly) {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        int out = (int)bw.getSendBps15s();
        if (outboundOnly) {
            return out;
        }
        return (int)Math.max((float)out, bw.getReceiveBps15s());
    }

    public int get15sRateIn() {
        FIFOBandwidthLimiter bw = this._context.bandwidthLimiter();
        return (int)bw.getReceiveBps15s();
    }

    public int get1mRate() {
        return this.get1mRate(false);
    }

    public int get1mRate(boolean outboundOnly) {
        int send = 0;
        StatManager mgr = this._context.statManager();
        RateStat rs = mgr.getRate("bw.sendRate");
        if (rs != null) {
            send = (int)rs.getRate(60000L).getAverageValue();
        }
        if (outboundOnly) {
            return send;
        }
        int recv = 0;
        rs = mgr.getRate("bw.recvRate");
        if (rs != null) {
            recv = (int)rs.getRate(60000L).getAverageValue();
        }
        return Math.max(send, recv);
    }

    public int get1mRateIn() {
        StatManager mgr = this._context.statManager();
        RateStat rs = mgr.getRate("bw.recvRate");
        int recv = 0;
        if (rs != null) {
            recv = (int)rs.getRate(60000L).getAverageValue();
        }
        return recv;
    }

    public int get5mRate() {
        return this.get5mRate(false);
    }

    public int get5mRate(boolean outboundOnly) {
        int send = 0;
        RateStat rs = this._context.statManager().getRate("bw.sendRate");
        if (rs != null) {
            send = (int)rs.getRate(300000L).getAverageValue();
        }
        if (outboundOnly) {
            return send;
        }
        int recv = 0;
        rs = this._context.statManager().getRate("bw.recvRate");
        if (rs != null) {
            recv = (int)rs.getRate(300000L).getAverageValue();
        }
        return Math.max(send, recv);
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    static {
        if (System.getProperty("I2P_DISABLE_DNS_CACHE_OVERRIDE") == null) {
            String DNS_CACHE_TIME = Integer.toString(7200);
            String DNS_NEG_CACHE_TIME = Integer.toString(1800);
            System.setProperty("sun.net.inetaddr.ttl", DNS_CACHE_TIME);
            System.setProperty("sun.net.inetaddr.negative.ttl", DNS_NEG_CACHE_TIME);
            System.setProperty("networkaddress.cache.ttl", DNS_CACHE_TIME);
            System.setProperty("networkaddress.cache.negative.ttl", DNS_NEG_CACHE_TIME);
        }
        if (System.getProperty("I2P_DISABLE_HTTP_KEEPALIVE_OVERRIDE") == null) {
            System.setProperty("http.keepAlive", "false");
        }
        originalTimeZoneID = TimeZone.getDefault().getID();
        if (System.getProperty("I2P_DISABLE_TIMEZONE_OVERRIDE") == null) {
            System.setProperty("user.timezone", "GMT");
            TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        }
        STATES_ALIVE = EnumSet.of(State.RUNNING, new State[]{State.GRACEFUL_SHUTDOWN, State.STARTING_1, State.STARTING_2, State.STARTING_3, State.NETDB_READY, State.EXPL_TUNNELS_READY});
        STATES_GRACEFUL = EnumSet.of(State.GRACEFUL_SHUTDOWN, State.FINAL_SHUTDOWN_1, State.FINAL_SHUTDOWN_2, State.FINAL_SHUTDOWN_3, State.STOPPED);
        STATES_FINAL = EnumSet.of(State.FINAL_SHUTDOWN_1, State.FINAL_SHUTDOWN_2, State.FINAL_SHUTDOWN_3, State.STOPPED);
        _rebuildFiles = new String[]{"router.info", "router.keys", "router.keys.dat", "netDb/my.info", "connectionTag.keys", "keyBackup/privateEncryption.key", "keyBackup/publicEncryption.key", "keyBackup/privateSigning.key", "keyBackup/publicSigning.key", "sessionKeys.dat"};
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZED,
        STARTING_1,
        STARTING_2,
        STARTING_3,
        NETDB_READY,
        EXPL_TUNNELS_READY,
        RUNNING,
        RESTARTING,
        GRACEFUL_SHUTDOWN,
        FINAL_SHUTDOWN_1,
        FINAL_SHUTDOWN_2,
        FINAL_SHUTDOWN_3,
        STOPPED;

    }

    private class LoggerCallback
    implements UPnPScannerCallback {
        private LoggerCallback() {
        }

        @Override
        public void beforeScan() {
            Router.this._log.info("SSDP beforeScan()");
        }

        @Override
        public void afterScan() {
            Router.this._log.info("SSDP afterScan()");
        }
    }
}

