/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeList;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.geomgraph.PlanarGraph;
import org.locationtech.jts.noding.FastNodingValidator;
import org.locationtech.jts.noding.IntersectionAdder;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.buffer.BufferCurveSetBuilder;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.BufferSubgraph;
import org.locationtech.jts.operation.buffer.SubgraphDepthLocater;
import org.locationtech.jts.operation.overlay.OverlayNodeFactory;
import org.locationtech.jts.operation.overlay.PolygonBuilder;

class BufferBuilder {
    private BufferParameters bufParams;
    private PrecisionModel workingPrecisionModel;
    private Noder workingNoder;
    private GeometryFactory geomFact;
    private PlanarGraph graph;
    private EdgeList edgeList = new EdgeList();
    private boolean isInvertOrientation = false;

    private static int depthDelta(Label label) {
        int lLoc = label.getLocation(0, 1);
        int rLoc = label.getLocation(0, 2);
        if (lLoc == 0 && rLoc == 2) {
            return 1;
        }
        if (lLoc == 2 && rLoc == 0) {
            return -1;
        }
        return 0;
    }

    public BufferBuilder(BufferParameters bufParams) {
        this.bufParams = bufParams;
    }

    public void setWorkingPrecisionModel(PrecisionModel pm) {
        this.workingPrecisionModel = pm;
    }

    public void setNoder(Noder noder) {
        this.workingNoder = noder;
    }

    void setInvertOrientation(boolean isInvertOrientation) {
        this.isInvertOrientation = isInvertOrientation;
    }

    public Geometry buffer(Geometry g, double distance) {
        PrecisionModel precisionModel = this.workingPrecisionModel;
        if (precisionModel == null) {
            precisionModel = g.getPrecisionModel();
        }
        this.geomFact = g.getFactory();
        BufferCurveSetBuilder curveSetBuilder = new BufferCurveSetBuilder(g, distance, precisionModel, this.bufParams);
        curveSetBuilder.setInvertOrientation(this.isInvertOrientation);
        List bufferSegStrList = curveSetBuilder.getCurves();
        if (bufferSegStrList.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        boolean isNodingValidated = distance == 0.0;
        this.computeNodedEdges(bufferSegStrList, precisionModel, isNodingValidated);
        this.graph = new PlanarGraph(new OverlayNodeFactory());
        this.graph.addEdges(this.edgeList.getEdges());
        List subgraphList = this.createSubgraphs(this.graph);
        PolygonBuilder polyBuilder = new PolygonBuilder(this.geomFact);
        this.buildSubgraphs(subgraphList, polyBuilder);
        List resultPolyList = polyBuilder.getPolygons();
        if (resultPolyList.size() <= 0) {
            return this.createEmptyResultGeometry();
        }
        Geometry resultGeom = this.geomFact.buildGeometry(resultPolyList);
        return resultGeom;
    }

    private Noder getNoder(PrecisionModel precisionModel) {
        if (this.workingNoder != null) {
            return this.workingNoder;
        }
        MCIndexNoder noder = new MCIndexNoder();
        RobustLineIntersector li = new RobustLineIntersector();
        li.setPrecisionModel(precisionModel);
        noder.setSegmentIntersector(new IntersectionAdder(li));
        return noder;
    }

    private void computeNodedEdges(List bufferSegStrList, PrecisionModel precisionModel, boolean isNodingValidated) {
        Noder noder = this.getNoder(precisionModel);
        noder.computeNodes(bufferSegStrList);
        Collection nodedSegStrings = noder.getNodedSubstrings();
        if (isNodingValidated) {
            FastNodingValidator nv = new FastNodingValidator(nodedSegStrings);
            nv.checkValid();
        }
        for (SegmentString segStr : nodedSegStrings) {
            Coordinate[] pts = segStr.getCoordinates();
            if (pts.length == 2 && pts[0].equals2D(pts[1])) continue;
            Label oldLabel = (Label)segStr.getData();
            Edge edge = new Edge(segStr.getCoordinates(), new Label(oldLabel));
            this.insertUniqueEdge(edge);
        }
    }

    protected void insertUniqueEdge(Edge e) {
        Edge existingEdge = this.edgeList.findEqualEdge(e);
        if (existingEdge != null) {
            Label existingLabel = existingEdge.getLabel();
            Label labelToMerge = e.getLabel();
            if (!existingEdge.isPointwiseEqual(e)) {
                labelToMerge = new Label(e.getLabel());
                labelToMerge.flip();
            }
            existingLabel.merge(labelToMerge);
            int mergeDelta = BufferBuilder.depthDelta(labelToMerge);
            int existingDelta = existingEdge.getDepthDelta();
            int newDelta = existingDelta + mergeDelta;
            existingEdge.setDepthDelta(newDelta);
        } else {
            this.edgeList.add(e);
            e.setDepthDelta(BufferBuilder.depthDelta(e.getLabel()));
        }
    }

    private List createSubgraphs(PlanarGraph graph) {
        ArrayList<BufferSubgraph> subgraphList = new ArrayList<BufferSubgraph>();
        for (Node node : graph.getNodes()) {
            if (node.isVisited()) continue;
            BufferSubgraph subgraph = new BufferSubgraph();
            subgraph.create(node);
            subgraphList.add(subgraph);
        }
        Collections.sort(subgraphList, Collections.reverseOrder());
        return subgraphList;
    }

    private void buildSubgraphs(List subgraphList, PolygonBuilder polyBuilder) {
        ArrayList<BufferSubgraph> processedGraphs = new ArrayList<BufferSubgraph>();
        for (BufferSubgraph subgraph : subgraphList) {
            Coordinate p = subgraph.getRightmostCoordinate();
            SubgraphDepthLocater locater = new SubgraphDepthLocater(processedGraphs);
            int outsideDepth = locater.getDepth(p);
            subgraph.computeDepth(outsideDepth);
            subgraph.findResultEdges();
            processedGraphs.add(subgraph);
            polyBuilder.add(subgraph.getDirectedEdges(), subgraph.getNodes());
        }
    }

    private static Geometry convertSegStrings(Iterator it) {
        GeometryFactory fact = new GeometryFactory();
        ArrayList<LineString> lines = new ArrayList<LineString>();
        while (it.hasNext()) {
            SegmentString ss = (SegmentString)it.next();
            LineString line = fact.createLineString(ss.getCoordinates());
            lines.add(line);
        }
        return fact.buildGeometry(lines);
    }

    private Geometry createEmptyResultGeometry() {
        Polygon emptyGeom = this.geomFact.createPolygon();
        return emptyGeom;
    }
}

