/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.snmp.trap;

import java.util.Map;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.TransportIpAddress;

public class SnmpTrapMessage {
    private final int version;
    private final byte[] securityName;
    private final Address peerAddress;
    private final Map<String, Object> trapEvent;
    private final Map<String, Object> formattedVariableBindings;

    public SnmpTrapMessage(int version, byte[] securityName, Address peerAddress, Map<String, Object> trapEvent, Map<String, Object> formattedVariableBindings) {
        this.version = version;
        this.securityName = securityName;
        this.peerAddress = peerAddress;
        this.trapEvent = trapEvent;
        this.formattedVariableBindings = formattedVariableBindings;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSecurityNameString() {
        return new String(this.securityName);
    }

    public Map<String, Object> getTrapEvent() {
        return this.trapEvent;
    }

    public Map<String, Object> getFormattedVariableBindings() {
        return this.formattedVariableBindings;
    }

    public String getPeerIpAddress() {
        if (this.peerAddress instanceof TransportIpAddress) {
            return ((TransportIpAddress)this.peerAddress).getInetAddress().getHostAddress();
        }
        return this.peerAddress.toString();
    }
}

