/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derby.shared.common.stream.PrintWriterGetHeader;

class BasicHeaderPrintWriter
extends PrintWriter
implements HeaderPrintWriter {
    private final PrintWriterGetHeader headerGetter;
    private final boolean canClose;
    private final String name;

    BasicHeaderPrintWriter(OutputStream writeTo, PrintWriterGetHeader headerGetter, boolean canClose, String streamName) {
        super(writeTo, true);
        this.headerGetter = headerGetter;
        this.canClose = canClose;
        this.name = streamName;
    }

    BasicHeaderPrintWriter(Writer writeTo, PrintWriterGetHeader headerGetter, boolean canClose, String writerName) {
        super(writeTo, true);
        this.headerGetter = headerGetter;
        this.canClose = canClose;
        this.name = writerName;
    }

    public synchronized void printlnWithHeader(String message) {
        this.print(this.headerGetter.getHeader());
        this.println(message);
    }

    public PrintWriterGetHeader getHeader() {
        return this.headerGetter;
    }

    public PrintWriter getPrintWriter() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    void complete() {
        this.flush();
        if (this.canClose) {
            this.close();
        }
    }
}

