/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.store.access.PropertyConglomerate;
import org.apache.derby.shared.common.error.StandardException;

public class PC_XenaVersion
implements Formatable {
    private static final int XENA_MAJOR_VERSION = 1;
    private static final int XENA_MINOR_VERSION_0 = 0;
    private int minorVersion = 0;

    private boolean isUpgradeNeeded(PC_XenaVersion fromVersion) {
        return fromVersion == null || this.getMajorVersionNumber() != fromVersion.getMajorVersionNumber();
    }

    public void upgradeIfNeeded(TransactionController tc, PropertyConglomerate pc, Properties serviceProperties) throws StandardException {
        PC_XenaVersion dbVersion = (PC_XenaVersion)pc.getProperty(tc, "PropertyConglomerateVersion");
        if (this.isUpgradeNeeded(dbVersion)) {
            throw StandardException.newException((String)"XCW00.D", (Object[])new Object[]{dbVersion, this});
        }
    }

    public int getMajorVersionNumber() {
        return 1;
    }

    public int getMinorVersionNumber() {
        return this.minorVersion;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.getMajorVersionNumber());
        out.writeInt(this.getMinorVersionNumber());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int majorVersion = in.readInt();
        this.minorVersion = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 15;
    }

    public String toString() {
        return this.getMajorVersionNumber() + "." + this.getMinorVersionNumber();
    }
}

