/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Arrays;
import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class LikeEscapeOperatorNode
extends TernaryOperatorNode {
    boolean addedEquals;
    String escape;

    LikeEscapeOperatorNode(ValueNode receiver, ValueNode leftOperand, ValueNode rightOperand, ContextManager cm) {
        super(receiver, leftOperand, rightOperand, 3, cm);
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        boolean rightConstant;
        boolean leftConstant;
        super.bindExpression(fromList, subqueryList, aggregates);
        String pattern = null;
        if (!this.leftOperand.requiresTypeFromContext() && !this.leftOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42884", (Object[])new Object[]{"LIKE", "FUNCTION"});
        }
        if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext() && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42884", (Object[])new Object[]{"LIKE", "FUNCTION"});
        }
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            if (!this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.leftOperand.getTypeServices());
            } else if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext()) {
                this.receiver.setCollationInfo(this.rightOperand.getTypeServices());
            } else {
                this.receiver.setCollationUsingCompilationSchema();
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.leftOperand.setType(this.receiver.getTypeServices());
            } else {
                this.leftOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.leftOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        if (this.rightOperand != null && this.rightOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.rightOperand.setType(this.receiver.getTypeServices());
            } else {
                this.rightOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.rightOperand.setCollationInfo(this.receiver.getTypeServices());
        }
        this.bindToBuiltIn();
        if (!this.receiver.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42884", (Object[])new Object[]{"LIKE", "FUNCTION"});
        }
        if (!this.leftOperand.getTypeId().isStringTypeId()) {
            this.leftOperand = this.castArgToString(this.leftOperand);
        }
        if (this.rightOperand != null) {
            this.rightOperand = this.castArgToString(this.rightOperand);
        }
        if (leftConstant = this.leftOperand instanceof CharConstantNode) {
            pattern = ((CharConstantNode)this.leftOperand).getString();
        }
        if (rightConstant = this.rightOperand instanceof CharConstantNode) {
            this.escape = ((CharConstantNode)this.rightOperand).getString();
            if (this.escape.length() != 1) {
                throw StandardException.newException((String)"22019", (Object[])new Object[]{this.escape});
            }
        } else if (this.rightOperand == null) {
            rightConstant = true;
        }
        if (!this.receiver.getTypeServices().compareCollationInfo(this.leftOperand.getTypeServices())) {
            throw StandardException.newException((String)"42ZA2", (Object[])new Object[]{this.receiver.getTypeServices().getSQLstring(), this.receiver.getTypeServices().getCollationName(), this.leftOperand.getTypeServices().getSQLstring(), this.leftOperand.getTypeServices().getCollationName()});
        }
        if (this.receiver instanceof ColumnReference && leftConstant && rightConstant && Like.isOptimizable(pattern)) {
            String newPattern = null;
            if (this.escape != null) {
                newPattern = Like.stripEscapesNoPatternChars(pattern, this.escape.charAt(0));
            } else if (pattern.indexOf(95) == -1 && pattern.indexOf(37) == -1) {
                newPattern = pattern;
            }
            if (newPattern != null) {
                ValueNode leftClone = this.receiver.getClone();
                this.addedEquals = true;
                BinaryComparisonOperatorNode equals = new BinaryRelationalOperatorNode(0, leftClone, new CharConstantNode(newPattern, this.getContextManager()), false, this.getContextManager());
                equals.setForQueryRewrite(true);
                equals = (BinaryComparisonOperatorNode)equals.bindExpression(fromList, subqueryList, aggregates);
                AndNode newAnd = new AndNode(this, equals, this.getContextManager());
                this.finishBindExpr();
                newAnd.postBindFixup();
                return newAnd;
            }
        }
        this.finishBindExpr();
        return this;
    }

    private void finishBindExpr() throws StandardException {
        boolean nullableResult;
        this.bindComparisonOperator();
        boolean bl = nullableResult = this.receiver.getTypeServices().isNullable() || this.leftOperand.getTypeServices().isNullable();
        if (this.rightOperand != null) {
            nullableResult |= this.rightOperand.getTypeServices().isNullable();
        }
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
    }

    public void bindComparisonOperator() throws StandardException {
        TypeId receiverType = this.receiver.getTypeId();
        TypeId leftType = this.leftOperand.getTypeId();
        if (!receiverType.isStringTypeId()) {
            throw StandardException.newException((String)"42X53", (Object[])new Object[]{receiverType.getSQLTypeName()});
        }
        if (!leftType.isStringTypeId()) {
            throw StandardException.newException((String)"42X53", (Object[])new Object[]{leftType.getSQLTypeName()});
        }
        if (this.rightOperand != null && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException((String)"42X53", (Object[])new Object[]{this.rightOperand.getTypeId().getSQLTypeName()});
        }
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        boolean eliminateLikeComparison = false;
        String greaterEqualString = null;
        String lessThanString = null;
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.receiver.getTypeId().getSQLTypeName().equals("CLOB")) {
            return this;
        }
        if (this.addedEquals) {
            return this;
        }
        if (!(this.leftOperand instanceof CharConstantNode) && !this.leftOperand.requiresTypeFromContext()) {
            return this;
        }
        if (!(this.receiver instanceof ColumnReference)) {
            return this;
        }
        if (this.receiver.getTypeServices().getCollationType() != 0) {
            return this;
        }
        if (this.leftOperand instanceof CharConstantNode) {
            String pattern = ((CharConstantNode)this.leftOperand).getString();
            if (!Like.isOptimizable(pattern)) {
                return this;
            }
            int maxWidth = this.receiver.getTypeServices().getMaximumWidth();
            if (maxWidth > 32700) {
                return this;
            }
            greaterEqualString = Like.greaterEqualString(pattern, this.escape, maxWidth);
            lessThanString = Like.lessThanString(pattern, this.escape, maxWidth);
            eliminateLikeComparison = !Like.isLikeComparisonNeeded(pattern);
        }
        AndNode newAnd = null;
        BooleanConstantNode trueNode = new BooleanConstantNode(true, this.getContextManager());
        if (lessThanString != null || this.leftOperand.requiresTypeFromContext()) {
            ValueNode likeLTopt = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "lessThanStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : new CharConstantNode(lessThanString, this.getContextManager());
            BinaryRelationalOperatorNode lessThan = new BinaryRelationalOperatorNode(4, this.receiver.getClone(), likeLTopt, false, this.getContextManager());
            lessThan.setForQueryRewrite(true);
            lessThan.bindComparisonOperator();
            lessThan.setBetweenSelectivity();
            newAnd = new AndNode(lessThan, trueNode, this.getContextManager());
            newAnd.postBindFixup();
        }
        ValueNode likeGEopt = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "greaterEqualStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : new CharConstantNode(greaterEqualString, this.getContextManager());
        BinaryRelationalOperatorNode greaterEqual = new BinaryRelationalOperatorNode(1, this.receiver.getClone(), likeGEopt, false, this.getContextManager());
        greaterEqual.setForQueryRewrite(true);
        greaterEqual.bindComparisonOperator();
        greaterEqual.setBetweenSelectivity();
        newAnd = newAnd == null ? new AndNode(greaterEqual, trueNode, this.getContextManager()) : new AndNode(greaterEqual, newAnd, this.getContextManager());
        newAnd.postBindFixup();
        if (!eliminateLikeComparison) {
            newAnd = new AndNode(this, newAnd, this.getContextManager());
            newAnd.postBindFixup();
        }
        this.setTransformed();
        return newAnd;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.receiver.generateExpression(acb, mb);
        this.receiverInterfaceType = this.receiver.getTypeCompiler().interfaceName();
        mb.upCast(this.receiverInterfaceType);
        this.leftOperand.generateExpression(acb, mb);
        mb.upCast(this.leftInterfaceType);
        if (this.rightOperand != null) {
            this.rightOperand.generateExpression(acb, mb);
            mb.upCast(this.rightInterfaceType);
        }
        mb.callMethod((short)185, null, this.methodName, this.resultInterfaceType, this.rightOperand == null ? 1 : 2);
    }

    private ValueNode setupOptimizeStringFromParameter(ValueNode parameterNode, ValueNode escapeNode, String methodName, int maxWidth) throws StandardException {
        ValueNode[] valueNodeArray;
        if (escapeNode != null) {
            methodName = (String)methodName + "WithEsc";
        }
        StaticMethodCallNode methodCall = new StaticMethodCallNode((String)methodName, "org.apache.derby.iapi.types.Like", this.getContextManager());
        methodCall.internalCall = true;
        NumericConstantNode maxWidthNode = new NumericConstantNode(TypeId.getBuiltInTypeId(4), maxWidth, this.getContextManager());
        if (escapeNode == null) {
            ValueNode[] valueNodeArray2 = new ValueNode[2];
            valueNodeArray2[0] = parameterNode;
            valueNodeArray = valueNodeArray2;
            valueNodeArray2[1] = maxWidthNode;
        } else {
            ValueNode[] valueNodeArray3 = new ValueNode[3];
            valueNodeArray3[0] = parameterNode;
            valueNodeArray3[1] = escapeNode;
            valueNodeArray = valueNodeArray3;
            valueNodeArray3[2] = maxWidthNode;
        }
        ValueNode[] param = valueNodeArray;
        methodCall.addParms(Arrays.asList(param));
        ValueNode java2SQL = new JavaToSQLValueNode(methodCall, this.getContextManager());
        java2SQL = ((ValueNode)java2SQL).bindExpression(null, null, null);
        CastNode likeOpt = new CastNode(java2SQL, parameterNode.getTypeServices(), this.getContextManager());
        likeOpt.bindCastNodeOnly();
        return likeOpt;
    }
}

