/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.DefaultVTIModDeferPolicy;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.vti.DeferModification;

class VTIDeferModPolicy
implements Visitor {
    private boolean deferred = false;
    private DeferModification deferralControl;
    private int statementType;
    private int tableNumber;
    private final HashSet<String> columns = new HashSet();

    public static boolean deferIt(int statementType, FromVTI targetVTI, String[] updateColumnNames, QueryTreeNode source) throws StandardException {
        try {
            int resultSetType = targetVTI.getResultSetType();
            if ((statementType == 2 || statementType == 3) && resultSetType == 1003) {
                return false;
            }
            DeferModification deferralControl = targetVTI.getDeferralControl();
            if (deferralControl == null) {
                String VTIClassName = targetVTI.getMethodCall().getJavaClassName();
                deferralControl = new DefaultVTIModDeferPolicy(VTIClassName, 1005 == resultSetType);
            }
            if (deferralControl.alwaysDefer(statementType)) {
                return true;
            }
            if (source == null && statementType != 2) {
                return false;
            }
            VTIDeferModPolicy deferralSearch = new VTIDeferModPolicy(targetVTI, updateColumnNames, deferralControl, statementType);
            if (source != null) {
                source.accept(deferralSearch);
            }
            if (statementType == 2) {
                for (String s : deferralSearch.columns) {
                    if (!deferralControl.columnRequiresDefer(statementType, s, false)) continue;
                    return true;
                }
            }
            return deferralSearch.deferred;
        }
        catch (SQLException sqle) {
            throw StandardException.unexpectedUserException((Throwable)sqle);
        }
    }

    private VTIDeferModPolicy(FromVTI targetVTI, String[] columnNames, DeferModification deferralControl, int statementType) {
        this.deferralControl = deferralControl;
        this.statementType = statementType;
        this.tableNumber = targetVTI.getTableNumber();
        if (statementType == 2 && columnNames != null) {
            this.columns.addAll(Arrays.asList(columnNames));
        }
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        try {
            if (node instanceof ColumnReference && this.statementType != 1) {
                ColumnReference cr = (ColumnReference)node;
                if (cr.getTableNumber() == this.tableNumber) {
                    String columnName = cr.getColumnName();
                    if (this.statementType == 3) {
                        if (this.columns.add(columnName) && this.deferralControl.columnRequiresDefer(this.statementType, columnName, true)) {
                            this.deferred = true;
                        }
                    } else if (this.statementType == 2 && this.columns.remove(columnName) && this.deferralControl.columnRequiresDefer(this.statementType, columnName, true)) {
                        this.deferred = true;
                    }
                }
            } else if (node instanceof SelectNode) {
                SelectNode subSelect = (SelectNode)node;
                FromList fromList = subSelect.getFromList();
                for (int i = 0; i < fromList.size(); ++i) {
                    FromVTI fromVTI;
                    FromTable fromTable = (FromTable)fromList.elementAt(i);
                    if (fromTable instanceof FromBaseTable) {
                        TableDescriptor td = fromTable.getTableDescriptor();
                        if (!this.deferralControl.subselectRequiresDefer(this.statementType, td.getSchemaName(), td.getName())) continue;
                        this.deferred = true;
                        continue;
                    }
                    if (!(fromTable instanceof FromVTI) || !this.deferralControl.subselectRequiresDefer(this.statementType, (fromVTI = (FromVTI)fromTable).getMethodCall().getJavaClassName())) continue;
                    this.deferred = true;
                }
            }
        }
        catch (SQLException sqle) {
            throw StandardException.unexpectedUserException((Throwable)sqle);
        }
        return node;
    }

    @Override
    public boolean stopTraversal() {
        return this.deferred;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return false;
    }

    @Override
    public boolean visitChildrenFirst(Visitable node) {
        return false;
    }
}

