/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class MaterializedResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow materializedRowBuffer;
    protected long materializedCID;
    public boolean materializedCreated;
    private boolean fromSource = true;
    protected ConglomerateController materializedCC;
    protected ScanController materializedScan;
    private TransactionController tc;
    private boolean sourceDrained;
    public long createTCTime;
    public long fetchTCTime;

    public MaterializedResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = source;
        this.tc = activation.getTransactionController();
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"MaterializedResultSet already open");
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT((boolean)this.isOpen, (String)"MaterializedResultSet already open");
        while (!this.sourceDrained) {
            this.getNextRowFromSource();
        }
        this.fromSource = false;
        if (this.materializedScan != null) {
            this.materializedScan.close();
        }
        if (this.materializedCID != 0L) {
            this.materializedScan = this.tc.openScan(this.materializedCID, false, 0, 7, 5, null, null, 0, null, null, 0);
            this.isOpen = true;
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException((String)"XCL16.S", (Object[])new Object[]{"next"});
        }
        result = this.fromSource ? this.getNextRowFromSource() : this.getNextRowFromTempTable();
        if (result != null) {
            ++this.rowsSeen;
        }
        this.setCurrentRow(result);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    private ExecRow getNextRowFromSource() throws StandardException {
        if (this.sourceDrained) {
            return null;
        }
        ExecRow sourceRow = null;
        Object result = null;
        sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            long beginTCTime = this.getCurrentTimeMillis();
            if (this.materializedRowBuffer == null) {
                this.materializedRowBuffer = sourceRow.getClone();
                this.tc = this.activation.getTransactionController();
                this.materializedCID = this.tc.createConglomerate("heap", this.materializedRowBuffer.getRowArray(), null, null, null, 3);
                this.materializedCreated = true;
                this.materializedCC = this.tc.openConglomerate(this.materializedCID, false, 4, 7, 5);
            }
            this.materializedCC.insert(sourceRow.getRowArray());
            this.createTCTime += this.getElapsedMillis(beginTCTime);
        } else {
            this.sourceDrained = true;
        }
        return sourceRow;
    }

    private ExecRow getNextRowFromTempTable() throws StandardException {
        long beginTCTime = this.getCurrentTimeMillis();
        if (this.materializedScan != null && this.materializedScan.fetchNext(this.materializedRowBuffer.getRowArray())) {
            this.fetchTCTime += this.getElapsedMillis(beginTCTime);
            return this.materializedRowBuffer;
        }
        return null;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            if (this.materializedScan != null) {
                this.materializedScan.close();
            }
            this.materializedScan = null;
            if (this.materializedCC != null) {
                this.materializedCC.close();
            }
            this.materializedCC = null;
            if (this.materializedCreated) {
                this.tc.dropConglomerate(this.materializedCID);
            }
            this.materializedCreated = false;
            super.close();
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of MaterializedResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof CursorResultSet), (String)"source not CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }
}

