/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.OrderableAggregator;
import org.apache.derby.shared.common.error.StandardException;

public final class MaxMinAggregator
extends OrderableAggregator {
    private boolean isMax;

    @Override
    public void setup(ClassFactory cf, String aggregateName, DataTypeDescriptor returnType) {
        super.setup(cf, aggregateName, returnType);
        this.isMax = aggregateName.equals("MAX");
    }

    @Override
    protected void accumulate(DataValueDescriptor addend) throws StandardException {
        if (this.value == null || this.isMax && this.value.compare(addend) < 0 || !this.isMax && this.value.compare(addend) > 0) {
            this.value = addend.cloneValue(false);
        }
    }

    @Override
    public ExecAggregator newAggregator() {
        MaxMinAggregator ma = new MaxMinAggregator();
        ma.isMax = this.isMax;
        return ma;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.isMax);
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.isMax = in.readBoolean();
        super.readExternal(in);
    }

    @Override
    public int getTypeFormatId() {
        return 152;
    }
}

