/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import nokogiri.internals.NokogiriErrorHandler;
import nokogiri.internals.ParserContext;
import org.jruby.Ruby;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class NokogiriEntityResolver
implements EntityResolver2 {
    protected final Ruby runtime;
    private final NokogiriErrorHandler handler;
    private final ParserContext.Options options;

    public NokogiriEntityResolver(Ruby ruby, NokogiriErrorHandler nokogiriErrorHandler, ParserContext.Options options) {
        this.runtime = ruby;
        this.handler = nokogiriErrorHandler;
        this.options = options;
    }

    @Override
    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        return this.resolveEntity(this.runtime, null, string, null, string2);
    }

    @Override
    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        return this.resolveEntity(this.runtime, string, string2, string3, string4);
    }

    private static File join(String string, String string2) {
        if (new File(string).isFile()) {
            string = new File(string).getParent();
        }
        return new File(string, string2);
    }

    private static InputSource emptyInputSource(InputSource inputSource) {
        inputSource.setByteStream(new ByteArrayInputStream(new byte[0]));
        return inputSource;
    }

    private boolean shouldLoadDtd() {
        return this.options.dtdLoad || this.options.dtdValid;
    }

    private void addError(String string) {
        if (this.handler != null) {
            this.handler.addError(new Exception(string));
        }
    }

    protected InputSource resolveEntity(Ruby ruby, String string, String string2, String string3, String string4) throws IOException, SAXException {
        String string5;
        InputSource inputSource = new InputSource();
        if (string.equals("[dtd]") && !this.shouldLoadDtd()) {
            return NokogiriEntityResolver.emptyInputSource(inputSource);
        }
        if (!string.equals("[dtd]") && !this.options.noEnt) {
            return NokogiriEntityResolver.emptyInputSource(inputSource);
        }
        URI uRI = URI.create(string4);
        if (this.options.noNet && uRI.getHost() != null) {
            this.addError("Attempt to load network entity " + string4);
            return NokogiriEntityResolver.emptyInputSource(inputSource);
        }
        if (uRI.isAbsolute() && !uRI.isOpaque()) {
            string5 = uRI.toURL().toString();
        } else if (new File(uRI.getPath()).isAbsolute()) {
            string5 = uRI.getPath();
        } else if (string3 != null) {
            URI uRI2 = URI.create(string3);
            if (this.options.noNet && uRI2.getHost() != null) {
                this.addError("Attempt to load network entity " + string4);
                return NokogiriEntityResolver.emptyInputSource(inputSource);
            }
            string5 = uRI2.getHost() == null ? NokogiriEntityResolver.join(uRI2.getPath(), uRI.getPath()).getCanonicalPath() : uRI2.resolve(string4).toURL().toString();
        } else {
            String string6 = ruby.getCurrentDirectory();
            string5 = NokogiriEntityResolver.join(string6, uRI.getPath()).getCanonicalPath();
        }
        inputSource.setSystemId(string5);
        inputSource.setPublicId(string2);
        return inputSource;
    }
}

