/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.NetStatementRequest;
import org.apache.derby.client.net.ResultSetRequestInterface;

class NetResultSetRequest
extends NetStatementRequest
implements ResultSetRequestInterface {
    NetResultSetRequest(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    @Override
    public void writeFetch(NetResultSet resultSet, Section section, int fetchSize) throws SqlException {
        boolean sendQryrowset = ((NetStatement)resultSet.statement_.getMaterialStatement()).qryrowsetSentOnOpnqry_;
        boolean sendRtnextdta = false;
        if (sendQryrowset && resultSet.resultSetType_ == 1003 && ((NetCursor)resultSet.cursor_).hasLobs_) {
            fetchSize = 1;
            resultSet.fetchSize_ = 1;
            sendRtnextdta = true;
            ((NetCursor)resultSet.cursor_).rtnextrow_ = false;
        } else if (resultSet.fetchSize_ == 0) {
            sendQryrowset = false;
        }
        this.buildCNTQRY(section, sendQryrowset, resultSet.queryInstanceIdentifier_, fetchSize, sendRtnextdta);
        this.buildOUTOVR(resultSet, resultSet.resultSetMetaData_, resultSet.firstOutovrBuilt_, ((NetCursor)resultSet.cursor_).hasLobs_);
    }

    @Override
    public void writeScrollableFetch(NetResultSet resultSet, Section section, int fetchSize, int orientation, long rowToFetch, boolean resetQueryBlocks) throws SqlException {
        int protocolOrientation = this.computePROTOCOLOrientation(orientation);
        boolean sendQryrowset = resultSet.isRowsetCursor_ || ((NetStatement)resultSet.statement_.getMaterialStatement()).qryrowsetSentOnOpnqry_ && (resultSet.sensitivity_ == 2 || ((NetCursor)resultSet.cursor_).blocking_);
        this.buildScrollCNTQRY(protocolOrientation, rowToFetch, section, sendQryrowset, resultSet.queryInstanceIdentifier_, fetchSize, resetQueryBlocks);
        this.buildOUTOVR(resultSet, resultSet.resultSetMetaData_, resultSet.firstOutovrBuilt_, ((NetCursor)resultSet.cursor_).hasLobs_);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writePositioningFetch(NetResultSet resultSet, Section section, int orientation, long rowToFetch) throws SqlException {
        protocolOrientation = this.computePROTOCOLOrientation(orientation);
        if (resultSet.isRowsetCursor_) ** GOTO lbl-1000
        if (((NetStatement)resultSet.statement_.getMaterialStatement()).qryrowsetSentOnOpnqry_) {
            ** if (resultSet.sensitivity_ == 3) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v0 = true;
            ** GOTO lbl10
        }
lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
lbl10:
        // 2 sources

        sendQryrowset = v0;
        this.buildPositioningCNTQRY(protocolOrientation, rowToFetch, section, sendQryrowset, resultSet.queryInstanceIdentifier_, resultSet.fetchSize_);
        this.buildOUTOVR(resultSet, resultSet.resultSetMetaData_, resultSet.firstOutovrBuilt_, ((NetCursor)resultSet.cursor_).hasLobs_);
    }

    @Override
    public void writeCursorClose(NetResultSet resultSet, Section section) throws SqlException {
        this.buildCLSQRY(section, resultSet.queryInstanceIdentifier_);
    }

    private void buildCLSQRY(Section section, long queryInstanceIdentifier) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8197);
        this.buildPKGNAMCSN(section);
        this.buildQRYINSID(queryInstanceIdentifier);
        this.updateLengthBytes();
    }

    private void buildCNTQRY(Section section, boolean sendQryrowset, long queryInstanceIdentifier, int qryrowsetSize, boolean sendRtnextdta) throws SqlException {
        this.buildCoreCNTQRY(section, sendQryrowset, queryInstanceIdentifier, qryrowsetSize);
        if (sendRtnextdta) {
            this.buildRTNEXTDTA(2);
        }
        this.updateLengthBytes();
    }

    private void buildCoreCNTQRY(Section section, boolean sendQryrowset, long queryInstanceIdentifier, int qryrowsetSize) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8198);
        this.buildPKGNAMCSN(section);
        this.buildQRYBLKSZ();
        if (sendQryrowset) {
            this.buildMAXBLKEXT(-1);
        }
        this.buildQRYINSID(queryInstanceIdentifier);
        if (sendQryrowset) {
            this.buildQRYROWSET(qryrowsetSize);
        }
    }

    private void buildScrollCNTQRY(int scrollOrientation, long rowNumber, Section section, boolean sendQryrowset, long queryInstanceIdentifier, int qryrowsetSize, boolean resetQueryBlocks) throws SqlException {
        this.buildCoreCNTQRY(section, sendQryrowset, queryInstanceIdentifier, qryrowsetSize);
        this.buildQRYSCRORN(scrollOrientation);
        if (scrollOrientation == 2 || scrollOrientation == 1) {
            this.buildQRYROWNBR(rowNumber);
        }
        if (resetQueryBlocks) {
            this.buildQRYBLKRST(241);
        } else {
            this.buildQRYBLKRST(240);
        }
        this.buildQRYRTNDTA(241);
        this.updateLengthBytes();
    }

    private void buildPositioningCNTQRY(int scrollOrientation, long rowNumber, Section section, boolean sendQryrowset, long queryInstanceIdentifier, int qryrowsetSize) throws SqlException {
        this.createCommand();
        this.markLengthBytes(8198);
        this.buildPKGNAMCSN(section);
        this.buildQRYBLKSZ();
        this.buildQRYINSID(queryInstanceIdentifier);
        if (sendQryrowset) {
            this.buildQRYROWSET(qryrowsetSize);
        }
        this.buildQRYSCRORN(scrollOrientation);
        if (scrollOrientation == 2 || scrollOrientation == 1) {
            this.buildQRYROWNBR(rowNumber);
        }
        this.buildQRYBLKRST(241);
        this.buildQRYRTNDTA(240);
        this.updateLengthBytes();
    }

    private void buildOUTOVR(NetResultSet resultSet, ColumnMetaData resultSetMetaData, boolean firstOutovrBuilt, boolean hasLobs) throws SqlException {
        if (hasLobs && !firstOutovrBuilt) {
            this.buildOUTOVR(resultSet, resultSetMetaData);
            resultSet.firstOutovrBuilt_ = true;
        }
    }

    private void buildRTNEXTDTA(int rtnextdta) throws SqlException {
        this.writeScalar1Byte(8520, rtnextdta);
    }

    private void buildQRYSCRORN(int scrollOrientation) throws SqlException {
        this.writeScalar1Byte(8530, scrollOrientation);
    }

    private void buildQRYBLKRST(int qryblkrst) throws SqlException {
        this.writeScalar1Byte(8532, qryblkrst);
    }

    private void buildQRYROWNBR(long rowNumber) throws SqlException {
        this.writeScalar8Bytes(8509, rowNumber);
    }

    private void buildQRYRTNDTA(int qryrtndta) throws SqlException {
        this.writeScalar1Byte(8533, qryrtndta);
    }

    private int computePROTOCOLOrientation(int orientation) throws SqlException {
        switch (orientation) {
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 1: {
                return 1;
            }
        }
        throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("XN013.S"), new Object[0]);
    }
}

